/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.config.internal;

import com.openexchange.config.ConfigurationService;
import com.openexchange.config.cascade.ConfigProviderService;
import com.openexchange.config.internal.ServerProperty;
import com.openexchange.exception.OXException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigProviderServiceImpl
implements ConfigProviderService {
    private static final String META = "meta";
    private static final String SETTINGS = "settings";
    private static final String PREFRENCE_PATH = "preferencePath";
    private static final String VALUE = "value";
    private static final String PROTECTED = "protected";
    private static final String TRUE = "true";
    private ConfigurationService configService;
    private static final Logger LOG = LoggerFactory.getLogger(ConfigProviderService.class);
    private final ConcurrentMap<String, ServerProperty> properties = new ConcurrentHashMap<String, ServerProperty>();

    public ConfigProviderServiceImpl(ConfigurationService configService) throws OXException {
        this.setConfigService(configService);
    }

    public ServerProperty get(String property, int contextId, int userId) throws OXException {
        if (null == property) {
            return null;
        }
        ServerProperty basicProperty = (ServerProperty)this.properties.get(property);
        if (basicProperty != null) {
            return basicProperty;
        }
        ServerProperty retval = new ServerProperty();
        String value = this.configService.getProperty(property);
        retval.setDefined(value != null);
        retval.set(value);
        ServerProperty alreadyDefined = this.properties.putIfAbsent(property, retval);
        if (alreadyDefined != null) {
            return alreadyDefined;
        }
        return retval;
    }

    public Collection<String> getAllPropertyNames(int contextId, int userId) throws OXException {
        Iterator<String> propertyNames = this.configService.propertyNames();
        HashSet<String> retval = new HashSet<String>();
        while (propertyNames.hasNext()) {
            retval.add(propertyNames.next());
        }
        retval.addAll(this.properties.keySet());
        return retval;
    }

    public void setConfigService(ConfigurationService configService) throws OXException {
        this.configService = configService;
        this.initSettings(configService);
        this.initStructuredObjects(configService);
        this.initMetadata(configService);
    }

    private void initSettings(ConfigurationService config) throws OXException {
        Properties propertiesInFolder = config.getPropertiesInFolder(SETTINGS);
        for (Object propName : propertiesInFolder.keySet()) {
            ServerProperty serverProperty = this.get((String)propName, -1, -1);
            serverProperty.set(PREFRENCE_PATH, (String)propName);
            if (serverProperty.get(PROTECTED) != null) continue;
            serverProperty.set(PROTECTED, TRUE);
        }
    }

    private void initStructuredObjects(ConfigurationService config) throws OXException {
        Map<String, Object> yamlInFolder = config.getYamlInFolder(SETTINGS);
        for (Object yamlContent : yamlInFolder.values()) {
            if (!(yamlContent instanceof Map)) continue;
            Map entries = (Map)yamlContent;
            for (Map.Entry entry : entries.entrySet()) {
                String namespace = (String)entry.getKey();
                Object subkeys = entry.getValue();
                this.recursivelyInitStructuredObjects(namespace, subkeys);
            }
        }
    }

    private void recursivelyInitStructuredObjects(String namespace, Object subkeys) throws OXException {
        if (subkeys instanceof Map) {
            Map entries = (Map)subkeys;
            for (Map.Entry entry : entries.entrySet()) {
                this.recursivelyInitStructuredObjects(namespace + "/" + (String)entry.getKey(), entry.getValue());
            }
        } else {
            ServerProperty serverProperty = this.get(namespace, -1, -1);
            serverProperty.set(PREFRENCE_PATH, namespace);
            serverProperty.set(subkeys.toString());
            serverProperty.setDefined(true);
            if (serverProperty.get(PROTECTED) == null) {
                serverProperty.set(PROTECTED, TRUE);
            }
        }
    }

    private void initMetadata(ConfigurationService config) throws OXException {
        Map<String, Object> yamlInFolder = config.getYamlInFolder(META);
        for (Object o : yamlInFolder.values()) {
            if (!this.checkMap(o)) continue;
            Map metadataDef = (Map)o;
            for (Map.Entry entry : metadataDef.entrySet()) {
                String propertyName = (String)entry.getKey();
                Object value2 = entry.getValue();
                if (!this.checkMap(value2)) continue;
                Map metadata = (Map)value2;
                ServerProperty basicProperty = this.get(propertyName, -1, -1);
                for (Map.Entry metadataProp : metadata.entrySet()) {
                    if (metadataProp.getValue() == null) continue;
                    basicProperty.set((String)metadataProp.getKey(), metadataProp.getValue().toString());
                }
                String value = basicProperty.get(VALUE);
                if (value == null) {
                    value = config.getProperty(propertyName);
                }
                basicProperty.set(value);
                basicProperty.setDefined(value != null);
            }
        }
    }

    private boolean checkMap(Object o) {
        if (!Map.class.isInstance(o)) {
            StringBuilder b = new StringBuilder("One of the .yml files in the meta configuration directory is improperly formatted\n");
            b.append("Please make sure they are formatted in this fashion:\n");
            b.append("ui/somepath:\n");
            b.append("\tprotected: false\n\n");
            b.append("ui/someOtherpath:\n");
            b.append("\tprotected: false\n\n");
            LOG.error(b.toString(), (Throwable)new IllegalArgumentException("Invalid .yml file"));
            return false;
        }
        return true;
    }

    public void invalidate() {
        this.properties.clear();
    }
}

