/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.appointment;

import com.meterware.httpunit.Base64;
import com.openexchange.ajax.appointment.recurrence.ManagedAppointmentTest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.importexport.actions.ICalImportRequest;
import com.openexchange.ajax.importexport.actions.ICalImportResponse;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Appointment;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.json.JSONException;

public class Bug19014Test_HugeCalendarsProvokeOOM
extends ManagedAppointmentTest {
    private static final int MAX_NUM_APP = 200;
    private static final int BATCH_SIZE = 100;

    public Bug19014Test_HugeCalendarsProvokeOOM(String name) {
        super(name);
    }

    protected long insertAppointments(int numberOfApps, int batchSize) throws Exception {
        long start = new Date().getTime();
        StringBuilder ical = new StringBuilder();
        for (int i = 1; i < numberOfApps + 1; ++i) {
            ical.append("BEGIN:VEVENT\nORGANIZER:MAILTO:oxpro-a01@qs-c4.de\nDTSTART;TZID=W. Europe Standard Time:20110510T170000\nDTEND;TZID=W. Europe Standard Time:20110510T180000\nDTSTAMP:20110510T113750Z\nLAST-MODIFIED:20110510T113750Z\nCLASS:PUBLIC\n");
            ical.append("SUMMARY:Bug 19014 Test Appointment #" + i + "/" + numberOfApps + "\n");
            ical.append("TITLE:Bug 19014 Test Appointment #" + i + "/" + numberOfApps + "\n");
            ical.append("END:VEVENT\n");
            if (i % batchSize != 0) continue;
            ical.insert(0, "BEGIN:VCALENDAR\nMETHOD:REQUEST\nPRODID:OX Test for Bug 19014\nVERSION:2.0\n");
            ical.append("END:VCALENDAR");
            ICalImportResponse importResponse = this.getClient().execute(new ICalImportRequest(this.folder.getObjectID(), ical.toString()));
            Bug19014Test_HugeCalendarsProvokeOOM.assertFalse((importResponse.hasConflicts() || importResponse.hasError() ? 1 : 0) != 0);
            ical = new StringBuilder();
        }
        return (new Date().getTime() - start) / 1000L;
    }

    private HttpResponse makeTheCall(int folderId) throws OXException, JSONException, IOException {
        AJAXConfig.init();
        String login = AJAXConfig.getProperty(AJAXClient.User.User1.getLogin());
        String context = AJAXConfig.getProperty(AJAXConfig.Property.CONTEXTNAME);
        String password = AJAXConfig.getProperty(AJAXClient.User.User1.getPassword());
        DefaultHttpClient rawClient = this.getClient().getSession().getHttpClient();
        HttpGet icalRequest = new HttpGet("http://localhost/servlet/webdav.ical?calendarfolder=" + folderId);
        icalRequest.addHeader("authorization", "Basic " + Base64.encode((String)(login + "@" + context + ":" + password)));
        HttpResponse response = rawClient.execute((HttpUriRequest)icalRequest);
        return response;
    }

    public void testHugeNumberOfAppointments() throws Exception {
        this.insertAppointments(200, 100);
        HttpResponse response = this.makeTheCall(this.folder.getObjectID());
        Pattern pattern = Pattern.compile("Bug 19014 Test Appointment #(\\d+)/200");
        BufferedReader ical = new BufferedReader(new InputStreamReader(response.getEntity().getContent()), 65536);
        String line = null;
        int numTzDefs = 0;
        HashSet<Integer> number = new HashSet<Integer>();
        while ((line = ical.readLine()) != null) {
            Matcher matcher = pattern.matcher(line);
            if (line.contains("TZID:Europe/Berlin")) {
                ++numTzDefs;
            }
            if (!matcher.find()) continue;
            String group = matcher.group(1);
            number.add(Integer.valueOf(group));
        }
        ical.close();
        for (int i = 1; i < 201; ++i) {
            Bug19014Test_HugeCalendarsProvokeOOM.assertTrue((String)("Did not find " + i), (boolean)number.contains(i));
        }
        Bug19014Test_HugeCalendarsProvokeOOM.assertEquals((String)"Timezone Europe/Berlin should be defined only once!", (int)1, (int)numTzDefs);
    }

    public void testSeriesExceptions() throws Exception {
        int fid = this.folder.getObjectID();
        Appointment series = this.generateDailyAppointment();
        series.setStartDate(this.D("1/1/2008 11:00", this.utc));
        series.setEndDate(this.D("1/1/2008 12:00", this.utc));
        series.setTitle("A daily series");
        series.setParentFolderID(fid);
        this.calendarManager.insert(series);
        Date lastMod = series.getLastModified();
        int numChanges = 105;
        for (int i = 1; i < numChanges + 1; ++i) {
            Appointment changeEx = new Appointment();
            changeEx.setParentFolderID(series.getParentFolderID());
            changeEx.setObjectID(series.getObjectID());
            changeEx.setLastModified(lastMod);
            changeEx.setRecurrencePosition(i);
            changeEx.setTitle("Element # " + i + " of series that has different name");
            this.calendarManager.update(changeEx);
            Bug19014Test_HugeCalendarsProvokeOOM.assertNull((String)("Problem with update #" + i), (Object)this.calendarManager.getLastException());
            lastMod = new Date(this.calendarManager.getLastModification().getTime() + 1L);
        }
        HttpResponse response = this.makeTheCall(this.folder.getObjectID());
        String ical = IOUtils.toString((InputStream)response.getEntity().getContent());
        Bug19014Test_HugeCalendarsProvokeOOM.assertTrue((String)("The series should be exported:" + System.getProperty("line.separator") + ical), (boolean)ical.contains("A daily series"));
        for (int i = 1; i < numChanges + 1; ++i) {
            Bug19014Test_HugeCalendarsProvokeOOM.assertTrue((String)"The exception should be exported", (boolean)ical.contains("Element # " + i + " of series that has different name"));
            if (i < 10) {
                Bug19014Test_HugeCalendarsProvokeOOM.assertTrue((String)("There should be an exception on day #" + i), (boolean)ical.contains("RECURRENCE-ID:2008010" + i + "T"));
                continue;
            }
            if (i >= 32) continue;
            Bug19014Test_HugeCalendarsProvokeOOM.assertTrue((String)("There should be an exception on day #" + i), (boolean)ical.contains("RECURRENCE-ID:200801" + i + "T"));
        }
    }
}

