/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.structure;

import com.openexchange.mail.AbstractMailTest;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.structure.StructureHandler;
import com.openexchange.mail.structure.StructureMailMessageParser;
import com.openexchange.mail.structure.handler.MIMEStructureHandler;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.mail.internet.MimeMessage;
import org.json.JSONObject;

public class Bug26317_StructureTest
extends AbstractMailTest {
    public Bug26317_StructureTest() {
    }

    public Bug26317_StructureTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testMIMEStructure() {
        try {
            this.getSession();
            ByteArrayInputStream is = new ByteArrayInputStream("X-Header: Open-Xchange USM Mailer (USM Version: 7.0.2-6, EAS Version: 7.0.2-6, Build f9dd375f96fde35b0cc630a626971a1196347d48)\nContent-Type: multipart/mixed; boundary=Apple-Mail-908E0B40-E1C4-4CC2-8245-8674A4C8DB7C\nContent-Transfer-Encoding: 7bit\nSubject: Stempeluhr\nFrom: Jane Doe <jane@foo.com>\nMessage-ID: <2094039877.318527.1367408118992.open-xchange@localhost>\nDate: Wed, 1 May 2013 13:35:19 +0200\nTo: bob@bar.com>\nMime-Version: 1.0\n\n\n\n--Apple-Mail-908E0B40-E1C4-4CC2-8245-8674A4C8DB7C\nContent-Type: text/plain;\n    charset=utf-8\nContent-Transfer-Encoding: quoted-printable\n\n=C3=9Cbersicht der gebuchten Zeiten:\n\n\n\n--Apple-Mail-908E0B40-E1C4-4CC2-8245-8674A4C8DB7C\nContent-Type: text/comma-separated-values;\n    name=\"Stempeluhr__01.05.2013 13:35.csv\"\nContent-Disposition: attachment;\n    filename=\"Stempeluhr__01.05.2013 13:35.csv\"\nContent-Transfer-Encoding: base64\n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\n\n--Apple-Mail-908E0B40-E1C4-4CC2-8245-8674A4C8DB7C\nContent-Type: text/plain;\n    charset=utf-8\nContent-Transfer-Encoding: quoted-printable\n\n\n\n\nMit freundlichen Gr=C3=BC=C3=9Fen\n\nJane Doe\n--Apple-Mail-908E0B40-E1C4-4CC2-8245-8674A4C8DB7C--".getBytes());
            MimeMessage mimeMessage = new MimeMessage(MimeDefaultSession.getDefaultSession(), (InputStream)is);
            MailMessage mail = MimeMessageConverter.convertMessage((MimeMessage)mimeMessage);
            MIMEStructureHandler handler = new MIMEStructureHandler(-1L);
            new StructureMailMessageParser().setParseTNEFParts(true).parseMailMessage(mail, (StructureHandler)handler);
            JSONObject jsonMailObject = handler.getJSONMailObject();
            Bug26317_StructureTest.assertNotNull((String)"Structured JSON mail object is null.", (Object)jsonMailObject);
            JSONObject jsonPartObject = jsonMailObject.getJSONArray("body").getJSONObject(1);
            JSONObject jsonHeaderObject = jsonPartObject.getJSONObject("headers").getJSONObject("content-type");
            Bug26317_StructureTest.assertEquals((String)"Unexpected Content-Type for Excel CSV sheet.", (String)"application/vnd.ms-excel", (String)jsonHeaderObject.getString("type"));
            String sData = jsonPartObject.getJSONObject("body").getString("data");
            Bug26317_StructureTest.assertTrue((String)("Unexpected base64 data:\n" + sData), (sData != null && sData.endsWith("AAsAAoA") ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Bug26317_StructureTest.fail((String)e.getMessage());
        }
    }
}

