/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.messagestorage;

import com.openexchange.exception.OXException;
import com.openexchange.mail.MailField;
import com.openexchange.mail.dataobjects.MailFolder;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.messagestorage.MessageStorageTest;
import java.io.IOException;
import javax.mail.MessagingException;

public final class MailCopyTest
extends MessageStorageTest {
    private static final MailField[] FIELDS_ID = new MailField[]{MailField.ID};
    private static final MailField[] FIELDS_MORE = new MailField[]{MailField.ID, MailField.CONTENT_TYPE, MailField.FLAGS, MailField.BODY};
    private static final MailField[] FIELDS_EVEN_MORE = new MailField[]{MailField.ID, MailField.CONTENT_TYPE, MailField.FLAGS, MailField.FROM, MailField.TO, MailField.DISPOSITION_NOTIFICATION_TO, MailField.COLOR_LABEL, MailField.HEADERS, MailField.SUBJECT, MailField.THREAD_LEVEL, MailField.SIZE, MailField.PRIORITY, MailField.SENT_DATE, MailField.RECEIVED_DATE, MailField.CC, MailField.BCC, MailField.FOLDER_ID};
    private static final MailField[] FIELDS_FULL = new MailField[]{MailField.FULL};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailCopyNotExistingMails() throws OXException, MessagingException, IOException {
        String[] uids = this.mailAccess.getMessageStorage().appendMessages("INBOX", this.testmessages);
        try {
            String fullname = this.createTemporaryFolder(this.getSession(), this.mailAccess);
            try {
                String[] tmpCopy = null;
                try {
                    long currentTimeMillis = System.currentTimeMillis();
                    tmpCopy = this.mailAccess.getMessageStorage().copyMessages("INBOX", fullname, new String[]{String.valueOf(currentTimeMillis), String.valueOf(currentTimeMillis + 1L)}, false);
                }
                catch (Exception e) {
                    MailCopyTest.fail((String)"No exception should be thrown here");
                }
                MailCopyTest.assertNotNull((String)"Move returned no IDs", tmpCopy);
                MailCopyTest.assertTrue((String)("Method moveMessages returned wrong id at pos 0. Must be null, but was " + (String)tmpCopy[0]), (tmpCopy[0] == null ? 1 : 0) != 0);
                MailCopyTest.assertTrue((String)("Method moveMessages returned wrong id at pos 1. Must be null, but was " + tmpCopy[1]), (tmpCopy[1] == null ? 1 : 0) != 0);
            }
            finally {
                this.mailAccess.getFolderStorage().deleteFolder(fullname, true);
            }
        }
        finally {
            this.mailAccess.getMessageStorage().deleteMessages("INBOX", uids, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailCopyNotExistingMailsMixed() throws OXException, MessagingException, IOException {
        String[] uids = this.mailAccess.getMessageStorage().appendMessages("INBOX", this.testmessages);
        try {
            String fullname = this.createTemporaryFolder(this.getSession(), this.mailAccess);
            try {
                String[] tmpCopy = null;
                try {
                    tmpCopy = this.mailAccess.getMessageStorage().copyMessages("INBOX", fullname, new String[]{String.valueOf(System.currentTimeMillis()), uids[0]}, false);
                }
                catch (Exception e) {
                    MailCopyTest.fail((String)"No exception should be thrown here");
                }
                MailCopyTest.assertNotNull((String)"Move returned no IDs", tmpCopy);
                MailCopyTest.assertTrue((String)("Method moveMessages returned wrong id at pos 0. Must be null, but was " + (String)tmpCopy[0]), (tmpCopy[0] == null ? 1 : 0) != 0);
                MailCopyTest.assertTrue((String)("Method moveMessages returned wrong id at pos 1. Must be != null, but was " + tmpCopy[1]), (tmpCopy[1] != null ? 1 : 0) != 0);
            }
            finally {
                this.mailAccess.getFolderStorage().deleteFolder(fullname, true);
            }
        }
        finally {
            this.mailAccess.getMessageStorage().deleteMessages("INBOX", uids, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailCopyToNotExistingFolder() throws OXException, MessagingException, IOException {
        String[] uids = this.mailAccess.getMessageStorage().appendMessages("INBOX", this.testmessages);
        try {
            MailFolder inbox = this.mailAccess.getFolderStorage().getFolder("INBOX");
            String tmpFolderName = inbox.getFullname() + inbox.getSeparator() + "MichGibtEsNicht";
            try {
                MailCopyTest.assertNull((String)"No ids should be returned", (Object)this.mailAccess.getMessageStorage().copyMessages("INBOX", tmpFolderName, uids, false));
            }
            catch (OXException e) {
                MailCopyTest.assertTrue((String)"Wrong Exception is thrown.", (boolean)e.getErrorCode().endsWith("-1002"));
            }
        }
        finally {
            this.mailAccess.getMessageStorage().deleteMessages("INBOX", uids, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailCopyFromNotExistingFolder() throws OXException, MessagingException, IOException {
        String[] uids = this.mailAccess.getMessageStorage().appendMessages("INBOX", this.testmessages);
        try {
            String fullname = this.createTemporaryFolder(this.getSession(), this.mailAccess);
            try {
                try {
                    MailCopyTest.assertNull((String)"No ids should be returned", (Object)this.mailAccess.getMessageStorage().copyMessages("MichGibtEsHoffentlichNicht", fullname, uids, false));
                }
                catch (OXException e) {
                    MailCopyTest.assertTrue((String)"Wrong Exception is thrown.", (boolean)e.getErrorCode().endsWith("-1002"));
                }
            }
            finally {
                this.mailAccess.getFolderStorage().deleteFolder(fullname, true);
            }
        }
        finally {
            this.mailAccess.getMessageStorage().deleteMessages("INBOX", uids, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailCopy() throws OXException, MessagingException, IOException {
        String[] uids = this.mailAccess.getMessageStorage().appendMessages("INBOX", this.testmessages);
        try {
            String fullname = this.createTemporaryFolder(this.getSession(), this.mailAccess);
            try {
                int i;
                String[] copied = this.mailAccess.getMessageStorage().copyMessages("INBOX", fullname, uids, false);
                MailCopyTest.assertTrue((String)"Missing copied mail IDs", (copied != null ? 1 : 0) != 0);
                MailCopyTest.assertTrue((String)"Number of copied messages does not match", (copied.length == uids.length ? 1 : 0) != 0);
                for (int i2 = 0; i2 < copied.length; ++i2) {
                    MailCopyTest.assertTrue((String)"Invalid mail ID", (copied[i2] != null ? 1 : 0) != 0);
                }
                MailMessage[] fetchedMails = this.mailAccess.getMessageStorage().getMessages(fullname, copied, FIELDS_ID);
                for (i = 0; i < fetchedMails.length; ++i) {
                    MailCopyTest.assertFalse((String)"Mail ID is null", (fetchedMails[i].getMailId() == null ? 1 : 0) != 0);
                }
                fetchedMails = this.mailAccess.getMessageStorage().getMessages(fullname, copied, FIELDS_MORE);
                for (i = 0; i < fetchedMails.length; ++i) {
                    MailCopyTest.assertFalse((String)"Missing mail ID", (fetchedMails[i].getMailId() == null ? 1 : 0) != 0);
                    MailCopyTest.assertTrue((String)"Missing content type", (boolean)fetchedMails[i].containsContentType());
                    MailCopyTest.assertTrue((String)"Missing flags", (boolean)fetchedMails[i].containsFlags());
                    if (fetchedMails[i].getContentType().isMimeType("multipart/*")) {
                        MailCopyTest.assertFalse((String)"Enclosed count returned -1", (fetchedMails[i].getEnclosedCount() == -1 ? 1 : 0) != 0);
                        continue;
                    }
                    MailCopyTest.assertFalse((String)"Content is null", (fetchedMails[i].getContent() == null ? 1 : 0) != 0);
                }
                fetchedMails = this.mailAccess.getMessageStorage().getMessages(fullname, copied, FIELDS_EVEN_MORE);
                for (i = 0; i < fetchedMails.length; ++i) {
                    MailCopyTest.assertFalse((String)"Missing mail ID", (fetchedMails[i].getMailId() == null ? 1 : 0) != 0);
                    MailCopyTest.assertTrue((String)"Missing content type", (boolean)fetchedMails[i].containsContentType());
                    MailCopyTest.assertTrue((String)"Missing flags", (boolean)fetchedMails[i].containsFlags());
                    MailCopyTest.assertTrue((String)"Missing From", (boolean)fetchedMails[i].containsFrom());
                    MailCopyTest.assertTrue((String)"Missing To", (boolean)fetchedMails[i].containsTo());
                    MailCopyTest.assertTrue((String)"Missing Disposition-Notification-To", (boolean)fetchedMails[i].containsDispositionNotification());
                    MailCopyTest.assertTrue((String)"Missing color label", (boolean)fetchedMails[i].containsColorLabel());
                    MailCopyTest.assertTrue((String)"Missing headers", (boolean)fetchedMails[i].containsHeaders());
                    MailCopyTest.assertTrue((String)"Missing subject", (boolean)fetchedMails[i].containsSubject());
                    MailCopyTest.assertTrue((String)"Missing thread level", (boolean)fetchedMails[i].containsThreadLevel());
                    MailCopyTest.assertTrue((String)"Missing size", (boolean)fetchedMails[i].containsSize());
                    MailCopyTest.assertTrue((String)"Missing priority", (boolean)fetchedMails[i].containsPriority());
                    MailCopyTest.assertTrue((String)"Missing sent date", (boolean)fetchedMails[i].containsSentDate());
                    MailCopyTest.assertTrue((String)"Missing received date", (boolean)fetchedMails[i].containsReceivedDate());
                    MailCopyTest.assertTrue((String)"Missing Cc", (boolean)fetchedMails[i].containsCc());
                    MailCopyTest.assertTrue((String)"Missing Bcc", (boolean)fetchedMails[i].containsBcc());
                    MailCopyTest.assertTrue((String)"Missing folder fullname", (boolean)fetchedMails[i].containsFolder());
                }
                fetchedMails = this.mailAccess.getMessageStorage().getMessages(fullname, copied, FIELDS_FULL);
                for (i = 0; i < fetchedMails.length; ++i) {
                    MailCopyTest.assertFalse((String)"Missing mail ID", (fetchedMails[i].getMailId() == null ? 1 : 0) != 0);
                    MailCopyTest.assertTrue((String)"Missing content type", (boolean)fetchedMails[i].containsContentType());
                    MailCopyTest.assertTrue((String)"Missing flags", (boolean)fetchedMails[i].containsFlags());
                    MailCopyTest.assertTrue((String)"Missing From", (boolean)fetchedMails[i].containsFrom());
                    MailCopyTest.assertTrue((String)"Missing To", (boolean)fetchedMails[i].containsTo());
                    MailCopyTest.assertTrue((String)"Missing Disposition-Notification-To", (boolean)fetchedMails[i].containsDispositionNotification());
                    MailCopyTest.assertTrue((String)"Missing color label", (boolean)fetchedMails[i].containsColorLabel());
                    MailCopyTest.assertTrue((String)"Missing headers", (boolean)fetchedMails[i].containsHeaders());
                    MailCopyTest.assertTrue((String)"Missing subject", (boolean)fetchedMails[i].containsSubject());
                    MailCopyTest.assertTrue((String)"Missing thread level", (boolean)fetchedMails[i].containsThreadLevel());
                    MailCopyTest.assertTrue((String)"Missing size", (boolean)fetchedMails[i].containsSize());
                    MailCopyTest.assertTrue((String)"Missing priority", (boolean)fetchedMails[i].containsPriority());
                    MailCopyTest.assertTrue((String)"Missing sent date", (boolean)fetchedMails[i].containsSentDate());
                    MailCopyTest.assertTrue((String)"Missing received date", (boolean)fetchedMails[i].containsReceivedDate());
                    MailCopyTest.assertTrue((String)"Missing Cc", (boolean)fetchedMails[i].containsCc());
                    MailCopyTest.assertTrue((String)"Missing Bcc", (boolean)fetchedMails[i].containsBcc());
                    MailCopyTest.assertTrue((String)"Missing folder fullname", (boolean)fetchedMails[i].containsFolder());
                    if (fetchedMails[i].getContentType().isMimeType("multipart/*")) {
                        MailCopyTest.assertFalse((String)"Enclosed count returned -1", (fetchedMails[i].getEnclosedCount() == -1 ? 1 : 0) != 0);
                        continue;
                    }
                    MailCopyTest.assertFalse((String)"Content is null", (fetchedMails[i].getContent() == null ? 1 : 0) != 0);
                }
            }
            finally {
                this.mailAccess.getFolderStorage().deleteFolder(fullname, true);
            }
        }
        finally {
            this.mailAccess.getMessageStorage().deleteMessages("INBOX", uids, true);
        }
    }
}

