/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.i18n;

import com.openexchange.i18n.tools.StringTemplate;
import java.util.Locale;
import junit.framework.TestCase;

public class CompiledLineParserTemplateTest
extends TestCase {
    private static final Locale locale = new Locale("en");

    public void testBasic() {
        StringTemplate template = new StringTemplate("Hello [title]!\n This is [location]!");
        String output = template.render(locale, new String[]{"title", "You", "location", "nice"});
        CompiledLineParserTemplateTest.assertEquals((String)"Hello You!\n This is nice!", (String)output);
    }

    public void testBeginsWithVar() {
        String test = "[title] rocks!";
        String expected = "Template parsing rocks!";
        StringTemplate template = new StringTemplate("[title] rocks!");
        String output = template.render(locale, new String[]{"title", "Template parsing"});
        CompiledLineParserTemplateTest.assertEquals((String)"Template parsing rocks!", (String)output);
    }

    public void testNull() {
        String test = "[title] is unset";
        String expected = " is unset";
        StringTemplate template = new StringTemplate("[title] is unset");
        String output = template.render(locale, new String[0]);
        CompiledLineParserTemplateTest.assertEquals((String)" is unset", (String)output);
    }

    public void testMissingOpeningBracket() {
        String test;
        String expected = test = "dysfunctional template]";
        StringTemplate template = new StringTemplate(test);
        String output = template.render(locale, new String[0]);
        CompiledLineParserTemplateTest.assertEquals((String)expected, (String)output);
    }
}

