/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore;

import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.groupware.infostore.webdav.PropertyStore;
import com.openexchange.groupware.infostore.webdav.PropertyStoreImpl;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.webdav.protocol.WebdavProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;

public class PropertyStoreTest
extends TestCase {
    private PropertyStore propertyStore;
    protected List<Integer> clean = new ArrayList<Integer>();
    protected int entity = 23;
    protected int entity2 = 42;
    private final Context ctx = new ContextImpl(1);
    private final User user = null;
    private final UserConfiguration userConfig = null;

    public void setUp() throws Exception {
        super.setUp();
        Init.startServer();
        this.propertyStore = new PropertyStoreImpl((DBProvider)new DBPoolProvider(), "infostore_property");
        this.propertyStore.startTransaction();
        WebdavProperty property = new WebdavProperty();
        property.setName("testprop");
        property.setNamespace("OX:");
        property.setValue("I'm the value");
        WebdavProperty property2 = new WebdavProperty();
        property2.setName("testprop2");
        property2.setNamespace("OX:");
        property2.setValue("<bla>I'm the value2</bla>");
        property2.setXML(true);
        this.propertyStore.saveProperties(this.entity, Arrays.asList(property, property2), this.ctx);
        this.clean.add(this.entity);
        this.propertyStore.saveProperties(this.entity2, Arrays.asList(property, property2), this.ctx);
        this.clean.add(this.entity2);
    }

    public void tearDown() throws Exception {
        this.propertyStore.removeAll(this.clean, this.ctx);
        this.clean.clear();
        this.propertyStore.commit();
        this.propertyStore.finish();
        Init.stopServer();
        super.tearDown();
    }

    public void testLoadSpecificForOneEntity() throws Exception {
        List props = this.propertyStore.loadProperties(this.entity, this.p("OX:", "testprop"), this.ctx);
        PropertyStoreTest.assertEquals((int)1, (int)props.size());
        PropertyStoreTest.assertEquals((String)"I'm the value", (String)((WebdavProperty)props.get(0)).getValue());
        PropertyStoreTest.assertFalse((boolean)((WebdavProperty)props.get(0)).isXML());
    }

    public void testLoadSpecificForManyEntities() throws Exception {
        Map props = this.propertyStore.loadProperties(Arrays.asList(this.entity, this.entity2), this.p("OX:", "testprop"), this.ctx);
        PropertyStoreTest.assertEquals((int)2, (int)props.keySet().size());
        List p = (List)props.get(this.entity);
        PropertyStoreTest.assertNotNull((Object)p);
        PropertyStoreTest.assertEquals((int)1, (int)p.size());
        PropertyStoreTest.assertEquals((String)"I'm the value", (String)((WebdavProperty)p.get(0)).getValue());
        PropertyStoreTest.assertFalse((boolean)((WebdavProperty)p.get(0)).isXML());
        p = (List)props.get(this.entity2);
        PropertyStoreTest.assertNotNull((Object)p);
        PropertyStoreTest.assertEquals((int)1, (int)p.size());
        PropertyStoreTest.assertEquals((String)"I'm the value", (String)((WebdavProperty)p.get(0)).getValue());
        PropertyStoreTest.assertFalse((boolean)((WebdavProperty)p.get(0)).isXML());
    }

    public void testLoadAllForOneEntity() throws Exception {
        List props = this.propertyStore.loadAllProperties(this.entity, this.ctx);
        this.checkProps(props);
    }

    public void testLoadAllForManyEntities() throws Exception {
        Map props = this.propertyStore.loadAllProperties(Arrays.asList(this.entity, this.entity2), this.ctx);
        PropertyStoreTest.assertEquals((int)2, (int)props.keySet().size());
        List p = (List)props.get(this.entity);
        this.checkProps(p);
        p = (List)props.get(this.entity2);
        this.checkProps(p);
    }

    public void testDeleteSpecificForOneEntity() throws Exception {
        this.propertyStore.removeProperties(this.entity, this.p("OX:", "testprop"), this.ctx);
        List props = this.propertyStore.loadAllProperties(this.entity, this.ctx);
        PropertyStoreTest.assertEquals((int)1, (int)props.size());
        PropertyStoreTest.assertEquals((String)"testprop2", (String)((WebdavProperty)props.get(0)).getName());
    }

    public void testDeleteAllForOneEntity() throws Exception {
        this.propertyStore.removeAll(this.entity, this.ctx);
        List props = this.propertyStore.loadAllProperties(this.entity, this.ctx);
        PropertyStoreTest.assertTrue((boolean)props.isEmpty());
    }

    private void checkProps(List<WebdavProperty> props) {
        PropertyStoreTest.assertNotNull(props);
        PropertyStoreTest.assertEquals((int)2, (int)props.size());
        int mask = 0;
        for (WebdavProperty prop : props) {
            if (prop.getName().equals("testprop")) {
                ++mask;
                PropertyStoreTest.assertEquals((String)"I'm the value", (String)prop.getValue());
                PropertyStoreTest.assertFalse((boolean)prop.isXML());
                continue;
            }
            if (!prop.getName().equals("testprop2")) continue;
            mask += 2;
            PropertyStoreTest.assertEquals((String)"<bla>I'm the value2</bla>", (String)prop.getValue());
            PropertyStoreTest.assertTrue((boolean)prop.isXML());
        }
        PropertyStoreTest.assertEquals((int)3, (int)mask);
    }

    private List<WebdavProperty> p(String ... props) {
        ArrayList<WebdavProperty> propList = new ArrayList<WebdavProperty>();
        for (int i = 0; i < props.length; ++i) {
            String namespace = props[i++];
            String name = props[i];
            propList.add(new WebdavProperty(namespace, name));
        }
        return propList;
    }
}

