/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.importexport.importers;

import com.openexchange.calendar.api.CalendarCollection;
import com.openexchange.data.conversion.ical.ConversionError;
import com.openexchange.data.conversion.ical.ICalParser;
import com.openexchange.data.conversion.ical.SimICalParser;
import com.openexchange.groupware.calendar.CalendarCollectionService;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.importexport.importers.ExtraneousSeriesMasterRecoveryParser;
import com.openexchange.server.services.ServerServiceRegistry;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import junit.framework.TestCase;

public class Bug12380RecoveryParserTest
extends TestCase {
    private SimICalParser parser;
    private ExtraneousSeriesMasterRecoveryParser bugParser;

    public void setUp() {
        this.parser = new SimICalParser();
        ServerServiceRegistry registry = ServerServiceRegistry.getInstance();
        this.bugParser = new ExtraneousSeriesMasterRecoveryParser((ICalParser)this.parser, registry);
        if (null == registry.getService(CalendarCollectionService.class)) {
            registry.addService(CalendarCollectionService.class, (Object)new CalendarCollection());
        }
    }

    public void testMultiplexes() throws ConversionError {
        CalendarDataObject appointment = new CalendarDataObject();
        appointment.setTitle("I start on a different date than my series settings suggest");
        appointment.setStartDate(TimeTools.D("Monday at 8 am"));
        appointment.setEndDate(TimeTools.D("Monday at 10 am"));
        appointment.setRecurrenceType(2);
        appointment.setInterval(1);
        appointment.setDays(4);
        this.parser.setAppointments(Arrays.asList(appointment));
        List parsed = this.bugParser.parseAppointments((String)null, null, null, null, null);
        Bug12380RecoveryParserTest.assertEquals((String)"Expected appointment to be split into two", (int)2, (int)parsed.size());
        CalendarDataObject app1 = (CalendarDataObject)parsed.get(0);
        CalendarDataObject app2 = (CalendarDataObject)parsed.get(1);
        Bug12380RecoveryParserTest.assertEquals((String)"Start date was not as expected", (Object)appointment.getStartDate(), (Object)app1.getStartDate());
        Bug12380RecoveryParserTest.assertEquals((String)"Start date was not as expected", (Object)appointment.getStartDate(), (Object)app2.getStartDate());
        Bug12380RecoveryParserTest.assertEquals((String)"End date was not as expected", (Object)appointment.getEndDate(), (Object)app1.getEndDate());
        Bug12380RecoveryParserTest.assertEquals((String)"End date was not as expected", (Object)appointment.getEndDate(), (Object)app2.getEndDate());
        Bug12380RecoveryParserTest.assertEquals((String)"Title was not as expected", (String)appointment.getTitle(), (String)app1.getTitle());
        Bug12380RecoveryParserTest.assertEquals((String)"Title was not as expected", (String)appointment.getTitle(), (String)app2.getTitle());
        Bug12380RecoveryParserTest.assertTrue((String)"One of app1 and app2 has to be a recurrence, the other one not.", (boolean)(app1.getRecurrenceType() == 0 ^ app2.getRecurrenceType() == 0));
    }

    public void testDoesntMultiplexWhenSeriesMasterIsOnStart() throws ConversionError {
        CalendarDataObject appointment = new CalendarDataObject();
        appointment.setTitle("I start on a date inside my series parameters");
        appointment.setStartDate(TimeTools.D("Tuesday at 8 am"));
        appointment.setEndDate(TimeTools.D("Tuesday at 10 am"));
        appointment.setRecurrenceType(2);
        appointment.setInterval(1);
        appointment.setDays(4);
        this.parser.setAppointments(Arrays.asList(appointment));
        List parsed = this.bugParser.parseAppointments((String)null, null, null, null, null);
        Bug12380RecoveryParserTest.assertEquals((String)"Expected appointment to be left as one", (int)1, (int)parsed.size());
    }

    public void testDoesntMultiplexWhenSeriesMasterIsOccurrence() throws ConversionError {
        CalendarDataObject appointment = new CalendarDataObject();
        appointment.setTitle("I start on a date inside my series parameters");
        appointment.setStartDate(new Date(TimeTools.D("Tuesday at 8 am ").getTime() + 604800L));
        appointment.setEndDate(new Date(TimeTools.D("Tuesday at 10 am ").getTime() + 604800L));
        appointment.setRecurrenceType(2);
        appointment.setInterval(1);
        appointment.setDays(4);
        this.parser.setAppointments(Arrays.asList(appointment));
        List parsed = this.bugParser.parseAppointments((String)null, null, null, null, null);
        Bug12380RecoveryParserTest.assertEquals((String)"Expected appointment to be left as one", (int)1, (int)parsed.size());
    }
}

