/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.importexport;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.database.provider.SimpleDBProvider;
import com.openexchange.event.impl.EventClient;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.Attachments;
import com.openexchange.groupware.contact.ContactExceptionCodes;
import com.openexchange.groupware.contact.ContactMySql;
import com.openexchange.groupware.contact.Contacts;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.java.Autoboxing;
import com.openexchange.java.StringAllocator;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.session.Session;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdbContactSQLImpl {
    private final int userId;
    private final int[] memberInGroups;
    private final Context ctx;
    private final Session session;
    private final UserConfiguration userConfiguration;
    private static final Logger LOG = LoggerFactory.getLogger(RdbContactSQLImpl.class);

    public RdbContactSQLImpl(Session session) throws OXException {
        this.ctx = ContextStorage.getStorageContext((Session)session);
        this.userId = session.getUserId();
        this.memberInGroups = UserStorage.getInstance().getUser(session.getUserId(), this.ctx).getGroups();
        this.session = session;
        this.userConfiguration = UserConfigurationStorage.getInstance().getUserConfigurationSafe(session.getUserId(), this.ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Contact getObjectById(int objectId, int fid) throws OXException {
        Contact co;
        if (objectId <= 0) {
            throw ContactExceptionCodes.CONTACT_NOT_FOUND.create(new Object[]{Autoboxing.I((int)objectId), Autoboxing.I((int)this.ctx.getContextId())});
        }
        FolderObject contactFolder = new OXFolderAccess(this.ctx).getFolderObject(fid);
        if (contactFolder.getModule() != 3) {
            throw ContactExceptionCodes.NON_CONTACT_FOLDER.create(new Object[]{Autoboxing.I((int)fid), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId)});
        }
        Connection con = DBPool.pickup((Context)this.ctx);
        try {
            co = Contacts.getContactById((int)objectId, (int)this.userId, (int[])this.memberInGroups, (Context)this.ctx, (UserConfiguration)this.userConfiguration, (Connection)con);
            if (!Contacts.performContactReadCheck((FolderObject)contactFolder, (int)this.userId, (int)co.getCreatedBy(), (UserConfiguration)this.userConfiguration, (Connection)con)) {
                throw ContactExceptionCodes.NO_ACCESS_PERMISSION.create(new Object[]{Autoboxing.I((int)fid), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId)});
            }
            Date creationDate = Attachments.getInstance((DBProvider)new SimpleDBProvider(con, null)).getNewestCreationDate(this.ctx, 7, objectId);
            if (null != creationDate) {
                co.setLastModifiedOfNewestAttachment(creationDate);
            }
        }
        finally {
            DBPool.closeReaderSilent((Context)this.ctx, (Connection)con);
        }
        return co;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteContactObject(int oid, int fuid, Date client_date) throws OXException {
        if (6 == fuid) {
            throw ContactExceptionCodes.NO_USER_CONTACT_DELETE.create();
        }
        Connection readcon = null;
        EffectivePermission oclPerm = null;
        int created_from = 0;
        Contact co = new Contact();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            readcon = DBPool.pickup((Context)this.ctx);
            boolean pflag = false;
            Date changing_date = null;
            ContactMySql cs = new ContactMySql(this.session, this.ctx);
            stmt = readcon.createStatement();
            rs = stmt.executeQuery(cs.iFdeleteContactObject(oid, this.ctx.getContextId()));
            if (!rs.next()) {
                throw ContactExceptionCodes.CONTACT_NOT_FOUND.create(new Object[]{Autoboxing.I((int)oid), Autoboxing.I((int)this.ctx.getContextId())});
            }
            created_from = rs.getInt(2);
            co.setCreatedBy(created_from);
            co.setParentFolderID(fuid);
            co.setObjectID(oid);
            long xx = rs.getLong(3);
            changing_date = new Date(xx);
            int pf = rs.getInt(4);
            if (!rs.wasNull() && pf > 0) {
                pflag = true;
            }
            if (client_date != null && client_date.getTime() >= 0L && client_date.before(changing_date)) {
                throw ContactExceptionCodes.OBJECT_HAS_CHANGED.create(new Object[]{Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)fuid), Autoboxing.I((int)this.userId), Autoboxing.I((int)oid)});
            }
            OXFolderAccess folderAccess = new OXFolderAccess(readcon, this.ctx);
            FolderObject contactFolder = folderAccess.getFolderObject(fuid);
            if (contactFolder.getModule() != 3) {
                throw ContactExceptionCodes.NON_CONTACT_FOLDER.create(new Object[]{Autoboxing.I((int)fuid), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId)});
            }
            if (contactFolder.getType() != 1 && pflag) {
                LOG.debug(new StringAllocator("Here is a contact in a non PRIVATE folder with a set private flag -> (cid=").append(this.ctx.getContextId()).append(" fid=").append(fuid).append(" oid=").append(oid).append(')').toString());
            } else if (contactFolder.getType() == 1 && pflag && created_from != this.userId) {
                throw ContactExceptionCodes.NO_DELETE_PERMISSION.create(new Object[]{Autoboxing.I((int)fuid), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId)});
            }
            oclPerm = folderAccess.getFolderPermission(fuid, this.userId, this.userConfiguration);
            if (oclPerm.getFolderPermission() <= 0) {
                throw ContactExceptionCodes.NO_DELETE_PERMISSION.create(new Object[]{Autoboxing.I((int)fuid), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId)});
            }
        }
        catch (SQLException e) {
            try {
                throw ContactExceptionCodes.SQL_PROBLEM.create((Throwable)e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                try {
                    if (readcon == null) throw throwable;
                    DBPool.closeReaderSilent((Context)this.ctx, (Connection)readcon);
                    throw throwable;
                }
                catch (Exception ex) {
                    LOG.error("Unable to return Connection", (Throwable)ex);
                }
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        try {
            if (readcon != null) {
                DBPool.closeReaderSilent((Context)this.ctx, (Connection)readcon);
            }
        }
        catch (Exception ex) {
            LOG.error("Unable to return Connection", (Throwable)ex);
        }
        Connection writecon = null;
        try {
            writecon = DBPool.pickupWriteable((Context)this.ctx);
            int deletePermission = oclPerm.getDeletePermission();
            if (deletePermission >= 4) {
                Contacts.deleteContact((int)oid, (int)this.ctx.getContextId(), (Connection)writecon);
            } else {
                if (deletePermission < 2 || created_from != this.userId) {
                    throw ContactExceptionCodes.NO_DELETE_PERMISSION.create(new Object[]{Autoboxing.I((int)fuid), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId)});
                }
                Contacts.deleteContact((int)oid, (int)this.ctx.getContextId(), (Connection)writecon);
            }
            EventClient ec = new EventClient(this.session);
            ec.delete(co);
            return;
        }
        catch (OXException e) {
            throw e;
        }
        finally {
            if (writecon != null) {
                DBPool.closeWriterSilent((Context)this.ctx, (Connection)writecon);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfContacts(int folderId) throws OXException {
        Connection readCon;
        try {
            readCon = DBPool.pickup((Context)this.ctx);
        }
        catch (OXException e) {
            throw ContactExceptionCodes.INIT_CONNECTION_FROM_DBPOOL.create((Throwable)e, new Object[0]);
        }
        try {
            FolderObject contactFolder = new OXFolderAccess(readCon, this.ctx).getFolderObject(folderId);
            if (contactFolder.getModule() != 3) {
                throw ContactExceptionCodes.NON_CONTACT_FOLDER.create(new Object[]{Autoboxing.I((int)folderId), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId)});
            }
            ContactMySql contactSQL = new ContactMySql(this.session, this.ctx);
            EffectivePermission oclPerm = new OXFolderAccess(readCon, this.ctx).getFolderPermission(folderId, this.userId, this.userConfiguration);
            if (oclPerm.getFolderPermission() <= 0) {
                throw ContactExceptionCodes.NO_ACCESS_PERMISSION.create(new Object[]{Autoboxing.I((int)folderId), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId)});
            }
            if (!oclPerm.canReadAllObjects()) {
                if (oclPerm.canReadOwnObjects()) {
                    contactSQL.setReadOnlyOwnFolder(this.userId);
                } else {
                    throw ContactExceptionCodes.NO_ACCESS_PERMISSION.create(new Object[]{Autoboxing.I((int)folderId), Autoboxing.I((int)this.ctx.getContextId()), Autoboxing.I((int)this.userId)});
                }
            }
            contactSQL.setSelect(contactSQL.iFgetNumberOfContactsString());
            contactSQL.setFolder(folderId);
            int retval = 0;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                stmt = contactSQL.getSqlStatement(readCon);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    retval = rs.getInt(1);
                }
            }
            catch (SQLException e) {
                try {
                    throw ContactExceptionCodes.SQL_PROBLEM.create((Throwable)e, new Object[0]);
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(rs, (Statement)stmt);
                    throw throwable;
                }
            }
            DBUtils.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            int n = retval;
            return n;
        }
        finally {
            DBPool.closeReaderSilent((Context)this.ctx, (Connection)readCon);
        }
    }
}

