/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar.tools;

import com.openexchange.api2.AppointmentSQLInterface;
import com.openexchange.calendar.CalendarSql;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.search.Order;
import com.openexchange.server.impl.DBPool;
import com.openexchange.session.Session;
import com.openexchange.setuptools.TestContextToolkit;
import com.openexchange.setuptools.TestFolderToolkit;
import com.openexchange.tools.iterator.SearchIterator;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;

public class CommonAppointments {
    private CalendarSql calendar = null;
    private int privateFolder;
    private final Context ctx;
    private final long FUTURE = System.currentTimeMillis() + 86400000L;
    private Session session;

    public CommonAppointments(Context ctx, String user) {
        this.ctx = ctx;
        this.switchUser(user);
    }

    public int getPrivateFolder() {
        return this.privateFolder;
    }

    public CalendarDataObject buildRecurringAppointment() {
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setTitle("recurring");
        cdao.setParentFolderID(this.privateFolder);
        cdao.setIgnoreConflicts(true);
        cdao.setStartDate(new Date(100L));
        cdao.setEndDate(new Date(36000100L));
        cdao.setRecurrenceType(3);
        cdao.setOccurrence(5);
        cdao.setDayInMonth(3);
        cdao.setInterval(2);
        cdao.setDays(4);
        cdao.setContext(this.ctx);
        return cdao;
    }

    public void copyRecurringInformation(CalendarDataObject source, CalendarDataObject target) {
        HashSet<Integer> recurrenceFields = new HashSet<Integer>(){
            {
                this.add(209);
                this.add(215);
                this.add(212);
                this.add(213);
                this.add(214);
                this.add(222);
                this.add(216);
            }
        };
        Iterator i$ = recurrenceFields.iterator();
        while (i$.hasNext()) {
            int recurrenceField = (Integer)i$.next();
            if (!source.contains(recurrenceField) || recurrenceField == 216 && target.contains(222) || recurrenceField == 222 && target.contains(216)) continue;
            target.set(recurrenceField, source.get(recurrenceField));
        }
    }

    public CalendarDataObject buildBasicAppointment(Date start, Date end) {
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setTitle("basic");
        cdao.setParentFolderID(this.privateFolder);
        cdao.setIgnoreConflicts(true);
        cdao.setStartDate(start);
        cdao.setEndDate(end);
        cdao.setContext(this.ctx);
        cdao.setTimezone("utc");
        return cdao;
    }

    public void removeAll(String user, List<CalendarDataObject> clean) throws SQLException, OXException {
        this.switchUser(user);
        for (CalendarDataObject cdao : clean) {
            try {
                this.calendar.deleteAppointmentObject(cdao, cdao.getParentFolderID(), new Date(Long.MAX_VALUE));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public CalendarDataObject buildAppointmentWithUserParticipants(String ... usernames) {
        return this.buildAppointmentWithParticipants(usernames, new String[0], new String[0]);
    }

    public CalendarDataObject buildAppointmentWithResourceParticipants(String ... resources) {
        return this.buildAppointmentWithParticipants(new String[0], resources, new String[0]);
    }

    public CalendarDataObject buildAppointmentWithGroupParticipants(String ... groups) {
        return this.buildAppointmentWithParticipants(new String[0], new String[0], groups);
    }

    public CalendarDataObject buildAppointmentWithParticipants(String[] users, String[] resources, String[] groups) {
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setTitle("with participants");
        cdao.setParentFolderID(this.privateFolder);
        cdao.setIgnoreConflicts(true);
        long FIVE_DAYS = 432000000L;
        long THREE_HOURS = 10800000L;
        cdao.setStartDate(new Date(this.FUTURE + 432000000L));
        cdao.setEndDate(new Date(this.FUTURE + 432000000L + 10800000L));
        cdao.setContext(this.ctx);
        TestContextToolkit tools = new TestContextToolkit();
        ArrayList<Object> participants = new ArrayList<Object>(users.length + resources.length + groups.length);
        List<UserParticipant> userParticipants = tools.users(this.ctx, users);
        participants.addAll(userParticipants);
        participants.addAll(tools.resources(this.ctx, resources));
        participants.addAll(tools.groups(this.ctx, groups));
        cdao.setParticipants(participants);
        cdao.setUsers(userParticipants);
        cdao.setContainsResources(resources.length > 0);
        return cdao;
    }

    public void switchUser(String user) {
        TestContextToolkit tools = new TestContextToolkit();
        int userId = tools.resolveUser(user, this.ctx);
        this.privateFolder = new TestFolderToolkit().getStandardFolder(userId, this.ctx);
        this.session = tools.getSessionForUser(user, this.ctx);
        this.calendar = new CalendarSql(this.session);
    }

    public CalendarDataObject[] move(CalendarDataObject cdao, int sourceFolderId) throws OXException {
        CalendarDataObject[] conflicts = null;
        conflicts = cdao.containsObjectID() ? this.calendar.updateAppointmentObject(cdao, sourceFolderId, new Date(Long.MAX_VALUE)) : this.calendar.insertAppointmentObject(cdao);
        if (conflicts == null) {
            return null;
        }
        for (CalendarDataObject conflict : conflicts) {
            conflict.setContext(cdao.getContext());
        }
        return conflicts;
    }

    public CalendarDataObject[] save(CalendarDataObject cdao) throws OXException {
        CalendarDataObject[] conflicts = null;
        conflicts = cdao.containsObjectID() ? this.calendar.updateAppointmentObject(cdao, cdao.getParentFolderID(), new Date(Long.MAX_VALUE)) : this.calendar.insertAppointmentObject(cdao);
        if (conflicts == null) {
            return null;
        }
        for (CalendarDataObject conflict : conflicts) {
            conflict.setContext(cdao.getContext());
        }
        return conflicts;
    }

    public void delete(CalendarDataObject cdao) throws OXException, SQLException {
        this.calendar.deleteAppointmentObject(cdao, cdao.getParentFolderID(), new Date(Long.MAX_VALUE));
    }

    public CalendarDataObject reload(CalendarDataObject which) throws SQLException, OXException {
        return this.calendar.getObjectById(which.getObjectID(), which.getParentFolderID());
    }

    public Session getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll(Context ctx) throws SQLException, OXException {
        Statement stmt = null;
        Connection writeCon = null;
        try {
            writeCon = DBPool.pickupWriteable((Context)ctx);
            stmt = writeCon.createStatement();
            for (String tablename : new String[]{"dateExternal", "prg_dates", "prg_dates_members", "prg_date_rights"}) {
                stmt.executeUpdate("DELETE FROM " + tablename + " WHERE cid = " + ctx.getContextId());
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (writeCon != null) {
                DBPool.closeWriterSilent((Context)ctx, (Connection)writeCon);
            }
        }
    }

    public List<Appointment> getPrivateAppointments() throws OXException {
        return this.getAppointmentsInFolder(this.privateFolder);
    }

    public List<Appointment> getAppointmentsInFolder(int folderId) throws OXException {
        return this.getAppointmentsInFolder(folderId, new int[]{1});
    }

    public List<Appointment> getAppointmentsInFolder(int folderId, int[] columns) throws OXException {
        ArrayList<Appointment> cdao = new ArrayList<Appointment>();
        try {
            SearchIterator iterator = this.calendar.getAppointmentsBetweenInFolder(folderId, columns, new Date(0L), new Date(Long.MAX_VALUE), 1, Order.ASCENDING);
            while (iterator.hasNext()) {
                cdao.add((Appointment)iterator.next());
            }
            return cdao;
        }
        catch (OXException e) {
            throw e;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return Collections.EMPTY_LIST;
        }
    }

    public List<Appointment> getModifiedInFolder(int folderId, long since) throws OXException {
        ArrayList<Appointment> cdao = new ArrayList<Appointment>();
        try {
            SearchIterator iterator = this.calendar.getModifiedAppointmentsInFolder(folderId, new Date(0L), new Date(Long.MAX_VALUE), new int[]{1}, new Date(since));
            while (iterator.hasNext()) {
                cdao.add((Appointment)iterator.next());
            }
            return cdao;
        }
        catch (OXException e) {
            if (e.getPrefix().equals("APP")) {
                throw e;
            }
            e.printStackTrace();
            return Collections.EMPTY_LIST;
        }
    }

    public List<Appointment> getDeletedInFolder(int folderId, long since) throws OXException {
        ArrayList<Appointment> cdao = new ArrayList<Appointment>();
        try {
            SearchIterator iterator = this.calendar.getDeletedAppointmentsInFolder(folderId, new int[]{1}, new Date(since));
            while (iterator.hasNext()) {
                cdao.add((Appointment)iterator.next());
            }
            return cdao;
        }
        catch (OXException e) {
            if (e.getPrefix().equals("APP")) {
                throw e;
            }
            e.printStackTrace();
            return Collections.EMPTY_LIST;
        }
    }

    public static Date D(String date) {
        return TimeTools.D(date);
    }

    public static Date recalculate(Date date, TimeZone from, TimeZone to) {
        GregorianCalendar fromCal = new GregorianCalendar();
        ((Calendar)fromCal).setTimeZone(from);
        fromCal.setTime(date);
        GregorianCalendar toCal = new GregorianCalendar();
        ((Calendar)toCal).setTimeZone(to);
        toCal.set(fromCal.get(1), fromCal.get(2), fromCal.get(5), fromCal.get(11), fromCal.get(12), fromCal.get(13));
        toCal.set(14, 0);
        return toCal.getTime();
    }

    public static String dateString(long time, TimeZone tz) {
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        format.setTimeZone(tz);
        return format.format(new Date(time));
    }

    public CalendarDataObject createIdentifyingCopy(CalendarDataObject appointment) {
        CalendarDataObject copy = new CalendarDataObject();
        copy.setObjectID(appointment.getObjectID());
        copy.setContext(appointment.getContext());
        copy.setParentFolderID(appointment.getParentFolderID());
        return copy;
    }

    public AppointmentSQLInterface getCurrentAppointmentSQLInterface() {
        return this.calendar;
    }

    public CalendarDataObject load(int objectId, int inFolder) throws OXException, SQLException {
        return this.calendar.getObjectById(objectId, inFolder);
    }

    public void confirm(int objectId, int userId, int status, String message) throws OXException {
        this.calendar.setUserConfirmation(objectId, this.getPrivateFolder(), userId, status, message);
    }
}

