/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.data.conversion.ical;

import com.openexchange.data.conversion.ical.Assert;
import com.openexchange.data.conversion.ical.ICalFile;
import com.openexchange.data.conversion.ical.ical4j.ICal4JEmitter;
import com.openexchange.data.conversion.ical.ical4j.internal.UserResolver;
import com.openexchange.data.conversion.ical.ical4j.internal.calendar.Participants;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.calendar.tools.CommonAppointments;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.CalendarObject;
import com.openexchange.groupware.container.ExternalUserParticipant;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.ResourceParticipant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.groupware.ldap.MockUserLookup;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.notify.NotificationConfig;
import com.openexchange.groupware.tasks.Task;
import java.io.IOException;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import junit.framework.TestCase;

public class ICalEmitterTest
extends TestCase {
    private ICal4JEmitter emitter;
    private MockUserLookup users;
    private UserResolver oldUserResolver;
    private final TimeZone tz = TimeZone.getDefault();

    private Appointment getDefault() {
        Appointment app = new Appointment();
        Date start = CommonAppointments.D("24/02/1981 10:00");
        Date end = CommonAppointments.D("24/02/1981 12:00");
        app.setStartDate(start);
        app.setEndDate(end);
        return app;
    }

    public void testSimpleAppointment() throws Exception {
        Appointment app = new Appointment();
        app.setTitle("The Title");
        app.setNote("The Note");
        app.setCategories("cat1, cat2, cat3");
        app.setLocation("The Location");
        app.setTimezone(this.tz.getDisplayName());
        Date start = CommonAppointments.D("24/02/1981 10:00");
        Date end = CommonAppointments.D("24/02/1981 12:00");
        app.setStartDate(start);
        app.setEndDate(end);
        ICalFile ical = this.serialize(app);
        Assert.assertStandardAppFields(ical, start, end);
        Assert.assertProperty(ical, "SUMMARY", "The Title");
        Assert.assertProperty(ical, "DESCRIPTION", "The Note");
        Assert.assertProperty(ical, "CATEGORIES", "cat1, cat2, cat3");
        Assert.assertProperty(ical, "LOCATION", "The Location");
    }

    public void testAppWholeDay() throws IOException {
        Appointment app = new Appointment();
        app.setStartDate(CommonAppointments.D("24/02/1981 00:00"));
        app.setEndDate(CommonAppointments.D("26/02/1981 00:00"));
        app.setFullTime(true);
        ICalFile ical = this.serialize(app);
        Assert.assertProperty(ical, "DTSTART", "VALUE=DATE", "19810224");
        Assert.assertProperty(ical, "DTEND", "VALUE=DATE", "19810226");
    }

    public void testCategoriesMayBeNullOrUnset() throws Exception {
        Appointment app = new Appointment();
        ICalFile ical = this.serialize(app);
        Assert.assertNoProperty(ical, "CATEGORIES");
        app.setCategories(null);
        ical = this.serialize(app);
        Assert.assertNoProperty(ical, "CATEGORIES");
    }

    public void testDeleteExceptionsMayBeNull() throws Exception {
        Appointment app = new Appointment();
        app.setDeleteExceptions((Date[])null);
        this.serialize(app);
        ICalEmitterTest.assertTrue((String)"Just testing survival", (boolean)true);
    }

    public void testAppCreated() throws IOException {
        Appointment appointment = this.getDefault();
        appointment.setCreationDate(CommonAppointments.D("24/02/1981 10:00"));
        ICalFile ical = this.serialize(appointment);
        Assert.assertProperty(ical, "CREATED", "19810224T100000Z");
    }

    public void testAppLastModified() throws IOException {
        Appointment appointment = this.getDefault();
        appointment.setLastModified(CommonAppointments.D("24/02/1981 10:00"));
        ICalFile ical = this.serialize(appointment);
        Assert.assertProperty(ical, "LAST-MODIFIED", "19810224T100000Z");
    }

    public void testAppRecurrence() throws IOException {
        Appointment appointment = this.getDefault();
        appointment.setOccurrence(3);
        appointment.setRecurrenceType(1);
        appointment.setInterval(2);
        ICalFile ical = this.serialize(appointment);
        Assert.assertProperty(ical, "RRULE", "FREQ=DAILY;COUNT=3;INTERVAL=2");
        appointment.setRecurrenceType(2);
        int days = 0;
        days |= 2;
        days |= 8;
        appointment.setDays(days |= 0x20);
        ical = this.serialize(appointment);
        Assert.assertProperty(ical, "RRULE", "FREQ=WEEKLY;COUNT=3;INTERVAL=2;BYDAY=MO,WE,FR");
        appointment.setRecurrenceType(3);
        appointment.removeDays();
        appointment.setDayInMonth(23);
        ical = this.serialize(appointment);
        Assert.assertProperty(ical, "RRULE", "FREQ=MONTHLY;COUNT=3;INTERVAL=2;BYMONTHDAY=23");
        appointment.setDayInMonth(3);
        days = 0;
        days |= 2;
        appointment.setDays(days |= 4);
        ical = this.serialize(appointment);
        Assert.assertProperty(ical, "RRULE", "FREQ=MONTHLY;COUNT=3;INTERVAL=2;BYDAY=MO,TU;BYSETPOS=3");
        appointment.setDayInMonth(5);
        appointment.setDays(4);
        ical = this.serialize(appointment);
        Assert.assertProperty(ical, "RRULE", "FREQ=MONTHLY;COUNT=3;INTERVAL=2;BYDAY=TU;BYSETPOS=-1");
        appointment.removeDays();
        appointment.removeDays();
        appointment.setRecurrenceType(4);
        appointment.setMonth(2);
        appointment.setDayInMonth(23);
        ical = this.serialize(appointment);
        Assert.assertProperty(ical, "RRULE", "FREQ=YEARLY;COUNT=3;INTERVAL=2;BYMONTH=3;BYMONTHDAY=23");
        appointment.setMonth(3);
        appointment.setDayInMonth(2);
        days = 0;
        days |= 2;
        appointment.setDays(days |= 8);
        ical = this.serialize(appointment);
        Assert.assertProperty(ical, "RRULE", "FREQ=YEARLY;COUNT=3;INTERVAL=2;BYMONTH=4;BYDAY=MO,WE;BYSETPOS=2");
        appointment = this.getDefault();
        appointment.setRecurrenceType(1);
        appointment.setInterval(2);
        appointment.setUntil(CommonAppointments.D("23/04/1989 00:00"));
        ical = this.serialize(appointment);
        Assert.assertProperty(ical, "RRULE", "FREQ=DAILY;UNTIL=19890423T235959Z;INTERVAL=2");
        appointment = this.getDefault();
        appointment.setRecurrenceType(0);
        appointment.setInterval(2);
        appointment.setUntil(CommonAppointments.D("23/04/1989 00:00"));
        appointment.setObjectID(1);
        appointment.setRecurrenceID(2);
        appointment.setRecurrencePosition(3);
        ical = this.serialize(appointment);
        Assert.assertNoProperty(ical, "RRULE");
    }

    public void testAppRecurrenceId() throws IOException {
        Appointment appointment = this.getDefault();
        appointment.setRecurrenceID(12);
        appointment.setRecurrenceDatePosition(CommonAppointments.D("26/06/2011 00:00"));
        ICalFile ical = this.serialize(appointment);
        Assert.assertProperty(ical, "RECURRENCE-ID", "20110626");
    }

    public void testAppAlarm() throws IOException {
        boolean MINUTES = true;
        Appointment appointment = this.getDefault();
        appointment.setAlarm(15);
        appointment.setNote("Blupp");
        ICalFile ical = this.serialize(appointment);
        Assert.assertProperty(ical, "BEGIN", "VALARM");
        Assert.assertProperty(ical, "ACTION", "DISPLAY");
        Assert.assertProperty(ical, "TRIGGER", "-PT15M");
        Assert.assertProperty(ical, "DESCRIPTION", "Blupp");
    }

    public void testAppPrivateFlag() throws IOException {
        Appointment app = this.getDefault();
        app.setPrivateFlag(false);
        ICalFile ical = this.serialize(app);
        Assert.assertProperty(ical, "CLASS", "PUBLIC");
        app.setPrivateFlag(true);
        ical = this.serialize(app);
        Assert.assertProperty(ical, "CLASS", "PRIVATE");
    }

    public void testAppTransparency() throws IOException {
        Appointment app = this.getDefault();
        app.setShownAs(1);
        ICalFile ical = this.serialize(app);
        Assert.assertProperty(ical, "TRANSP", "OPAQUE");
        app.setShownAs(4);
        ical = this.serialize(app);
        Assert.assertProperty(ical, "TRANSP", "TRANSPARENT");
    }

    public void testAppAttendees() throws IOException {
        Appointment app = this.getDefault();
        this.setParticipants((CalendarObject)app, new String[]{"user1@internal.invalid", "user2@internal.invalid"}, new String[]{"external1@external.invalid", "external2@external.invalid"});
        ICalFile ical = this.serialize(app);
        Assert.assertProperty(ical, "ATTENDEE", "mailto:user1@internal.invalid");
        Assert.assertProperty(ical, "ATTENDEE", "mailto:user2@internal.invalid");
        Assert.assertProperty(ical, "ATTENDEE", "mailto:external1@external.invalid");
        Assert.assertProperty(ical, "ATTENDEE", "mailto:external2@external.invalid");
        app = this.getDefault();
        this.setUserParticipants(app, 2, 4, 6);
        ical = this.serialize(app);
        Assert.assertProperty(ical, "ATTENDEE", "mailto:user1@test.invalid");
        Assert.assertProperty(ical, "ATTENDEE", "mailto:user3@test.invalid");
        Assert.assertProperty(ical, "ATTENDEE", "mailto:user5@test.invalid");
    }

    private void setUserParticipants(Appointment app, int ... ids) {
        Participant[] allParticipants = new Participant[ids.length];
        UserParticipant[] users = new UserParticipant[ids.length];
        int i = 0;
        int j = 0;
        for (int id : ids) {
            UserParticipant p = new UserParticipant(id);
            allParticipants[i++] = p;
            users[j++] = p;
        }
        app.setParticipants(allParticipants);
        app.setUsers(users);
    }

    private void setParticipants(CalendarObject calendarObject, String[] internal, String[] external) {
        UserParticipant p;
        Participant[] allParticipants = new Participant[internal.length + external.length];
        UserParticipant[] users = new UserParticipant[internal.length];
        int i = 0;
        int j = 0;
        for (String mail : internal) {
            p = new UserParticipant(-1);
            p.setEmailAddress(mail);
            allParticipants[i++] = p;
            users[j++] = p;
        }
        j = 0;
        for (String mail : external) {
            p = new ExternalUserParticipant(mail);
            allParticipants[i++] = p;
        }
        calendarObject.setParticipants(allParticipants);
        calendarObject.setUsers(users);
    }

    public void testAppResources() throws IOException {
        Appointment app = this.getDefault();
        this.setResources((CalendarObject)app, "beamer", "toaster", "deflector");
        ICalFile ical = this.serialize(app);
        Assert.assertProperty(ical, "RESOURCES", "beamer,toaster,deflector");
    }

    private void setResources(CalendarObject calendarObject, String ... displayNames) {
        Participant[] participants = new Participant[displayNames.length];
        int i = 0;
        for (String displayName : displayNames) {
            ResourceParticipant p = new ResourceParticipant(-1);
            p.setDisplayName(displayName);
            participants[i++] = p;
        }
        calendarObject.setParticipants(participants);
    }

    public void testAppDeleteExceptions() throws IOException {
        Appointment app = this.getDefault();
        app.setRecurrenceType(1);
        app.setInterval(3);
        app.setOccurrence(5);
        app.setDeleteExceptions(new Date[]{CommonAppointments.D("25/02/2009 10:00"), CommonAppointments.D("28/02/2009 12:00")});
        ICalFile ical = this.serialize(app);
        Assert.assertProperty(ical, "EXDATE", "20090225T100000Z");
        Assert.assertProperty(ical, "EXDATE", "20090228T120000Z");
    }

    public void testAppUid() throws IOException {
        Appointment appointment = this.getDefault();
        appointment.setUid("nexn787n478478onzwo87nwiuhi");
        ICalFile ical = this.serialize(appointment);
        Assert.assertProperty(ical, "UID", "nexn787n478478onzwo87nwiuhi");
    }

    public void testAppOrganizer() throws IOException {
        Appointment appointment = this.getDefault();
        appointment.setOrganizer("organizer");
        ICalFile ical = this.serialize(appointment);
        Assert.assertProperty(ical, "ORGANIZER", "mailto:organizer");
    }

    public void testAppSequence() throws IOException {
        Appointment appointment = this.getDefault();
        appointment.setSequence(5);
        ICalFile ical = this.serialize(appointment);
        Assert.assertProperty(ical, "SEQUENCE", "5");
    }

    public void testTaskSimpleFields() throws IOException {
        Task task = new Task();
        task.setTitle("The Title");
        task.setNote("The Note");
        task.setCategories("cat1, cat2, cat3");
        task.setPercentComplete(23);
        ICalFile ical = this.serialize(task);
        Assert.assertProperty(ical, "SUMMARY", "The Title");
        Assert.assertProperty(ical, "DESCRIPTION", "The Note");
        Assert.assertProperty(ical, "CATEGORIES", "cat1, cat2, cat3");
        Assert.assertProperty(ical, "PERCENT-COMPLETE", "23");
    }

    public void testTaskCompleted() throws IOException {
        Task task = new Task();
        task.setTitle("The Title");
        task.setDateCompleted(CommonAppointments.D("24/02/2009 10:00"));
        task.setPercentComplete(100);
        task.setStatus(3);
        ICalFile ical = this.serialize(task);
        Assert.assertProperty(ical, "SUMMARY", "The Title");
        Assert.assertProperty(ical, "COMPLETED", "20090224T100000Z");
        Assert.assertProperty(ical, "PERCENT-COMPLETE", "100");
    }

    public void testTaskCategoriesMayBeNullOrUnset() throws Exception {
        Task task = new Task();
        ICalFile ical = this.serialize(task);
        Assert.assertNoProperty(ical, "CATEGORIES");
        task.setCategories(null);
        ical = this.serialize(task);
        Assert.assertNoProperty(ical, "CATEGORIES");
    }

    public void testTaskCreated() throws IOException {
        Task task = new Task();
        task.setCreationDate(CommonAppointments.D("24/02/1981 10:00"));
        ICalFile ical = this.serialize(task);
        Assert.assertProperty(ical, "CREATED", "19810224T100000Z");
    }

    public void testTaskLastModified() throws IOException {
        Task task = new Task();
        task.setLastModified(CommonAppointments.D("24/02/1981 10:00"));
        ICalFile ical = this.serialize(task);
        Assert.assertProperty(ical, "LAST-MODIFIED", "19810224T100000Z");
    }

    public void testTaskDateFields() throws IOException {
        Task task = new Task();
        Date start = CommonAppointments.D("13/07/1976 15:00");
        Date end = CommonAppointments.D("13/07/1976 17:00");
        task.setStartDate(start);
        task.setEndDate(end);
        ICalFile ical = this.serialize(task);
        Assert.assertStandardTaskFields(ical, start, end);
    }

    public void testTaskUid() throws IOException {
        Task task = new Task();
        task.setUid("nexn787n478478onzwo87nwiuhi");
        ICalFile ical = this.serialize(task);
        Assert.assertProperty(ical, "UID", "nexn787n478478onzwo87nwiuhi");
    }

    public void testShouldNotUseDTENDasEndForIndividualAppointmentsInASeries() throws IOException {
        int occurences = 4;
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(5, 1);
        cal.set(11, 8);
        Date start = cal.getTime();
        cal.add(10, 1);
        Date end = cal.getTime();
        Appointment app = new Appointment();
        app.setStartDate(start);
        app.setEndDate(end);
        app.setRecurrenceType(1);
        app.setOccurrence(4);
        app.setInterval(1);
        app.setDays(127);
        ICalFile ical = this.serialize(app);
        String dtend = ical.getValue("DTEND");
        ICalEmitterTest.assertEquals((String)"Recurrence rule should be 'daily, for four days, every day'.", (String)"FREQ=DAILY;COUNT=4;INTERVAL=1", (String)ical.getValue("RRULE"));
        ICalEmitterTest.assertTrue((String)"Reccurence rule should point to the next day, not the end of the recurences", (boolean)dtend.startsWith(new SimpleDateFormat("yyyyMMdd").format(end)));
    }

    public void no_testTaskOrganizer() throws IOException {
        Task task = new Task();
        task.setOrganizer("organizer");
        ICalFile ical = this.serialize(task);
        Assert.assertProperty(ical, "ORGANIZER", "mailto:organizer");
    }

    public void setUp() throws Exception {
        Init.startServer();
        NotificationConfig.override((NotificationConfig.NotificationProperty)NotificationConfig.NotificationProperty.FROM_SOURCE, (String)"internal");
        this.users = new MockUserLookup();
        this.emitter = new ICal4JEmitter();
        this.oldUserResolver = Participants.userResolver;
        Participants.userResolver = new UserResolver(){

            public List<User> findUsers(List<String> mails, Context ctx) {
                LinkedList<User> found = new LinkedList<User>();
                for (String mail : mails) {
                    User user = ICalEmitterTest.this.users.getUserByMail(mail);
                    if (user == null) continue;
                    found.add(user);
                }
                return found;
            }

            public User loadUser(int userId, Context ctx) throws OXException {
                return ICalEmitterTest.this.users.getUser(userId);
            }
        };
    }

    public void tearDown() {
        Participants.userResolver = this.oldUserResolver;
        NotificationConfig.forgetOverrides();
    }

    private ICalFile serialize(Appointment app) throws IOException {
        String icalText = this.emitter.writeAppointments(Arrays.asList(app), (Context)new ContextImpl(1), new ArrayList(), new ArrayList());
        return new ICalFile(new StringReader(icalText));
    }

    private ICalFile serialize(Task task) throws IOException {
        return new ICalFile(new StringReader(this.emitter.writeTasks(Arrays.asList(task), new ArrayList(), new ArrayList(), null)));
    }
}

