/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.CommonListResponse;
import com.openexchange.ajax.framework.ListIDs;
import com.openexchange.ajax.task.AbstractTaskTest;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.GetRequest;
import com.openexchange.ajax.task.actions.GetResponse;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.ajax.task.actions.ListRequest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.tasks.Create;
import com.openexchange.groupware.tasks.Mapper;
import com.openexchange.groupware.tasks.Mapping;
import com.openexchange.groupware.tasks.Task;
import java.io.IOException;
import java.util.TimeZone;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class Bug15580Test
extends AbstractTaskTest {
    private static final int[] ATTRIBUTE_IDS = new int[]{308, 303, 307, 302};
    private AJAXClient client;
    private int folderId;
    private TimeZone tz;
    private Task task;

    public Bug15580Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.folderId = this.client.getValues().getPrivateTaskFolder();
        this.tz = this.client.getValues().getTimeZone();
        this.task = Create.createWithDefaults(this.folderId, "Bug 10071 test task");
        for (int attributeId : ATTRIBUTE_IDS) {
            this.setToNull(Mapping.getMapping((int)attributeId));
        }
        InsertResponse insertR = this.client.execute(new InsertRequest(this.task, this.tz));
        insertR.fillTask(this.task);
    }

    private void setToNull(Mapper mapper) {
        mapper.set(this.task, null);
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.execute(new DeleteRequest(this.task));
        super.tearDown();
    }

    public void testDurationAndCostsSetToZero() throws OXException, IOException, SAXException, JSONException, OXException {
        GetRequest request = new GetRequest(this.task);
        GetResponse response = this.client.execute(request);
        Task toTest = response.getTask(this.tz);
        ListIDs ids = ListIDs.l(new int[][]{{this.task.getParentFolderID(), this.task.getObjectID()}});
        ListRequest request2 = new ListRequest(ids, ATTRIBUTE_IDS);
        CommonListResponse response2 = this.client.execute(request2);
        for (int attributeId : ATTRIBUTE_IDS) {
            Mapper mapper = Mapping.getMapping((int)attributeId);
            Bug15580Test.assertFalse((String)("Attribute " + mapper.getDBColumnName() + " should not be set in GET."), (boolean)mapper.isSet(toTest));
            Object value = response2.getValue(0, attributeId);
            Bug15580Test.assertNull((String)("Attribute " + mapper.getDBColumnName() + " should not be set in LIST."), (Object)value);
        }
    }
}

