/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.publish.tests;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.publish.actions.GetPublicationRequest;
import com.openexchange.ajax.publish.actions.GetPublicationResponse;
import com.openexchange.ajax.publish.actions.NewPublicationRequest;
import com.openexchange.ajax.publish.actions.NewPublicationResponse;
import com.openexchange.ajax.publish.tests.AbstractPublicationTest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.publish.Publication;
import com.openexchange.publish.PublicationTargetDiscoveryService;
import com.openexchange.publish.SimPublicationTargetDiscoveryService;
import java.io.IOException;
import java.util.Date;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class CreatePublicationTest
extends AbstractPublicationTest {
    public CreatePublicationTest(String name) {
        super(name);
    }

    public void testOnePublicationOfOneContactFolderShouldNotBeAHassle() throws OXException, IOException, SAXException, JSONException, OXException, OXException {
        FolderObject folder = this.fMgr.generatePublicFolder("publishedContacts" + new Date().getTime(), 3, this.getClient().getValues().getPrivateContactFolder(), this.getClient().getValues().getUserId());
        this.fMgr.insertFolderOnServer(folder);
        Contact contact = this.generateContact("Herbert", "Meier");
        contact.setParentFolderID(folder.getObjectID());
        this.cMgr.newAction(contact);
        SimPublicationTargetDiscoveryService discovery = new SimPublicationTargetDiscoveryService();
        Publication expected = this.generatePublication("contacts", String.valueOf(folder.getObjectID()), discovery);
        NewPublicationRequest newReq = new NewPublicationRequest(expected);
        AJAXClient myClient = this.getClient();
        NewPublicationResponse newResp = myClient.execute(newReq);
        expected.setId(newResp.getId());
        GetPublicationRequest getReq = new GetPublicationRequest(expected.getId());
        GetPublicationResponse getResp = myClient.execute(getReq);
        Publication actual = getResp.getPublication((PublicationTargetDiscoveryService)discovery);
        CreatePublicationTest.assertEquals((String)"Should return the same folder as sent to the server", (String)expected.getEntityId(), (String)actual.getEntityId());
        CreatePublicationTest.assertEquals((String)"Should return the same module as sent to the server", (String)expected.getModule(), (String)actual.getModule());
        CreatePublicationTest.assertEquals((String)"Should return the same user as sent to the server", (int)expected.getUserId(), (int)actual.getUserId());
        CreatePublicationTest.assertEquals((String)"Should return the same target id as sent to the server", (String)expected.getTarget().getId(), (String)actual.getTarget().getId());
        CreatePublicationTest.assertEquals((String)"Should be enabled by default", (boolean)true, (boolean)actual.isEnabled());
    }

    public void testOnePublicationOfOneContactFolderWithoutAContactShouldNotBeAHassle() throws OXException, IOException, SAXException, JSONException, OXException, OXException {
        FolderObject folder = this.fMgr.generatePublicFolder("publishedContacts" + new Date().getTime(), 3, this.getClient().getValues().getPrivateContactFolder(), this.getClient().getValues().getUserId());
        this.fMgr.insertFolderOnServer(folder);
        Contact contact = this.generateContact("Herbert", "Meier");
        contact.setParentFolderID(folder.getObjectID());
        this.cMgr.newAction(contact);
        SimPublicationTargetDiscoveryService discovery = new SimPublicationTargetDiscoveryService();
        Publication expected = this.generatePublication("contacts", String.valueOf(folder.getObjectID()), discovery);
        this.pubMgr.setPublicationTargetDiscoveryService((PublicationTargetDiscoveryService)discovery);
        this.pubMgr.newAction(expected);
        Publication actual = this.pubMgr.getAction(expected.getId());
        CreatePublicationTest.assertEquals((String)"Should return the same folder as sent to the server", (String)expected.getEntityId(), (String)actual.getEntityId());
        CreatePublicationTest.assertEquals((String)"Should return the same module as sent to the server", (String)expected.getModule(), (String)actual.getModule());
        CreatePublicationTest.assertEquals((String)"Should return the same user as sent to the server", (int)expected.getUserId(), (int)actual.getUserId());
        CreatePublicationTest.assertEquals((String)"Should return the same target id as sent to the server", (String)expected.getTarget().getId(), (String)actual.getTarget().getId());
    }
}

