/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.netsol.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.Header;
import com.openexchange.ajax.mail.FolderAndID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class NetsolDeleteRequest
implements AJAXRequest<NetsolDeleteResponse> {
    private final FolderAndID[] mailPaths;
    private final boolean hardDelete;

    public NetsolDeleteRequest(FolderAndID[] mailPaths, boolean hardDelete) {
        this.mailPaths = mailPaths;
        this.hardDelete = hardDelete;
    }

    @Override
    public Object getBody() throws JSONException {
        JSONArray array = new JSONArray();
        for (int i = 0; i < this.mailPaths.length; ++i) {
            JSONObject jo = new JSONObject();
            jo.put("folder", (Object)this.mailPaths[i].folderId);
            jo.put("id", (Object)this.mailPaths[i].id);
            array.put((Object)jo);
        }
        return array;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public Header[] getHeaders() {
        return NO_HEADER;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        return new AJAXRequest.Parameter[]{new AJAXRequest.Parameter("action", "delete"), new AJAXRequest.Parameter("harddelete", this.hardDelete ? "1" : "0")};
    }

    public DeleteParser getParser() {
        return new DeleteParser(true);
    }

    @Override
    public String getServletPath() {
        return "/ajax/mail";
    }

    public static final class NetsolDeleteResponse
    extends AbstractAJAXResponse {
        public NetsolDeleteResponse(Response response) {
            super(response);
        }

        public JSONArray getFailed() {
            return (JSONArray)this.getData();
        }
    }

    static final class DeleteParser
    extends AbstractAJAXParser<NetsolDeleteResponse> {
        DeleteParser(boolean failOnError) {
            super(failOnError);
        }

        @Override
        protected NetsolDeleteResponse createResponse(Response response) {
            return new NetsolDeleteResponse(response);
        }
    }
}

