/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.mail.AbstractReplyTest;
import com.openexchange.ajax.mail.TestMail;
import com.openexchange.ajax.mail.actions.ClearRequest;
import com.openexchange.ajax.mail.contenttypes.MailContentType;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.search.ContactSearchObject;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;

public class ReplyAllTest
extends AbstractReplyTest {
    public ReplyAllTest(String name) {
        super(name);
    }

    public List<Contact> extract(int amount, Contact[] source, List<String> excludedEmail) {
        LinkedList<Contact> returnees = new LinkedList<Contact>();
        int used = 0;
        for (Contact elem : source) {
            if (excludedEmail.contains(elem.getEmail1()) || excludedEmail.contains(elem.getEmail2()) || excludedEmail.contains(elem.getEmail3()) || used >= amount) continue;
            returnees.add(elem);
            ++used;
        }
        return returnees;
    }

    public void testDummy() throws Exception {
        String mail1 = new AJAXClient(AJAXClient.User.User1).getValues().getSendAddress();
        ReplyAllTest.assertTrue((mail1.length() > 0 ? 1 : 0) != 0);
    }

    public void no_testShouldReplyToSenderAndAllRecipients() throws OXException, IOException, SAXException, JSONException {
        AJAXClient client1 = new AJAXClient(AJAXClient.User.User1);
        AJAXClient client2 = new AJAXClient(AJAXClient.User.User2);
        String folder = client2.getValues().getInboxFolder();
        Executor.execute(client2.getSession(), new ClearRequest(folder).setHardDelete(true));
        folder = client2.getValues().getSentFolder();
        Executor.execute(client2.getSession(), new ClearRequest(folder).setHardDelete(true));
        String mail1 = client1.getValues().getSendAddress();
        String mail2 = client2.getValues().getSendAddress();
        ContactSearchObject searchObject = new ContactSearchObject();
        searchObject.setEmail1("*" + AJAXConfig.getProperty(AJAXConfig.Property.CONTEXTNAME) + "*");
        searchObject.addFolder(6);
        List<Contact> otherContacts = this.extract(2, this.contactManager.searchAction(searchObject), Arrays.asList(mail1, mail2));
        if (otherContacts.isEmpty()) {
            searchObject = new ContactSearchObject();
            searchObject.setEmail1("*");
            searchObject.addFolder(6);
            otherContacts = this.extract(2, this.contactManager.searchAction(searchObject), Arrays.asList(mail1, mail2));
        }
        ReplyAllTest.assertTrue((String)("Precondition: This test needs at least two other contacts in the global address book to work, but has " + otherContacts.size()), (otherContacts.size() > 1 ? 1 : 0) != 0);
        this.client = client2;
        String anotherMail = otherContacts.get(0).getEmail1();
        String yetAnotherMail = otherContacts.get(1).getEmail1();
        JSONObject mySentMail = this.createEMail(this.adresses(mail1, anotherMail, yetAnotherMail), "ReplyAll test", MailContentType.ALTERNATIVE.toString(), "Mail text.<br /><br />People have been asking for support for the IMAP IDLE command for quite<br />a few years and I think I've finally figured out how to provide such<br />support safely.  The difficulty isn't in executing the command, which<br />is quite straightforward, the difficulty is in deciding how to expose<br />it to applications, and inhandling the multithreading issues that<br />arise.<br /><br />After three attempts, I've got a version that seems to work.  It passes<br />all my tests, including a multithreading test I wrote just for this<br />purpose.  So now it's time for others to try it out as well.  Below is<br />my writeup on how to use the IDLE command.  You can find the test<br />version of JavaMail (essentially an early version of JavaMail 1.4.1)<br />in the java.net Maven repository (you want the 1.4.1ea version):<br /><br />https://maven-repository.dev.java.net/nonav/repository/javax.mail/<br /><br />Note that this version is built with JDK 1.5 and thus requires JDK 1.5.<br /><br />Oh,and here's the entire list of what's fixed in this version so far:<br /><br />4107594 IMAP implementation should use the IDLE extension if available<br />6423701 Problem with using OrTerm when the protocol is IMAP<br />6431207 SMTP is adding extra CRLF to message content<br />6447295 IMAPMessage fails to return Content-Language from bodystructure<br />6447799 encoded text not decoded even when mail.mime.decodetext.strict is false<br />6447801 MimeBodyPart.writeTo reencodes data unnecessarily<br />6456422 NullPointerException in smtptransport when sending MimeMessages<br />        with no encoding<br />6456444 MimeMessages created from stream are not correctly handled<br />        with allow8bitmime<br />&lt;no id&gt; fix performance bug in base64 encoder; now even faster!");
        this.sendMail(mySentMail.toString());
        this.client = client1;
        JSONObject myReceivedMail = this.getFirstMailInFolder(this.getInboxFolder());
        TestMail myReplyMail = new TestMail(this.getReplyAllEMail(new TestMail(myReceivedMail)));
        ReplyAllTest.assertTrue((String)"Should contain indicator that this is a reply in the subject line", (boolean)myReplyMail.getSubject().startsWith("Re:"));
        List<String> toAndCC = myReplyMail.getTo();
        toAndCC.addAll(myReplyMail.getCc());
        ReplyAllTest.assertTrue((String)"Sender of original message should become recipient in reply", (boolean)this.contains(toAndCC, mail2));
        ReplyAllTest.assertTrue((String)("1st recipient (" + anotherMail + ") of original message should still be recipient in reply, but TO/CC field only has these: " + toAndCC), (boolean)this.contains(toAndCC, anotherMail));
        ReplyAllTest.assertTrue((String)("2nd recipient (" + yetAnotherMail + ") of original message should still be recipient in reply, but TO/CC field only has these: " + toAndCC), (boolean)this.contains(toAndCC, yetAnotherMail));
    }

    protected String adresses(String ... mails) {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        for (String mail : mails) {
            builder.append("[null,");
            builder.append(mail);
            builder.append("],");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(']');
        return builder.toString();
    }
}

