/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.kata.contacts;

import com.openexchange.ajax.contact.action.AllRequest;
import com.openexchange.ajax.contact.action.ContactUpdatesResponse;
import com.openexchange.ajax.contact.action.ListRequest;
import com.openexchange.ajax.contact.action.SearchRequest;
import com.openexchange.ajax.contact.action.SearchResponse;
import com.openexchange.ajax.contact.action.UpdatesRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.ajax.framework.CommonListResponse;
import com.openexchange.ajax.framework.ListIDs;
import com.openexchange.ajax.kata.NeedExistingStep;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.search.ContactSearchObject;
import com.openexchange.groupware.search.Order;
import com.openexchange.test.ContactTestManager;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.junit.Assert;
import org.xml.sax.SAXException;

public class ContactVerificationStep
extends NeedExistingStep<Contact> {
    private final Contact entry;
    private ContactTestManager manager;
    private int expectedFolderId;

    public ContactVerificationStep(Contact entry, String name) {
        super(name, null);
        this.entry = entry;
    }

    @Override
    protected void assumeIdentity(Contact thing) {
        this.expectedFolderId = this.entry.getParentFolderID();
        boolean containsFolderId = this.entry.containsParentFolderID();
        super.assumeIdentity(this.entry);
        if (!containsFolderId) {
            this.expectedFolderId = this.entry.getParentFolderID();
        }
    }

    @Override
    public void perform(AJAXClient client) throws Exception {
        this.client = client;
        this.manager = new ContactTestManager(client);
        this.assumeIdentity(this.entry);
        this.checkWithReadMethods(this.entry);
    }

    private void checkWithReadMethods(Contact contact) throws OXException, JSONException, OXException, IOException, SAXException {
        this.checkViaGet(contact);
        this.checkViaAll(contact);
        this.checkViaList(contact);
        this.checkViaUpdates(contact);
        this.checkViaSearch(contact);
    }

    private void checkViaGet(Contact contact) throws OXException, JSONException {
        Contact loaded = this.manager.getAction(this.expectedFolderId, contact.getObjectID());
        this.compare(contact, loaded);
    }

    private void checkViaAll(Contact contact) throws OXException, IOException, SAXException, JSONException {
        Object[][] rows = this.getViaAll(contact);
        this.checkInList(contact, rows, Contact.ALL_COLUMNS, "all-");
    }

    private void checkViaList(Contact contact) throws OXException, IOException, SAXException, JSONException {
        ListRequest listRequest = new ListRequest(ListIDs.l(new int[][]{{this.expectedFolderId, contact.getObjectID()}}), Contact.ALL_COLUMNS, false);
        CommonListResponse response = this.client.execute(listRequest);
        Object[][] rows = response.getArray();
        this.checkInList(contact, rows, Contact.ALL_COLUMNS, "list-");
    }

    private void checkViaUpdates(Contact contact) throws OXException, IOException, SAXException, JSONException, OXException {
        UpdatesRequest updates = new UpdatesRequest(this.expectedFolderId, Contact.ALL_COLUMNS, 1, Order.ASCENDING, new Date(0L));
        ContactUpdatesResponse response = this.client.execute(updates);
        List<Contact> contacts = response.getContacts();
        this.checkInList(contact, contacts, "updates-");
    }

    private void checkViaSearch(Contact contact) throws OXException, IOException, SAXException, JSONException {
        Object[][] rows = this.getViaSearch(contact);
        this.checkInList(contact, rows, Contact.ALL_COLUMNS, "search-");
    }

    private void checkInList(Contact contact, Object[][] rows, int[] columns, String typeOfAction) throws OXException, IOException, SAXException, JSONException {
        int idPos = this.findIDIndex(columns);
        for (int i = 0; i < rows.length; ++i) {
            Object[] row = rows[i];
            int id = (Integer)row[idPos];
            if (id != contact.getObjectID()) continue;
            this.compare(contact, row, columns);
            return;
        }
        Assert.fail((String)("Object not found in " + typeOfAction + "response. " + this.name));
    }

    private Object[][] getViaAll(Contact contact) throws OXException, IOException, SAXException, JSONException {
        AllRequest all = new AllRequest(this.expectedFolderId, Contact.ALL_COLUMNS);
        CommonAllResponse response = this.client.execute(all);
        return response.getArray();
    }

    private Object[][] getViaSearch(Contact contact) throws OXException, IOException, SAXException, JSONException {
        ContactSearchObject contactSearch = new ContactSearchObject();
        contactSearch.setPattern("*");
        contactSearch.addFolder(this.expectedFolderId);
        SearchRequest searchRequest = new SearchRequest(contactSearch, Contact.ALL_COLUMNS, false);
        SearchResponse searchResponse = this.client.execute(searchRequest);
        JSONArray data = (JSONArray)searchResponse.getResponse().getData();
        Object[][] results = new Object[data.length()][];
        for (int i = 0; i < results.length; ++i) {
            JSONArray tempArray = data.getJSONArray(i);
            results[i] = new Object[tempArray.length()];
            for (int j = 0; j < tempArray.length(); ++j) {
                results[i][j] = tempArray.get(j);
            }
        }
        return results;
    }

    private void compare(Contact contact, Contact loaded) {
        int[] columns = Contact.ALL_COLUMNS;
        for (int i = 0; i < columns.length; ++i) {
            int col = columns[i];
            if (col == 6 || col == 5 || !contact.contains(col)) continue;
            Assert.assertEquals((String)(this.name + ": Column " + col + " differs!"), (Object)contact.get(col), (Object)loaded.get(col));
        }
    }

    private void compare(Contact contact, Object[] row, int[] columns) throws OXException, IOException, SAXException, JSONException {
        Assert.assertEquals((String)"Result should contain same number of elements as the request", (Object)row.length, (Object)columns.length);
        for (int i = 0; i < columns.length; ++i) {
            int column = columns[i];
            if (column == 6 || column == 5 || !contact.contains(column)) continue;
            Object expected = contact.get(column);
            Object actual = row[i];
            actual = this.transform(column, actual);
            Assert.assertEquals((String)(this.name + " Column: " + column), (Object)expected, (Object)actual);
        }
    }

    private int findIDIndex(int[] columns) {
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i] != 1) continue;
            return i;
        }
        Assert.fail((String)("No ID column requested. This won't work. " + this.name));
        return -1;
    }

    private void checkInList(Contact contact, List<Contact> contacts, String nameOfAction) {
        for (Contact contactFromList : contacts) {
            if (contactFromList.getObjectID() != contact.getObjectID()) continue;
            this.compare(contact, contactFromList);
            return;
        }
        Assert.fail((String)("Object not found in response. " + this.name));
    }

    private Object transform(int column, Object actual) throws OXException, IOException, SAXException, JSONException {
        return actual;
    }

    @Override
    public void cleanUp() throws Exception {
    }
}

