/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.framework;

import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.Header;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONException;

public interface AJAXRequest<T extends AbstractAJAXResponse> {
    public static final Header[] NO_HEADER = new Header[0];

    public Method getMethod();

    public String getServletPath();

    public Parameter[] getParameters() throws IOException, JSONException;

    public AbstractAJAXParser<? extends T> getParser();

    public Object getBody() throws IOException, JSONException;

    public Header[] getHeaders();

    public static class FieldParameter
    extends Parameter {
        public FieldParameter(String fieldName, String fieldContent) {
            super(fieldName, fieldContent);
        }

        public String getFieldName() {
            return super.getName();
        }

        public String getFieldContent() {
            return super.getValue();
        }
    }

    public static class FileParameter
    extends Parameter {
        private final InputStream inputStream;
        private final String mimeType;

        public FileParameter(String name, String fileName, InputStream inputStream, String mimeType) {
            super(name, fileName);
            this.inputStream = inputStream;
            this.mimeType = mimeType;
        }

        public String getFileName() {
            return super.getValue();
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        @Override
        public String toString() {
            return super.toString() + ',' + this.mimeType;
        }
    }

    public static class URLParameter
    extends Parameter {
        public URLParameter(String name, String value) {
            super(name, value);
        }

        public URLParameter(String name, int value) {
            this(name, Integer.toString(value));
        }

        public URLParameter(String name, int[] values) {
            this(name, URLParameter.convert(values));
        }

        public URLParameter(String name, boolean value) {
            this(name, Boolean.toString(value));
        }
    }

    public static class Parameter {
        private final String name;
        private final String value;

        public Parameter(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public Parameter(String name, String[] values) {
            this(name, Parameter.convert(values));
        }

        public Parameter(String name, int[] values) {
            this(name, Parameter.convert(values));
        }

        public Parameter(String name, int identifier) {
            this(name, String.valueOf(identifier));
        }

        public Parameter(String name, long time) {
            this(name, String.valueOf(time));
        }

        public Parameter(String name, Date time) {
            this(name, time.getTime());
        }

        public Parameter(String name, Date time, TimeZone tz) {
            this(name, time.getTime() + (long)tz.getOffset(time.getTime()));
        }

        public Parameter(String name, boolean schalter) {
            this(name, String.valueOf(schalter));
        }

        public static String convert(int[] values) {
            StringBuilder columnSB = new StringBuilder();
            for (int i : values) {
                columnSB.append(i);
                columnSB.append(',');
            }
            columnSB.delete(columnSB.length() - 1, columnSB.length());
            return columnSB.toString();
        }

        public static String convert(String[] values) {
            StringBuilder columnSB = new StringBuilder();
            for (String i : values) {
                columnSB.append(i);
                columnSB.append(',');
            }
            columnSB.delete(columnSB.length() - 1, columnSB.length());
            return columnSB.toString();
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.name + "=" + this.value;
        }
    }

    public static enum Method {
        GET,
        POST,
        UPLOAD,
        PUT;

    }
}

