/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.folder.actions.GetResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;

public class GetVirtualTest
extends AbstractAJAXSession {
    private AJAXClient client;

    public GetVirtualTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
    }

    public void testGetVirtual() throws Throwable {
        GetRequest getRequest = new GetRequest((API)EnumAPI.OX_OLD, 12, new int[]{1, 300, 305, 306});
        GetResponse getResponse = this.client.execute(getRequest);
        GetVirtualTest.assertFalse((String)"GET request failed.", (boolean)getResponse.hasError());
        FolderObject folder = getResponse.getFolder();
        GetVirtualTest.assertEquals((String)"Unexpected object ID: ", (int)12, (int)folder.getObjectID());
        OCLPermission[] perms = folder.getNonSystemPermissionsAsArray();
        GetVirtualTest.assertNotNull((String)"Missing permissions", (Object)perms);
        GetVirtualTest.assertEquals((String)"Unexpected number of permissions: ", (int)1, (int)perms.length);
        OCLPermission p = perms[0];
        GetVirtualTest.assertNotNull((String)"Missing permission", (Object)p);
        GetVirtualTest.assertEquals((String)"Unexpected entity: ", (int)0, (int)p.getEntity());
        GetVirtualTest.assertEquals((String)"Unexpected folder permission: ", (int)2, (int)p.getFolderPermission());
        GetVirtualTest.assertEquals((String)"Unexpected read permission: ", (int)0, (int)p.getReadPermission());
        GetVirtualTest.assertEquals((String)"Unexpected write permission: ", (int)0, (int)p.getWritePermission());
        GetVirtualTest.assertEquals((String)"Unexpected delete permission: ", (int)0, (int)p.getDeletePermission());
        GetVirtualTest.assertEquals((String)"Unexpected folder admin flag: ", (boolean)false, (boolean)p.isFolderAdmin());
        GetVirtualTest.assertEquals((String)"Unexpected group flag: ", (boolean)true, (boolean)p.isGroupPermission());
    }
}

