/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.recurrence;

import com.openexchange.ajax.appointment.recurrence.AbstractRecurrenceTest;
import com.openexchange.ajax.appointment.recurrence.Occurrence;
import com.openexchange.groupware.container.Appointment;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeeklyRecurrenceTest
extends AbstractRecurrenceTest {
    private static final Logger LOG = LoggerFactory.getLogger(WeeklyRecurrenceTest.class);

    public WeeklyRecurrenceTest(String name) {
        super(name);
        this.simpleDateFormatUTC.setTimeZone(timeZoneUTC);
    }

    public void testDummy() {
    }

    public void _notestWeeklyRecurrenceFromWinter2SummerTime() throws Exception {
        Date until = this.simpleDateFormatUTC.parse("2007-04-01 00:00:00");
        Date start = this.simpleDateFormatUTC.parse("2007-02-01 00:00:00");
        Date end = this.simpleDateFormatUTC.parse("2007-05-01 00:00:00");
        Date startDate = this.simpleDateFormatUTC.parse("2007-03-05 08:00:00");
        Date endDate = this.simpleDateFormatUTC.parse("2007-03-05 10:00:00");
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testWeeklyRecurrenceFromWinter2SummerTime");
        appointmentObj.setStartDate(startDate);
        appointmentObj.setEndDate(endDate);
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setRecurrenceType(2);
        appointmentObj.setDays(2);
        appointmentObj.setInterval(1);
        appointmentObj.setUntil(until);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = WeeklyRecurrenceTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = WeeklyRecurrenceTest.loadAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        this.compareObject(appointmentObj, loadAppointment, startDate.getTime(), endDate.getTime());
        boolean found = false;
        ArrayList<Occurrence> occurrenceList = new ArrayList<Occurrence>();
        Appointment[] appointmentArray = WeeklyRecurrenceTest.listAppointment(this.getWebConversation(), appointmentFolderId, _fields, start, end, this.timeZone, true, this.getHostName(), this.getSessionId());
        for (int a = 0; a < appointmentArray.length; ++a) {
            if (appointmentArray[a].getObjectID() != objectId) continue;
            occurrenceList.add(new Occurrence(appointmentArray[a].getStartDate(), appointmentArray[a].getEndDate(), appointmentArray[a].getRecurrencePosition()));
            found = true;
        }
        WeeklyRecurrenceTest.assertTrue((String)"appointment not found in response", (boolean)found);
        Occurrence[] occurrenceArray = occurrenceList.toArray(new Occurrence[occurrenceList.size()]);
        Occurrence occurrence = this.getOccurrenceByPosition(occurrenceArray, 1);
        WeeklyRecurrenceTest.assertOccurrence(1, this.simpleDateFormatUTC.parse("2007-03-05 08:00:00"), this.simpleDateFormatUTC.parse("2007-03-05 10:00:00"), occurrence);
        occurrence = this.getOccurrenceByPosition(occurrenceArray, 2);
        WeeklyRecurrenceTest.assertOccurrence(2, this.simpleDateFormatUTC.parse("2007-03-12 08:00:00"), this.simpleDateFormatUTC.parse("2007-03-12 10:00:00"), occurrence);
        occurrence = this.getOccurrenceByPosition(occurrenceArray, 3);
        WeeklyRecurrenceTest.assertOccurrence(3, this.simpleDateFormatUTC.parse("2007-03-19 08:00:00"), this.simpleDateFormatUTC.parse("2007-03-19 10:00:00"), occurrence);
        occurrence = this.getOccurrenceByPosition(occurrenceArray, 4);
        WeeklyRecurrenceTest.assertOccurrence(4, this.simpleDateFormatUTC.parse("2007-03-26 08:00:00"), this.simpleDateFormatUTC.parse("2007-03-26 10:00:00"), occurrence);
        WeeklyRecurrenceTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void _notestWeeklyRecurrenceFromSummer2WinterTime() throws Exception {
        Date until = this.simpleDateFormatUTC.parse("2007-11-01 00:00:00");
        Date start = this.simpleDateFormatUTC.parse("2007-9-01 00:00:00");
        Date end = this.simpleDateFormatUTC.parse("2007-12-01 00:00:00");
        Date startDate = this.simpleDateFormatUTC.parse("2007-10-01 08:00:00");
        Date endDate = this.simpleDateFormatUTC.parse("2007-10-01 10:00:00");
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testWeeklyRecurrenceFromSummer2WinterTime");
        appointmentObj.setStartDate(startDate);
        appointmentObj.setEndDate(endDate);
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setRecurrenceType(2);
        appointmentObj.setDays(2);
        appointmentObj.setInterval(1);
        appointmentObj.setUntil(until);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = WeeklyRecurrenceTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = WeeklyRecurrenceTest.loadAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        this.compareObject(appointmentObj, loadAppointment, startDate.getTime(), endDate.getTime());
        boolean found = false;
        ArrayList<Occurrence> occurrenceList = new ArrayList<Occurrence>();
        Appointment[] appointmentArray = WeeklyRecurrenceTest.listAppointment(this.getWebConversation(), appointmentFolderId, _fields, start, end, this.timeZone, true, this.getHostName(), this.getSessionId());
        for (int a = 0; a < appointmentArray.length; ++a) {
            if (appointmentArray[a].getObjectID() != objectId) continue;
            occurrenceList.add(new Occurrence(appointmentArray[a].getStartDate(), appointmentArray[a].getEndDate(), appointmentArray[a].getRecurrencePosition()));
            found = true;
        }
        WeeklyRecurrenceTest.assertTrue((String)"appointment not found in response", (boolean)found);
        Occurrence[] occurrenceArray = occurrenceList.toArray(new Occurrence[occurrenceList.size()]);
        Occurrence occurrence = this.getOccurrenceByPosition(occurrenceArray, 1);
        WeeklyRecurrenceTest.assertOccurrence(1, this.simpleDateFormatUTC.parse("2007-10-01 08:00:00"), this.simpleDateFormatUTC.parse("2007-10-01 10:00:00"), occurrence);
        occurrence = this.getOccurrenceByPosition(occurrenceArray, 2);
        WeeklyRecurrenceTest.assertOccurrence(2, this.simpleDateFormatUTC.parse("2007-10-08 08:00:00"), this.simpleDateFormatUTC.parse("2007-10-08 10:00:00"), occurrence);
        occurrence = this.getOccurrenceByPosition(occurrenceArray, 3);
        WeeklyRecurrenceTest.assertOccurrence(3, this.simpleDateFormatUTC.parse("2007-10-15 08:00:00"), this.simpleDateFormatUTC.parse("2007-10-15 10:00:00"), occurrence);
        occurrence = this.getOccurrenceByPosition(occurrenceArray, 4);
        WeeklyRecurrenceTest.assertOccurrence(4, this.simpleDateFormatUTC.parse("2007-10-22 08:00:00"), this.simpleDateFormatUTC.parse("2007-10-22 10:00:00"), occurrence);
        occurrence = this.getOccurrenceByPosition(occurrenceArray, 5);
        WeeklyRecurrenceTest.assertOccurrence(5, this.simpleDateFormatUTC.parse("2007-10-29 08:00:00"), this.simpleDateFormatUTC.parse("2007-10-29 10:00:00"), occurrence);
        WeeklyRecurrenceTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }
}

