/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.threadpool.osgi;

import com.openexchange.config.ConfigurationService;
import com.openexchange.management.ManagementService;
import com.openexchange.osgi.HousekeepingActivator;
import com.openexchange.server.ServiceLookup;
import com.openexchange.session.Session;
import com.openexchange.session.SessionThreadCounter;
import com.openexchange.sessionCount.SessionThreadCounterImpl;
import com.openexchange.sessiond.SessiondEventConstants;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.threadpool.internal.ThreadPoolProperties;
import com.openexchange.threadpool.internal.ThreadPoolServiceImpl;
import com.openexchange.threadpool.osgi.ManagementServiceTrackerCustomizer;
import com.openexchange.threadpool.osgi.ManagementServiceTrackerCustomizer2;
import com.openexchange.threadpool.osgi.SessionThreadCountEventHandler;
import com.openexchange.timer.TimerService;
import com.openexchange.timer.internal.CustomThreadPoolExecutorTimerService;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadPoolActivator
extends HousekeepingActivator {
    public static final AtomicReference<ThreadPoolService> REF_THREAD_POOL = new AtomicReference();
    public static final AtomicReference<TimerService> REF_TIMER = new AtomicReference();
    private volatile ThreadPoolServiceImpl threadPool;

    protected void startBundle() throws Exception {
        Logger LOG = LoggerFactory.getLogger(ThreadPoolActivator.class);
        try {
            LOG.info("starting bundle: com.openexchange.threadpool");
            ConfigurationService confService = (ConfigurationService)this.getService(ConfigurationService.class);
            ThreadPoolProperties init = new ThreadPoolProperties().init(confService);
            this.threadPool = ThreadPoolServiceImpl.newInstance(init);
            if (init.isPrestartAllCoreThreads()) {
                this.threadPool.prestartAllCoreThreads();
            }
            this.track(ManagementService.class, new ManagementServiceTrackerCustomizer(this.context, this.threadPool));
            REF_THREAD_POOL.set(this.threadPool);
            this.registerService(ThreadPoolService.class, this.threadPool);
            Hashtable<String, Object> dict = new Hashtable<String, Object>(4);
            ((Dictionary)dict).put("service.ranking", Integer.MAX_VALUE);
            ((Dictionary)dict).put("service.description", "The Open-Xchange ExecutorService");
            ((Dictionary)dict).put("service.vendor", "Open-Xchange Inc.");
            this.registerService(ExecutorService.class, this.threadPool.getExecutor(), dict);
            CustomThreadPoolExecutorTimerService timerService = new CustomThreadPoolExecutorTimerService(this.threadPool.getThreadPoolExecutor());
            REF_TIMER.set(timerService);
            this.registerService(TimerService.class, timerService);
            int notifyThreashold = confService.getIntProperty("com.openexchange.session.maxThreadNotifyThreshold", -1);
            SessionThreadCounterImpl counterImpl = new SessionThreadCounterImpl(notifyThreashold, (ServiceLookup)this);
            this.registerService(SessionThreadCounter.class, counterImpl);
            SessionThreadCounter.REFERENCE.set(counterImpl);
            SessionThreadCountEventHandler handler = new SessionThreadCountEventHandler(this.context, notifyThreashold, counterImpl);
            this.rememberTracker(handler);
            Hashtable<String, Object> dict2 = new Hashtable<String, Object>(1);
            ((Dictionary)dict2).put("event.topics", SessionThreadCounter.EVENT_TOPIC);
            this.registerService(EventHandler.class, (Object)handler, dict2);
            this.track(ManagementService.class, new ManagementServiceTrackerCustomizer2(this.context, counterImpl, handler));
            EventHandler sessionEventHandler = new EventHandler(){

                public void handleEvent(Event event) {
                    block3: {
                        String topic;
                        block4: {
                            block2: {
                                topic = event.getTopic();
                                if (!"com/openexchange/sessiond/remove/data".equals(topic)) break block2;
                                Map container = (Map)event.getProperty("com.openexchange.sessiond.container");
                                for (Session session : container.values()) {
                                    this.removeFor(session);
                                }
                                break block3;
                            }
                            if (!"com/openexchange/sessiond/remove/session".equals(topic)) break block4;
                            this.removeFor((Session)event.getProperty("com.openexchange.sessiond.session"));
                            break block3;
                        }
                        if (!"com/openexchange/sessiond/remove/container".equals(topic)) break block3;
                        Map container = (Map)event.getProperty("com.openexchange.sessiond.container");
                        for (Session session : container.values()) {
                            this.removeFor(session);
                        }
                    }
                }

                private void removeFor(Session session) {
                    SessionThreadCounter threadCounter = (SessionThreadCounter)SessionThreadCounter.REFERENCE.get();
                    if (null != threadCounter) {
                        threadCounter.remove(session.getSessionID());
                    }
                }
            };
            dict2 = new Hashtable(1);
            ((Dictionary)dict2).put("event.topics", SessiondEventConstants.getAllTopics());
            this.registerService(EventHandler.class, sessionEventHandler, dict2);
            this.openTrackers();
        }
        catch (Exception e) {
            LOG.error("Failed start-up of bundle com.openexchange.threadpool", (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopBundle() throws Exception {
        block7: {
            Logger LOG = LoggerFactory.getLogger(ThreadPoolActivator.class);
            try {
                LOG.info("stopping bundle: com.openexchange.threadpool");
                REF_THREAD_POOL.set(null);
                REF_TIMER.set(null);
                this.cleanUp();
                SessionThreadCounter.REFERENCE.set(null);
                ThreadPoolServiceImpl threadPool = this.threadPool;
                if (null == threadPool) break block7;
                try {
                    threadPool.shutdownNow();
                    threadPool.awaitTermination(10000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    this.threadPool = null;
                }
            }
            catch (Exception e) {
                LOG.error("Failed shut-down of bundle com.openexchange.threadpool", (Throwable)e);
                throw e;
            }
        }
    }

    protected Class<?>[] getNeededServices() {
        return new Class[]{ConfigurationService.class};
    }

    protected void handleAvailability(Class<?> clazz) {
        Logger LOG = LoggerFactory.getLogger(ThreadPoolActivator.class);
        LOG.info("Appeared service: {}", (Object)clazz.getName());
    }

    protected void handleUnavailability(Class<?> clazz) {
        Logger LOG = LoggerFactory.getLogger(ThreadPoolActivator.class);
        LOG.info("Disappeared service: {}", (Object)clazz.getName());
    }
}

