/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.threadpool;

import com.openexchange.exception.OXException;
import com.openexchange.threadpool.CancelableCompletionService;
import com.openexchange.threadpool.Task;
import com.openexchange.threadpool.TaskWrapper;
import com.openexchange.threadpool.ThreadPoolCompletionService;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.threadpool.ThreadRenamer;
import com.openexchange.threadpool.Trackable;
import com.openexchange.threadpool.internal.CustomThreadFactory;
import com.openexchange.threadpool.osgi.ThreadPoolActivator;
import com.openexchange.timer.TimerService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadPools {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadPools.class);
    public static final ExpectedExceptionFactory<OXException> DEFAULT_EXCEPTION_FACTORY = new ExpectedExceptionFactory<OXException>(){

        @Override
        public Class<OXException> getType() {
            return OXException.class;
        }

        @Override
        public OXException newUnexpectedError(Throwable t) {
            return new OXException(t);
        }
    };
    public static final ExecutorService CURRENT_THREAD_EXECUTOR_SERVICE = new CurrentThreadExecutorService();

    private ThreadPools() {
    }

    public static ExecutorService getExecutorService() {
        ThreadPoolService pool = ThreadPoolActivator.REF_THREAD_POOL.get();
        return null == pool ? null : pool.getExecutor();
    }

    public static ThreadPoolService getThreadPool() {
        return ThreadPoolActivator.REF_THREAD_POOL.get();
    }

    public static TimerService getTimerService() {
        return ThreadPoolActivator.REF_TIMER.get();
    }

    public static void appendStackTrace(StackTraceElement[] trace, StringBuilder sb, String lineSeparator) {
        if (null == trace) {
            sb.append("<missing stack trace>\n");
            return;
        }
        for (StackTraceElement ste : trace) {
            String className = ste.getClassName();
            if (null == className) continue;
            sb.append("    at ").append(className).append('.').append(ste.getMethodName());
            if (ste.isNativeMethod()) {
                sb.append("(Native Method)");
            } else {
                String fileName = ste.getFileName();
                if (null == fileName) {
                    sb.append("(Unknown Source)");
                } else {
                    int lineNumber = ste.getLineNumber();
                    sb.append('(').append(fileName);
                    if (lineNumber >= 0) {
                        sb.append(':').append(lineNumber);
                    }
                    sb.append(')');
                }
            }
            sb.append(lineSeparator);
        }
    }

    public static void appendCurrentStackTrace(StringBuilder sb, String lineSeparator) {
        ThreadPools.appendStackTrace(new Throwable().getStackTrace(), sb, lineSeparator);
    }

    public static <R, E extends Exception> List<R> pollCompletionService(CompletionService<R> completionService, int size, long timeoutMillis, ExpectedExceptionFactory<E> factory) throws E {
        try {
            ArrayList<R> ret = new ArrayList<R>(size);
            for (int i = 0; i < size; ++i) {
                Future<R> f = completionService.poll(timeoutMillis, TimeUnit.MILLISECONDS);
                if (null != f) {
                    ret.add(f.get());
                    continue;
                }
                LOG.warn("Completion service's task elapsed time-out of {}msec", (Object)timeoutMillis);
            }
            return ret;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw factory.newUnexpectedError(e);
        }
        catch (ExecutionException e) {
            throw ThreadPools.launderThrowable(e, factory.getType());
        }
    }

    public static <R> List<R> takeCompletionService(CompletionService<R> completionService, int size) throws OXException {
        return ThreadPools.takeCompletionService(completionService, size, DEFAULT_EXCEPTION_FACTORY);
    }

    public static <R, E extends Exception> List<R> takeCompletionService(CompletionService<R> completionService, int size, ExpectedExceptionFactory<E> factory) throws E {
        try {
            ArrayList<R> ret = new ArrayList<R>(size);
            for (int i = 0; i < size; ++i) {
                ret.add(completionService.take().get());
            }
            return ret;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw factory.newUnexpectedError(e);
        }
        catch (ExecutionException e) {
            throw ThreadPools.launderThrowable(e, factory.getType());
        }
    }

    public static <R> void awaitCompletionService(CompletionService<R> completionService, int size) throws OXException {
        ThreadPools.awaitCompletionService(completionService, size, DEFAULT_EXCEPTION_FACTORY);
    }

    public static <R, E extends Exception> void awaitCompletionService(CompletionService<R> completionService, int size, ExpectedExceptionFactory<E> factory) throws E {
        try {
            for (int i = 0; i < size; ++i) {
                completionService.take().get();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw factory.newUnexpectedError(e);
        }
        catch (ExecutionException e) {
            throw ThreadPools.launderThrowable(e, factory.getType());
        }
    }

    public static <E extends Exception> E launderThrowable(ExecutionException e, Class<E> expectedExceptionType) {
        Throwable t = e.getCause();
        if (null != expectedExceptionType && expectedExceptionType.isInstance(t)) {
            return (E)((Exception)expectedExceptionType.cast(t));
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new IllegalStateException("Not unchecked", t);
    }

    public static <V> V getFrom(Future<V> f) throws OXException {
        return ThreadPools.getFrom(f, DEFAULT_EXCEPTION_FACTORY);
    }

    public static <V, E extends Exception> V getFrom(Future<V> f, ExpectedExceptionFactory<E> factory) throws E {
        if (null == f) {
            return null;
        }
        ExpectedExceptionFactory<Object> fac = factory;
        if (null == fac) {
            fac = DEFAULT_EXCEPTION_FACTORY;
        }
        try {
            return f.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw factory.newUnexpectedError(e);
        }
        catch (ExecutionException e) {
            throw ThreadPools.launderThrowable(e, factory.getType());
        }
    }

    public static <T> Task<T> task(Runnable task, T result) {
        if (task == null) {
            throw new NullPointerException();
        }
        return new TaskAdapter<T>(new RunnableAdapter<T>(task, result));
    }

    public static <T> Task<T> task(Runnable task, T result, boolean trackable) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableAdapter<T> callable = new RunnableAdapter<T>(task, result);
        return trackable ? new TrackableTaskAdapter<T>(callable) : new TaskAdapter<T>(callable);
    }

    public static Task<Object> task(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        return new TaskAdapter<Object>(new RunnableAdapter<Object>(task, null));
    }

    public static Task<Object> trackableTask(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        return new TrackableTaskAdapter<Object>(new RunnableAdapter<Object>(task, null));
    }

    public static Task<Object> task(Runnable task, boolean trackable) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableAdapter<Object> callable = new RunnableAdapter<Object>(task, null);
        return trackable ? new TrackableTaskAdapter<Object>(callable) : new TaskAdapter<Object>(callable);
    }

    public static Task<Object> task(Runnable task, String prefix) {
        if (task == null || prefix == null) {
            throw new NullPointerException();
        }
        return new RenamingTaskAdapter<Object>(new RunnableAdapter<Object>(task, null), prefix);
    }

    public static <T> Task<T> task(Callable<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        return new TaskAdapter<T>(task);
    }

    public static <T> Task<T> task(Callable<T> task, boolean trackable) {
        if (task == null) {
            throw new NullPointerException();
        }
        return trackable ? new TrackableTaskAdapter<T>(task) : new TaskAdapter<T>(task);
    }

    public static <T> Task<T> task(Callable<T> task, String prefix) {
        if (task == null) {
            throw new NullPointerException();
        }
        return new RenamingTaskAdapter<T>(task, prefix);
    }

    public static ThreadFactory newThreadFactory(String namePrefix) {
        return new CustomThreadFactory(namePrefix);
    }

    public static <V> CancelableCompletionService<V> newCompletionService(ThreadPoolService threadPool) {
        return new ThreadPoolCompletionService(threadPool);
    }

    public static abstract class TrackableCallable<V>
    implements Callable<V>,
    Trackable {
        protected TrackableCallable() {
        }
    }

    private static class CurrentThreadExecutorService
    extends AbstractExecutorService {
        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            return Collections.emptyList();
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return false;
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }

    private static class RenamingTaskAdapter<V>
    implements Task<V>,
    TaskWrapper {
        private final Callable<V> callable;
        private final String prefix;

        RenamingTaskAdapter(Callable<V> callable, String prefix) {
            this.callable = callable;
            this.prefix = prefix;
        }

        @Override
        public Object getWrapped() {
            return this.callable instanceof TaskWrapper ? ((TaskWrapper)((Object)this.callable)).getWrapped() : this.callable;
        }

        @Override
        public void afterExecute(Throwable throwable) {
        }

        @Override
        public void beforeExecute(Thread thread) {
        }

        @Override
        public void setThreadName(ThreadRenamer threadRenamer) {
            threadRenamer.renamePrefix(this.prefix);
        }

        @Override
        public V call() throws Exception {
            return this.callable.call();
        }
    }

    private static class TrackableTaskAdapter<V>
    extends TaskAdapter<V>
    implements Trackable {
        TrackableTaskAdapter(Callable<V> callable) {
            super(callable);
        }
    }

    private static class TaskAdapter<V>
    implements Task<V>,
    TaskWrapper {
        private final Callable<V> callable;

        TaskAdapter(Callable<V> callable) {
            this.callable = callable;
        }

        @Override
        public Object getWrapped() {
            return this.callable instanceof TaskWrapper ? ((TaskWrapper)((Object)this.callable)).getWrapped() : this.callable;
        }

        @Override
        public void afterExecute(Throwable throwable) {
        }

        @Override
        public void beforeExecute(Thread thread) {
        }

        @Override
        public void setThreadName(ThreadRenamer threadRenamer) {
        }

        @Override
        public V call() throws Exception {
            return this.callable.call();
        }
    }

    private static class RunnableAdapter<T>
    implements Callable<T>,
    TaskWrapper {
        private final Runnable task;
        private final T result;

        RunnableAdapter(Runnable task, T result) {
            this.task = task;
            this.result = result;
        }

        @Override
        public Runnable getWrapped() {
            return this.task;
        }

        @Override
        public T call() {
            this.task.run();
            return this.result;
        }
    }

    public static interface ExpectedExceptionFactory<E extends Exception> {
        public Class<E> getType();

        public E newUnexpectedError(Throwable var1);
    }
}

