/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.protocol.helpers;

import com.openexchange.exception.OXException;
import com.openexchange.webdav.protocol.WebdavProperty;
import com.openexchange.webdav.protocol.helpers.PropertyMixin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InMemoryMixin
implements PropertyMixin {
    private final Map<String, WebdavProperty> properties = new HashMap<String, WebdavProperty>();
    private PropertyMixin mixin = null;

    @Override
    public List<WebdavProperty> getAllProperties() throws OXException {
        ArrayList<WebdavProperty> allProperties = new ArrayList<WebdavProperty>(this.properties.values());
        if (this.mixin != null) {
            allProperties.addAll(this.mixin.getAllProperties());
        }
        return allProperties;
    }

    @Override
    public WebdavProperty getProperty(String namespace, String name) throws OXException {
        WebdavProperty webdavProperty = this.properties.get(namespace + ":" + name);
        if (webdavProperty == null && this.mixin != null) {
            return this.mixin.getProperty(namespace, name);
        }
        return webdavProperty;
    }

    public void setMixin(PropertyMixin mixin) {
        this.mixin = mixin;
    }

    public void setProperty(WebdavProperty property) {
        this.properties.put(property.getNamespace() + ":" + property.getName(), property);
    }
}

