/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.tnef;

import com.openexchange.java.Strings;
import com.openexchange.mail.mime.QuotedInternetAddress;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.mail.internet.AddressException;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import net.freeutils.tnef.MAPIProp;
import net.freeutils.tnef.MAPIPropName;
import net.freeutils.tnef.MAPIProps;

public final class TNEF2ICalUtility {
    private static final TimeZoneRegistry TIME_ZONE_REGISTRY = TimeZoneRegistryFactory.getInstance().createRegistry();

    private TNEF2ICalUtility() {
    }

    public static String getEmailAddress(String s) {
        if (TNEF2ICalUtility.isEmpty(s)) {
            return null;
        }
        int pos = s.indexOf(58);
        String address = pos >= 0 ? s.substring(pos + 1).trim() : s.trim();
        try {
            String verifiedAddr = new QuotedInternetAddress(address, false).getAddress();
            return new StringBuilder(48).append("mailto:").append(verifiedAddr).toString();
        }
        catch (AddressException e) {
            return null;
        }
    }

    public static DateTime toDateTime(Date date) {
        DateTime retval = new DateTime(true);
        retval.setTime(date.getTime());
        return retval;
    }

    public static DateTime toDateTime(Date date, String tzid) {
        if (tzid == null) {
            return TNEF2ICalUtility.toDateTime(date);
        }
        TimeZone ical4jTimezone = TIME_ZONE_REGISTRY.getTimeZone(tzid);
        if (ical4jTimezone == null) {
            return TNEF2ICalUtility.toDateTime(date);
        }
        DateTime retval = new DateTime(false);
        retval.setTimeZone(ical4jTimezone);
        retval.setTime(date.getTime());
        return retval;
    }

    public static Date pureISOToLocalQDateTime(String dtStr) {
        return TNEF2ICalUtility.pureISOToLocalQDateTime(dtStr, false);
    }

    public static Date pureISOToLocalQDateTime(String dtStr, boolean bDateOnly) {
        int second;
        int minute;
        int hour;
        int day;
        int month;
        int year;
        Calendar cal = Calendar.getInstance(java.util.TimeZone.getTimeZone("UTC"), Locale.ENGLISH);
        if (bDateOnly) {
            year = Integer.parseInt(TNEF2ICalUtility.left(dtStr, 4));
            month = Integer.parseInt(TNEF2ICalUtility.mid(dtStr, 4, 2));
            day = Integer.parseInt(TNEF2ICalUtility.mid(dtStr, 6, 2));
            hour = 0;
            minute = 0;
            second = 0;
        } else {
            year = Integer.parseInt(TNEF2ICalUtility.left(dtStr, 4));
            month = Integer.parseInt(TNEF2ICalUtility.mid(dtStr, 4, 2));
            day = Integer.parseInt(TNEF2ICalUtility.mid(dtStr, 6, 2));
            hour = Integer.parseInt(TNEF2ICalUtility.mid(dtStr, 9, 2));
            minute = Integer.parseInt(TNEF2ICalUtility.mid(dtStr, 11, 2));
            second = Integer.parseInt(TNEF2ICalUtility.mid(dtStr, 13, 2));
        }
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, day);
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
        if (bDateOnly || dtStr.charAt(dtStr.length() - 1) == 'Z') {
            // empty if block
        }
        return cal.getTime();
    }

    public static String mid(String s, int pos, int len) {
        if (null == s) {
            return null;
        }
        if (len < 0) {
            return s.substring(pos);
        }
        int length = Math.min(s.length(), pos + len);
        StringBuilder sb = new StringBuilder(len);
        for (int i = pos; i < length; ++i) {
            sb.append(s.charAt(i));
        }
        return sb.toString();
    }

    private static String left(String s, int n) {
        if (null == s) {
            return null;
        }
        int length = s.length();
        StringBuilder sb = new StringBuilder(n);
        for (int i = 0; i < n && i < length; ++i) {
            sb.append(s.charAt(i));
        }
        return sb.toString();
    }

    public static String remove(String s, char ... chars) {
        if (null == s) {
            return null;
        }
        int length = s.length();
        StringBuilder sb = new StringBuilder(length);
        Arrays.sort(chars);
        for (int i = 0; i < length; ++i) {
            char cur = s.charAt(i);
            if (Arrays.binarySearch(chars, cur) >= 0) continue;
            sb.append(cur);
        }
        return sb.toString();
    }

    public static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Strings.isWhitespace((char)string.charAt(i));
        }
        return isWhitespace;
    }

    public static <V> V findProp(int id, MAPIProps mapiProps) throws IOException {
        return (V)TNEF2ICalUtility.findProp(id, null, mapiProps);
    }

    public static <V> V findProp(int id, V fallback, MAPIProps mapiProps) throws IOException {
        Object retval = mapiProps.getPropValue(id);
        return (V)(null == retval ? fallback : retval);
    }

    public static String findPropString(int id, MAPIProps mapiProps) throws IOException {
        return TNEF2ICalUtility.findPropString(id, null, mapiProps);
    }

    public static String findPropString(int id, String fallback, MAPIProps mapiProps) throws IOException {
        Object retval = mapiProps.getPropValue(id);
        return null == retval ? fallback : retval.toString();
    }

    public static <V> V findNamedProp(String name, MAPIProps mapiProps) throws IOException {
        return (V)TNEF2ICalUtility.findNamedProp(name, null, mapiProps);
    }

    public static <V> V findNamedProp(String name, V fallback, MAPIProps mapiProps) throws IOException {
        if (name.startsWith("0x")) {
            int id = Integer.parseInt(name.substring(2), 16);
            for (MAPIProp mapiProp : mapiProps.getProps()) {
                MAPIPropName propName = mapiProp.getName();
                if (null == propName || propName.getID() != (long)id) continue;
                return (V)mapiProp.getValue();
            }
        } else {
            for (MAPIProp mapiProp : mapiProps.getProps()) {
                String n;
                MAPIPropName propName = mapiProp.getName();
                if (null == propName || (n = propName.getName()) == null || !n.equals(name)) continue;
                return (V)mapiProp.getValue();
            }
        }
        return fallback;
    }

    public static String findNamedPropString(String name, MAPIProps mapiProps) throws IOException {
        return TNEF2ICalUtility.findNamedPropString(name, null, mapiProps);
    }

    public static String findNamedPropString(String name, String fallback, MAPIProps mapiProps) throws IOException {
        if (name.startsWith("0x")) {
            int id = Integer.parseInt(name.substring(2), 16);
            for (MAPIProp mapiProp : mapiProps.getProps()) {
                MAPIPropName propName = mapiProp.getName();
                if (null == propName || propName.getID() != (long)id) continue;
                return mapiProp.getValue().toString();
            }
        } else {
            for (MAPIProp mapiProp : mapiProps.getProps()) {
                String n;
                MAPIPropName propName = mapiProp.getName();
                if (null == propName || (n = propName.getName()) == null || !n.equals(name)) continue;
                return mapiProp.getValue().toString();
            }
        }
        return fallback;
    }

    public static String toHexString(byte[] bytes) {
        return TNEF2ICalUtility.toHexString(bytes, 0, bytes != null ? bytes.length : 0, -1);
    }

    public static String toHexString(byte[] bytes, int max) {
        return TNEF2ICalUtility.toHexString(bytes, 0, bytes != null ? bytes.length : 0, max);
    }

    public static String toHexString(byte[] bytes, int offset, int len, int max) {
        if (bytes == null) {
            return "[null]";
        }
        int count = max > -1 && max < len ? max : len;
        StringBuilder s = new StringBuilder(count * 2);
        for (int i = 0; i < count; ++i) {
            String b = Integer.toHexString(bytes[offset + i] & 0xFF).toUpperCase();
            if (b.length() == 1) {
                s.append('0');
            }
            s.append(b);
        }
        if (count < len) {
            s.append("... (" + len + " bytes)");
        }
        return s.toString();
    }
}

