/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.resource.storage;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.resource.Resource;
import com.openexchange.resource.ResourceGroup;
import java.sql.Connection;
import java.util.Date;

public abstract class ResourceStorage {
    protected static final String SEARCH_PATTERN_ALL = "*";
    private static volatile ResourceStorage instance;

    protected ResourceStorage() {
    }

    public static ResourceStorage getInstance() {
        return instance;
    }

    public static void setInstance(ResourceStorage resourceStorage) {
        instance = resourceStorage;
    }

    public static void releaseInstance() {
        instance = null;
    }

    public abstract ResourceGroup getGroup(int var1, Context var2) throws OXException;

    public abstract ResourceGroup[] getGroups(Context var1) throws OXException;

    public abstract Resource getResource(int var1, Context var2) throws OXException;

    public abstract ResourceGroup[] searchGroups(String var1, Context var2) throws OXException;

    public Resource[] getAllResources(Context context) throws OXException {
        return this.searchResources(SEARCH_PATTERN_ALL, context);
    }

    public abstract Resource[] searchResources(String var1, Context var2) throws OXException;

    public abstract Resource[] searchResourcesByMail(String var1, Context var2) throws OXException;

    public abstract Resource[] listModified(Date var1, Context var2) throws OXException;

    public abstract Resource[] listDeleted(Date var1, Context var2) throws OXException;

    public final void insertResource(Context ctx, Connection con, Resource resource) throws OXException {
        this.insertResource(ctx, con, resource, StorageType.ACTIVE);
    }

    public abstract void insertResource(Context var1, Connection var2, Resource var3, StorageType var4) throws OXException;

    public abstract void updateResource(Context var1, Connection var2, Resource var3) throws OXException;

    public void deleteResource(Context ctx, Connection con, Resource resource) throws OXException {
        this.deleteResourceById(ctx, con, resource.getIdentifier());
    }

    public abstract void deleteResourceById(Context var1, Connection var2, int var3) throws OXException;

    public static enum StorageType {
        ACTIVE,
        DELETED;

    }
}

