/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.AJAXServlet;
import com.openexchange.ajax.container.ThresholdFileHolder;
import com.openexchange.ajax.helper.DownloadUtility;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.java.CharsetDetector;
import com.openexchange.java.Streams;
import com.openexchange.java.StringAllocator;
import com.openexchange.java.Strings;
import com.openexchange.log.LogProperties;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.MimeFilter;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.preferences.ServerUserSetting;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Action(method=RequestMethod.GET, name="get", description="Get a mail.", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="id", description="Object ID of the requested mail."), @Parameter(name="message_id", description="(Preliminary) The value of \"Message-Id\" header of the requested mail. This parameter is a substitute for \"id\" parameter."), @Parameter(name="folder", description="Object ID of the mail's folder."), @Parameter(name="edit", optional=true, description="1 indicates that this request should fill the message compose dialog to edit a message and thus display-specific date is going to be withheld."), @Parameter(name="hdr", optional=true, description="1 to let the response contain only the (formatted) message headers as plain text"), @Parameter(name="src", optional=true, description="1 to let the response contain the complete message source as plain text"), @Parameter(name="save", optional=true, description="1 to write the complete message source to output stream. NOTE: This parameter will only be used if parameter src is set to 1."), @Parameter(name="view", optional=true, description="(available with SP4) \"raw\" returns the content as it is, meaning no preparation are performed and thus no guarantee for safe contents is given (available with SP6 v6.10). \"text\" forces the server to deliver a text-only version of the requested mail's body, even if content is HTML. \"textNoHtmlAttach\" is the same as \"text\", but does not deliver the HTML part as attachment in case of multipart/alternative content. \"html\" to allow a possible HTML mail body being transferred as it is (but white-list filter applied). \"noimg\" to allow a possible HTML content being transferred but without original image src attributes which references external images: Can be used to prevent loading external linked images (spam privacy protection). NOTE: if set, the corresponding gui config setting will be ignored."), @Parameter(name="unseen", optional=true, description="\"1\" or \"true\" to leave an unseen mail as unseen although its content is requested")}, responseDescription="(not IMAP: with timestamp): An JSON object containing all data of the requested mail. The fields of the object are listed in Detailed mail data. The fields id and attachment are not included. NOTE: Of course response is not a JSON object if either parameter hdr or parameter src are set to \"1\". Then the response contains plain text. Moreover if optional parameter save is set to \"1\" the complete message source is going to be directly written to output stream to open browser's save dialog.")
public final class GetAction
extends AbstractMailAction {
    private static final Logger LOG = LoggerFactory.getLogger(GetAction.class);
    private static final byte[] CHUNK1 = "{\"data\":\"".getBytes();
    private static final byte[] CHUNK2 = "\"}".getBytes();
    private static final Pattern SPLIT = Pattern.compile(" *, *");

    public GetAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException {
        JSONArray paths = (JSONArray)req.getRequest().getData();
        if (null == paths) {
            return this.performGet(req);
        }
        return this.performPut(req, paths);
    }

    private AJAXRequestResult performPut(MailRequest req, JSONArray paths) throws OXException {
        try {
            int length = paths.length();
            if (length != 1) {
                throw new IllegalArgumentException("JSON array's length is not 1");
            }
            AJAXRequestData requestData = req.getRequest();
            for (int i = 0; i < length; ++i) {
                JSONObject folderAndID = paths.getJSONObject(i);
                requestData.putParameter("folder", folderAndID.getString("folder"));
                requestData.putParameter("id", folderAndID.get("id").toString());
            }
            return this.performGet(new MailRequest(requestData, req.getSession()));
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AJAXRequestResult performGet(MailRequest req) throws OXException {
        try {
            MailMessage mail;
            String uid;
            MimeFilter mimeFilter;
            ServerSession session = req.getSession();
            String folderPath = req.checkParameter("folder");
            String tmp = req.getParameter("src");
            boolean showMessageSource = "1".equals(tmp) || Boolean.parseBoolean(tmp);
            tmp = req.getParameter("hdr");
            boolean showMessageHeaders = "1".equals(tmp) || Boolean.parseBoolean(tmp);
            String saveParam = req.getParameter("save");
            boolean saveToDisk = AJAXRequestDataTools.parseBoolParameter(saveParam) || "download".equals(GetAction.toLowerCase(req.getParameter(AJAXServlet.PARAMETER_DELIVERY)));
            tmp = req.getParameter("unseen");
            boolean unseen = tmp != null && ("1".equals(tmp) || Boolean.parseBoolean(tmp));
            tmp = req.getParameter("ignorable");
            if (GetAction.isEmpty(tmp)) {
                mimeFilter = null;
            } else {
                MimeFilter mf;
                String[] strings = SPLIT.split(tmp, 0);
                int length = strings.length;
                if (1 == length && (mf = MimeFilter.filterFor(strings[0])) != null) {
                    mimeFilter = mf;
                } else {
                    ArrayList<String> ignorableContentTypes = new ArrayList<String>(length);
                    for (int i = 0; i < length; ++i) {
                        String cts = strings[i];
                        if ("ics".equalsIgnoreCase(cts)) {
                            ignorableContentTypes.add("text/calendar");
                            ignorableContentTypes.add("application/ics");
                            continue;
                        }
                        ignorableContentTypes.add(cts);
                    }
                    mimeFilter = MimeFilter.filterFor(ignorableContentTypes);
                }
            }
            tmp = null;
            ArrayList<OXException> warnings = new ArrayList<OXException>(2);
            MailServletInterface mailInterface = this.getMailInterface(req);
            String tmp2 = req.getParameter("id");
            if (null == tmp2) {
                tmp2 = req.getParameter("message_id");
                if (null == tmp2) {
                    throw AjaxExceptionCodes.MISSING_PARAMETER.create("id");
                }
                uid = mailInterface.getMailIDByMessageID(folderPath, tmp2);
            } else {
                uid = tmp2;
            }
            LogProperties.put((LogProperties.Name)LogProperties.Name.MAIL_MAIL_ID, (Object)uid);
            LogProperties.put((LogProperties.Name)LogProperties.Name.MAIL_FULL_NAME, (Object)folderPath);
            AJAXRequestResult data = GetAction.getJSONNullResult();
            if (showMessageSource) {
                boolean doUnseen;
                AJAXRequestData requestData;
                OutputStream directOutputStream;
                mail = mailInterface.getMessage(folderPath, uid, !unseen);
                if (mail == null) {
                    throw MailExceptionCode.MAIL_NOT_FOUND.create(uid, folderPath);
                }
                if (null == mimeFilter && null != (directOutputStream = (requestData = req.getRequest()).optOutputStream())) {
                    if (saveToDisk) {
                        if (requestData.setResponseHeader("Content-Type", "application/octet-stream")) {
                            StringAllocator sb = new StringAllocator(64).append("attachment");
                            Object subject = mail.getSubject();
                            String fileName = GetAction.isEmpty((String)subject) ? "mail.eml" : GetAction.saneForFileName((String)subject) + ".eml";
                            DownloadUtility.appendFilenameParameter(fileName, requestData.getUserAgent(), sb);
                            requestData.setResponseHeader("Content-Disposition", sb.toString());
                            requestData.removeCachingHeader();
                            mail.writeTo(directOutputStream);
                            directOutputStream.flush();
                            subject = new AJAXRequestResult(AJAXRequestResult.DIRECT_OBJECT, "direct");
                            return subject;
                        }
                    } else {
                        directOutputStream.write(CHUNK1);
                        Object jsonStringOutputStream = new JSONStringOutputStream(directOutputStream);
                        mail.writeTo((OutputStream)jsonStringOutputStream);
                        jsonStringOutputStream.flush();
                        directOutputStream.write(CHUNK2);
                        directOutputStream.flush();
                        jsonStringOutputStream = new AJAXRequestResult(AJAXRequestResult.DIRECT_OBJECT, "direct");
                        return jsonStringOutputStream;
                    }
                }
                ThresholdFileHolder fileHolder = new ThresholdFileHolder();
                try {
                    mail.writeTo(fileHolder.asOutputStream());
                }
                catch (OXException e) {
                    if (!MailExceptionCode.NO_CONTENT.equals(e)) {
                        throw e;
                    }
                    LOG.debug("", (Throwable)e);
                    fileHolder = new ThresholdFileHolder();
                    fileHolder.write(new byte[0]);
                }
                if (null != mimeFilter) {
                    InputStream is = fileHolder.getStream();
                    try {
                        MimeMessage mimeMessage = new MimeMessage(MimeDefaultSession.getDefaultSession(), is);
                        Streams.close((Closeable)is);
                        is = null;
                        fileHolder.close();
                        MimeMessageConverter.saveChanges(mimeMessage);
                        mimeMessage = mimeFilter.filter(mimeMessage);
                        fileHolder = new ThresholdFileHolder();
                        mimeMessage.writeTo(fileHolder.asOutputStream());
                    }
                    finally {
                        Streams.close((Closeable)is);
                    }
                }
                boolean wasUnseen = mail.containsPrevSeen() && !mail.isPrevSeen();
                boolean bl = doUnseen = unseen && wasUnseen;
                if (doUnseen) {
                    mail.setFlag(32, false);
                    int unreadMsgs = mail.getUnreadMessages();
                    mail.setUnreadMessages(unreadMsgs < 0 ? 0 : unreadMsgs + 1);
                }
                if (doUnseen) {
                    mailInterface.updateMessageFlags(folderPath, new String[]{uid}, 32, false);
                } else if (wasUnseen) {
                    try {
                        ServerUserSetting setting = ServerUserSetting.getInstance();
                        int contextId = session.getContextId();
                        int userId = session.getUserId();
                        if (setting.isContactCollectOnMailAccess(contextId, userId).booleanValue()) {
                            GetAction.triggerContactCollector(session, mail);
                        }
                    }
                    catch (OXException e) {
                        LOG.warn("Contact collector could not be triggered.", (Throwable)e);
                    }
                }
                if (saveToDisk) {
                    OutputStream directOutputStream2;
                    AJAXRequestData requestData2 = req.getRequest();
                    if (requestData2.setResponseHeader("Content-Type", "application/octet-stream") && null != (directOutputStream2 = requestData2.optOutputStream())) {
                        StringAllocator sb = new StringAllocator(64).append("attachment");
                        String subject = mail.getSubject();
                        String fileName = GetAction.isEmpty(subject) ? "mail.eml" : GetAction.saneForFileName(subject) + ".eml";
                        DownloadUtility.appendFilenameParameter(fileName, requestData2.getUserAgent(), sb);
                        requestData2.setResponseHeader("Content-Disposition", sb.toString());
                        requestData2.removeCachingHeader();
                        InputStream is = fileHolder.getStream();
                        try {
                            int read;
                            int len = 2048;
                            byte[] buf = new byte[2048];
                            while ((read = is.read(buf, 0, 2048)) > 0) {
                                directOutputStream2.write(buf, 0, read);
                            }
                        }
                        finally {
                            Streams.close((Closeable)is);
                        }
                        directOutputStream2.flush();
                        AJAXRequestResult aJAXRequestResult = new AJAXRequestResult(AJAXRequestResult.DIRECT_OBJECT, "direct");
                        return aJAXRequestResult;
                    }
                    requestData2.setFormat("file");
                    fileHolder.setContentType("application/octet-stream");
                    fileHolder.setDelivery("download");
                    String subject = mail.getSubject();
                    fileHolder.setName(new StringAllocator(GetAction.isEmpty(subject) ? "mail" : GetAction.saneForFileName(subject)).append(".eml").toString());
                    AJAXRequestResult sb = new AJAXRequestResult((Object)fileHolder, "file");
                    return sb;
                }
                ContentType ct = mail.getContentType();
                data = ct.containsCharsetParameter() && CharsetDetector.isValid((String)ct.getCharsetParameter()) ? new AJAXRequestResult((Object)new String(fileHolder.toByteArray(), ct.getCharsetParameter()), "string") : new AJAXRequestResult((Object)new String(fileHolder.toByteArray(), "UTF-8"), "string");
            } else if (showMessageHeaders) {
                mail = mailInterface.getMessage(folderPath, uid, !unseen);
                if (mail == null) {
                    throw MailExceptionCode.MAIL_NOT_FOUND.create(uid, folderPath);
                }
                boolean wasUnseen = mail.containsPrevSeen() && !mail.isPrevSeen();
                boolean doUnseen = unseen && wasUnseen;
                ContentType rct = new ContentType("text/plain");
                ContentType ct = mail.getContentType();
                if (ct.containsCharsetParameter() && CharsetDetector.isValid((String)ct.getCharsetParameter())) {
                    rct.setCharsetParameter(ct.getCharsetParameter());
                } else {
                    rct.setCharsetParameter("UTF-8");
                }
                data = new AJAXRequestResult((Object)GetAction.formatMessageHeaders(mail.getHeadersIterator()), "string");
                if (doUnseen) {
                    mailInterface.updateMessageFlags(folderPath, new String[]{uid}, 32, false);
                } else if (wasUnseen) {
                    try {
                        ServerUserSetting setting = ServerUserSetting.getInstance();
                        int contextId = session.getContextId();
                        int userId = session.getUserId();
                        if (setting.isContactCollectOnMailAccess(contextId, userId).booleanValue()) {
                            GetAction.triggerContactCollector(session, mail);
                        }
                    }
                    catch (OXException e) {
                        LOG.warn("Contact collector could not be triggered.", (Throwable)e);
                    }
                }
            } else {
                boolean wasUnseen;
                mail = mailInterface.getMessage(folderPath, uid, !unseen);
                if (mail == null) {
                    throw MailExceptionCode.MAIL_NOT_FOUND.create(uid, folderPath);
                }
                if (!mail.containsAccountId()) {
                    mail.setAccountId(mailInterface.getAccountID());
                }
                boolean bl = unseen ? !mail.isSeen() : (wasUnseen = mail.containsPrevSeen() && !mail.isPrevSeen());
                if (wasUnseen) {
                    try {
                        ServerUserSetting setting = ServerUserSetting.getInstance();
                        int contextId = session.getContextId();
                        int userId = session.getUserId();
                        if (setting.isContactCollectOnMailAccess(contextId, userId).booleanValue()) {
                            GetAction.triggerContactCollector(session, mail);
                        }
                    }
                    catch (OXException e) {
                        LOG.warn("Contact collector could not be triggered.", (Throwable)e);
                    }
                }
                data = new AJAXRequestResult((Object)mail, "mail");
            }
            data.addWarnings(warnings);
            AJAXRequestResult aJAXRequestResult = data;
            return aJAXRequestResult;
        }
        catch (OXException e) {
            if (MailExceptionCode.MAIL_NOT_FOUND.equals(e)) {
                String uid;
                LOG.warn("Requested mail could not be found. Most likely this is caused by concurrent access of multiple clients while one performed a delete on affected mail.", (Throwable)e);
                Object[] args = e.getDisplayArgs();
                String string = null == args || 0 == args.length ? null : (uid = null == args[0] ? null : args[0].toString());
                if ("undefined".equalsIgnoreCase(uid)) {
                    throw MailExceptionCode.PROCESSING_ERROR.create(e, new Object[0]);
                }
            } else {
                LOG.error("", (Throwable)e);
            }
            throw e;
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            LogProperties.remove((LogProperties.Name)LogProperties.Name.MAIL_MAIL_ID);
            LogProperties.remove((LogProperties.Name)LogProperties.Name.MAIL_FULL_NAME);
        }
    }

    private static final String formatMessageHeaders(Iterator<Map.Entry<String, String>> iter) {
        StringAllocator sb = new StringAllocator(1024);
        String delim = ": ";
        String crlf = "\r\n";
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\r\n");
        }
        return sb.toString();
    }

    private static String saneForFileName(String fileName) {
        if (GetAction.isEmpty(fileName)) {
            return fileName;
        }
        int len = fileName.length();
        StringAllocator sb = new StringAllocator(len);
        char prev = '\u0000';
        for (int i = 0; i < len; ++i) {
            char c = fileName.charAt(i);
            if (Strings.isWhitespace((char)c)) {
                if (prev == '_') continue;
                prev = '_';
                sb.append(prev);
                continue;
            }
            if ('/' == c) {
                if (prev == 95) continue;
                prev = '_';
                sb.append(prev);
                continue;
            }
            if ('\\' == c) {
                if (prev == 95) continue;
                prev = '_';
                sb.append(prev);
                continue;
            }
            prev = '\u0000';
            sb.append(c);
        }
        return sb.toString();
    }

    private static String toLowerCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringAllocator builder = new StringAllocator(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c);
        }
        return builder.toString();
    }
}

