/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.cache;

import com.openexchange.caching.CacheKey;
import com.openexchange.mail.MailSessionCache;
import com.openexchange.mail.MailSessionParameterNames;
import com.openexchange.mail.cache.SessionMailCacheEntry;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.LoggerFactory;

public final class SessionMailCache {
    private final ConcurrentMap<CacheKey, Object> cache = new ConcurrentHashMap<CacheKey, Object>();

    public static SessionMailCache getInstance(Session session, int accountId) {
        SessionMailCache newInst;
        MailSessionCache mailSessionCache = MailSessionCache.getInstance(session);
        String key = MailSessionParameterNames.getParamMailCache();
        SessionMailCache mailCache = null;
        try {
            mailCache = (SessionMailCache)mailSessionCache.getParameter(accountId, key);
        }
        catch (ClassCastException e) {
            mailCache = null;
            mailSessionCache.removeParameter(accountId, key);
        }
        if (null == mailCache && null == (mailCache = (SessionMailCache)mailSessionCache.putParameterIfAbsent(accountId, key, newInst = new SessionMailCache()))) {
            mailCache = newInst;
        }
        return mailCache;
    }

    public static void clearAll(Session session) {
        try {
            MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class);
            if (null != storageService) {
                MailAccount[] accounts;
                for (MailAccount mailAccount : accounts = storageService.getUserMailAccounts(session.getUserId(), session.getContextId())) {
                    SessionMailCache.getInstance(session, mailAccount.getId()).clear();
                }
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(SessionMailCache.class).warn("", (Throwable)e);
        }
    }

    private SessionMailCache() {
    }

    public <V> void put(SessionMailCacheEntry<V> entry) {
        if (null == entry.getValue()) {
            this.cache.remove(entry.getKey());
        } else {
            this.cache.put(entry.getKey(), entry.getValue());
        }
    }

    public <V> void get(SessionMailCacheEntry<V> entry) {
        entry.setValue(entry.getEntryClass().cast(this.cache.get(entry.getKey())));
    }

    public <V> void remove(SessionMailCacheEntry<V> entry) {
        entry.setValue(entry.getEntryClass().cast(this.cache.remove(entry.getKey())));
    }

    public void clear() {
        this.cache.clear();
    }
}

