/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.userconfiguration;

import com.openexchange.capabilities.Capability;
import com.openexchange.capabilities.CapabilityService;
import com.openexchange.capabilities.CapabilitySet;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationCodes;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.java.StringAllocator;
import com.openexchange.server.services.ServerServiceRegistry;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapabilityUserConfigurationStorage
extends UserConfigurationStorage {
    private static final Logger LOG = LoggerFactory.getLogger(CapabilityUserConfigurationStorage.class);

    @Override
    protected void startInternal() {
    }

    @Override
    protected void stopInternal() {
    }

    @Override
    public UserConfiguration getUserConfiguration(int userId, int[] groups, Context ctx) throws OXException {
        try {
            return CapabilityUserConfigurationStorage.loadUserConfiguration(userId, groups, ctx);
        }
        catch (SQLException e) {
            throw UserConfigurationCodes.SQL_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public UserConfiguration[] getUserConfiguration(Context ctx, User[] users) throws OXException {
        try {
            return CapabilityUserConfigurationStorage.loadUserConfiguration(ctx, null, users);
        }
        catch (SQLException e) {
            throw UserConfigurationCodes.SQL_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public void clearStorage() {
    }

    @Override
    public void invalidateCache(int userId, Context ctx) {
    }

    public static UserConfiguration loadUserConfiguration(int userId, Context ctx) throws SQLException, OXException {
        return CapabilityUserConfigurationStorage.loadUserConfiguration(userId, null, ctx, true, null);
    }

    public static UserConfiguration loadUserConfiguration(int userId, int[] groups, Context ctx) throws SQLException, OXException {
        return CapabilityUserConfigurationStorage.loadUserConfiguration(userId, groups, ctx, true, null);
    }

    private static Set<String> getCapabilities(int userId, int cid) throws OXException {
        CapabilityService capabilityService = ServerServiceRegistry.getInstance().getService(CapabilityService.class);
        if (capabilityService == null) {
            return new HashSet<String>();
        }
        return CapabilityUserConfigurationStorage.stringify(capabilityService.getCapabilities(userId, cid));
    }

    private static Set<String> stringify(CapabilitySet capabilities) {
        HashSet<String> set = new HashSet<String>(capabilities.size());
        for (Capability capability : capabilities) {
            set.add(CapabilityUserConfigurationStorage.toLowerCase(capability.getId()));
        }
        return set;
    }

    private static String toLowerCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringAllocator builder = new StringAllocator(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c);
        }
        return builder.toString();
    }

    public static UserConfiguration loadUserConfiguration(int userId, int[] groupsArg, Context ctx, boolean calcPerms, Connection readConArg) throws SQLException, OXException {
        int[] groups = groupsArg == null ? UserStorage.getInstance().getUser(userId, ctx).getGroups() : groupsArg;
        UserStorage.getInstance().getUser(userId, ctx);
        UserConfiguration userConfiguration = new UserConfiguration(CapabilityUserConfigurationStorage.getCapabilities(userId, ctx.getContextId()), userId, groups, ctx);
        return userConfiguration;
    }

    public static UserConfiguration[] loadUserConfiguration(Context ctx, Connection conArg, User[] users) throws OXException, SQLException {
        UserConfiguration[] retval = new UserConfiguration[users.length];
        for (int i = 0; i < users.length; ++i) {
            UserConfiguration userConfiguration;
            User user = users[i];
            retval[i] = userConfiguration = new UserConfiguration(CapabilityUserConfigurationStorage.getCapabilities(user.getId(), ctx.getContextId()), user.getId(), user.getGroups(), ctx);
        }
        return retval;
    }

    @Override
    public UserConfiguration[] getUserConfigurations(Context ctx, int[] userIds, int[][] groups) throws OXException {
        if (0 == userIds.length) {
            return new UserConfiguration[0];
        }
        Connection con = Database.get(ctx, false);
        try {
            UserConfiguration[] userConfigurationArray = CapabilityUserConfigurationStorage.loadUserConfigurations(ctx, con, userIds, groups);
            return userConfigurationArray;
        }
        catch (SQLException e) {
            throw UserConfigurationCodes.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            Database.back(ctx, false, con);
        }
    }

    private static UserConfiguration[] loadUserConfigurations(Context ctx, Connection con, int[] userIds, int[][] groupsArg) throws OXException, SQLException {
        ArrayList<UserConfiguration> list = new ArrayList<UserConfiguration>(userIds.length);
        for (int i = 0; i < userIds.length; ++i) {
            int userId = userIds[i];
            int[] groups = groupsArg[i] == null ? UserStorage.getInstance().getUser(userId, ctx).getGroups() : groupsArg[i];
            list.add(new UserConfiguration(CapabilityUserConfigurationStorage.getCapabilities(userId, ctx.getContextId()), userId, groups, ctx));
        }
        return list.toArray(new UserConfiguration[0]);
    }
}

