/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Column;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class PrgDatesMembersPrimaryKeyUpdateTask
extends UpdateTaskAdapter {
    private static final String PRG_DATES_MEMBERS = "prg_dates_members";

    @Override
    public void perform(PerformParameters params) throws OXException {
        int cid = params.getContextId();
        Connection con = Database.getNoTimeout(cid, true);
        try {
            con.setAutoCommit(false);
            this.fillPfid(con);
            Column column = new Column("pfid", "INT(11) NOT NULL DEFAULT -2");
            Tools.modifyColumns(con, PRG_DATES_MEMBERS, column);
            if (Tools.hasPrimaryKey(con, PRG_DATES_MEMBERS)) {
                Tools.dropPrimaryKey(con, PRG_DATES_MEMBERS);
            }
            Tools.createPrimaryKey(con, PRG_DATES_MEMBERS, new String[]{"cid", "object_id", "member_uid", "pfid"});
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.OTHER_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(cid, true, con);
        }
    }

    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillPfid(Connection con) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT object_id, member_uid, confirm, reason, reminder, cid FROM prg_dates_members WHERE pfid IS NULL FOR UPDATE");
            rs = stmt.executeQuery();
            PreparedStatement stmt2 = null;
            try {
                while (rs.next()) {
                    int oldPos = 1;
                    StringBuilder sb = new StringBuilder();
                    int objectId = rs.getInt(oldPos++);
                    sb.append("UPDATE prg_dates_members SET pfid = -2 WHERE object_id = ? ");
                    int memberUid = rs.getInt(oldPos++);
                    sb.append("AND member_uid = ? ");
                    int confirm = rs.getInt(oldPos++);
                    sb.append("AND confirm = ? ");
                    String reason = rs.getString(oldPos++);
                    boolean reasonNull = rs.wasNull();
                    if (reasonNull) {
                        sb.append("AND reason IS ? ");
                    } else {
                        sb.append("AND reason = ? ");
                    }
                    int reminder = rs.getInt(oldPos++);
                    boolean reminderNull = rs.wasNull();
                    if (reminderNull) {
                        sb.append("AND reminder IS ? ");
                    } else {
                        sb.append("AND reminder = ? ");
                    }
                    int cid = rs.getInt(oldPos++);
                    sb.append("AND cid = ?");
                    stmt2 = con.prepareStatement(sb.toString());
                    int newPos = 1;
                    stmt2.setInt(newPos++, objectId);
                    stmt2.setInt(newPos++, memberUid);
                    stmt2.setInt(newPos++, confirm);
                    if (reasonNull) {
                        stmt2.setNull(newPos++, 1);
                    } else {
                        stmt2.setString(newPos++, reason);
                    }
                    if (reminderNull) {
                        stmt2.setNull(newPos++, 4);
                    } else {
                        stmt2.setInt(newPos++, reminder);
                    }
                    stmt2.setInt(newPos++, cid);
                    stmt2.execute();
                }
            }
            finally {
                DBUtils.closeSQLStuff(stmt2);
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs, stmt);
    }
}

