/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorrectCharsetAndCollationTask
implements UpdateTask {
    private static final Logger LOG = LoggerFactory.getLogger(CorrectCharsetAndCollationTask.class);

    @Override
    public int addedWithVersion() {
        return 31;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.NORMAL.priority;
    }

    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        Connection con = Database.getNoTimeout(contextId, true);
        try {
            con.setAutoCommit(false);
            this.correctDatabase(con);
            for (String table : this.getTables(con)) {
                this.correctTable(con, table);
            }
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(contextId, true, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void correctDatabase(Connection con) throws SQLException {
        LOG.info("Correcting database.");
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            stmt.execute("ALTER DATABASE DEFAULT CHARSET utf8 DEFAULT COLLATE utf8_unicode_ci");
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getTables(Connection con) throws SQLException {
        DatabaseMetaData metaData = con.getMetaData();
        ResultSet result = null;
        ArrayList<String> tables = new ArrayList<String>();
        try {
            result = metaData.getTables(null, null, null, null);
            while (result.next()) {
                tables.add(result.getString(3));
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(result);
            throw throwable;
        }
        DBUtils.closeSQLStuff(result);
        return tables.toArray(new String[tables.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void correctTable(Connection con, String table) {
        LOG.info("Correcting table {}.", (Object)table);
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            stmt.execute("ALTER TABLE `" + table + "` CONVERT TO CHARSET utf8 " + "COLLATE utf8_unicode_ci;");
        }
        catch (SQLException e) {
            LOG.error("", (Throwable)e);
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }
}

