/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.CalendarCollectionService;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.OXCalendarExceptionCodes;
import com.openexchange.groupware.calendar.RecurringResultInterface;
import com.openexchange.groupware.calendar.RecurringResultsInterface;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AppointmentRepairRecurrenceDatePosition
implements UpdateTask {
    private static final Logger LOG = LoggerFactory.getLogger(AppointmentRepairRecurrenceDatePosition.class);
    private static final String findSQL = "SELECT cid,timestampfield01,timestampfield02,timezone,intfield01,intfield02,intfield04,intfield05,field06 FROM prg_dates WHERE intfield01!=intfield02 AND field08 IS NULL ORDER BY cid ASC";

    @Override
    public int addedWithVersion() {
        return 23;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.NORMAL.priority;
    }

    @Override
    public void perform(Schema schema, int contextId) throws OXException, OXException {
        LOG.info("Performing update task to repair the recurrence date position of appointment change exceptions.");
        Connection con = Database.get(contextId, true);
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            con.setAutoCommit(false);
            stmt = con.prepareStatement(findSQL);
            result = stmt.executeQuery();
            while (result.next()) {
                CalendarDataObject appointment = this.fillAppointment(result);
                LOG.info("Repairing in context {} appointment {}.", (Object)appointment.getContextID(), (Object)appointment.getObjectID());
                try {
                    long recurrence_date_position;
                    if (!appointment.containsRecurrencePosition()) {
                        LOG.info("Unable to repair appointment {} in context {}. Recurrence position is missing.", (Object)appointment.getObjectID(), (Object)appointment.getContextID());
                        continue;
                    }
                    if (null != appointment.getRecurrence()) {
                        AppointmentRepairRecurrenceDatePosition.calculateRecurrenceDatePosition(appointment, appointment.getRecurrencePosition());
                        recurrence_date_position = appointment.getRecurrenceDatePosition().getTime();
                    } else {
                        CalendarDataObject series = this.loadAppointment(con, appointment.getContext(), appointment.getRecurrenceID());
                        AppointmentRepairRecurrenceDatePosition.calculateRecurrenceDatePosition(series, appointment.getRecurrencePosition());
                        recurrence_date_position = series.getRecurrenceDatePosition().getTime();
                    }
                    this.writeRecurrenceDatePosition(con, appointment.getContextID(), appointment.getObjectID(), recurrence_date_position);
                }
                catch (UnsupportedOperationException e) {
                    LOG.info("Unable to repair appointment " + appointment.getObjectID() + " in context " + appointment.getContextID() + ".", (Throwable)e);
                }
                catch (OXException e) {
                    LOG.info("Unable to repair appointment " + appointment.getObjectID() + " in context " + appointment.getContextID() + ".", (Throwable)e);
                }
            }
            con.commit();
        }
        catch (SQLException e) {
            try {
                DBUtils.rollback(con);
                throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.autocommit(con);
                DBUtils.closeSQLStuff(result, stmt);
                if (con != null) {
                    Database.back(contextId, true, con);
                }
                throw throwable;
            }
        }
        DBUtils.autocommit(con);
        DBUtils.closeSQLStuff(result, stmt);
        if (con != null) {
            Database.back(contextId, true, con);
        }
        LOG.info("Update task to repair the recurrence date position of appointment change exceptions performed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRecurrenceDatePosition(Connection con, int cid, int id, long recurrenceDatePosition) {
        String sql = "UPDATE prg_dates SET field08=? WHERE cid=? AND intfield01=?";
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("UPDATE prg_dates SET field08=? WHERE cid=? AND intfield01=?");
            stmt.setString(1, Long.toString(recurrenceDatePosition));
            stmt.setInt(2, cid);
            stmt.setInt(3, id);
            int changed = stmt.executeUpdate();
            if (1 != changed) {
                LOG.error("Updated {} appointments instead of 1.", (Object)changed);
            }
        }
        catch (SQLException e) {
            LOG.error("SQL psroblem while repairing recurrence date position.", (Throwable)e);
        }
        finally {
            DBUtils.closeSQLStuff(null, stmt);
        }
    }

    private CalendarDataObject loadAppointment(Connection con, Context ctx, int id) throws OXException {
        String sql = "SELECT cid,timestampfield01,timestampfield02,timezone,intfield01,intfield02,intfield04,intfield05,field06 FROM prg_dates WHERE cid=? AND intfield01=?";
        PreparedStatement stmt = null;
        ResultSet result = null;
        CalendarDataObject retval = null;
        try {
            stmt = con.prepareStatement("SELECT cid,timestampfield01,timestampfield02,timezone,intfield01,intfield02,intfield04,intfield05,field06 FROM prg_dates WHERE cid=? AND intfield01=?");
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, id);
            result = stmt.executeQuery();
            if (!result.next()) {
                throw OXException.notFound((String)String.valueOf(id));
            }
            retval = this.fillAppointment(result);
        }
        catch (SQLException e) {
            try {
                throw OXCalendarExceptionCodes.CALENDAR_SQL_ERROR.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        return retval;
    }

    private CalendarDataObject fillAppointment(ResultSet result) throws SQLException {
        CalendarDataObject retval = new CalendarDataObject();
        int pos = 1;
        retval.setContext(new SimpleContext(result.getInt(pos++)));
        retval.setStartDate(result.getTimestamp(pos++));
        retval.setEndDate(result.getTimestamp(pos++));
        String tmpString = result.getString(pos++);
        if (!result.wasNull()) {
            retval.setTimezone(tmpString);
        }
        retval.setObjectID(result.getInt(pos++));
        int tmpInt = result.getInt(pos++);
        if (!result.wasNull()) {
            retval.setRecurrenceID(tmpInt);
        }
        tmpInt = result.getInt(pos++);
        if (!result.wasNull()) {
            retval.setRecurrenceCalculator(tmpInt);
        }
        tmpInt = result.getInt(pos++);
        if (!result.wasNull()) {
            retval.setRecurrencePosition(tmpInt);
        }
        tmpString = result.getString(pos++);
        if (!result.wasNull()) {
            retval.setRecurrence(tmpString);
        }
        return retval;
    }

    private static final void calculateRecurrenceDatePosition(CalendarDataObject appointment, int recurrencePosition) throws OXException {
        CalendarCollectionService recColl = ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class);
        recColl.fillDAO(appointment);
        RecurringResultsInterface rrs = recColl.calculateRecurring(appointment, 0L, 0L, recurrencePosition, 999, true);
        if (null == rrs) {
            throw OXCalendarExceptionCodes.UNABLE_TO_CALCULATE_RECURRING_POSITION_NO_INPUT.create();
        }
        RecurringResultInterface rs = rrs.getRecurringResult(0);
        if (null == rs) {
            throw OXCalendarExceptionCodes.UNABLE_TO_CALCULATE_RECURRING_POSITION_NO_INPUT.create();
        }
        appointment.setRecurrenceDatePosition(new Date(rs.getNormalized()));
    }

    private static final class SimpleContext
    implements Context {
        private static final long serialVersionUID = -3564750621953002511L;
        private final int cid;

        SimpleContext(int cid) {
            this.cid = cid;
        }

        public int getContextId() {
            return this.cid;
        }

        public String[] getFileStorageAuth() {
            throw new UnsupportedOperationException("getFileStorageAuth");
        }

        public long getFileStorageQuota() {
            throw new UnsupportedOperationException("getFileStorageQuota");
        }

        public int getFilestoreId() {
            throw new UnsupportedOperationException("getFilestoreId");
        }

        public String getFilestoreName() {
            throw new UnsupportedOperationException("getFilestoreName");
        }

        public String[] getLoginInfo() {
            throw new UnsupportedOperationException("getLoginInfo");
        }

        public int getMailadmin() {
            throw new UnsupportedOperationException("getMailadmin");
        }

        public String getName() {
            throw new UnsupportedOperationException("getName");
        }

        public boolean isEnabled() {
            throw new UnsupportedOperationException("isEnabled");
        }

        public boolean isUpdating() {
            throw new UnsupportedOperationException("isUpdating");
        }

        public boolean isReadOnly() {
            throw new UnsupportedOperationException("isReadOnly");
        }

        public Map<String, List<String>> getAttributes() {
            throw new UnsupportedOperationException("getAttributes");
        }
    }
}

