/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.links;

import com.openexchange.event.impl.AppointmentEventInterface;
import com.openexchange.event.impl.ContactEventInterface;
import com.openexchange.event.impl.NoDelayEventInterface;
import com.openexchange.event.impl.TaskEventInterface;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageEventHelper;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.server.impl.DBPool;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinksEventHandler
implements NoDelayEventInterface,
AppointmentEventInterface,
TaskEventInterface,
ContactEventInterface,
EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LinksEventHandler.class);
    private static final String SQL_DEL = "DELETE from prg_links WHERE (firstid = ? AND firstmodule = ? AND firstfolder = ?) OR (secondid = ? AND secondmodule = ? AND secondfolder = ?) AND cid = ?";
    private static final String SQL_LOAD = "SELECT firstid, firstfolder, secondid, secondfolder FROM prg_links WHERE ((firstid = ? AND firstmodule = ?) OR (secondid = ? AND secondmodule = ?)) AND cid = ? LIMIT 1";
    private static final String SQL_UP1 = "UPDATE prg_links SET firstfolder = ? WHERE firstid = ? AND firstmodule = ? AND cid = ?";
    private static final String SQL_UP2 = "UPDATE prg_links SET secondfolder = ? WHERE secondid = ? AND secondmodule = ? AND cid = ?";

    @Override
    public void appointmentCreated(Appointment appointmentObj, Session sessionObj) {
    }

    @Override
    public void appointmentModified(Appointment appointmentObj, Session sessionObj) {
        this.updateLink(appointmentObj.getObjectID(), 1, appointmentObj.getParentFolderID(), sessionObj);
    }

    @Override
    public void appointmentDeleted(Appointment appointmentObj, Session sessionObj) {
        this.deleteLink(appointmentObj.getObjectID(), 1, appointmentObj.getParentFolderID(), sessionObj);
    }

    @Override
    public void taskCreated(Task taskObj, Session sessionObj) {
    }

    @Override
    public void taskModified(Task taskObj, Session sessionObj) {
        this.updateLink(taskObj.getObjectID(), 4, taskObj.getParentFolderID(), sessionObj);
    }

    @Override
    public void taskDeleted(Task taskObj, Session sessionObj) {
        this.deleteLink(taskObj.getObjectID(), 4, taskObj.getParentFolderID(), sessionObj);
    }

    @Override
    public void contactCreated(Contact contactObj, Session sessionObj) {
    }

    @Override
    public void contactModified(Contact contactObj, Session sessionObj) {
        this.updateLink(contactObj.getObjectID(), 7, contactObj.getParentFolderID(), sessionObj);
    }

    @Override
    public void contactDeleted(Contact contactObj, Session sessionObj) {
        this.deleteLink(contactObj.getObjectID(), 7, contactObj.getParentFolderID(), sessionObj);
    }

    public void handleEvent(final Event event) {
        if (FileStorageEventHelper.isInfostoreEvent((Event)event)) {
            if (FileStorageEventHelper.isUpdateEvent((Event)event)) {
                try {
                    int id = Integer.parseInt(FileStorageEventHelper.extractObjectId((Event)event));
                    int folderId = Integer.parseInt(FileStorageEventHelper.extractFolderId((Event)event));
                    ServerSession session = ServerSessionAdapter.valueOf(FileStorageEventHelper.extractSession((Event)event));
                    this.updateLink(id, 137, folderId, session);
                }
                catch (OXException e) {
                    LOG.error("", (Throwable)e);
                }
                catch (NumberFormatException e) {
                    LOG.debug("Error parsing numerical identifiers from event: {}. Skipping.", (Object)e.getMessage());
                }
                LOG.debug("{}", new Object(){

                    public String toString() {
                        return FileStorageEventHelper.createDebugMessage((String)"UpdateEvent", (Event)event);
                    }
                });
            } else if (FileStorageEventHelper.isDeleteEvent((Event)event)) {
                try {
                    int id = Integer.parseInt(FileStorageEventHelper.extractObjectId((Event)event));
                    int folderId = Integer.parseInt(FileStorageEventHelper.extractFolderId((Event)event));
                    ServerSession session = ServerSessionAdapter.valueOf(FileStorageEventHelper.extractSession((Event)event));
                    this.deleteLink(id, 137, folderId, session);
                }
                catch (OXException e) {
                    LOG.error("", (Throwable)e);
                }
                catch (NumberFormatException e) {
                    LOG.debug("Error parsing numerical identifiers from event: {}. Skipping.", (Object)e.getMessage());
                }
                LOG.debug("{}", new Object(){

                    public String toString() {
                        return FileStorageEventHelper.createDebugMessage((String)"DebugEvent", (Event)event);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void deleteLink(int id, int type, int fid, Session so) {
        block16: {
            contextId = so.getContextId();
            try {
                ct = ContextStorage.getStorageContext(contextId);
            }
            catch (OXException e) {
                LinksEventHandler.LOG.error("ERROR: Unable to Delete Links from Object! cid={} oid={} fid={}", new Object[]{contextId, id, fid, e});
                return;
            }
            con = null;
            stmt = null;
            rs = null;
            try {
                con = DBPool.pickup(ct);
                stmt = con.prepareStatement("SELECT DISTINCT 1 FROM prg_links WHERE cid = ?");
                stmt.setInt(1, contextId);
                rs = stmt.executeQuery();
                if (rs.next()) break block16;
            }
            catch (Exception se) {
                try {
                    LinksEventHandler.LOG.debug("DEBUG: Error occurred during look-up attempt. cid={} oid={} fid={}", new Object[]{contextId, id, fid, se});
                }
                catch (Throwable var11_14) {
                    DBUtils.closeSQLStuff(rs, stmt);
                    if (null != con) {
                        DBPool.closeReaderSilent(ct, con);
                    }
                    throw var11_14;
                }
                DBUtils.closeSQLStuff(rs, stmt);
                if (null != con) {
                    DBPool.closeReaderSilent(ct, con);
                } else {
                    ** GOTO lbl38
                }
            }
            DBUtils.closeSQLStuff(rs, stmt);
            if (null != con) {
                DBPool.closeReaderSilent(ct, con);
            }
            return;
        }
        DBUtils.closeSQLStuff(rs, stmt);
        if (null != con) {
            DBPool.closeReaderSilent(ct, con);
        }
        con = null;
        stmt = null;
        rs = null;
        try {
            con = DBPool.pickupWriteable(ct);
            stmt = con.prepareStatement("DELETE from prg_links WHERE (firstid = ? AND firstmodule = ? AND firstfolder = ?) OR (secondid = ? AND secondmodule = ? AND secondfolder = ?) AND cid = ?");
            pos = 1;
            stmt.setInt(pos++, id);
            stmt.setInt(pos++, type);
            stmt.setInt(pos++, fid);
            stmt.setInt(pos++, id);
            stmt.setInt(pos++, type);
            stmt.setInt(pos++, fid);
            stmt.setInt(pos++, contextId);
            stmt.executeUpdate();
        }
        catch (Exception se) {
            LinksEventHandler.LOG.error("ERROR: Unable to Delete Links from Object! cid={} oid={} fid={}", new Object[]{contextId, id, fid, se});
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
            if (null != con) {
                DBPool.closeWriterSilent(ct, con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLink(int id, int type, int fid, Session so) {
        Context ct;
        boolean updater;
        ResultSet rs;
        PreparedStatement smt;
        Connection writecon;
        block21: {
            writecon = null;
            smt = null;
            rs = null;
            updater = false;
            ct = null;
            try {
                ct = ContextStorage.getStorageContext(so.getContextId());
            }
            catch (OXException e) {
                LOG.error("UNABLE TO LOAD LINK OBJECT FOR UPDATE (cid={} uid={} type={} fid={})", new Object[]{so.getContextId(), id, type, fid, e});
                return;
            }
            try {
                writecon = DBPool.pickup(ct);
                smt = writecon.prepareStatement(SQL_LOAD);
                int pos = 1;
                smt.setInt(pos++, id);
                smt.setInt(pos++, type);
                smt.setInt(pos++, id);
                smt.setInt(pos++, type);
                smt.setInt(pos++, so.getContextId());
                rs = smt.executeQuery();
                if (!rs.next()) break block21;
                int tp = rs.getInt(1);
                int fp = rs.getInt(2);
                if (tp != id) {
                    tp = rs.getInt(3);
                    fp = rs.getInt(4);
                }
                if (fid == fp) break block21;
                updater = true;
            }
            catch (Exception e) {
                try {
                    LOG.error("UNABLE TO LOAD LINK OBJECT FOR UPDATE (cid={} uid={} type={} fid={})", new Object[]{so.getContextId(), id, type, fid, e});
                }
                catch (Throwable throwable) {
                    DBUtils.closeResources(rs, (Statement)smt, writecon, false, ct);
                    rs = null;
                    smt = null;
                    throw throwable;
                }
                DBUtils.closeResources(rs, (Statement)smt, writecon, false, ct);
                rs = null;
                smt = null;
            }
        }
        DBUtils.closeResources(rs, (Statement)smt, writecon, false, ct);
        rs = null;
        smt = null;
        PreparedStatement upd = null;
        if (updater) {
            try {
                writecon = DBPool.pickup(ct);
                writecon.setAutoCommit(false);
                upd = writecon.prepareStatement(SQL_UP1);
                int pos = 1;
                upd.setInt(pos++, fid);
                upd.setInt(pos++, id);
                upd.setInt(pos++, type);
                upd.setInt(pos++, so.getContextId());
                upd.executeUpdate();
                upd.close();
                upd = writecon.prepareStatement(SQL_UP2);
                pos = 1;
                upd.setInt(pos++, fid);
                upd.setInt(pos++, id);
                upd.setInt(pos++, type);
                upd.setInt(pos++, so.getContextId());
                upd.executeUpdate();
                writecon.commit();
            }
            catch (Exception se) {
                try {
                    writecon.rollback();
                }
                catch (SQLException see) {
                    LOG.error("Uable to rollback Link Update", (Throwable)see);
                }
                LOG.error("ERROR: Unable to Update Links for Object! cid={} oid={} fid={}", new Object[]{so.getContextId(), id, fid, se});
            }
            finally {
                try {
                    writecon.setAutoCommit(true);
                }
                catch (SQLException see) {
                    LOG.error("Unable to restore auto-commit", (Throwable)see);
                }
                DBUtils.closeResources(null, (Statement)upd, writecon, false, ct);
            }
        }
    }

    @Override
    public void appointmentAccepted(Appointment appointmentObj, Session sessionObj) {
    }

    @Override
    public void appointmentDeclined(Appointment appointmentObj, Session sessionObj) {
    }

    @Override
    public void appointmentTentativelyAccepted(Appointment appointmentObj, Session sessionObj) {
    }

    @Override
    public void appointmentWaiting(Appointment appointmentObj, Session sessionObj) {
    }

    @Override
    public void taskAccepted(Task taskObj, Session sessionObj) {
    }

    @Override
    public void taskDeclined(Task taskObj, Session sessionObj) {
    }

    @Override
    public void taskTentativelyAccepted(Task taskObj, Session sessionObj) {
    }
}

