/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.container;

import com.openexchange.groupware.container.CalendarObject;
import com.openexchange.groupware.container.Change;
import com.openexchange.groupware.container.ConfirmationChange;
import com.openexchange.groupware.container.Differ;
import com.openexchange.groupware.container.Difference;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import edu.emory.mathcs.backport.java.util.Arrays;

public class ParticipantsDiffer
extends Differ<CalendarObject> {
    @Override
    public Difference getDifference(CalendarObject original, CalendarObject update) {
        boolean found;
        if (!update.containsParticipants()) {
            return null;
        }
        if (!original.containsParticipants() && update.containsParticipants()) {
            Difference difference = new Difference(220);
            difference.getAdded().addAll(Arrays.asList((Object[])update.getParticipants()));
            return difference;
        }
        if (original.getParticipants() == update.getParticipants()) {
            return null;
        }
        if (original.getParticipants() == null) {
            Difference difference = new Difference(220);
            difference.getAdded().addAll(Arrays.asList((Object[])update.getParticipants()));
            return difference;
        }
        boolean isDifferent = false;
        Difference difference = new Difference(220);
        if (original.getParticipants() != null) {
            for (Participant o : original.getParticipants()) {
                found = false;
                if (update.getParticipants() != null) {
                    for (Participant u : update.getParticipants()) {
                        if ((o.getIdentifier() != u.getIdentifier() || o.getIdentifier() == -1) && (o.getEmailAddress() == null || !o.getEmailAddress().equalsIgnoreCase(u.getEmailAddress()))) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                difference.getRemoved().add(o);
                isDifferent = true;
            }
        }
        if (update.getParticipants() != null) {
            for (Participant u : update.getParticipants()) {
                found = false;
                if (original.getParticipants() != null) {
                    for (Participant o : original.getParticipants()) {
                        if ((u.getIdentifier() != o.getIdentifier() || o.getIdentifier() == -1) && (u.getEmailAddress() == null || !u.getEmailAddress().equalsIgnoreCase(o.getEmailAddress()))) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                difference.getAdded().add(u);
                isDifferent = true;
            }
        }
        return isDifferent ? difference : null;
    }

    private Change getChange(UserParticipant original, UserParticipant update) {
        boolean changed = false;
        ConfirmationChange change = new ConfirmationChange(Integer.toString(original.getIdentifier()));
        if (original.getConfirm() != update.getConfirm()) {
            changed = true;
            change.setStatus(original.getConfirm(), update.getConfirm());
        }
        if (original.getConfirmMessage() != update.getConfirmMessage() && (original.getConfirmMessage() == null && update.getConfirmMessage() != null || !original.getConfirmMessage().equals(update.getConfirmMessage()))) {
            changed = true;
            change.setMessage(original.getConfirmMessage(), update.getConfirmMessage());
        }
        return changed ? change : null;
    }

    @Override
    public int getColumn() {
        return 220;
    }
}

