/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.container;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderChildObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.tools.OXCloneable;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.OXFolderIteratorSQL;
import com.openexchange.tools.oxfolder.OXFolderLoader;
import com.openexchange.tools.oxfolder.OXFolderSQL;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderObject
extends FolderChildObject
implements Cloneable {
    private static final long serialVersionUID = 1019652520335292041L;
    private static final transient Logger LOG = LoggerFactory.getLogger(FolderObject.class);
    public static final int SYSTEM_ROOT_FOLDER_ID = 0;
    public static final int SYSTEM_PRIVATE_FOLDER_ID = 1;
    public static final int SYSTEM_PUBLIC_FOLDER_ID = 2;
    public static final int SYSTEM_SHARED_FOLDER_ID = 3;
    public static final int SYSTEM_FOLDER_ID = 4;
    public static final int SYSTEM_GLOBAL_FOLDER_ID = 5;
    public static final int SYSTEM_LDAP_FOLDER_ID = 6;
    public static final int SYSTEM_OX_FOLDER_ID = 7;
    public static final int SYSTEM_OX_PROJECT_FOLDER_ID = 8;
    public static final int SYSTEM_INFOSTORE_FOLDER_ID = 9;
    public static final int SYSTEM_USER_INFOSTORE_FOLDER_ID = 10;
    public static final int SYSTEM_PUBLIC_INFOSTORE_FOLDER_ID = 15;
    public static final int VIRTUAL_LIST_TASK_FOLDER_ID = 11;
    public static final int VIRTUAL_LIST_CALENDAR_FOLDER_ID = 12;
    public static final int VIRTUAL_LIST_CONTACT_FOLDER_ID = 13;
    public static final int VIRTUAL_LIST_INFOSTORE_FOLDER_ID = 14;
    public static final int MIN_FOLDER_ID = 20;
    public static final String SYSTEM_PRIVATE_FOLDER_NAME = "private";
    public static final String SYSTEM_PUBLIC_FOLDER_NAME = "public";
    public static final String SYSTEM_SHARED_FOLDER_NAME = "shared";
    public static final String SYSTEM_FOLDER_NAME = "system";
    public static final String SYSTEM_GLOBAL_FOLDER_NAME = "system_global";
    public static final String SYSTEM_LDAP_FOLDER_NAME = "system_ldap";
    public static final String SYSTEM_OX_FOLDER_NAME = "user";
    public static final String SYSTEM_OX_PROJECT_FOLDER_NAME = "projects";
    public static final String SYSTEM_INFOSTORE_FOLDER_NAME = "infostore";
    public static final String SYSTEM_USER_INFOSTORE_FOLDER_NAME = "userstore";
    public static final String SYSTEM_PUBLIC_INFOSTORE_FOLDER_NAME = "public_infostore";
    public static final String SHARED_PREFIX = "u:";
    public static final int FOLDER_NAME = 300;
    public static final int MODULE = 301;
    public static final int TYPE = 302;
    public static final int SUBFOLDERS = 304;
    public static final int OWN_RIGHTS = 305;
    public static final int PERMISSIONS_BITS = 306;
    public static final int SUMMARY = 307;
    public static final int STANDARD_FOLDER = 308;
    public static final int TOTAL = 309;
    public static final int NEW = 310;
    public static final int UNREAD = 311;
    public static final int DELETED = 312;
    public static final int CAPABILITIES = 313;
    public static final int SUBSCRIBED = 314;
    public static final int SUBSCR_SUBFLDS = 315;
    public static final int[] ALL_COLUMNS = new int[]{300, 301, 302, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 20, 1, 2, 3, 4, 5, 6};
    public static final int TASK = 1;
    public static final int CALENDAR = 2;
    public static final int CONTACT = 3;
    public static final int UNBOUND = 4;
    public static final int SYSTEM_MODULE = 5;
    public static final int PROJECT = 6;
    public static final int MAIL = 7;
    public static final int INFOSTORE = 8;
    public static final int MESSAGING = 13;
    public static final int FILE = 14;
    public static final int PRIVATE = 1;
    public static final int PUBLIC = 2;
    public static final int SHARED = 3;
    public static final int SYSTEM_TYPE = 5;
    private static final int[] SORTED_TYPES = new int[]{1, 2, 3};
    public static final String SQL_IN_STR_STANDARD_MODULES = "" + '(' + 1 + ',' + 2 + ',' + 3 + ',' + 4 + ',' + 8 + ')';
    public static final String SQL_IN_STR_STANDARD_MODULES_ALL = "" + '(' + 1 + ',' + 2 + ',' + 3 + ',' + 4 + ',' + 5 + ',' + 8 + ')';
    public static final int PRIVATE_PERMISSION = 1;
    public static final int PUBLIC_PERMISSION = 2;
    public static final int CUSTOM_PERMISSION = 3;
    protected String folderName;
    protected boolean b_folderName;
    protected int module;
    protected boolean b_module;
    protected int type;
    protected boolean b_type;
    protected boolean defaultFolder;
    protected boolean b_defaultFolder;
    protected int permissionFlag;
    protected boolean b_permissionFlag;
    protected ArrayList<OCLPermission> permissions = new ArrayList();
    protected boolean b_permissions;
    protected boolean subfolderFlag;
    protected boolean b_subfolderFlag;
    protected ArrayList<Integer> subfolderIds = new ArrayList();
    protected boolean b_subfolderIds;
    protected String fullName;
    protected boolean b_fullName;
    private static final int[] MODULES = new int[]{1, 2, 3};
    private static final OCLPermission VIRTUAL_FOLDER_PERMISSION = new OCLPermission();

    public static String getFolderString(int id, Locale locale) {
        StringHelper strHelper = StringHelper.valueOf(locale);
        switch (id) {
            case 1: {
                return strHelper.getString("Private folders");
            }
            case 2: {
                return strHelper.getString("Public folders");
            }
            case 3: {
                return strHelper.getString("Shared folders");
            }
            case 4: {
                return strHelper.getString("System");
            }
            case 5: {
                return strHelper.getString("Shared address book");
            }
            case 6: {
                return strHelper.getString("Global address book");
            }
            case 7: {
                return strHelper.getString("OX folders");
            }
            case 8: {
                return strHelper.getString("Projects");
            }
            case 9: {
                return strHelper.getString("Infostore");
            }
            case 10: {
                return strHelper.getString("Userstore");
            }
            case 15: {
                return strHelper.getString("Public infostore");
            }
            case 11: {
                return strHelper.getString("Other task folders");
            }
            case 12: {
                return strHelper.getString("Other calendar folders");
            }
            case 13: {
                return strHelper.getString("Other contact folders");
            }
            case 14: {
                return strHelper.getString("Other infostore folders");
            }
        }
        return null;
    }

    public static final boolean isValidFolderType(int type) {
        return Arrays.binarySearch(SORTED_TYPES, type) >= 0;
    }

    public FolderObject() {
        this.topic = "ox/common/folder";
    }

    public FolderObject(int objectId) {
        this.objectId = objectId;
        this.b_objectId = true;
        this.topic = "ox/common/folder";
    }

    public FolderObject(String folderName, int objectId, int module, int type, int creator) {
        this.folderName = folderName;
        this.b_folderName = true;
        this.module = module;
        this.b_module = true;
        this.type = type;
        this.b_type = true;
        this.objectId = objectId;
        this.b_objectId = true;
        this.createdBy = creator;
        this.b_createdBy = true;
        this.topic = "ox/common/folder";
    }

    public boolean isDefaultFolder() {
        return this.defaultFolder;
    }

    public boolean containsDefaultFolder() {
        return this.b_defaultFolder;
    }

    public void setDefaultFolder(boolean defaultFolder) {
        this.defaultFolder = defaultFolder;
        this.b_defaultFolder = true;
    }

    public void removeDefaultFolder() {
        this.defaultFolder = false;
        this.b_defaultFolder = false;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public boolean containsFolderName() {
        return this.b_folderName;
    }

    public void setFolderName(String folderName) {
        this.folderName = folderName;
        this.b_folderName = true;
    }

    public void removeFolderName() {
        this.folderName = null;
        this.b_folderName = false;
    }

    public int getModule() {
        return this.module;
    }

    public boolean containsModule() {
        return this.b_module;
    }

    public void setModule(int module) {
        this.module = module;
        this.b_module = true;
    }

    public void removeModule() {
        this.module = 0;
        this.b_module = false;
    }

    public int getPermissionFlag() {
        return this.permissionFlag;
    }

    public boolean containsPermissionFlag() {
        return this.b_permissionFlag;
    }

    public void setPermissionFlag(int permissionFlag) {
        this.permissionFlag = permissionFlag;
        this.b_permissionFlag = true;
    }

    public void removePermissionFlag() {
        this.permissionFlag = 0;
        this.b_permissionFlag = false;
    }

    public List<OCLPermission> getPermissions() {
        return this.permissions;
    }

    public OCLPermission[] getPermissionsAsArray() {
        OCLPermission[] perms = new OCLPermission[this.permissions.size()];
        System.arraycopy(this.permissions.toArray(), 0, perms, 0, perms.length);
        return perms;
    }

    public OCLPermission[] getNonSystemPermissionsAsArray() {
        ArrayList<OCLPermission> retval = new ArrayList<OCLPermission>(this.permissions.size());
        for (OCLPermission permission : this.permissions) {
            if (permission.isSystem()) continue;
            retval.add(permission);
        }
        return retval.toArray(new OCLPermission[retval.size()]);
    }

    public OCLPermission getNonSystemPermission(int entity) {
        for (OCLPermission permission : this.permissions) {
            if (permission.isSystem() || permission.getEntity() != entity) continue;
            return permission.deepClone();
        }
        return null;
    }

    public boolean isNonSystemVisible(int entity) {
        for (OCLPermission permission : this.permissions) {
            if (permission.isSystem() || permission.getEntity() != entity || !permission.isFolderVisible()) continue;
            return true;
        }
        return false;
    }

    public boolean isVisibleForAny(int[] entities) {
        if (null == entities) {
            return false;
        }
        int length = entities.length;
        if (0 == length) {
            return false;
        }
        if (1 == length) {
            return this.isVisible(entities[0]);
        }
        Arrays.sort(entities);
        for (OCLPermission cur : this.permissions) {
            if (Arrays.binarySearch(entities, cur.getEntity()) < 0 || !cur.isFolderVisible()) continue;
            return true;
        }
        return false;
    }

    public boolean isVisible(int entity) {
        if (entity < 0) {
            return false;
        }
        for (OCLPermission cur : this.permissions) {
            if (cur.getEntity() != entity || !cur.isFolderVisible()) continue;
            return true;
        }
        return false;
    }

    public boolean containsPermissions() {
        return this.b_permissions;
    }

    public void setPermissionsNoClone(List<OCLPermission> permissions) {
        this.permissions = new ArrayList<OCLPermission>(permissions);
        this.b_permissions = true;
    }

    public void setPermissions(List<OCLPermission> permissions) {
        if (null != permissions) {
            int size = permissions.size();
            this.permissions = new ArrayList(size);
            for (OCLPermission permission : permissions) {
                this.permissions.add(permission.deepClone());
            }
            this.b_permissions = true;
        }
    }

    public void setPermissionsAsArray(OCLPermission[] permissions) {
        if (null == permissions) {
            return;
        }
        if (this.permissions == null) {
            this.permissions = new ArrayList();
        } else {
            this.permissions.clear();
        }
        for (OCLPermission permission : permissions) {
            this.permissions.add(permission.deepClone());
        }
        this.b_permissions = true;
    }

    public void addPermission(OCLPermission permission) {
        if (null == permission) {
            return;
        }
        if (this.permissions == null) {
            this.permissions = new ArrayList(4);
        }
        this.b_permissions = true;
        this.permissions.add(permission.deepClone());
    }

    public void removePermissions() {
        this.permissions = null;
        this.b_permissions = false;
    }

    public int getType() {
        return this.type;
    }

    public int getType(int userId) {
        return this.isShared(userId) ? 3 : this.type;
    }

    public boolean containsType() {
        return this.b_type;
    }

    public void setType(int type) {
        this.type = type;
        this.b_type = true;
    }

    public void removeType() {
        this.type = 0;
        this.b_type = false;
    }

    public int getCreator() {
        return this.createdBy;
    }

    public boolean containsCreator() {
        return this.b_createdBy;
    }

    public void setCreator(int creator) {
        this.createdBy = creator;
        this.b_createdBy = true;
    }

    public void removeCreator() {
        this.createdBy = 0;
        this.b_createdBy = false;
    }

    public boolean hasSubfolders() {
        return this.subfolderFlag;
    }

    public final boolean hasVisibleSubfolders(User user, UserConfiguration userConfig, Context ctx) throws OXException {
        return this.hasVisibleSubfolders(user.getId(), user.getGroups(), userConfig, ctx);
    }

    public final boolean hasVisibleSubfolders(int userId, int[] groups, UserConfiguration userConfig, Context ctx) throws OXException {
        SearchIterator<FolderObject> iter = null;
        try {
            if (0 == this.objectId) {
                boolean bl = true;
                return bl;
            }
            if (2 == this.objectId) {
                if (new OXFolderAccess(ctx).getFolderPermission(6, userId, userConfig).isFolderVisible()) {
                    boolean bl = true;
                    return bl;
                }
                iter = OXFolderIteratorSQL.getAllVisibleFoldersIteratorOfType(userId, groups, userConfig.getAccessibleModules(), 2, MODULES, 2, ctx);
                boolean bl = iter.hasNext();
                return bl;
            }
            if (9 == this.objectId) {
                boolean bl = userConfig.hasInfostore();
                return bl;
            }
            if (!this.subfolderFlag) {
                boolean bl = false;
                return bl;
            }
            if (this.objectId == 10 || this.objectId == 1 || this.objectId == 12 || this.objectId == 13 || this.objectId == 11 || this.objectId == 14) {
                boolean bl = this.subfolderFlag;
                return bl;
            }
            iter = OXFolderIteratorSQL.getVisibleSubfoldersIterator(this.objectId, userId, groups, ctx, userConfig.getUserPermissionBits(), null);
            boolean bl = iter.hasNext();
            return bl;
        }
        catch (OXException e) {
            throw e;
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            if (iter != null) {
                try {
                    iter.close();
                }
                catch (OXException e) {
                    LOG.error("SearchIterator cannot be closed", (Throwable)e);
                }
            }
        }
    }

    public boolean containsSubfolderFlag() {
        return this.b_subfolderFlag;
    }

    public void setSubfolderFlag(boolean subfolderFlag) {
        this.subfolderFlag = subfolderFlag;
        this.b_subfolderFlag = true;
    }

    public void removeSubfolderFlag() {
        this.subfolderFlag = false;
        this.b_subfolderFlag = false;
    }

    public final List<FolderObject> getVisibleSubfolders(User userObj, UserConfiguration userConfig, Context ctx) throws SQLException, OXException {
        return this.getVisibleSubfolders(userObj.getId(), userObj.getGroups(), userConfig, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<FolderObject> getVisibleSubfolders(int userId, int[] groups, UserConfiguration userConfig, Context ctx) throws OXException, SQLException {
        if (this.b_subfolderFlag && !this.subfolderFlag) {
            return new ArrayList<FolderObject>(0);
        }
        SearchIterator<FolderObject> iter = null;
        try {
            ArrayList<FolderObject> retval;
            iter = this.objectId == 11 ? OXFolderIteratorSQL.getVisibleFoldersNotSeenInTreeView(1, userId, groups, userConfig.getUserPermissionBits(), ctx, null) : (this.objectId == 12 ? OXFolderIteratorSQL.getVisibleFoldersNotSeenInTreeView(2, userId, groups, userConfig.getUserPermissionBits(), ctx, null) : (this.objectId == 13 ? OXFolderIteratorSQL.getVisibleFoldersNotSeenInTreeView(3, userId, groups, userConfig.getUserPermissionBits(), ctx, null) : (this.objectId == 14 ? OXFolderIteratorSQL.getVisibleFoldersNotSeenInTreeView(8, userId, groups, userConfig.getUserPermissionBits(), ctx, null) : OXFolderIteratorSQL.getVisibleSubfoldersIterator(this.objectId, userId, groups, ctx, userConfig.getUserPermissionBits(), null))));
            if (iter.size() != -1) {
                int size = iter.size();
                retval = new ArrayList(size);
                for (int i = 0; i < size; ++i) {
                    retval.add((FolderObject)iter.next());
                }
            } else {
                retval = new ArrayList<FolderObject>();
                while (iter.hasNext()) {
                    retval.add((FolderObject)iter.next());
                }
            }
            ArrayList<FolderObject> arrayList = retval;
            return arrayList;
        }
        finally {
            if (iter != null) {
                iter.close();
                iter = null;
            }
        }
    }

    public final List<Integer> getSubfolderIds() throws OXException {
        if (!this.b_subfolderIds) {
            throw OXFolderExceptionCode.ATTRIBUTE_NOT_SET.create("subfolderIds", Integer.toString(this.getObjectID()), "");
        }
        return this.subfolderIds;
    }

    public final List<Integer> getSubfolderIds(boolean enforce, Context ctx) throws OXException, SQLException, OXException {
        return this.getSubfolderIds(enforce, null, ctx);
    }

    public final List<Integer> getSubfolderIds(boolean enforce, Connection readCon, Context ctx) throws OXException, SQLException, OXException {
        if (!this.b_subfolderIds) {
            if (this.b_subfolderFlag && !this.subfolderFlag) {
                return new ArrayList<Integer>(0);
            }
            if (!enforce) {
                throw OXFolderExceptionCode.ATTRIBUTE_NOT_SET.create("subfolderIds", Integer.toString(this.getObjectID()), "");
            }
            this.subfolderIds = FolderObject.getSubfolderIds(this.objectId, ctx, readCon);
            this.b_subfolderIds = true;
        }
        return this.subfolderIds;
    }

    public boolean containsSubfolderIds() {
        return this.b_subfolderIds;
    }

    public void setSubfolderIds(ArrayList<Integer> subfolderIds) {
        this.subfolderIds = new ArrayList<Integer>(subfolderIds);
        this.b_subfolderIds = true;
    }

    public void removeSubfolderIds() {
        this.subfolderIds = null;
        this.b_subfolderIds = false;
    }

    public String getFullName() {
        return this.fullName;
    }

    public boolean containsFullName() {
        return this.b_fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
        this.b_fullName = true;
    }

    public void removeFullName() {
        this.fullName = null;
        this.b_fullName = false;
    }

    @Override
    public final void reset() {
        super.reset();
        this.removeCreator();
        this.removeType();
        this.removePermissions();
        this.removePermissionFlag();
        this.removeModule();
        this.removeFolderName();
        this.removeSubfolderFlag();
        this.removeSubfolderIds();
    }

    public final FolderObject fill(FolderObject other) {
        return this.fill(other, true);
    }

    public final FolderObject fill(FolderObject other, boolean overwrite) {
        if (overwrite) {
            this.reset();
        }
        if (other.containsObjectID() && (overwrite || !this.containsObjectID())) {
            this.setObjectID(other.getObjectID());
        }
        if (other.containsCreatedBy() && (overwrite || !this.containsCreatedBy())) {
            this.setCreatedBy(other.getCreatedBy());
        }
        if (other.containsCreationDate() && (overwrite || !this.containsCreationDate())) {
            this.setCreationDate(other.getCreationDate());
        }
        if (other.containsDefaultFolder() && (overwrite || !this.containsDefaultFolder())) {
            this.setDefaultFolder(other.isDefaultFolder());
        }
        if (other.containsFolderName() && (overwrite || !this.containsFolderName())) {
            this.setFolderName(other.getFolderName());
        }
        if (other.containsFullName() && (overwrite || !this.containsFullName())) {
            this.setFullName(other.getFullName());
        }
        if (other.containsLastModified() && (overwrite || !this.containsLastModified())) {
            this.setLastModified(other.getLastModified());
        }
        if (other.containsModifiedBy() && (overwrite || !this.containsModifiedBy())) {
            this.setModifiedBy(other.getModifiedBy());
        }
        if (other.containsModule() && (overwrite || !this.containsModule())) {
            this.setModule(other.getModule());
        }
        if (other.containsParentFolderID() && (overwrite || !this.containsParentFolderID())) {
            this.setParentFolderID(other.getParentFolderID());
        }
        if (other.containsPermissionFlag() && (overwrite || !this.containsPermissionFlag())) {
            this.setPermissionFlag(other.getPermissionFlag());
        }
        if (other.containsPermissions() && (overwrite || !this.containsPermissions())) {
            this.setPermissions(other.getPermissions());
        }
        if (other.containsSubfolderFlag() && (overwrite || !this.containsSubfolderFlag())) {
            this.setSubfolderFlag(other.hasSubfolders());
        }
        if (other.containsSubfolderIds() && (overwrite || !this.containsSubfolderIds())) {
            try {
                this.setSubfolderIds((ArrayList)other.getSubfolderIds());
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
        }
        if (other.containsType() && (overwrite || !this.containsType())) {
            this.setType(other.getType());
        }
        return this;
    }

    public final boolean exists(Context ctx) throws OXException {
        if (this.containsObjectID()) {
            try {
                return OXFolderSQL.exists(this.getObjectID(), null, ctx);
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
        }
        if (this.containsParentFolderID() && this.containsFolderName() && this.containsModule()) {
            try {
                int fuid = OXFolderSQL.lookUpFolder(this.getParentFolderID(), this.getFolderName(), this.getModule(), null, ctx);
                if (fuid == -1) {
                    return false;
                }
                this.setObjectID(fuid);
                return true;
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
        }
        throw OXFolderExceptionCode.UNSUFFICIENT_FOLDER_INFORMATION.create();
    }

    public final boolean isShared(int userId) {
        return this.type == 1 && this.createdBy != userId;
    }

    public final boolean isVisible(int userId, UserPermissionBits userPerm) throws OXException {
        return this.getEffectiveUserPermission(userId, userPerm).isFolderVisible();
    }

    public final boolean isVisible(int userId, UserConfiguration userConfig) throws OXException {
        return this.getEffectiveUserPermission(userId, userConfig).isFolderVisible();
    }

    public final EffectivePermission getEffectiveUserPermission(int userId, UserPermissionBits userPerm) throws OXException {
        if (!this.containsPermissions()) {
            try {
                this.setPermissionsAsArray(FolderObject.getFolderPermissions(this.getObjectID(), ContextStorage.getStorageContext(userPerm.getContextId()), null));
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
        }
        return this.calcEffectiveUserPermission(userId, userPerm);
    }

    public final EffectivePermission getEffectiveUserPermission(int userId, UserConfiguration userConfig) throws OXException {
        if (!this.containsPermissions()) {
            try {
                this.setPermissionsAsArray(FolderObject.getFolderPermissions(this.getObjectID(), userConfig.getContext(), null));
            }
            catch (SQLException e) {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
        }
        return this.calcEffectiveUserPermission(userId, userConfig);
    }

    public final EffectivePermission getEffectiveUserPermission(int userId, UserPermissionBits upb, Connection readConArg) throws SQLException, OXException {
        if (!this.containsPermissions()) {
            this.setPermissionsAsArray(FolderObject.getFolderPermissions(this.getObjectID(), upb.getContext(), readConArg));
        }
        return this.calcEffectiveUserPermission(userId, upb);
    }

    public final EffectivePermission getEffectiveUserPermission(int userId, UserConfiguration userConfig, Connection readConArg) throws SQLException, OXException {
        if (!this.containsPermissions()) {
            this.setPermissionsAsArray(FolderObject.getFolderPermissions(this.getObjectID(), userConfig.getContext(), readConArg));
        }
        return this.calcEffectiveUserPermission(userId, userConfig);
    }

    private final EffectivePermission calcEffectiveUserPermission(int userId, UserPermissionBits userPermissionBits) {
        return this.calcEffectiveUserPermission(userId, userPermissionBits, true);
    }

    private final EffectivePermission calcEffectiveUserPermission(int userId, UserPermissionBits userPermissionBits, boolean considerSystemPermissions) {
        EffectivePermission maxPerm = new EffectivePermission(userId, this.getObjectID(), this.getType(userId), this.getModule(), this.getCreatedBy(), userPermissionBits);
        int[] groups = userPermissionBits.getGroups();
        int[] idArr = new int[groups.length + 1];
        idArr[0] = userId;
        System.arraycopy(groups, 0, idArr, 1, groups.length);
        Arrays.sort(idArr);
        int fp = 0;
        int orp = 0;
        int owp = 0;
        int odp = 0;
        boolean admin = false;
        for (OCLPermission oclPerm : this.getPermissions()) {
            if (!considerSystemPermissions && oclPerm.isSystem() || Arrays.binarySearch(idArr, oclPerm.getEntity()) < 0) continue;
            int cur = oclPerm.getFolderPermission();
            if (cur > fp) {
                fp = cur;
            }
            if ((cur = oclPerm.getReadPermission()) > orp) {
                orp = cur;
            }
            if ((cur = oclPerm.getWritePermission()) > owp) {
                owp = cur;
            }
            if ((cur = oclPerm.getDeletePermission()) > odp) {
                odp = cur;
            }
            admin |= oclPerm.isFolderAdmin();
        }
        maxPerm.setAllPermission(fp, orp, owp, odp);
        maxPerm.setFolderAdmin(admin);
        return maxPerm;
    }

    private final EffectivePermission calcEffectiveUserPermission(int userId, UserConfiguration userConfig) {
        EffectivePermission maxPerm = new EffectivePermission(userId, this.getObjectID(), this.getType(userId), this.getModule(), this.getCreatedBy(), userConfig);
        int[] groups = userConfig.getGroups();
        int[] idArr = new int[groups.length + 1];
        idArr[0] = userId;
        System.arraycopy(groups, 0, idArr, 1, groups.length);
        Arrays.sort(idArr);
        int fp = 0;
        int orp = 0;
        int owp = 0;
        int odp = 0;
        boolean admin = false;
        for (OCLPermission oclPerm : this.getPermissions()) {
            if (Arrays.binarySearch(idArr, oclPerm.getEntity()) < 0) continue;
            int cur = oclPerm.getFolderPermission();
            if (cur > fp) {
                fp = cur;
            }
            if ((cur = oclPerm.getReadPermission()) > orp) {
                orp = cur;
            }
            if ((cur = oclPerm.getWritePermission()) > owp) {
                owp = cur;
            }
            if ((cur = oclPerm.getDeletePermission()) > odp) {
                odp = cur;
            }
            admin |= oclPerm.isFolderAdmin();
        }
        maxPerm.setAllPermission(fp, orp, owp, odp);
        maxPerm.setFolderAdmin(admin);
        return maxPerm;
    }

    public String toString() {
        int i;
        Iterator<Serializable> iter;
        int size;
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append('\n');
        if (this.containsObjectID()) {
            sb.append("ObjectID=").append(this.getObjectID());
        } else {
            sb.append("<no-object-id>");
        }
        if (this.containsFullName()) {
            sb.append(" Full Name=").append(this.getFullName());
        }
        if (this.containsParentFolderID()) {
            sb.append(" Parent Folder ID=").append(this.getParentFolderID());
        }
        if (this.containsFolderName()) {
            sb.append(" Folder Name=").append(this.getFolderName());
        }
        if (this.containsType()) {
            sb.append(" Type=").append(this.getType());
        }
        if (this.containsModule()) {
            sb.append(" Module=").append(this.getModule());
        }
        if (this.containsCreatedBy()) {
            sb.append(" Created By=").append(this.getCreatedBy());
        }
        if (this.containsCreationDate()) {
            sb.append(" Creation Date=").append(this.getCreationDate());
        }
        if (this.containsModifiedBy()) {
            sb.append(" Modified By=").append(this.getModifiedBy());
        }
        if (this.containsLastModified()) {
            sb.append(" Last Modified=").append(this.getLastModified());
        }
        if (this.containsDefaultFolder()) {
            sb.append(" Default Folder=").append(this.isDefaultFolder());
        }
        if (this.containsSubfolderFlag()) {
            sb.append(" Has Subfolders=").append(this.hasSubfolders());
        }
        if (this.containsPermissions()) {
            sb.append(" permissions=");
            size = this.getPermissions().size();
            iter = this.getPermissions().iterator();
            for (i = 0; i < size; ++i) {
                sb.append(((OCLPermission)iter.next()).toString());
                if (i >= size - 1) continue;
                sb.append('|');
            }
        }
        if (this.containsSubfolderIds()) {
            try {
                sb.append(" subfolder IDs=");
                size = this.getSubfolderIds().size();
                iter = this.getSubfolderIds().iterator();
                for (i = 0; i < size; ++i) {
                    sb.append(((Integer)iter.next()).toString());
                    if (i >= size - 1) continue;
                    sb.append('|');
                }
            }
            catch (OXException e) {
                sb.append("");
            }
        }
        return sb.toString();
    }

    public FolderObject clone() {
        try {
            FolderObject clone = (FolderObject)super.clone();
            if (this.b_createdBy) {
                clone.setCreatedBy(this.createdBy);
            }
            if (this.b_creationDate) {
                clone.setCreationDate(this.creationDate);
            }
            if (this.b_defaultFolder) {
                clone.setDefaultFolder(this.defaultFolder);
            }
            if (this.b_objectId) {
                clone.setObjectID(this.objectId);
            }
            if (this.b_folderName) {
                clone.setFolderName(this.folderName);
            }
            if (this.b_fullName) {
                clone.setFullName(this.fullName);
            }
            if (this.b_lastModified) {
                clone.setLastModified(this.lastModified);
            }
            if (this.b_modifiedBy) {
                clone.setModifiedBy(this.modifiedBy);
            }
            if (this.b_module) {
                clone.setModule(this.module);
            }
            if (this.b_parent_folder_id) {
                clone.setParentFolderID(this.parentFolderId);
            }
            if (this.b_permissionFlag) {
                clone.setPermissionFlag(this.permissionFlag);
            }
            if (this.b_subfolderFlag) {
                clone.setSubfolderFlag(this.subfolderFlag);
            }
            if (this.b_subfolderIds) {
                clone.setSubfolderIds(FolderObject.copyIntArrayList(this.subfolderIds));
            }
            if (this.b_permissions) {
                clone.setPermissions(FolderObject.copyArrayList(this.permissions));
            }
            if (this.b_type) {
                clone.setType(this.type);
            }
            return clone;
        }
        catch (CloneNotSupportedException exc) {
            return null;
        }
    }

    @Override
    public void set(int field, Object value) {
        switch (field) {
            case 301: {
                this.setModule((Integer)value);
                break;
            }
            case 300: {
                this.setFolderName((String)value);
                break;
            }
            case 302: {
                this.setType((Integer)value);
                break;
            }
            case 304: {
                this.setSubfolderFlag((Boolean)value);
                break;
            }
            case 306: {
                if (value.getClass().isInstance(new OCLPermission[0])) {
                    this.setPermissionsAsArray((OCLPermission[])value);
                    break;
                }
                this.setPermissions((List)value);
                break;
            }
            default: {
                super.set(field, value);
            }
        }
    }

    @Override
    public Object get(int field) {
        switch (field) {
            case 301: {
                return this.getModule();
            }
            case 300: {
                return this.getFolderName();
            }
            case 302: {
                return this.getType();
            }
            case 304: {
                return this.hasSubfolders();
            }
            case 306: {
                return this.getPermissions();
            }
        }
        return super.get(field);
    }

    @Override
    public boolean contains(int field) {
        switch (field) {
            case 301: {
                return this.containsModule();
            }
            case 300: {
                return this.containsFolderName();
            }
            case 302: {
                return this.containsType();
            }
            case 304: {
                return this.containsSubfolderFlag();
            }
            case 306: {
                return this.containsPermissions();
            }
        }
        return super.contains(field);
    }

    @Override
    public void remove(int field) {
        switch (field) {
            case 301: {
                this.removeModule();
                break;
            }
            case 300: {
                this.removeFolderName();
                break;
            }
            case 302: {
                this.removeType();
                break;
            }
            case 304: {
                this.removeSubfolderIds();
                this.removeSubfolderFlag();
                break;
            }
            case 306: {
                this.removePermissions();
                break;
            }
            default: {
                super.remove(field);
            }
        }
    }

    @Override
    public Set<Integer> findDifferingFields(DataObject dataObject) {
        Set<Integer> differingFields = super.findDifferingFields(dataObject);
        if (!this.getClass().isAssignableFrom(dataObject.getClass())) {
            return differingFields;
        }
        FolderObject other = (FolderObject)dataObject;
        if (!this.containsFolderName() && other.containsFolderName() || this.containsFolderName() && other.containsFolderName() && this.getFolderName() != other.getFolderName() && (this.getFolderName() == null || !this.getFolderName().equals(other.getFolderName()))) {
            differingFields.add(300);
        }
        if (!this.containsModule() && other.containsModule() || this.containsModule() && other.containsModule() && this.getModule() != other.getModule()) {
            differingFields.add(301);
        }
        if (!this.containsType() && other.containsType() || this.containsType() && other.containsType() && this.getType() != other.getType()) {
            differingFields.add(302);
        }
        return differingFields;
    }

    private static final <T extends OXCloneable<T>> ArrayList<T> copyArrayList(ArrayList<T> original) {
        int size = original.size();
        ArrayList copy = new ArrayList(original.size());
        Iterator<T> iter = original.iterator();
        for (int i = 0; i < size; ++i) {
            copy.add(((OXCloneable)iter.next()).deepClone());
        }
        return copy;
    }

    private static final ArrayList<Integer> copyIntArrayList(ArrayList<Integer> original) {
        int size = original.size();
        ArrayList<Integer> copy = new ArrayList<Integer>(original.size());
        for (int i = 0; i < size; ++i) {
            copy.add((int)original.get(i));
        }
        return copy;
    }

    public static FolderObject loadFolderObjectFromDB(int folderId, Context ctx) throws OXException {
        return OXFolderLoader.loadFolderObjectFromDB(folderId, ctx);
    }

    public static FolderObject loadFolderObjectFromDB(int folderId, Context ctx, Connection readCon) throws OXException {
        return OXFolderLoader.loadFolderObjectFromDB(folderId, ctx, readCon);
    }

    public static final FolderObject loadFolderObjectFromDB(int folderId, Context ctx, Connection readConArg, boolean loadPermissions, boolean loadSubfolderList) throws OXException {
        return OXFolderLoader.loadFolderObjectFromDB(folderId, ctx, readConArg, loadPermissions, loadSubfolderList);
    }

    public static final FolderObject loadFolderObjectFromDB(int folderId, Context ctx, Connection readConArg, boolean loadPermissions, boolean loadSubfolderList, String table, String permTable) throws OXException {
        return OXFolderLoader.loadFolderObjectFromDB(folderId, ctx, readConArg, loadPermissions, loadSubfolderList, table, permTable);
    }

    public static final OCLPermission[] getFolderPermissions(int folderId, Context ctx, Connection readConArg) throws SQLException, OXException {
        return OXFolderLoader.getFolderPermissions(folderId, ctx, readConArg);
    }

    public static final OCLPermission[] getFolderPermissions(int folderId, Context ctx, Connection readConArg, String table) throws SQLException, OXException {
        return OXFolderLoader.getFolderPermissions(folderId, ctx, readConArg, table);
    }

    public static final ArrayList<Integer> getSubfolderIds(int folderId, Context ctx, Connection readConArg) throws SQLException, OXException {
        return OXFolderLoader.getSubfolderIds(folderId, ctx, readConArg);
    }

    public static final ArrayList<Integer> getSubfolderIds(int folderId, Context ctx, Connection readConArg, String table) throws SQLException, OXException {
        return OXFolderLoader.getSubfolderIds(folderId, ctx, readConArg, table);
    }

    public static final FolderObject createVirtualFolderObject(int objectID, String name, int module, boolean hasSubfolders, int type) {
        return FolderObject.createVirtualFolderObject(objectID, name, module, hasSubfolders, type, null);
    }

    public static final FolderObject createVirtualFolderObject(int objectID, String name, int module, boolean hasSubfolders, int type, OCLPermission virtualPerm) {
        OCLPermission p = virtualPerm == null ? VIRTUAL_FOLDER_PERMISSION : virtualPerm;
        FolderObject virtualFolder = new FolderObject(objectID);
        virtualFolder.setFolderName(name);
        virtualFolder.setModule(module);
        virtualFolder.setSubfolderFlag(hasSubfolders);
        virtualFolder.setType(type);
        p.setFuid(objectID);
        virtualFolder.setPermissionsAsArray(new OCLPermission[]{p});
        return virtualFolder;
    }

    public static final FolderObject createVirtualFolderObject(String fullName, String name, int module, boolean hasSubfolders, int type) {
        OCLPermission p = VIRTUAL_FOLDER_PERMISSION;
        FolderObject virtualFolder = new FolderObject();
        virtualFolder.setFullName(fullName);
        virtualFolder.setFolderName(name);
        virtualFolder.setModule(module);
        virtualFolder.setSubfolderFlag(hasSubfolders);
        virtualFolder.setType(type);
        virtualFolder.setPermissionsAsArray(new OCLPermission[]{p});
        return virtualFolder;
    }

    public static final FolderObject createVirtualSharedFolderObject(int createdBy, String creatorDisplayName) {
        return FolderObject.createVirtualFolderObject(new StringBuilder(20).append(SHARED_PREFIX).append(createdBy).toString(), creatorDisplayName, 5, true, 5);
    }

    public void setMeta(Map<String, Object> meta) {
        this.setMap(meta);
    }

    public Map<String, Object> getMeta() {
        return this.getMap();
    }

    public boolean containsMeta() {
        return this.containsMap();
    }

    static {
        VIRTUAL_FOLDER_PERMISSION.setEntity(0);
        VIRTUAL_FOLDER_PERMISSION.setFolderAdmin(false);
        VIRTUAL_FOLDER_PERMISSION.setGroupPermission(true);
        VIRTUAL_FOLDER_PERMISSION.setAllPermission(2, 0, 0, 0);
    }
}

