/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.messaging;

import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.java.StringAllocator;
import java.io.Serializable;

public final class MessagingFolderIdentifier
implements Serializable {
    private static final long serialVersionUID = 2518247692416742487L;
    private static final String DELIM = "://";
    private final String serviceId;
    private final int accountId;
    private final String fullname;
    private final int hash;
    private final String fqn;
    private static final int RADIX = 10;

    public static String getFQN(String serviceId, int accountId, String fullname) {
        return new StringAllocator(64).append(serviceId).append(DELIM).append(accountId).append('/').append(fullname).toString();
    }

    public static boolean isFQN(String identifier) {
        if (null == identifier) {
            return false;
        }
        int pos = identifier.indexOf(DELIM);
        if (pos <= 0) {
            return false;
        }
        int prev = pos + DELIM.length();
        if ((pos = identifier.indexOf(47, prev)) <= 0) {
            return MessagingFolderIdentifier.getUnsignedInteger(identifier.substring(prev)) > 0;
        }
        return MessagingFolderIdentifier.getUnsignedInteger(identifier.substring(prev, pos)) > 0;
    }

    public static MessagingFolderIdentifier parseFQN(String identifier) {
        try {
            return new MessagingFolderIdentifier(identifier);
        }
        catch (OXException e) {
            return null;
        }
    }

    public MessagingFolderIdentifier(String identifier) throws OXException {
        if (null == identifier) {
            throw FolderExceptionErrorMessage.MISSING_FOLDER_ID.create();
        }
        int pos = identifier.indexOf(DELIM);
        if (pos <= 0) {
            throw FolderExceptionErrorMessage.INVALID_FOLDER_ID.create(identifier);
        }
        int prev = 0;
        this.serviceId = identifier.substring(prev, pos);
        prev = pos + DELIM.length();
        if ((pos = identifier.indexOf(47, prev)) <= 0) {
            this.accountId = MessagingFolderIdentifier.getUnsignedInteger(identifier.substring(prev));
            if (this.accountId <= 0) {
                throw FolderExceptionErrorMessage.INVALID_FOLDER_ID.create(identifier);
            }
            this.fullname = "";
            this.fqn = new StringAllocator(identifier).append('/').toString();
        } else {
            this.accountId = MessagingFolderIdentifier.getUnsignedInteger(identifier.substring(prev, pos));
            if (this.accountId <= 0) {
                throw FolderExceptionErrorMessage.INVALID_FOLDER_ID.create(identifier);
            }
            this.fullname = identifier.substring(pos + 1);
            this.fqn = identifier;
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + this.accountId;
        result = 31 * result + (this.fullname == null ? 0 : this.fullname.hashCode());
        this.hash = result = 31 * result + (this.serviceId == null ? 0 : this.serviceId.hashCode());
    }

    public MessagingFolderIdentifier(String serviceId, int accountId, String fullname) {
        this.serviceId = serviceId;
        this.accountId = accountId;
        this.fullname = fullname;
        this.fqn = new StringAllocator(64).append(serviceId).append(DELIM).append(accountId).append('/').append(fullname).toString();
        int prime = 31;
        int result = 1;
        result = 31 * result + accountId;
        result = 31 * result + (fullname == null ? 0 : fullname.hashCode());
        this.hash = result = 31 * result + (serviceId == null ? 0 : serviceId.hashCode());
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public int getAccountId() {
        return this.accountId;
    }

    public String getFullname() {
        return this.fullname;
    }

    public String toString() {
        return this.fqn;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MessagingFolderIdentifier)) {
            return false;
        }
        MessagingFolderIdentifier other = (MessagingFolderIdentifier)obj;
        if (this.accountId != other.accountId) {
            return false;
        }
        if (this.fullname == null ? other.fullname != null : !this.fullname.equals(other.fullname)) {
            return false;
        }
        return !(this.serviceId == null ? other.serviceId != null : !this.serviceId.equals(other.serviceId));
    }

    private static final int getUnsignedInteger(String s) {
        int digit;
        if (s == null) {
            return -1;
        }
        int max = s.length();
        if (max <= 0) {
            return -1;
        }
        if (s.charAt(0) == '-') {
            return -1;
        }
        int result = 0;
        int i = 0;
        int limit = -2147483647;
        int multmin = -214748364;
        if (i < max) {
            if ((digit = MessagingFolderIdentifier.digit(s.charAt(i++))) < 0) {
                return -1;
            }
            result = -digit;
        }
        while (i < max) {
            if ((digit = MessagingFolderIdentifier.digit(s.charAt(i++))) < 0) {
                return -1;
            }
            if (result < -214748364) {
                return -1;
            }
            if ((result *= 10) < -2147483647 + digit) {
                return -1;
            }
            result -= digit;
        }
        return -result;
    }

    private static int digit(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
        }
        return -1;
    }
}

