/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.internal.performers;

import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderServiceDecorator;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderStorageDiscoverer;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.SortableId;
import com.openexchange.folderstorage.StorageParameters;
import com.openexchange.folderstorage.StorageParametersUtility;
import com.openexchange.folderstorage.Type;
import com.openexchange.folderstorage.UserizedFolder;
import com.openexchange.folderstorage.database.contentType.CalendarContentType;
import com.openexchange.folderstorage.database.contentType.ContactContentType;
import com.openexchange.folderstorage.database.contentType.InfostoreContentType;
import com.openexchange.folderstorage.database.contentType.TaskContentType;
import com.openexchange.folderstorage.filestorage.contentType.FileStorageContentType;
import com.openexchange.folderstorage.internal.CalculatePermission;
import com.openexchange.folderstorage.internal.UserizedFolderImpl;
import com.openexchange.folderstorage.internal.performers.AbstractPerformer;
import com.openexchange.folderstorage.type.PrivateType;
import com.openexchange.folderstorage.type.SharedType;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.session.ServerSession;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;

public abstract class AbstractUserizedFolderPerformer
extends AbstractPerformer {
    private static final String DUMMY_ID = "dummyId";
    private final FolderServiceDecorator decorator;
    private volatile TimeZone timeZone;
    private volatile Locale locale;
    private volatile List<ContentType> allowedContentTypes;
    protected static final Set<String> PARENTHESIS_CAPABLE = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(CalendarContentType.getInstance().toString(), TaskContentType.getInstance().toString(), ContactContentType.getInstance().toString(), InfostoreContentType.getInstance().toString(), FileStorageContentType.getInstance().toString())));

    public AbstractUserizedFolderPerformer(ServerSession session, FolderServiceDecorator decorator) throws OXException {
        super(session);
        this.decorator = decorator;
        this.storageParameters.setDecorator(decorator);
    }

    public AbstractUserizedFolderPerformer(User user, Context context, FolderServiceDecorator decorator) {
        super(user, context);
        this.decorator = decorator;
        this.storageParameters.setDecorator(decorator);
    }

    public AbstractUserizedFolderPerformer(ServerSession session, FolderServiceDecorator decorator, FolderStorageDiscoverer folderStorageDiscoverer) throws OXException {
        super(session, folderStorageDiscoverer);
        this.decorator = decorator;
        this.storageParameters.setDecorator(decorator);
    }

    public AbstractUserizedFolderPerformer(User user, Context context, FolderServiceDecorator decorator, FolderStorageDiscoverer folderStorageDiscoverer) {
        super(user, context, folderStorageDiscoverer);
        this.decorator = decorator;
        this.storageParameters.setDecorator(decorator);
    }

    protected final FolderServiceDecorator getDecorator() {
        return this.decorator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final TimeZone getTimeZone() {
        TimeZone tmp = this.timeZone;
        if (null == tmp) {
            AbstractUserizedFolderPerformer abstractUserizedFolderPerformer = this;
            synchronized (abstractUserizedFolderPerformer) {
                tmp = this.timeZone;
                if (null == tmp) {
                    TimeZone tz = null == this.decorator ? null : this.decorator.getTimeZone();
                    tmp = tz == null ? TimeZoneUtils.getTimeZone(this.getUser().getTimeZone()) : tz;
                    this.timeZone = tmp;
                }
            }
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Locale getLocale() {
        Locale tmp = this.locale;
        if (null == tmp) {
            AbstractUserizedFolderPerformer abstractUserizedFolderPerformer = this;
            synchronized (abstractUserizedFolderPerformer) {
                tmp = this.locale;
                if (null == tmp) {
                    Locale l = null == this.decorator ? null : this.decorator.getLocale();
                    tmp = l == null ? this.getUser().getLocale() : l;
                    this.locale = tmp;
                }
            }
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final List<ContentType> getAllowedContentTypes() {
        List<ContentType> tmp = this.allowedContentTypes;
        if (null == tmp) {
            AbstractUserizedFolderPerformer abstractUserizedFolderPerformer = this;
            synchronized (abstractUserizedFolderPerformer) {
                tmp = this.allowedContentTypes;
                if (null == tmp) {
                    tmp = null == this.decorator ? ALL_ALLOWED : this.decorator.getAllowedContentTypes();
                    this.allowedContentTypes = tmp;
                }
            }
        }
        return tmp;
    }

    protected final <V> V getDecoratorProperty(String name) {
        if (null == name || null == this.decorator) {
            return null;
        }
        Object val = this.decorator.getProperty(name);
        return (V)(null == val ? null : val);
    }

    protected final String getDecoratorStringProperty(String name) {
        if (null == name || null == this.decorator) {
            return null;
        }
        Object val = this.decorator.getProperty(name);
        return null == val ? null : val.toString();
    }

    protected UserizedFolder getUserizedFolder(Folder folder, Permission ownPermission, String treeId, boolean all, boolean nullIsPublicAccess, StorageParameters storageParameters, Collection<FolderStorage> openedStorages) throws OXException {
        return this.getUserizedFolder(folder, ownPermission, treeId, all, nullIsPublicAccess, storageParameters, openedStorages, false);
    }

    protected UserizedFolder getUserizedFolder(Folder folder, Permission ownPermission, String treeId, boolean all, boolean nullIsPublicAccess, StorageParameters storageParameters, Collection<FolderStorage> openedStorages, boolean checkOnly) throws OXException {
        Date lm;
        Date cd;
        boolean isShared;
        UserizedFolderImpl userizedFolder;
        Folder f = folder;
        int createdBy = f.getCreatedBy();
        Type type = f.getType();
        if (SharedType.getInstance().equals(type)) {
            userizedFolder = new UserizedFolderImpl(f, storageParameters.getSession(), storageParameters.getUser(), storageParameters.getContext());
            userizedFolder.setDefault(false);
            userizedFolder.setDefaultType(0);
            isShared = true;
        } else if (createdBy >= 0 && createdBy != this.getUserId() && PrivateType.getInstance().equals(type)) {
            FolderStorage curStorage = this.folderStorageDiscoverer.getFolderStorage(treeId, f.getID());
            boolean alreadyOpened = false;
            Iterator<FolderStorage> it = openedStorages.iterator();
            for (int j = 0; !alreadyOpened && j < openedStorages.size(); ++j) {
                if (!it.next().equals(curStorage)) continue;
                alreadyOpened = true;
            }
            if (!alreadyOpened && curStorage.startTransaction(storageParameters, false)) {
                openedStorages.add(curStorage);
            }
            f = curStorage.prepareFolder(treeId, f, storageParameters);
            userizedFolder = new UserizedFolderImpl(f, storageParameters.getSession(), storageParameters.getUser(), storageParameters.getContext());
            userizedFolder.setDefault(false);
            userizedFolder.setDefaultType(0);
            userizedFolder.setType(SharedType.getInstance());
            isShared = true;
        } else {
            userizedFolder = new UserizedFolderImpl(f, storageParameters.getSession(), storageParameters.getUser(), storageParameters.getContext());
            isShared = false;
        }
        userizedFolder.setLocale(this.getLocale());
        userizedFolder.setAltNames(StorageParametersUtility.getBoolParameter("altNames", storageParameters));
        userizedFolder.setOwnPermission(ownPermission);
        CalculatePermission.calculateUserPermissions(userizedFolder, this.getContext());
        if (userizedFolder.getID().startsWith("u:")) {
            userizedFolder.setParentID(FolderStorage.SHARED_ID);
        }
        if (null != (cd = f.getCreationDate())) {
            long time = cd.getTime();
            userizedFolder.setCreationDate(new Date(AbstractUserizedFolderPerformer.addTimeZoneOffset(time, this.getTimeZone())));
            userizedFolder.setCreationDateUTC(new Date(time));
        }
        if (null != (lm = f.getLastModified())) {
            long time = lm.getTime();
            userizedFolder.setLastModified(new Date(AbstractUserizedFolderPerformer.addTimeZoneOffset(time, this.getTimeZone())));
            userizedFolder.setLastModifiedUTC(new Date(time));
        }
        if (!checkOnly) {
            if (isShared) {
                String[] visibleSubfolders = f.getSubfolderIDs();
                if (null == visibleSubfolders) {
                    String[] stringArray;
                    if (nullIsPublicAccess) {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = DUMMY_ID;
                    } else {
                        stringArray = new String[]{};
                    }
                    userizedFolder.setSubfolderIDs(stringArray);
                } else {
                    userizedFolder.setSubfolderIDs(visibleSubfolders);
                }
            } else {
                this.hasVisibleSubfolderIDs(f, treeId, all, userizedFolder, nullIsPublicAccess, storageParameters, openedStorages);
            }
        }
        return userizedFolder;
    }

    private void hasVisibleSubfolderIDs(Folder folder, String treeId, boolean all, UserizedFolder userizedFolder, boolean nullIsPublicAccess, StorageParameters storageParameters, Collection<FolderStorage> openedStorages) throws OXException {
        String[] stringArray;
        String[] subfolders = folder.getSubfolderIDs();
        String dummyId = null;
        if (null == subfolders) {
            if (nullIsPublicAccess) {
                dummyId = DUMMY_ID;
            } else {
                String folderId = folder.getID();
                FolderStorage[] ss = this.folderStorageDiscoverer.getFolderStoragesForParent(treeId, folderId);
                for (int i = 0; null == dummyId && i < ss.length; ++i) {
                    SortableId[] visibleIds;
                    FolderStorage curStorage = ss[i];
                    boolean alreadyOpened = false;
                    Iterator<FolderStorage> it = openedStorages.iterator();
                    for (int j = 0; !alreadyOpened && j < openedStorages.size(); ++j) {
                        if (!it.next().equals(curStorage)) continue;
                        alreadyOpened = true;
                    }
                    if (!alreadyOpened && curStorage.startTransaction(storageParameters, false)) {
                        openedStorages.add(curStorage);
                    }
                    if ((visibleIds = curStorage.getSubfolders(treeId, folderId, storageParameters)).length <= 0) continue;
                    for (int j = 0; null == dummyId && j < visibleIds.length; ++j) {
                        Permission p;
                        String id = visibleIds[0].getId();
                        Folder subfolder = curStorage.getFolder(treeId, id, storageParameters);
                        if (!all && !subfolder.isSubscribed() && !subfolder.hasSubscribedSubfolders() || !(p = CalculatePermission.calculate(subfolder, this.session, this.getAllowedContentTypes())).isVisible()) continue;
                        dummyId = id;
                    }
                }
            }
        } else {
            int length = subfolders.length;
            if (length > 0) {
                if (folder.isGlobalID()) {
                    for (int i = 0; null == dummyId && i < length; ++i) {
                        String id = subfolders[i];
                        FolderStorage tmp = this.getOpenedStorage(id, treeId, storageParameters, openedStorages);
                        Folder subfolder = tmp.getFolder(treeId, id, storageParameters);
                        if (!all && !subfolder.isSubscribed() && !subfolder.hasSubscribedSubfolders() || !CalculatePermission.isVisible(subfolder, this.getUser(), this.getContext(), this.getAllowedContentTypes())) continue;
                        dummyId = id;
                    }
                } else if (all || folder.hasSubscribedSubfolders()) {
                    dummyId = DUMMY_ID;
                }
            }
        }
        if (null == dummyId) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = dummyId;
        }
        userizedFolder.setSubfolderIDs(stringArray);
    }

    private static long addTimeZoneOffset(long date, TimeZone timeZone) {
        return date + (long)timeZone.getOffset(date);
    }
}

