/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.filemanagement.json.actions;

import com.openexchange.ajax.container.FileHolder;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.DispatcherNotes;
import com.openexchange.ajax.requesthandler.ETagAwareAJAXActionService;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.filemanagement.ManagedFile;
import com.openexchange.filemanagement.ManagedFileExceptionErrorMessage;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.groupware.upload.impl.UploadException;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.server.ServiceLookup;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.session.ServerSession;
import java.io.File;

@Action(method=RequestMethod.GET, name="get", description="Requesting a formerly uploaded file", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="id", description="The ID of the uploaded file.")}, responseDescription="The content of the requested file is directly written into output stream.")
@DispatcherNotes(defaultFormat="file", allowPublicSession=true)
public final class GetAction
implements ETagAwareAJAXActionService {
    private final ServiceLookup services;

    public GetAction(ServiceLookup services) {
        this.services = services;
    }

    @Override
    public boolean checkETag(String clientETag, AJAXRequestData request, ServerSession session) throws OXException {
        if (clientETag == null || clientETag.length() == 0) {
            return false;
        }
        try {
            ManagedFileManagement management = ServerServiceRegistry.getInstance().getService(ManagedFileManagement.class);
            management.getByID(clientETag);
            request.setExpires(300000L);
            return true;
        }
        catch (OXException e) {
            if (ManagedFileExceptionErrorMessage.NOT_FOUND.equals(e)) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public void setETag(String eTag, long expires, AJAXRequestResult result) throws OXException {
        result.setExpires(expires);
        result.setHeader("ETag", eTag);
    }

    @Override
    public AJAXRequestResult perform(AJAXRequestData requestData, ServerSession session) throws OXException {
        try {
            String id = requestData.getParameter("id");
            if (id == null || id.length() == 0) {
                throw UploadException.UploadCode.MISSING_PARAM.create("id").setAction("get");
            }
            ManagedFileManagement management = ServerServiceRegistry.getInstance().getService(ManagedFileManagement.class);
            ManagedFile file = management.getByID(id);
            String fileName = file.getFileName();
            String disposition = file.getContentDisposition();
            ContentType contentType = new ContentType(file.getContentType());
            if (null != fileName) {
                if (contentType.startsWith("application/octet-stream")) {
                    String ct = MimeType2ExtMap.getContentType(fileName);
                    int pos = ct.indexOf(47);
                    contentType.setPrimaryType(ct.substring(0, pos));
                    contentType.setSubType(ct.substring(pos + 1));
                }
                contentType.setParameter("name", fileName);
            }
            File tmpFile = file.getFile();
            FileHolder fileHolder = new FileHolder(FileHolder.newClosureFor(tmpFile), tmpFile.length(), null, null);
            if (fileName != null) {
                fileHolder.setName(fileName);
            }
            fileHolder.setContentType(contentType.toString());
            fileHolder.setDisposition(disposition);
            AJAXRequestResult result = new AJAXRequestResult((Object)fileHolder, "file");
            this.setETag(id, 300000L, result);
            return result;
        }
        catch (RuntimeException e) {
            throw ManagedFileExceptionErrorMessage.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }
}

