/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.event.impl.osgi;

import com.openexchange.event.CommonEvent;
import com.openexchange.event.impl.AppointmentEventInterface;
import com.openexchange.event.impl.AppointmentEventInterface2;
import com.openexchange.event.impl.EventDispatcher;
import com.openexchange.event.impl.TaskEventInterface;
import com.openexchange.event.impl.TaskEventInterface2;
import com.openexchange.event.impl.osgi.EventHandlerRegistration;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.session.Session;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSGiEventDispatcher
implements EventHandlerRegistration,
EventDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(OSGiEventDispatcher.class);
    private final Queue<AppointmentEventInterface> appointmentListeners = new ConcurrentLinkedQueue<AppointmentEventInterface>();
    private final Queue<TaskEventInterface> taskListeners = new ConcurrentLinkedQueue<TaskEventInterface>();
    private volatile ServiceRegistration<EventHandler> serviceRegistration;

    @Override
    public void addListener(AppointmentEventInterface listener) {
        this.appointmentListeners.add(listener);
    }

    public void created(Appointment appointment, Session session) {
        for (AppointmentEventInterface listener : this.appointmentListeners) {
            listener.appointmentCreated(appointment, session);
        }
    }

    public void modified(Appointment oldAppointment, Appointment newAppointment, Session session) {
        for (AppointmentEventInterface listener : this.appointmentListeners) {
            if (oldAppointment != null && AppointmentEventInterface2.class.isAssignableFrom(listener.getClass())) {
                ((AppointmentEventInterface2)listener).appointmentModified(oldAppointment, newAppointment, session);
                continue;
            }
            listener.appointmentModified(newAppointment, session);
        }
    }

    public void accepted(Appointment appointment, Session session) {
        for (AppointmentEventInterface listener : this.appointmentListeners) {
            listener.appointmentAccepted(appointment, session);
        }
    }

    public void declined(Appointment appointment, Session session) {
        for (AppointmentEventInterface listener : this.appointmentListeners) {
            listener.appointmentDeclined(appointment, session);
        }
    }

    public void tentativelyAccepted(Appointment appointment, Session session) {
        for (AppointmentEventInterface listener : this.appointmentListeners) {
            listener.appointmentTentativelyAccepted(appointment, session);
        }
    }

    public void waiting(Appointment appointment, Session session) {
        for (AppointmentEventInterface listener : this.appointmentListeners) {
            listener.appointmentWaiting(appointment, session);
        }
    }

    public void deleted(Appointment appointment, Session session) {
        for (AppointmentEventInterface listener : this.appointmentListeners) {
            listener.appointmentDeleted(appointment, session);
        }
    }

    @Override
    public void addListener(TaskEventInterface listener) {
        this.taskListeners.add(listener);
    }

    public void created(Task task, Session session) {
        for (TaskEventInterface listener : this.taskListeners) {
            listener.taskCreated(task, session);
        }
    }

    public void modified(Task oldTask, Task newTask, Session session) {
        for (TaskEventInterface listener : this.taskListeners) {
            if (oldTask != null && TaskEventInterface2.class.isAssignableFrom(listener.getClass())) {
                ((TaskEventInterface2)listener).taskModified(oldTask, newTask, session);
                continue;
            }
            listener.taskModified(newTask, session);
        }
    }

    public void accepted(Task oldTask, Task task, Session session) {
        for (TaskEventInterface listener : this.taskListeners) {
            if (!TaskEventInterface2.class.isAssignableFrom(listener.getClass())) continue;
            ((TaskEventInterface2)listener).taskAccepted(oldTask, task, session);
        }
    }

    public void declined(Task oldTask, Task task, Session session) {
        for (TaskEventInterface listener : this.taskListeners) {
            if (!TaskEventInterface2.class.isAssignableFrom(listener.getClass())) continue;
            ((TaskEventInterface2)listener).taskDeclined(oldTask, task, session);
        }
    }

    public void tentativelyAccepted(Task oldTask, Task task, Session session) {
        for (TaskEventInterface listener : this.taskListeners) {
            if (!TaskEventInterface2.class.isAssignableFrom(listener.getClass())) continue;
            ((TaskEventInterface2)listener).taskTentativelyAccepted(oldTask, task, session);
        }
    }

    public void deleted(Task task, Session session) {
        for (TaskEventInterface listener : this.taskListeners) {
            listener.taskDeleted(task, session);
        }
    }

    public void handleEvent(Event event) {
        try {
            CommonEvent commonEvent = (CommonEvent)event.getProperty("OX_EVENT");
            if (commonEvent != null) {
                Object actionObj = commonEvent.getActionObj();
                Object oldObj = commonEvent.getOldObj();
                Session session = commonEvent.getSession();
                int module = commonEvent.getModule();
                int action = commonEvent.getAction();
                if (1 == module) {
                    if (1 == action) {
                        this.created((Appointment)actionObj, session);
                    } else if (2 == action || 4 == action) {
                        this.modified((Appointment)oldObj, (Appointment)actionObj, session);
                    } else if (3 == action) {
                        this.deleted((Appointment)actionObj, session);
                    } else if (5 == action) {
                        this.accepted((Appointment)actionObj, session);
                    } else if (6 == action) {
                        this.declined((Appointment)actionObj, session);
                    } else if (7 == action) {
                        this.tentativelyAccepted((Appointment)actionObj, session);
                    } else if (8 == action) {
                        this.waiting((Appointment)actionObj, session);
                    }
                } else if (4 == module) {
                    if (1 == action) {
                        this.created((Task)actionObj, session);
                    } else if (2 == action || 4 == action) {
                        this.modified((Task)oldObj, (Task)actionObj, session);
                    } else if (3 == action) {
                        this.deleted((Task)actionObj, session);
                    } else if (5 == action) {
                        this.accepted((Task)oldObj, (Task)actionObj, session);
                    } else if (6 == action) {
                        this.declined((Task)oldObj, (Task)actionObj, session);
                    } else if (7 == action) {
                        this.tentativelyAccepted((Task)oldObj, (Task)actionObj, session);
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
        }
    }

    @Override
    public void registerService(BundleContext context) {
        Hashtable<String, String[]> serviceProperties = new Hashtable<String, String[]>(1);
        ((Dictionary)serviceProperties).put("event.topics", new String[]{"com/openexchange/groupware/*"});
        this.serviceRegistration = context.registerService(EventHandler.class, (Object)this, serviceProperties);
    }

    @Override
    public void unregisterService() {
        ServiceRegistration<EventHandler> serviceRegistration = this.serviceRegistration;
        if (null != serviceRegistration) {
            serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
    }
}

