/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.writer;

import com.openexchange.ajax.AJAXServlet;
import com.openexchange.ajax.Folder;
import com.openexchange.ajax.customizer.folder.AdditionalFolderField;
import com.openexchange.ajax.customizer.folder.AdditionalFolderFieldList;
import com.openexchange.ajax.writer.FolderWriter;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.messaging.MessagingFolderIdentifier;
import com.openexchange.folderstorage.messaging.MessagingFolderImpl;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.java.StringAllocator;
import com.openexchange.messaging.DefaultMessagingPermission;
import com.openexchange.messaging.MessagingExceptionCodes;
import com.openexchange.messaging.MessagingFolder;
import com.openexchange.messaging.MessagingPermission;
import com.openexchange.tools.session.ServerSession;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessagingFolderWriter {
    private static final Logger LOG = LoggerFactory.getLogger(MessagingFolderWriter.class);
    private static final TIntObjectMap<MessagingFolderFieldWriter> WRITERS_MAP = new TIntObjectHashMap(20);
    private static final int[] ALL_FLD_FIELDS;
    private static final int BIT_USER_FLAG = 0x20000000;
    private static final int[] mapping;

    private MessagingFolderWriter() {
    }

    public static JSONObject writeMessagingFolder(String serviceId, int accountId, MessagingFolder folder, ServerSession session) throws OXException {
        MessagingFolderFieldWriter[] writers;
        JSONObject jsonObject = new JSONObject();
        JSONObjectPutter putter = new JSONObjectPutter(jsonObject);
        for (MessagingFolderFieldWriter writer : writers = MessagingFolderWriter.getMessagingFolderFieldWriter(ALL_FLD_FIELDS, session)) {
            writer.writeField(putter, serviceId, accountId, folder);
        }
        return jsonObject;
    }

    public static MessagingFolderFieldWriter[] getMessagingFolderFieldWriter(int[] fields, ServerSession session) {
        return MessagingFolderWriter.getMessagingFolderFieldWriter(fields, session, Folder.getAdditionalFields());
    }

    public static MessagingFolderFieldWriter[] getMessagingFolderFieldWriter(int[] fields, final ServerSession session, AdditionalFolderFieldList additionalFields) {
        MessagingFolderFieldWriter[] retval = new MessagingFolderFieldWriter[fields.length];
        for (int i = 0; i < retval.length; ++i) {
            int curField = fields[i];
            MessagingFolderFieldWriter mffw = (MessagingFolderFieldWriter)WRITERS_MAP.get(curField);
            if (mffw == null) {
                if (!additionalFields.knows(curField)) {
                    LOG.warn("Unknown folder field: {}", (Object)curField);
                }
                final AdditionalFolderField folderField = additionalFields.get(curField);
                retval[i] = new MessagingFolderFieldWriter(){

                    @Override
                    public void writeField(JSONValuePutter jsonContainer, String serviceId, int accountId, MessagingFolder folder, String name, int hasSubfolders, String id, int module, boolean all) throws OXException {
                        try {
                            FolderObject fo = new FolderObject();
                            fo.setFullName(folder.getId());
                            fo.setFolderName(folder.getName());
                            fo.setModule(13);
                            fo.setType(13);
                            fo.setCreatedBy(-1);
                            jsonContainer.put(folderField.getColumnName(), folderField.renderJSON(folderField.getValue(fo, session)));
                        }
                        catch (JSONException e) {
                            throw MessagingExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                        }
                    }
                };
                continue;
            }
            retval[i] = mffw;
        }
        return retval;
    }

    static int createPermissionBits(MessagingPermission perm) throws OXException {
        return MessagingFolderWriter.createPermissionBits(perm.getFolderPermission(), perm.getReadPermission(), perm.getWritePermission(), perm.getDeletePermission(), perm.isAdmin());
    }

    static int createPermissionBits(int fp, int orp, int owp, int odp, boolean adminFlag) throws OXException {
        int[] perms = new int[]{fp == 64 ? 128 : fp, orp == 64 ? 128 : orp, owp == 64 ? 128 : owp, odp == 64 ? 128 : odp, adminFlag ? 1 : 0};
        return MessagingFolderWriter.createPermissionBits(perms);
    }

    private static int createPermissionBits(int[] permission) throws OXException {
        int retval = 0;
        boolean first = true;
        for (int i = permission.length - 1; i >= 0; --i) {
            int shiftVal = i * 7;
            if (first) {
                retval += permission[i] << shiftVal;
                first = false;
                continue;
            }
            if (permission[i] == 128) {
                retval += 64 << shiftVal;
                continue;
            }
            try {
                retval += mapping[permission[i]] << shiftVal;
                continue;
            }
            catch (Exception e) {
                throw MessagingExceptionCodes.UNEXPECTED_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
        }
        return retval;
    }

    static {
        WRITERS_MAP.put(1, (Object)new MessagingFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonContainer, String serviceId, int accountId, MessagingFolder folder, String name, int hasSubfolders, String id, int module, boolean all) throws OXException {
                try {
                    jsonContainer.put("id", null == id ? MessagingFolderIdentifier.getFQN(serviceId, accountId, folder.getId()) : id);
                }
                catch (JSONException e) {
                    throw MessagingExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
            }
        });
        WRITERS_MAP.put(2, (Object)new MessagingFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonContainer, String serviceId, int accountId, MessagingFolder folder, String name, int hasSubfolders, String id, int module, boolean all) throws OXException {
                try {
                    jsonContainer.put("created_by", -1);
                }
                catch (JSONException e) {
                    throw MessagingExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
            }
        });
        WRITERS_MAP.put(3, (Object)new MessagingFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonContainer, String serviceId, int accountId, MessagingFolder folder, String name, int hasSubfolders, String id, int module, boolean all) throws OXException {
                try {
                    jsonContainer.put("modified_by", -1);
                }
                catch (JSONException e) {
                    throw MessagingExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
            }
        });
        WRITERS_MAP.put(4, (Object)new MessagingFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonContainer, String serviceId, int accountId, MessagingFolder folder, String name, int hasSubfolders, String id, int module, boolean all) throws OXException {
                try {
                    jsonContainer.put("creation_date", 0);
                }
                catch (JSONException e) {
                    throw MessagingExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
            }
        });
        WRITERS_MAP.put(5, (Object)new MessagingFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonContainer, String serviceId, int accountId, MessagingFolder folder, String name, int hasSubfolders, String id, int module, boolean all) throws OXException {
                try {
                    jsonContainer.put("last_modified", 0);
                }
                catch (JSONException e) {
                    throw MessagingExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
            }
        });
        WRITERS_MAP.put(20, (Object)new MessagingFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonContainer, String serviceId, int accountId, MessagingFolder folder, String name, int hasSubfolders, String id, int module, boolean all) throws OXException {
                try {
                    Object parent = null == folder.getParentId() ? Integer.valueOf(1) : MessagingFolderIdentifier.getFQN(serviceId, accountId, folder.getParentId());
                    jsonContainer.put("folder_id", parent);
                }
                catch (JSONException e) {
                    throw MessagingExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
            }
        });
        WRITERS_MAP.put(300, (Object)new MessagingFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonContainer, String serviceId, int accountId, MessagingFolder folder, String name, int hasSubfolders, String id, int module, boolean all) throws OXException {
                try {
                    jsonContainer.put("title", name == null ? folder.getName() : name);
                }
                catch (JSONException e) {
                    throw MessagingExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
            }
        });
        WRITERS_MAP.put(301, (Object)new MessagingFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonContainer, String serviceId, int accountId, MessagingFolder folder, String name, int hasSubfolders, String id, int module, boolean all) throws OXException {
                try {
                    jsonContainer.put("module", AJAXServlet.getModuleString(module == -1 ? 13 : module, -1));
                }
                catch (JSONException e) {
                    throw MessagingExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
            }
        });
        WRITERS_MAP.put(302, (Object)new MessagingFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonContainer, String serviceId, int accountId, MessagingFolder folder, String name, int hasSubfolders, String id, int module, boolean all) throws OXException {
                try {
                    jsonContainer.put("type", 13);
                }
                catch (JSONException e) {
                    throw MessagingExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
            }
        });
        WRITERS_MAP.put(304, (Object)new MessagingFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonContainer, String serviceId, int accountId, MessagingFolder folder, String name, int hasSubfolders, String id, int module, boolean all) throws OXException {
                try {
                    boolean boolVal = hasSubfolders == -1 ? (all ? folder.hasSubfolders() : folder.hasSubscribedSubfolders()) : hasSubfolders > 0;
                    jsonContainer.put("subfolders", boolVal);
                }
                catch (JSONException e) {
                    throw MessagingExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
            }
        });
        WRITERS_MAP.put(305, (Object)new MessagingFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonContainer, String serviceId, int accountId, MessagingFolder folder, String name, int hasSubfolders, String id, int module, boolean all) throws OXException {
                try {
                    MessagingPermission mp;
                    if (folder.isRootFolder()) {
                        MessagingPermission rootPermission = folder.getOwnPermission();
                        if (rootPermission == null) {
                            mp = DefaultMessagingPermission.newInstance();
                            mp.setAllPermissions(8, 0, 0, 0);
                            mp.setAdmin(false);
                        } else {
                            mp = rootPermission;
                        }
                    } else {
                        mp = folder.getOwnPermission();
                    }
                    if (!folder.isHoldsFolders() && mp.getFolderPermission() >= 8) {
                        mp.setFolderPermission(4);
                    }
                    if (!folder.isHoldsMessages() && mp.getReadPermission() >= 2) {
                        mp.setReadPermission(0);
                    }
                    int permissionBits = MessagingFolderWriter.createPermissionBits(mp);
                    if (folder.getCapabilities().contains("USER_FLAGS")) {
                        permissionBits |= 0x20000000;
                    }
                    jsonContainer.put("own_rights", permissionBits);
                }
                catch (JSONException e) {
                    throw MessagingExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
            }
        });
        WRITERS_MAP.put(306, (Object)new MessagingFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonContainer, String serviceId, int accountId, MessagingFolder folder, String name, int hasSubfolders, String id, int module, boolean all) throws OXException {
                try {
                    JSONArray ja = new JSONArray();
                    List perms = folder.getPermissions();
                    for (MessagingPermission perm : perms) {
                        JSONObject jo = new JSONObject();
                        jo.put("bits", MessagingFolderWriter.createPermissionBits(perm));
                        jo.put("entity", perm.getEntity());
                        jo.put("group", perm.isGroup());
                        ja.put((Object)jo);
                    }
                    jsonContainer.put("permissions", ja);
                }
                catch (JSONException e) {
                    throw MessagingExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
            }
        });
        WRITERS_MAP.put(307, (Object)new MessagingFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonContainer, String serviceId, int accountId, MessagingFolder folder, String name, int hasSubfolders, String id, int module, boolean all) throws OXException {
                try {
                    String value = folder.isRootFolder() ? "" : new StringAllocator(16).append('(').append(folder.getMessageCount()).append('/').append(folder.getUnreadMessageCount()).append(')').toString();
                    jsonContainer.put("summary", value);
                }
                catch (JSONException e) {
                    throw MessagingExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
            }
        });
        WRITERS_MAP.put(308, (Object)new MessagingFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonContainer, String serviceId, int accountId, MessagingFolder folder, String name, int hasSubfolders, String id, int module, boolean all) throws OXException {
                try {
                    jsonContainer.put("standard_folder", folder.containsDefaultFolderType() ? folder.isDefaultFolder() : false);
                }
                catch (JSONException e) {
                    throw MessagingExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
            }
        });
        WRITERS_MAP.put(309, (Object)new MessagingFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonContainer, String serviceId, int accountId, MessagingFolder folder, String name, int hasSubfolders, String id, int module, boolean all) throws OXException {
                try {
                    jsonContainer.put("total", folder.getMessageCount());
                }
                catch (JSONException e) {
                    throw MessagingExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
            }
        });
        WRITERS_MAP.put(310, (Object)new MessagingFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonContainer, String serviceId, int accountId, MessagingFolder folder, String name, int hasSubfolders, String id, int module, boolean all) throws OXException {
                try {
                    jsonContainer.put("new", folder.getNewMessageCount());
                }
                catch (JSONException e) {
                    throw MessagingExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
            }
        });
        WRITERS_MAP.put(311, (Object)new MessagingFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonContainer, String serviceId, int accountId, MessagingFolder folder, String name, int hasSubfolders, String id, int module, boolean all) throws OXException {
                try {
                    jsonContainer.put("unread", folder.getUnreadMessageCount());
                }
                catch (JSONException e) {
                    throw MessagingExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
            }
        });
        WRITERS_MAP.put(312, (Object)new MessagingFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonContainer, String serviceId, int accountId, MessagingFolder folder, String name, int hasSubfolders, String id, int module, boolean all) throws OXException {
                try {
                    jsonContainer.put("deleted", folder.getDeletedMessageCount());
                }
                catch (JSONException e) {
                    throw MessagingExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
            }
        });
        WRITERS_MAP.put(314, (Object)new MessagingFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonContainer, String serviceId, int accountId, MessagingFolder folder, String name, int hasSubfolders, String id, int module, boolean all) throws OXException {
                try {
                    Boolean boolVal = folder.getCapabilities().contains("SUBSCRIPTION") ? Boolean.valueOf(folder.isSubscribed()) : Boolean.TRUE;
                    jsonContainer.put("subscribed", boolVal);
                }
                catch (JSONException e) {
                    throw MessagingExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
            }
        });
        WRITERS_MAP.put(315, (Object)new MessagingFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonContainer, String serviceId, int accountId, MessagingFolder folder, String name, int hasSubfolders, String id, int module, boolean all) throws OXException {
                try {
                    Boolean boolVal = !folder.getCapabilities().contains("SUBSCRIPTION") ? (hasSubfolders == -1 ? Boolean.valueOf(folder.hasSubfolders()) : Boolean.valueOf(hasSubfolders > 0)) : (hasSubfolders == -1 ? (folder.hasSubfolders() ? Boolean.valueOf(folder.hasSubscribedSubfolders()) : Boolean.FALSE) : Boolean.valueOf(hasSubfolders > 0));
                    jsonContainer.put("subscr_subflds", boolVal);
                }
                catch (JSONException e) {
                    throw MessagingExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
            }
        });
        WRITERS_MAP.put(313, (Object)new MessagingFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter jsonContainer, String serviceId, int accountId, MessagingFolder folder, String name, int hasSubfolders, String id, int module, boolean all) throws OXException {
                try {
                    Integer caps = MessagingFolderImpl.parseCaps(folder.getCapabilities());
                    jsonContainer.put("capabilities", caps);
                }
                catch (JSONException e) {
                    throw MessagingExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
            }
        });
        ALL_FLD_FIELDS = FolderWriter.getAllFolderFields();
        mapping = new int[]{0, -1, 1, -1, 2, -1, -1, -1, 4};
    }

    public static abstract class MessagingFolderFieldWriter {
        public void writeField(JSONValuePutter jsonContainer, String serviceId, int accountId, MessagingFolder folder) throws OXException {
            this.writeField(jsonContainer, serviceId, accountId, folder, null, -1);
        }

        public void writeField(JSONValuePutter jsonContainer, String serviceId, int accountId, MessagingFolder folder, String name, int hasSubfolders) throws OXException {
            this.writeField(jsonContainer, serviceId, accountId, folder, name, hasSubfolders, null, -1, false);
        }

        public abstract void writeField(JSONValuePutter var1, String var2, int var3, MessagingFolder var4, String var5, int var6, String var7, int var8, boolean var9) throws OXException;
    }

    public static final class JSONObjectPutter
    implements JSONValuePutter {
        private JSONObject jsonObject;

        public JSONObjectPutter() {
        }

        public JSONObjectPutter(JSONObject jsonObject) {
            this();
            this.jsonObject = jsonObject;
        }

        public JSONObjectPutter setJSONObject(JSONObject jsonObject) {
            this.jsonObject = jsonObject;
            return this;
        }

        @Override
        public void put(String key, Object value) throws JSONException {
            if (null == value || JSONObject.NULL.equals(value) || null == key) {
                return;
            }
            this.jsonObject.put(key, value);
        }
    }

    public static final class JSONArrayPutter
    implements JSONValuePutter {
        private JSONArray jsonArray;

        public JSONArrayPutter() {
        }

        public JSONArrayPutter(JSONArray jsonArray) {
            this();
            this.jsonArray = jsonArray;
        }

        public JSONArrayPutter setJSONArray(JSONArray jsonArray) {
            this.jsonArray = jsonArray;
            return this;
        }

        @Override
        public void put(String key, Object value) throws JSONException {
            this.jsonArray.put(value);
        }
    }

    public static interface JSONValuePutter {
        public void put(String var1, Object var2) throws JSONException;
    }
}

