/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters.preview.cache;

import com.openexchange.ajax.requesthandler.cache.AbstractResourceCache;
import com.openexchange.ajax.requesthandler.cache.CachedResource;
import com.openexchange.ajax.requesthandler.cache.ResourceCacheMetadata;
import com.openexchange.ajax.requesthandler.cache.ResourceCacheMetadataStore;
import com.openexchange.database.DatabaseService;
import com.openexchange.database.Databases;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.filestore.FilestoreStorage;
import com.openexchange.java.Streams;
import com.openexchange.preview.PreviewExceptionCodes;
import com.openexchange.tools.file.FileStorage;
import com.openexchange.tools.file.QuotaFileStorage;
import com.openexchange.tools.file.external.FileStorageCodes;
import gnu.trove.ConcurrentTIntObjectHashMap;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileStoreResourceCacheImpl
extends AbstractResourceCache {
    private static final Logger LOG = LoggerFactory.getLogger(FileStoreResourceCacheImpl.class);
    private static final ConcurrentTIntObjectHashMap<FileStorage> FILE_STORE_CACHE = new ConcurrentTIntObjectHashMap();
    private final boolean quotaAware;

    private static FileStorage getFileStorage(Context ctx, boolean quotaAware) throws OXException {
        int key = ctx.getContextId();
        FileStorage fs = (FileStorage)FILE_STORE_CACHE.get(key);
        if (null == fs) {
            URI uri = FilestoreStorage.createURI(ctx);
            FileStorage newFileStorage = quotaAware ? QuotaFileStorage.getInstance(uri, ctx) : FileStorage.getInstance(uri);
            fs = (FileStorage)FILE_STORE_CACHE.putIfAbsent(key, (Object)newFileStorage);
            if (null == fs) {
                fs = newFileStorage;
            }
        }
        return fs;
    }

    private static FileStorage getFileStorage(int contextId, boolean quotaAware) throws OXException {
        return FileStoreResourceCacheImpl.getFileStorage(ContextStorage.getStorageContext(contextId), quotaAware);
    }

    public FileStoreResourceCacheImpl(boolean quotaAware) {
        this.quotaAware = quotaAware;
    }

    private void batchDeleteFiles(Collection<String> ids, FileStorage fileStorage) {
        try {
            fileStorage.deleteFiles(ids.toArray(new String[0]));
        }
        catch (Exception e) {
            for (String id : ids) {
                if (null == id) continue;
                try {
                    fileStorage.deleteFile(id);
                }
                catch (Exception x) {}
            }
        }
    }

    @Override
    public boolean save(String id, CachedResource resource, int userId, int contextId) throws OXException {
        InputStream in = resource.getInputStream();
        if (null == in) {
            return this.save(id, resource.getBytes(), resource.getFileName(), resource.getFileType(), userId, contextId);
        }
        return this.save(id, in, resource.getFileName(), resource.getFileType(), userId, contextId);
    }

    private boolean save(String id, InputStream in, String optName, String optType, int userId, int contextId) throws OXException {
        try {
            return this.save(id, Streams.stream2bytes((InputStream)in), optName, optType, userId, contextId);
        }
        catch (IOException e) {
            throw PreviewExceptionCodes.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    private boolean save(String id, byte[] bytes, String optName, String optType, int userId, int contextId) throws OXException {
        long existingSize;
        ResourceCacheMetadataStore metadataStore = this.getMetadataStore();
        FileStorage fileStorage = FileStoreResourceCacheImpl.getFileStorage(contextId, this.quotaAware);
        DatabaseService dbService = this.getDBService();
        Connection con = dbService.getWritable(contextId);
        ResourceCacheMetadata existingMetadata = FileStoreResourceCacheImpl.loadExistingEntry(metadataStore, con, contextId, userId, id);
        long l = existingSize = existingMetadata == null ? 0L : existingMetadata.getSize();
        if (!this.ensureUnexceededContextQuota(con, bytes.length, contextId, existingSize)) {
            dbService.backWritable(contextId, con);
            return false;
        }
        String refId = null;
        boolean committed = false;
        try {
            Databases.startTransaction((Connection)con);
            refId = fileStorage.saveNewFile(Streams.newByteArrayInputStream((byte[])bytes));
            ResourceCacheMetadata metadata = new ResourceCacheMetadata();
            metadata.setContextId(contextId);
            metadata.setUserId(userId);
            metadata.setResourceId(id);
            metadata.setFileName(optName);
            metadata.setFileType(optType);
            metadata.setSize(bytes.length);
            metadata.setCreatedAt(System.currentTimeMillis());
            metadata.setRefId(refId);
            if (existingMetadata == null) {
                metadataStore.store(con, metadata);
            } else {
                metadataStore.update(con, metadata);
            }
            con.commit();
            committed = true;
            boolean bl = true;
            return bl;
        }
        catch (DataTruncation e) {
            throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (SQLException e) {
            throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        finally {
            if (committed) {
                Databases.autocommit((Connection)con);
                dbService.backWritable(contextId, con);
                if (existingMetadata != null) {
                    try {
                        if (!fileStorage.deleteFile(existingMetadata.getRefId())) {
                            LOG.warn("Could not remove stored file '{}' after updating cached resource. Consider using 'checkconsistency' to clean up the filestore.", (Object)existingMetadata.getRefId());
                        }
                    }
                    catch (OXException e) {
                        LOG.warn("Could not remove stored file '{}' after updating cached resource. Consider using 'checkconsistency' to clean up the filestore.", (Object)existingMetadata.getRefId(), (Object)e);
                    }
                }
            } else {
                if (con != null) {
                    try {
                        con.rollback();
                    }
                    catch (SQLException e) {
                        LOG.warn("Could not rollback database transaction after failing to cache a resource. Consider using 'checkconsistency' to clean up the database.");
                    }
                    Databases.autocommit((Connection)con);
                    dbService.backWritableAfterReading(contextId, con);
                }
                try {
                    if (refId != null && !fileStorage.deleteFile(refId)) {
                        LOG.warn("Could not remove stored file '{}' during transaction rollback. Consider using 'checkconsistency' to clean up the filestore.", (Object)refId);
                    }
                }
                catch (OXException e) {
                    LOG.warn("Could not remove stored file '{}' during transaction rollback. Consider using 'checkconsistency' to clean up the filestore.", (Object)refId, (Object)e);
                }
            }
        }
    }

    @Override
    public void remove(int userId, int contextId) throws OXException {
        ResourceCacheMetadataStore metadataStore = this.getMetadataStore();
        FileStorage fileStorage = FileStoreResourceCacheImpl.getFileStorage(contextId, this.quotaAware);
        List<ResourceCacheMetadata> removed = metadataStore.removeAll(contextId, userId);
        ArrayList<String> refIds = new ArrayList<String>();
        for (ResourceCacheMetadata metadata : removed) {
            if (metadata.getRefId() == null) continue;
            refIds.add(metadata.getRefId());
        }
        this.batchDeleteFiles(refIds, fileStorage);
    }

    @Override
    public void removeAlikes(String id, int userId, int contextId) throws OXException {
        if (null == id) {
            throw PreviewExceptionCodes.ERROR.create(new Object[]{"Missing identifier."});
        }
        ResourceCacheMetadataStore metadataStore = this.getMetadataStore();
        FileStorage fileStorage = FileStoreResourceCacheImpl.getFileStorage(contextId, this.quotaAware);
        List<ResourceCacheMetadata> removed = metadataStore.removeAll(contextId, userId, id);
        ArrayList<String> refIds = new ArrayList<String>();
        for (ResourceCacheMetadata metadata : removed) {
            if (metadata.getRefId() == null) continue;
            refIds.add(metadata.getRefId());
        }
        this.batchDeleteFiles(refIds, fileStorage);
    }

    @Override
    public void clearFor(int contextId) throws OXException {
        this.remove(-1, contextId);
    }

    @Override
    public CachedResource get(String id, int userId, int contextId) throws OXException {
        if (null == id || contextId <= 0) {
            return null;
        }
        ResourceCacheMetadataStore metadataStore = this.getMetadataStore();
        FileStorage fileStorage = FileStoreResourceCacheImpl.getFileStorage(contextId, this.quotaAware);
        ResourceCacheMetadata metadata = metadataStore.load(contextId, userId, id);
        if (metadata == null) {
            return null;
        }
        if (metadata.getRefId() == null) {
            metadataStore.remove(contextId, userId, id);
            return null;
        }
        InputStream file = fileStorage.getFile(metadata.getRefId());
        return new CachedResource(file, metadata.getFileName(), metadata.getFileType(), metadata.getSize());
    }

    @Override
    public boolean exists(String id, int userId, int contextId) throws OXException {
        if (null == id || contextId <= 0) {
            return false;
        }
        FileStorage fileStorage = FileStoreResourceCacheImpl.getFileStorage(contextId, this.quotaAware);
        ResourceCacheMetadataStore metadataStore = this.getMetadataStore();
        ResourceCacheMetadata metadata = metadataStore.load(contextId, userId, id);
        if (metadata == null) {
            return false;
        }
        if (metadata.getRefId() == null) {
            metadataStore.remove(contextId, userId, id);
            return false;
        }
        try {
            Streams.close((Closeable)fileStorage.getFile(metadata.getRefId()));
        }
        catch (OXException e) {
            if (!FileStorageCodes.FILE_NOT_FOUND.equals(e)) {
                throw e;
            }
            metadataStore.remove(contextId, userId, id);
            return false;
        }
        return true;
    }

    private boolean ensureUnexceededContextQuota(Connection con, long desiredSize, int contextId, long existingSize) throws OXException {
        ResourceCacheMetadataStore metadataStore = this.getMetadataStore();
        long[] qts = this.getContextQuota(contextId);
        long total = qts[0];
        long totalPerDocument = qts[1];
        if (total > 0L || totalPerDocument > 0L) {
            if (total <= 0L) {
                return totalPerDocument <= 0L || desiredSize <= totalPerDocument;
            }
            if (desiredSize > total || desiredSize > totalPerDocument) {
                return false;
            }
            ArrayList<ResourceCacheMetadata> toRemove = new ArrayList<ResourceCacheMetadata>();
            boolean commited = false;
            try {
                Databases.startTransaction((Connection)con);
                long usedContextQuota = metadataStore.getUsedSize(con, contextId) - existingSize;
                while (usedContextQuota + desiredSize > total) {
                    ResourceCacheMetadata metadata = metadataStore.removeOldest(con, contextId);
                    if (metadata == null) {
                        boolean bl = false;
                        return bl;
                    }
                    toRemove.add(metadata);
                    usedContextQuota = metadataStore.getUsedSize(con, contextId) - existingSize;
                    if (usedContextQuota > 0L || desiredSize <= total) continue;
                    boolean bl = false;
                    return bl;
                }
                con.commit();
                commited = true;
            }
            catch (SQLException e) {
                throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
            finally {
                if (commited) {
                    this.deleteResources(contextId, toRemove);
                } else {
                    Databases.rollback((Connection)con);
                }
                Databases.autocommit((Connection)con);
            }
        }
        return true;
    }

    private void deleteResources(int contextId, List<ResourceCacheMetadata> toRemove) throws OXException {
        ArrayList<String> refIds = new ArrayList<String>(toRemove.size());
        for (ResourceCacheMetadata metadata : toRemove) {
            if (metadata.getRefId() == null) continue;
            refIds.add(metadata.getRefId());
        }
        if (refIds.size() > 0) {
            this.batchDeleteFiles(refIds, FileStoreResourceCacheImpl.getFileStorage(contextId, this.quotaAware));
        }
    }
}

