/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.container;

import com.openexchange.ajax.container.IFileHolder;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import java.io.InputStream;

public final class ByteArrayFileHolder
implements IFileHolder {
    private final byte[] bytes;
    private String name;
    private String contentType;
    private String disposition;
    private String delivery;

    public ByteArrayFileHolder(byte[] bytes) {
        this.bytes = bytes;
        this.contentType = "application/octet-stream";
    }

    @Override
    public boolean repetitive() {
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public InputStream getStream() {
        return new UnsynchronizedByteArrayInputStream(this.bytes);
    }

    @Override
    public long getLength() {
        return this.bytes.length;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisposition() {
        return this.disposition;
    }

    public void setDisposition(String disposition) {
        this.disposition = disposition;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDelivery(String delivery) {
        this.delivery = delivery;
    }

    @Override
    public String getDelivery() {
        return this.delivery;
    }
}

