/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.openexchange.ajax.AJAXServlet;
import com.openexchange.ajax.PermissionServlet;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.helper.BrowserDetector;
import com.openexchange.ajax.helper.DownloadUtility;
import com.openexchange.ajax.helper.ParamContainer;
import com.openexchange.ajax.parser.SearchTermParser;
import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.contactcollector.ContactCollectorService;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccessFactory;
import com.openexchange.file.storage.parse.FileMetadataParserService;
import com.openexchange.filemanagement.ManagedFile;
import com.openexchange.groupware.EnumComponent;
import com.openexchange.groupware.container.CommonObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.importexport.MailImportResult;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.upload.impl.UploadEvent;
import com.openexchange.groupware.upload.impl.UploadException;
import com.openexchange.groupware.upload.impl.UploadListener;
import com.openexchange.groupware.upload.impl.UploadRegistry;
import com.openexchange.html.HtmlService;
import com.openexchange.java.CharsetDetector;
import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.json.OXJSONWriter;
import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailJSONField;
import com.openexchange.mail.MailListField;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.MailSortField;
import com.openexchange.mail.OrderDirection;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.IMailMessageStorageExt;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.attachment.AttachmentToken;
import com.openexchange.mail.attachment.AttachmentTokenRegistry;
import com.openexchange.mail.cache.MailMessageCache;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.dataobjects.compose.ComposeType;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.dataobjects.compose.ContentAwareComposedMailMessage;
import com.openexchange.mail.json.parser.MessageParser;
import com.openexchange.mail.json.writer.MessageWriter;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.ManagedMimeMessage;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.MimeFilter;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.MimeMailExceptionCode;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.filler.MimeMessageFiller;
import com.openexchange.mail.structure.parser.MIMEStructureParser;
import com.openexchange.mail.transport.MailTransport;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.utils.DisplayMode;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.mail.utils.MsisdnUtility;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountExceptionCodes;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.preferences.ServerUserSetting;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.threadpool.AbstractTask;
import com.openexchange.threadpool.Task;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.threadpool.ThreadRenamer;
import com.openexchange.tools.Collections;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.encoding.Helper;
import com.openexchange.tools.encoding.URLCoder;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import com.openexchange.tools.servlet.UploadServletException;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import com.openexchange.tools.versit.utility.VersitUtility;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.idn.IDNA;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;
import org.json.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mail
extends PermissionServlet
implements UploadListener {
    private static final transient Logger LOG = LoggerFactory.getLogger(Mail.class);
    private static final long ZERO = 0L;
    private static final String MIME_TEXT_HTML_CHARSET_UTF_8 = "text/html; charset=UTF-8";
    private static final String MIME_TEXT_PLAIN = "text/plain";
    private static final String MIME_TEXT_HTML = "text/htm";
    private static final String STR_CONTENT_DISPOSITION = "Content-disposition";
    private static final String STR_USER_AGENT = "user-agent";
    private static final String STR_DELIM = ": ";
    private static final String STR_CRLF = "\r\n";
    private static final String STR_THREAD = "thread";
    private static final long serialVersionUID = 1980226522220313667L;
    private static final String UPLOAD_PARAM_MAILINTERFACE = "msint";
    private static final String UPLOAD_PARAM_WRITER = "writer";
    private static final String UPLOAD_PARAM_SESSION = "sess";
    private static final String UPLOAD_PARAM_HOSTNAME = "hostn";
    private static final String UPLOAD_PARAM_PROTOCOL = "proto";
    private static final String UPLOAD_PARAM_GID = "gid";
    private static final String STR_UTF8 = "UTF-8";
    private static final String STR_1 = "1";
    private static final String STR_EMPTY = "";
    private static final String STR_NULL = "null";
    public static final String PARAMETER_MAILFOLDER = "folder";
    public static final String PARAMETER_MAILATTCHMENT = "attachment";
    public static final String PARAMETER_DESTINATION_FOLDER = "dest_folder";
    public static final String PARAMETER_MAILCID = "cid";
    public static final String PARAMETER_SAVE = "save";
    public static final String PARAMETER_SHOW_SRC = "src";
    public static final String PARAMETER_SHOW_HEADER = "hdr";
    public static final String PARAMETER_EDIT_DRAFT = "edit";
    public static final String PARAMETER_SEND_TYPE = "sendtype";
    public static final String PARAMETER_VIEW = "view";
    public static final String PARAMETER_SRC = "src";
    public static final String PARAMETER_FLAGS = "flags";
    public static final String PARAMETER_UNSEEN = "unseen";
    public static final String PARAMETER_PREPARE = "prepare";
    public static final String PARAMETER_FILTER = "filter";
    public static final String PARAMETER_COL = "col";
    public static final String PARAMETER_MESSAGE_ID = "message_id";
    public static final String PARAMETER_HEADERS = "headers";
    private static final String VIEW_RAW = "raw";
    private static final String VIEW_TEXT = "text";
    private static final String VIEW_TEXT_NO_HTML_ATTACHMENT = "textNoHtmlAttach";
    private static final String VIEW_HTML = "html";
    private static final String VIEW_HTML_BLOCKED_IMAGES = "noimg";
    private static final transient JSONArray EMPTY_JSON_ARR = new JSONArray();
    private final transient MessageWriter.MailFieldWriter WRITER_ID = MessageWriter.getMailFieldWriter(new MailListField[]{MailListField.ID})[0];
    private static final String STR_ASC = "asc";
    private static final String STR_DESC = "desc";
    private static final Pattern PAT_BSLASH = Pattern.compile("\\\\");
    private static final Pattern PAT_QUOTE = Pattern.compile("\"");
    private static final Pattern PART_FILENAME_PATTERN = Pattern.compile("(part )([0-9]+)(?:(\\.)([0-9]+))*", 2);
    private static final String DEFAULT_FILENAME = "file.dat";
    private static final Pattern P = Pattern.compile("^[\\w\\d\\:\\/\\.]+(\\.\\w{3,4})$");
    private static final Pattern SPLIT = Pattern.compile(" *, *");
    protected static final MimeMessage POISON = new MimeMessage(MimeDefaultSession.getDefaultSession());
    private static final MailListField[] FIELDS_FLAGS = new MailListField[]{MailListField.FLAGS};

    protected static final OXException getWrappingOXException(Exception cause) {
        String message = cause.getMessage();
        String lineSeparator = System.getProperty("line.separator");
        LOG.warn("An unexpected exception occurred, which is going to be wrapped for proper display.{}For safety reason its original content is displayed here.{}{}", new Object[]{lineSeparator, lineSeparator, null == message ? "[Not available]" : message, cause});
        return MailExceptionCode.UNEXPECTED_ERROR.create(cause, null == message ? "[Not available]" : message);
    }

    private static void appendStackTrace(StackTraceElement[] trace, StringBuilder sb, String lineSeparator) {
        if (null == trace) {
            sb.append("<missing stack trace>").append(lineSeparator);
            return;
        }
        for (StackTraceElement ste : trace) {
            String className = ste.getClassName();
            if (null == className) continue;
            sb.append("    at ").append(className).append('.').append(ste.getMethodName());
            if (ste.isNativeMethod()) {
                sb.append("(Native Method)");
            } else {
                String fileName = ste.getFileName();
                if (null == fileName) {
                    sb.append("(Unknown Source)");
                } else {
                    int lineNumber = ste.getLineNumber();
                    sb.append('(').append(fileName);
                    if (lineNumber >= 0) {
                        sb.append(':').append(lineNumber);
                    }
                    sb.append(')');
                }
            }
            sb.append(lineSeparator);
        }
    }

    private static PrintWriter writerFrom(HttpServletResponse resp) throws IOException {
        try {
            return resp.getWriter();
        }
        catch (IllegalStateException ise) {
            return new PrintWriter((OutputStream)resp.getOutputStream());
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setContentType("text/javascript; charset=UTF-8");
        Tools.disableCaching(resp);
        try {
            this.actionGet(req, resp);
        }
        catch (Exception e) {
            LOG.error("doGet", (Throwable)e);
            Mail.writeError(e.toString(), new JSONWriter((Writer)Mail.writerFrom(resp)));
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setContentType("text/javascript; charset=UTF-8");
        Tools.disableCaching(resp);
        try {
            this.actionPut(req, resp);
        }
        catch (Exception e) {
            LOG.error("doPut", (Throwable)e);
            Mail.writeError(e.toString(), new JSONWriter((Writer)Mail.writerFrom(resp)));
        }
    }

    private static final void writeError(String error, JSONWriter jsonWriter) {
        try {
            Mail.startResponse(jsonWriter);
            jsonWriter.value((Object)STR_EMPTY);
            Mail.endResponse(jsonWriter, null, error);
        }
        catch (Exception exc) {
            LOG.error("writeError", (Throwable)exc);
        }
    }

    private final void actionGet(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String actionStr = Mail.checkStringParam(req, "action");
        if (actionStr.equalsIgnoreCase("all")) {
            this.actionGetAllMails(req, resp);
        } else if (actionStr.equalsIgnoreCase("count")) {
            this.actionGetMailCount(req, resp);
        } else if (actionStr.equalsIgnoreCase("updates")) {
            this.actionGetUpdates(req, resp);
        } else if (actionStr.equalsIgnoreCase("reply") || actionStr.equalsIgnoreCase("replyall")) {
            this.actionGetReply(req, resp, actionStr.equalsIgnoreCase("replyall"));
        } else if (actionStr.equalsIgnoreCase("forward")) {
            this.actionGetForward(req, resp);
        } else if (actionStr.equalsIgnoreCase("get")) {
            this.actionGetMessage(req, resp);
        } else if (actionStr.equalsIgnoreCase("get_structure")) {
            this.actionGetStructure(req, resp);
        } else if (actionStr.equalsIgnoreCase(PARAMETER_MAILATTCHMENT)) {
            this.actionGetAttachment(req, resp);
        } else if (actionStr.equalsIgnoreCase("attachmentToken")) {
            this.actionGetAttachmentToken(req, resp);
        } else if (actionStr.equalsIgnoreCase("zip_attachments")) {
            this.actionGetMultipleAttachments(req, resp);
        } else if (actionStr.equalsIgnoreCase("zip_messages")) {
            this.actionGetMultipleMessages(req, resp);
        } else if (actionStr.equalsIgnoreCase("newmsgs")) {
            this.actionGetNew(req, resp);
        } else if (actionStr.equalsIgnoreCase("saveVersit")) {
            this.actionGetSaveVersit(req, resp);
        } else {
            throw new Exception("Unknown value in parameter action through GET command");
        }
    }

    private final void actionPut(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String actionStr = Mail.checkStringParam(req, "action");
        if (actionStr.equalsIgnoreCase("list")) {
            this.actionPutMailList(req, resp);
        } else if (actionStr.equalsIgnoreCase("delete")) {
            this.actionPutDeleteMails(req, resp);
        } else if (actionStr.equalsIgnoreCase("update")) {
            this.actionPutUpdateMail(req, resp);
        } else if (actionStr.equalsIgnoreCase("transport")) {
            this.actionPutTransportMail(req, resp);
        } else if (actionStr.equalsIgnoreCase("copy")) {
            this.actionPutCopyMail(req, resp);
        } else if (actionStr.equalsIgnoreCase(PARAMETER_MAILATTCHMENT)) {
            this.actionPutAttachment(req, resp);
        } else if (actionStr.equalsIgnoreCase("receipt_ack")) {
            this.actionPutReceiptAck(req, resp);
        } else if (actionStr.equalsIgnoreCase("search")) {
            this.actionPutMailSearch(req, resp);
        } else if (actionStr.equalsIgnoreCase("clear")) {
            this.actionPutClear(req, resp);
        } else if (actionStr.equalsIgnoreCase("autosave")) {
            this.actionPutAutosave(req, resp);
        } else if (actionStr.equalsIgnoreCase("forward")) {
            this.actionPutForwardMultiple(req, resp);
        } else if (actionStr.equalsIgnoreCase("reply") || actionStr.equalsIgnoreCase("replyall")) {
            this.actionPutReply(req, resp, actionStr.equalsIgnoreCase("replyall"));
        } else if (actionStr.equalsIgnoreCase("get")) {
            this.actionPutGet(req, resp);
        } else if (actionStr.equalsIgnoreCase("new")) {
            this.actionPutNewMail(req, resp);
        } else {
            throw new Exception("Unknown value in parameter action through PUT command");
        }
    }

    public void actionGetUpdates(ServerSession session, JSONWriter writer, JSONObject requestObj, MailServletInterface mi) throws JSONException {
        ResponseWriter.write(this.actionGetUpdates(session, ParamContainer.getInstance(requestObj, EnumComponent.MAIL), mi), writer, session.getUser().getLocale());
    }

    private final void actionGetUpdates(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ServerSession session = Mail.getSessionObject((ServletRequest)req);
        try {
            ResponseWriter.write(this.actionGetUpdates(session, ParamContainer.getInstance(req, EnumComponent.MAIL, resp), null), resp.getWriter(), Mail.localeFrom(session));
        }
        catch (JSONException e) {
            OXException oxe = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error(STR_EMPTY, (Throwable)oxe);
            Response response = new Response(session);
            response.setException(oxe);
            try {
                ResponseWriter.write(response, resp.getWriter(), Mail.localeFrom(session));
            }
            catch (JSONException e1) {
                LOG.error("Error while writing response object.", (Throwable)e1);
                Mail.sendError(resp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Response actionGetUpdates(ServerSession session, ParamContainer paramContainer, MailServletInterface mailInterfaceArg) throws JSONException {
        OXJSONWriter jsonWriter;
        Response response;
        block15: {
            response = new Response(session);
            jsonWriter = new OXJSONWriter();
            jsonWriter.array();
            try {
                String folderId = paramContainer.checkStringParam(PARAMETER_MAILFOLDER);
                String ignore = paramContainer.getStringParam("ignore");
                String tmp = paramContainer.getStringParam("timezone");
                TimeZone timeZone = Mail.isEmpty(tmp) ? null : TimeZoneUtils.getTimeZone(tmp.trim());
                tmp = null;
                boolean bIgnoreDelete = false;
                boolean bIgnoreModified = false;
                if (ignore != null && ignore.indexOf("deleted") != -1) {
                    bIgnoreDelete = true;
                }
                if (ignore != null && ignore.indexOf("changed") != -1) {
                    bIgnoreModified = true;
                }
                if (bIgnoreModified && bIgnoreDelete) break block15;
                int[] columns = paramContainer.checkIntArrayParam("columns");
                int userId = session.getUserId();
                int contextId = session.getContextId();
                MailServletInterface mailInterface = mailInterfaceArg;
                boolean closeMailInterface = false;
                try {
                    if (mailInterface == null) {
                        mailInterface = MailServletInterface.getInstance(session);
                        closeMailInterface = true;
                    }
                    if (!bIgnoreModified) {
                        MailMessage[] modified = mailInterface.getUpdatedMessages(folderId, columns);
                        MessageWriter.MailFieldWriter[] writers = MessageWriter.getMailFieldWriter(MailListField.getFields(columns));
                        for (MailMessage mail : modified) {
                            if (mail == null) continue;
                            JSONArray ja = new JSONArray();
                            for (MessageWriter.MailFieldWriter writer : writers) {
                                writer.writeField((JSONValue)ja, mail, 0, false, mailInterface.getAccountID(), userId, contextId, timeZone);
                            }
                            jsonWriter.value(ja);
                        }
                    }
                    if (!bIgnoreDelete) {
                        MailMessage[] deleted;
                        for (MailMessage mail : deleted = mailInterface.getDeletedMessages(folderId, columns)) {
                            JSONArray ja = new JSONArray();
                            this.WRITER_ID.writeField((JSONValue)ja, mail, 0, false, mailInterface.getAccountID(), userId, contextId, timeZone);
                            jsonWriter.value(ja);
                        }
                    }
                }
                finally {
                    if (closeMailInterface && mailInterface != null) {
                        mailInterface.close(true);
                    }
                }
            }
            catch (OXException e) {
                LOG.error(STR_EMPTY, (Throwable)e);
                response.setException(e);
            }
            catch (Exception e) {
                OXException wrapper = Mail.getWrappingOXException(e);
                LOG.error(STR_EMPTY, (Throwable)wrapper);
                response.setException(wrapper);
            }
        }
        jsonWriter.endArray();
        response.setData(jsonWriter.getObject());
        response.setTimestamp(null);
        return response;
    }

    public void actionGetMailCount(Session session, JSONWriter writer, JSONObject requestObj, MailServletInterface mi) throws JSONException {
        ResponseWriter.write(this.actionGetMailCount(session, ParamContainer.getInstance(requestObj, EnumComponent.MAIL), mi), writer, Mail.localeFrom(session));
    }

    private final void actionGetMailCount(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ServerSession session = Mail.getSessionObject((ServletRequest)req);
        try {
            ResponseWriter.write(this.actionGetMailCount(session, ParamContainer.getInstance(req, EnumComponent.MAIL, resp), null), resp.getWriter(), Mail.localeFrom(session));
        }
        catch (JSONException e) {
            OXException oxe = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error(STR_EMPTY, (Throwable)oxe);
            Response response = new Response(session);
            response.setException(oxe);
            try {
                ResponseWriter.write(response, resp.getWriter(), Mail.localeFrom(session));
            }
            catch (JSONException e1) {
                LOG.error("Error while writing response object.", (Throwable)e1);
                Mail.sendError(resp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Response actionGetMailCount(Session session, ParamContainer paramContainer, MailServletInterface mailInterfaceArg) {
        Response response;
        try {
            response = new Response(session);
        }
        catch (OXException e) {
            return new Response().setException(e);
        }
        Object data = JSONObject.NULL;
        try {
            String folderId = paramContainer.checkStringParam(PARAMETER_MAILFOLDER);
            MailServletInterface mailInterface = mailInterfaceArg;
            boolean closeMailInterface = false;
            try {
                if (mailInterface == null) {
                    mailInterface = MailServletInterface.getInstance(session);
                    closeMailInterface = true;
                }
                data = mailInterface.getAllMessageCount(folderId)[0];
            }
            finally {
                if (closeMailInterface && mailInterface != null) {
                    mailInterface.close(true);
                }
            }
        }
        catch (OXException e) {
            LOG.error(STR_EMPTY, (Throwable)e);
            if (!e.getCategory().equals(Category.CATEGORY_PERMISSION_DENIED)) {
                response.setException(e);
            }
        }
        catch (Exception e) {
            OXException wrapper = Mail.getWrappingOXException(e);
            LOG.error(STR_EMPTY, (Throwable)wrapper);
            response.setException(wrapper);
        }
        response.setData(data);
        response.setTimestamp(null);
        return response;
    }

    public void actionGetAllMails(ServerSession session, JSONWriter writer, JSONObject requestObj, MailServletInterface mi) throws OXException, JSONException {
        ResponseWriter.write(this.actionGetAllMails(session, ParamContainer.getInstance(requestObj, EnumComponent.MAIL), mi), writer, session.getUser().getLocale());
    }

    private final void actionGetAllMails(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ServerSession session = Mail.getSessionObject((ServletRequest)req);
        try {
            ResponseWriter.write(this.actionGetAllMails(session, ParamContainer.getInstance(req, EnumComponent.MAIL, resp), null), resp.getWriter(), Mail.localeFrom(session));
        }
        catch (JSONException e) {
            OXException oxe = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error(STR_EMPTY, (Throwable)oxe);
            Response response = new Response(session);
            response.setException(oxe);
            try {
                ResponseWriter.write(response, resp.getWriter(), Mail.localeFrom(session));
            }
            catch (JSONException e1) {
                LOG.error("Error while writing response object.", (Throwable)e1);
                Mail.sendError(resp);
            }
        }
        catch (OXException e) {
            LOG.error(STR_EMPTY, (Throwable)e);
            Response response = new Response(session);
            response.setException(e);
            try {
                ResponseWriter.write(response, resp.getWriter(), Mail.localeFrom(session));
            }
            catch (JSONException e1) {
                LOG.error("Error while writing response object.", (Throwable)e1);
                Mail.sendError(resp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Response actionGetAllMails(ServerSession session, ParamContainer paramContainer, MailServletInterface mailInterfaceArg) throws JSONException, OXException {
        Response response = new Response(session);
        OXJSONWriter jsonWriter = new OXJSONWriter();
        jsonWriter.array();
        SearchIterator<MailMessage> it = null;
        try {
            String folderId = paramContainer.checkStringParam(PARAMETER_MAILFOLDER);
            int[] columns = paramContainer.checkIntArrayParam("columns");
            String sort = paramContainer.getStringParam("sort");
            String order = paramContainer.getStringParam("order");
            if (sort != null && order == null) {
                throw MailExceptionCode.MISSING_PARAM.create("order");
            }
            String tmp = paramContainer.getStringParam("timezone");
            TimeZone timeZone = Mail.isEmpty(tmp) ? null : TimeZoneUtils.getTimeZone(tmp.trim());
            tmp = null;
            int leftHandLimit = paramContainer.getIntParam("left_hand_limit");
            int rightHandLimit = paramContainer.getIntParam("right_hand_limit");
            int[] fromToIndices = leftHandLimit == -9999 || rightHandLimit == -9999 ? null : new int[]{leftHandLimit, rightHandLimit};
            MailServletInterface mailInterface = mailInterfaceArg;
            boolean closeMailInterface = false;
            try {
                if (mailInterface == null) {
                    mailInterface = MailServletInterface.getInstance(session);
                    closeMailInterface = true;
                }
                MessageWriter.MailFieldWriter[] writers = MessageWriter.getMailFieldWriter(MailListField.getFields(columns));
                int userId = session.getUserId();
                int contextId = session.getContextId();
                int orderDir = OrderDirection.ASC.getOrder();
                if (order != null) {
                    if (order.equalsIgnoreCase(STR_ASC)) {
                        orderDir = OrderDirection.ASC.getOrder();
                    } else if (order.equalsIgnoreCase(STR_DESC)) {
                        orderDir = OrderDirection.DESC.getOrder();
                    } else {
                        throw MailExceptionCode.INVALID_INT_VALUE.create("order");
                    }
                }
                if (STR_THREAD.equalsIgnoreCase(sort)) {
                    it = mailInterface.getAllThreadedMessages(folderId, MailSortField.RECEIVED_DATE.getField(), orderDir, columns, fromToIndices);
                    int size = it.size();
                    for (int i = 0; i < size; ++i) {
                        MailMessage mail = (MailMessage)it.next();
                        if (mail == null || mail.isDeleted()) continue;
                        JSONArray ja = new JSONArray();
                        for (MessageWriter.MailFieldWriter writer : writers) {
                            writer.writeField((JSONValue)ja, mail, mail.getThreadLevel(), false, mailInterface.getAccountID(), userId, contextId, timeZone);
                        }
                        jsonWriter.value(ja);
                    }
                } else {
                    int sortCol = sort == null ? MailListField.RECEIVED_DATE.getField() : Integer.parseInt(sort);
                    it = mailInterface.getAllMessages(folderId, sortCol, orderDir, columns, fromToIndices);
                    int size = it.size();
                    for (int i = 0; i < size; ++i) {
                        MailMessage mail = (MailMessage)it.next();
                        if (mail == null || mail.isDeleted()) continue;
                        JSONArray ja = new JSONArray();
                        for (MessageWriter.MailFieldWriter writer : writers) {
                            writer.writeField((JSONValue)ja, mail, 0, false, mailInterface.getAccountID(), userId, contextId, timeZone);
                        }
                        jsonWriter.value(ja);
                    }
                }
            }
            finally {
                if (closeMailInterface && mailInterface != null) {
                    mailInterface.close(true);
                }
            }
        }
        catch (OXException e) {
            LOG.error(STR_EMPTY, (Throwable)e);
            response.setException(e);
        }
        catch (Exception e) {
            OXException wrapper = Mail.getWrappingOXException(e);
            LOG.error(STR_EMPTY, (Throwable)wrapper);
            response.setException(wrapper);
        }
        finally {
            if (it != null) {
                it.close();
            }
        }
        jsonWriter.endArray();
        response.setData(jsonWriter.getObject());
        response.setTimestamp(null);
        return response;
    }

    public void actionGetReply(ServerSession session, JSONWriter writer, JSONObject jo, boolean reply2all, MailServletInterface mailInterface) throws JSONException {
        ResponseWriter.write(this.actionGetReply(session, reply2all, ParamContainer.getInstance(jo, EnumComponent.MAIL), mailInterface), writer, session.getUser().getLocale());
    }

    private final void actionGetReply(HttpServletRequest req, HttpServletResponse resp, boolean reply2all) throws IOException {
        ServerSession session = Mail.getSessionObject((ServletRequest)req);
        try {
            ResponseWriter.write(this.actionGetReply(session, reply2all, ParamContainer.getInstance(req, EnumComponent.MAIL, resp), null), resp.getWriter(), Mail.localeFrom(session));
        }
        catch (JSONException e) {
            OXException oxe = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error(STR_EMPTY, (Throwable)oxe);
            Response response = new Response(session);
            response.setException(oxe);
            try {
                ResponseWriter.write(response, resp.getWriter(), Mail.localeFrom(session));
            }
            catch (JSONException e1) {
                LOG.error("Error while writing response object.", (Throwable)e1);
                Mail.sendError(resp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Response actionGetReply(ServerSession session, boolean reply2all, ParamContainer paramContainer, MailServletInterface mailInterfaceArg) {
        Response response = new Response(session);
        Object data = JSONObject.NULL;
        ArrayList<OXException> warnings = new ArrayList<OXException>(2);
        try {
            String folderPath = paramContainer.checkStringParam(PARAMETER_MAILFOLDER);
            String uid = paramContainer.checkStringParam("id");
            String view = paramContainer.getStringParam(PARAMETER_VIEW);
            UserSettingMail usmNoSave = session.getUserSettingMail().clone();
            usmNoSave.setNoSave(true);
            DisplayMode displayMode = Mail.detectDisplayMode(true, view, usmNoSave);
            MailServletInterface mailInterface = mailInterfaceArg;
            boolean closeMailInterface = false;
            try {
                if (mailInterface == null) {
                    mailInterface = MailServletInterface.getInstance(session);
                    closeMailInterface = true;
                }
                data = MessageWriter.writeMailMessage(mailInterface.getAccountID(), mailInterface.getReplyMessageForDisplay(folderPath, uid, reply2all, usmNoSave), displayMode, false, session, usmNoSave, warnings, false, -1);
            }
            finally {
                if (closeMailInterface && mailInterface != null) {
                    mailInterface.close(true);
                }
            }
        }
        catch (OXException e) {
            LOG.error(STR_EMPTY, (Throwable)e);
            response.setException(e);
        }
        catch (Exception e) {
            OXException wrapper = Mail.getWrappingOXException(e);
            LOG.error(STR_EMPTY, (Throwable)wrapper);
            response.setException(wrapper);
        }
        response.setData(data);
        response.setTimestamp(null);
        if (!warnings.isEmpty()) {
            response.addWarning((OXException)((Object)warnings.get(0)));
        }
        return response;
    }

    public void actionGetForward(ServerSession session, JSONWriter writer, JSONObject requestObj, MailServletInterface mailInterface) throws JSONException {
        ResponseWriter.write(this.actionGetForward(session, ParamContainer.getInstance(requestObj, EnumComponent.MAIL), mailInterface), writer, Mail.localeFrom(session));
    }

    private final void actionGetForward(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ServerSession session = Mail.getSessionObject((ServletRequest)req);
        try {
            ResponseWriter.write(this.actionGetForward(session, ParamContainer.getInstance(req, EnumComponent.MAIL, resp), null), resp.getWriter(), Mail.localeFrom(session));
        }
        catch (JSONException e) {
            OXException oxe = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error(STR_EMPTY, (Throwable)oxe);
            Response response = new Response(session);
            response.setException(oxe);
            try {
                ResponseWriter.write(response, resp.getWriter(), Mail.localeFrom(session));
            }
            catch (JSONException e1) {
                LOG.error("Error while writing response object.", (Throwable)e1);
                Mail.sendError(resp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Response actionGetForward(ServerSession session, ParamContainer paramContainer, MailServletInterface mailInterfaceArg) {
        Response response = new Response(session);
        Object data = JSONObject.NULL;
        ArrayList<OXException> warnings = new ArrayList<OXException>(2);
        try {
            String folderPath = paramContainer.checkStringParam(PARAMETER_MAILFOLDER);
            String uid = paramContainer.checkStringParam("id");
            String view = paramContainer.getStringParam(PARAMETER_VIEW);
            UserSettingMail usmNoSave = session.getUserSettingMail().clone();
            usmNoSave.setNoSave(true);
            DisplayMode displayMode = Mail.detectDisplayMode(true, view, usmNoSave);
            MailServletInterface mailInterface = mailInterfaceArg;
            boolean closeMailInterface = false;
            try {
                if (mailInterface == null) {
                    mailInterface = MailServletInterface.getInstance(session);
                    closeMailInterface = true;
                }
                data = MessageWriter.writeMailMessage(mailInterface.getAccountID(), mailInterface.getForwardMessageForDisplay(new String[]{folderPath}, new String[]{uid}, usmNoSave), displayMode, false, session, usmNoSave, warnings, false, -1);
            }
            finally {
                if (closeMailInterface && mailInterface != null) {
                    mailInterface.close(true);
                }
            }
        }
        catch (OXException e) {
            LOG.error(STR_EMPTY, (Throwable)e);
            response.setException(e);
        }
        catch (Exception e) {
            OXException wrapper = Mail.getWrappingOXException(e);
            LOG.error(STR_EMPTY, (Throwable)wrapper);
            response.setException(wrapper);
        }
        response.setData(data);
        response.setTimestamp(null);
        if (!warnings.isEmpty()) {
            response.addWarning((OXException)((Object)warnings.get(0)));
        }
        return response;
    }

    public void actionGetStructure(ServerSession session, JSONWriter writer, JSONObject requestObj, MailServletInterface mi) throws JSONException {
        Response response = this.actionGetStructure(session, ParamContainer.getInstance(requestObj, EnumComponent.MAIL), mi);
        if (null != response) {
            ResponseWriter.write(response, writer, Mail.localeFrom(session));
        }
    }

    private final void actionGetStructure(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ServerSession session = Mail.getSessionObject((ServletRequest)req);
        try {
            Response response = this.actionGetStructure(session, ParamContainer.getInstance(req, EnumComponent.MAIL, resp), null);
            if (null != response) {
                ResponseWriter.write(response, resp.getWriter(), Mail.localeFrom(session));
            }
        }
        catch (JSONException e) {
            OXException oxe = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error(STR_EMPTY, (Throwable)oxe);
            Response response = new Response(session);
            response.setException(oxe);
            try {
                ResponseWriter.write(response, resp.getWriter(), Mail.localeFrom(session));
            }
            catch (JSONException e1) {
                LOG.error("Error while writing response object.", (Throwable)e1);
                Mail.sendError(resp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Response actionGetStructure(ServerSession session, ParamContainer paramContainer, MailServletInterface mailInterfaceArg) {
        Object data;
        Response response;
        block21: {
            response = new Response(session);
            data = JSONObject.NULL;
            try {
                long maxSize;
                String folderPath = paramContainer.checkStringParam(PARAMETER_MAILFOLDER);
                String tmp = paramContainer.getStringParam(PARAMETER_UNSEEN);
                boolean unseen = STR_1.equals(tmp) || Boolean.parseBoolean(tmp);
                String tmp2 = paramContainer.getStringParam("max_size");
                if (null == tmp2) {
                    maxSize = -1L;
                } else {
                    long l = -1L;
                    try {
                        l = Long.parseLong(tmp2.trim());
                    }
                    catch (NumberFormatException e) {
                        l = -1L;
                    }
                    maxSize = l;
                }
                MailServletInterface mailInterface = mailInterfaceArg;
                boolean closeMailInterface = false;
                try {
                    boolean doUnseen;
                    String uid;
                    String tmp22;
                    if (mailInterface == null) {
                        mailInterface = MailServletInterface.getInstance(session);
                        closeMailInterface = true;
                    }
                    if (null == (tmp22 = paramContainer.getStringParam("id"))) {
                        tmp22 = paramContainer.getStringParam(PARAMETER_MESSAGE_ID);
                        if (null == tmp22) {
                            throw AjaxExceptionCodes.MISSING_PARAMETER.create("id");
                        }
                        uid = mailInterface.getMailIDByMessageID(folderPath, tmp22);
                    } else {
                        uid = tmp22;
                    }
                    MailMessage mail = mailInterface.getMessage(folderPath, uid);
                    if (mail == null) {
                        throw MailExceptionCode.MAIL_NOT_FOUND.create(uid, folderPath);
                    }
                    boolean wasUnseen = mail.containsPrevSeen() && !mail.isPrevSeen();
                    boolean bl = doUnseen = unseen && wasUnseen;
                    if (doUnseen) {
                        mail.setFlag(32, false);
                        int unreadMsgs = mail.getUnreadMessages();
                        mail.setUnreadMessages(unreadMsgs < 0 ? 0 : unreadMsgs + 1);
                    }
                    data = MessageWriter.writeStructure(mailInterface.getAccountID(), mail, maxSize);
                    if (doUnseen) {
                        mailInterface.updateMessageFlags(folderPath, new String[]{uid}, 32, false);
                        break block21;
                    }
                    if (!wasUnseen) break block21;
                    try {
                        ServerUserSetting setting = ServerUserSetting.getInstance();
                        int contextId = session.getContextId();
                        int userId = session.getUserId();
                        if (setting.isContactCollectionEnabled(contextId, userId).booleanValue() && setting.isContactCollectOnMailAccess(contextId, userId).booleanValue()) {
                            Mail.triggerContactCollector(session, mail);
                        }
                    }
                    catch (OXException e) {
                        LOG.warn("Contact collector could not be triggered.", (Throwable)e);
                    }
                }
                finally {
                    if (closeMailInterface && mailInterface != null) {
                        mailInterface.close(true);
                    }
                }
            }
            catch (OXException e) {
                LOG.error(STR_EMPTY, (Throwable)e);
                response.setException(e);
            }
            catch (Exception e) {
                OXException wrapper = Mail.getWrappingOXException(e);
                LOG.error(STR_EMPTY, (Throwable)wrapper);
                response.setException(wrapper);
            }
        }
        response.setData(data);
        response.setTimestamp(null);
        return response;
    }

    public void actionGetMessage(ServerSession session, JSONWriter writer, JSONObject requestObj, MailServletInterface mi) throws JSONException {
        Response response = this.actionGetMessage(session, ParamContainer.getInstance(requestObj, EnumComponent.MAIL), mi);
        if (null != response) {
            ResponseWriter.write(response, writer, Mail.localeFrom(session));
        }
    }

    private final void actionGetMessage(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ServerSession session = Mail.getSessionObject((ServletRequest)req);
        try {
            Response response = this.actionGetMessage(session, ParamContainer.getInstance(req, EnumComponent.MAIL, resp), null);
            if (null != response) {
                ResponseWriter.write(response, resp.getWriter(), Mail.localeFrom(session));
            }
        }
        catch (JSONException e) {
            OXException oxe = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error(STR_EMPTY, (Throwable)oxe);
            Response response = new Response(session);
            response.setException(oxe);
            try {
                ResponseWriter.write(response, resp.getWriter(), Mail.localeFrom(session));
            }
            catch (JSONException e1) {
                LOG.error("Error while writing response object.", (Throwable)e1);
                Mail.sendError(resp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Response actionGetMessage(ServerSession session, ParamContainer paramContainer, MailServletInterface mailInterfaceArg) throws JSONException {
        ArrayList<OXException> warnings;
        Object data;
        Response response;
        block56: {
            response = new Response(session);
            data = JSONObject.NULL;
            warnings = new ArrayList<OXException>(2);
            boolean errorAsCallback = false;
            try {
                MimeFilter mimeFilter;
                int ttlMillis;
                String folderPath = paramContainer.checkStringParam(PARAMETER_MAILFOLDER);
                String tmp = paramContainer.getStringParam("src");
                boolean showMessageSource = STR_1.equals(tmp) || Boolean.parseBoolean(tmp);
                tmp = paramContainer.getStringParam(PARAMETER_EDIT_DRAFT);
                boolean editDraft = STR_1.equals(tmp) || Boolean.parseBoolean(tmp);
                tmp = paramContainer.getStringParam(PARAMETER_SHOW_HEADER);
                boolean showMessageHeaders = STR_1.equals(tmp) || Boolean.parseBoolean(tmp);
                tmp = paramContainer.getStringParam(PARAMETER_SAVE);
                boolean saveToDisk = tmp != null && tmp.length() > 0 && Integer.parseInt(tmp) > 0;
                tmp = paramContainer.getStringParam(PARAMETER_VIEW);
                String view = null == tmp ? null : tmp.toLowerCase(Locale.ENGLISH);
                tmp = paramContainer.getStringParam(PARAMETER_UNSEEN);
                boolean unseen = tmp != null && (STR_1.equals(tmp) || Boolean.parseBoolean(tmp));
                tmp = paramContainer.getStringParam("token");
                boolean token = tmp != null && (STR_1.equals(tmp) || Boolean.parseBoolean(tmp));
                tmp = paramContainer.getStringParam("ttlMillis");
                try {
                    ttlMillis = tmp == null ? -1 : Integer.parseInt(tmp.trim());
                }
                catch (NumberFormatException e) {
                    ttlMillis = -1;
                }
                tmp = paramContainer.getStringParam("ignorable");
                if (Mail.isEmpty(tmp)) {
                    mimeFilter = null;
                } else {
                    MimeFilter mf;
                    String[] strings = SPLIT.split(tmp, 0);
                    int length = strings.length;
                    if (1 == length && (mf = MimeFilter.filterFor(strings[0])) != null) {
                        mimeFilter = mf;
                    } else {
                        ArrayList<String> ignorableContentTypes = new ArrayList<String>(length);
                        for (int i = 0; i < length; ++i) {
                            String cts = strings[i];
                            if ("ics".equalsIgnoreCase(cts)) {
                                ignorableContentTypes.add("text/calendar");
                                ignorableContentTypes.add("application/ics");
                                continue;
                            }
                            ignorableContentTypes.add(cts);
                        }
                        mimeFilter = MimeFilter.filterFor(ignorableContentTypes);
                    }
                }
                tmp = null;
                errorAsCallback = saveToDisk;
                MailServletInterface mailInterface = mailInterfaceArg;
                boolean closeMailInterface = false;
                try {
                    boolean doUnseen;
                    MailMessage mail;
                    String uid;
                    String tmp2;
                    if (mailInterface == null) {
                        mailInterface = MailServletInterface.getInstance(session);
                        closeMailInterface = true;
                    }
                    if (null == (tmp2 = paramContainer.getStringParam("id"))) {
                        tmp2 = paramContainer.getStringParam(PARAMETER_MESSAGE_ID);
                        if (null == tmp2) {
                            throw AjaxExceptionCodes.MISSING_PARAMETER.create("id");
                        }
                        uid = mailInterface.getMailIDByMessageID(folderPath, tmp2);
                    } else {
                        uid = tmp2;
                    }
                    if (showMessageSource) {
                        boolean doUnseen2;
                        mail = mailInterface.getMessage(folderPath, uid);
                        if (mail == null) {
                            throw MailExceptionCode.MAIL_NOT_FOUND.create(uid, folderPath);
                        }
                        UnsynchronizedByteArrayOutputStream baos = new UnsynchronizedByteArrayOutputStream();
                        try {
                            mail.writeTo((OutputStream)baos);
                        }
                        catch (OXException e) {
                            if (!MailExceptionCode.NO_CONTENT.equals(e)) {
                                throw e;
                            }
                            LOG.debug(STR_EMPTY, (Throwable)e);
                            baos.reset();
                        }
                        if (null != mimeFilter) {
                            MimeMessage mimeMessage = new MimeMessage(MimeDefaultSession.getDefaultSession(), (InputStream)Streams.newByteArrayInputStream((byte[])baos.toByteArray()));
                            mimeMessage = mimeFilter.filter(mimeMessage);
                            baos.reset();
                            mimeMessage.writeTo((OutputStream)baos);
                        }
                        boolean wasUnseen = mail.containsPrevSeen() && !mail.isPrevSeen();
                        boolean bl = doUnseen2 = unseen && wasUnseen;
                        if (doUnseen2) {
                            mail.setFlag(32, false);
                            int unreadMsgs = mail.getUnreadMessages();
                            mail.setUnreadMessages(unreadMsgs < 0 ? 0 : unreadMsgs + 1);
                        }
                        if (doUnseen2) {
                            mailInterface.updateMessageFlags(folderPath, new String[]{uid}, 32, false);
                        } else if (wasUnseen) {
                            try {
                                ServerUserSetting setting = ServerUserSetting.getInstance();
                                int contextId = session.getContextId();
                                int userId = session.getUserId();
                                if (setting.isContactCollectionEnabled(contextId, userId).booleanValue() && setting.isContactCollectOnMailAccess(contextId, userId).booleanValue()) {
                                    Mail.triggerContactCollector(session, mail);
                                }
                            }
                            catch (OXException e) {
                                LOG.warn("Contact collector could not be triggered.", (Throwable)e);
                            }
                        }
                        if (saveToDisk) {
                            ContentType contentType = new ContentType();
                            contentType.setPrimaryType("application");
                            contentType.setSubType("octet-stream");
                            HttpServletResponse httpResponse = paramContainer.getHttpServletResponse();
                            httpResponse.setContentType(contentType.toString());
                            httpResponse.setHeader(STR_CONTENT_DISPOSITION, Mail.getAttachmentDispositionValue(mail.getSubject() + ".eml", null, paramContainer.getHeader(STR_USER_AGENT)));
                            Tools.removeCachingHeader(httpResponse);
                            ServletOutputStream out = httpResponse.getOutputStream();
                            byte[] bytes = baos.toByteArray();
                            int offset = 0;
                            while (true) {
                                if (offset >= bytes.length) {
                                    out.flush();
                                    Response response2 = null;
                                    return response2;
                                }
                                int len = Math.min(65535, bytes.length - offset);
                                out.write(bytes, offset, len);
                                offset += len;
                            }
                        }
                        ContentType ct = mail.getContentType();
                        data = ct.containsCharsetParameter() && CharsetDetector.isValid((String)ct.getCharsetParameter()) ? new String(baos.toByteArray(), Charsets.forName((String)ct.getCharsetParameter())) : new String(baos.toByteArray(), Charsets.UTF_8);
                        break block56;
                    }
                    if (showMessageHeaders) {
                        boolean doUnseen3;
                        mail = mailInterface.getMessage(folderPath, uid);
                        if (mail == null) {
                            throw MailExceptionCode.MAIL_NOT_FOUND.create(uid, folderPath);
                        }
                        boolean wasUnseen = mail.containsPrevSeen() && !mail.isPrevSeen();
                        boolean bl = doUnseen3 = unseen && wasUnseen;
                        if (doUnseen3) {
                            mail.setFlag(32, false);
                            int unreadMsgs = mail.getUnreadMessages();
                            mail.setUnreadMessages(unreadMsgs < 0 ? 0 : unreadMsgs + 1);
                        }
                        data = Mail.formatMessageHeaders(mail.getHeadersIterator());
                        if (doUnseen3) {
                            mailInterface.updateMessageFlags(folderPath, new String[]{uid}, 32, false);
                            break block56;
                        }
                        if (!wasUnseen) break block56;
                        try {
                            ServerUserSetting setting = ServerUserSetting.getInstance();
                            int contextId = session.getContextId();
                            int userId = session.getUserId();
                            if (setting.isContactCollectionEnabled(contextId, userId).booleanValue() && setting.isContactCollectOnMailAccess(contextId, userId).booleanValue()) {
                                Mail.triggerContactCollector(session, mail);
                            }
                            break block56;
                        }
                        catch (OXException e) {
                            LOG.warn("Contact collector could not be triggered.", (Throwable)e);
                        }
                        break block56;
                    }
                    UserSettingMail usmNoSave = session.getUserSettingMail().clone();
                    usmNoSave.setNoSave(true);
                    DisplayMode displayMode = Mail.detectDisplayMode(editDraft, view, usmNoSave);
                    FullnameArgument fa = MailFolderUtility.prepareMailFolderParam(folderPath);
                    fa.getAccountId();
                    fa.getFullname();
                    MailMessage mail2 = mailInterface.getMessage(folderPath, uid);
                    if (mail2 == null) {
                        throw MailExceptionCode.MAIL_NOT_FOUND.create(uid, folderPath);
                    }
                    boolean wasUnseen = mail2.containsPrevSeen() && !mail2.isPrevSeen();
                    boolean bl = doUnseen = unseen && wasUnseen;
                    if (doUnseen) {
                        mail2.setFlag(32, false);
                        int unreadMsgs = mail2.getUnreadMessages();
                        mail2.setUnreadMessages(unreadMsgs < 0 ? 0 : unreadMsgs + 1);
                    }
                    data = MessageWriter.writeMailMessage(mailInterface.getAccountID(), mail2, displayMode, false, session, usmNoSave, warnings, token, ttlMillis, mimeFilter);
                    if (doUnseen) {
                        mailInterface.updateMessageFlags(folderPath, new String[]{uid}, 32, false);
                        break block56;
                    }
                    if (!wasUnseen) break block56;
                    try {
                        ServerUserSetting setting = ServerUserSetting.getInstance();
                        int contextId = session.getContextId();
                        int userId = session.getUserId();
                        if (setting.isContactCollectionEnabled(contextId, userId).booleanValue() && setting.isContactCollectOnMailAccess(contextId, userId).booleanValue()) {
                            Mail.triggerContactCollector(session, mail2);
                        }
                    }
                    catch (OXException e) {
                        LOG.warn("Contact collector could not be triggered.", (Throwable)e);
                    }
                }
                finally {
                    if (closeMailInterface && mailInterface != null) {
                        mailInterface.close(true);
                    }
                }
            }
            catch (OXException e) {
                if (MailExceptionCode.MAIL_NOT_FOUND.equals(e)) {
                    LOG.warn("Requested mail could not be found. Most likely this is caused by concurrent access of multiple clients while one performed a delete on affected mail.", (Throwable)e);
                } else {
                    LOG.error(STR_EMPTY, (Throwable)e);
                }
                response.setException(e);
                if (errorAsCallback) {
                    try {
                        HttpServletResponse resp = paramContainer.getHttpServletResponse();
                        resp.setContentType(MIME_TEXT_HTML_CHARSET_UTF_8);
                        String jsResponse = Mail.substituteJS(ResponseWriter.getJSON(response).toString(), "get");
                        PrintWriter writer = resp.getWriter();
                        writer.write(jsResponse);
                        writer.flush();
                        return null;
                    }
                    catch (Exception exc) {
                        throw new JSONException((Throwable)exc);
                    }
                }
            }
            catch (Exception e) {
                OXException wrapper = Mail.getWrappingOXException(e);
                LOG.error(STR_EMPTY, (Throwable)wrapper);
                response.setException(wrapper);
                if (!errorAsCallback) break block56;
                try {
                    HttpServletResponse resp = paramContainer.getHttpServletResponse();
                    resp.setContentType(MIME_TEXT_HTML_CHARSET_UTF_8);
                    String jsResponse = Mail.substituteJS(ResponseWriter.getJSON(response).toString(), "get");
                    PrintWriter writer = resp.getWriter();
                    writer.write(jsResponse);
                    writer.flush();
                    return null;
                }
                catch (Exception exc) {
                    throw new JSONException((Throwable)exc);
                }
            }
        }
        response.setData(data);
        response.setTimestamp(null);
        if (warnings.isEmpty()) return response;
        response.addWarning((OXException)((Object)warnings.get(0)));
        return response;
    }

    private static DisplayMode detectDisplayMode(boolean modifyable, String view, UserSettingMail usmNoSave) {
        DisplayMode displayMode;
        if (null != view) {
            if (VIEW_RAW.equals(view)) {
                displayMode = DisplayMode.RAW;
            } else if (VIEW_TEXT_NO_HTML_ATTACHMENT.equals(view)) {
                usmNoSave.setDisplayHtmlInlineContent(false);
                usmNoSave.setSuppressHTMLAlternativePart(true);
                displayMode = modifyable ? DisplayMode.MODIFYABLE : DisplayMode.DISPLAY;
            } else if (VIEW_TEXT.equals(view)) {
                usmNoSave.setDisplayHtmlInlineContent(false);
                displayMode = modifyable ? DisplayMode.MODIFYABLE : DisplayMode.DISPLAY;
            } else if (VIEW_HTML.equals(view)) {
                usmNoSave.setDisplayHtmlInlineContent(true);
                usmNoSave.setAllowHTMLImages(true);
                displayMode = modifyable ? DisplayMode.MODIFYABLE : DisplayMode.DISPLAY;
            } else if (VIEW_HTML_BLOCKED_IMAGES.equals(view)) {
                usmNoSave.setDisplayHtmlInlineContent(true);
                usmNoSave.setAllowHTMLImages(false);
                displayMode = modifyable ? DisplayMode.MODIFYABLE : DisplayMode.DISPLAY;
            } else {
                LOG.warn("Unknown value in parameter {}: {}. Using user's mail settings as fallback.", (Object)PARAMETER_VIEW, (Object)view);
                displayMode = modifyable ? DisplayMode.MODIFYABLE : DisplayMode.DISPLAY;
            }
        } else {
            displayMode = modifyable ? DisplayMode.MODIFYABLE : DisplayMode.DISPLAY;
        }
        return displayMode;
    }

    private static void triggerContactCollector(ServerSession session, MailMessage mail) throws OXException {
        ContactCollectorService ccs = ServerServiceRegistry.getInstance().getService(ContactCollectorService.class);
        if (null != ccs) {
            HashSet<InternetAddress> addrs = new HashSet<InternetAddress>();
            addrs.addAll(Arrays.asList(mail.getFrom()));
            addrs.addAll(Arrays.asList(mail.getTo()));
            addrs.addAll(Arrays.asList(mail.getCc()));
            addrs.addAll(Arrays.asList(mail.getBcc()));
            try {
                String[] aliases;
                HashSet<QuotedInternetAddress> validAddrs = new HashSet<QuotedInternetAddress>(4);
                UserSettingMail usm = session.getUserSettingMail();
                if (usm.getSendAddr() != null && usm.getSendAddr().length() > 0) {
                    validAddrs.add(new QuotedInternetAddress(usm.getSendAddr()));
                }
                User user = UserStorage.getInstance().getUser(session.getUserId(), session.getContextId());
                validAddrs.add(new QuotedInternetAddress(user.getMail()));
                for (String alias : aliases = user.getAliases()) {
                    validAddrs.add(new QuotedInternetAddress(alias));
                }
                addrs.removeAll(validAddrs);
            }
            catch (AddressException e) {
                LOG.warn("Collected contacts could not be stripped by user's email aliases", (Throwable)e);
            }
            if (!addrs.isEmpty()) {
                ccs.memorizeAddresses(new ArrayList(addrs), (Session)session);
            }
        }
    }

    private static void triggerContactCollector(ServerSession session, JSONObject mail) throws OXException {
        ContactCollectorService ccs = ServerServiceRegistry.getInstance().getService(ContactCollectorService.class);
        if (null != ccs) {
            HashSet<InternetAddress> addrs = new HashSet<InternetAddress>();
            try {
                String[] aliases;
                addrs.addAll(Arrays.asList(MessageParser.parseAddressKey(MailJSONField.FROM.getKey(), mail)));
                addrs.addAll(Arrays.asList(MessageParser.parseAddressKey(MailJSONField.RECIPIENT_TO.getKey(), mail)));
                addrs.addAll(Arrays.asList(MessageParser.parseAddressKey(MailJSONField.RECIPIENT_CC.getKey(), mail)));
                addrs.addAll(Arrays.asList(MessageParser.parseAddressKey(MailJSONField.RECIPIENT_BCC.getKey(), mail)));
                HashSet<QuotedInternetAddress> validAddrs = new HashSet<QuotedInternetAddress>(4);
                UserSettingMail usm = session.getUserSettingMail();
                if (usm.getSendAddr() != null && usm.getSendAddr().length() > 0) {
                    validAddrs.add(new QuotedInternetAddress(usm.getSendAddr()));
                }
                User user = UserStorage.getInstance().getUser(session.getUserId(), session.getContextId());
                validAddrs.add(new QuotedInternetAddress(user.getMail()));
                for (String alias : aliases = user.getAliases()) {
                    validAddrs.add(new QuotedInternetAddress(alias));
                }
                addrs.removeAll(validAddrs);
            }
            catch (AddressException e) {
                LOG.warn("Contact collector could not be triggered", (Throwable)e);
            }
            catch (JSONException e) {
                LOG.warn("Contact collector could not be triggered", (Throwable)e);
            }
            if (!addrs.isEmpty()) {
                ccs.memorizeAddresses(new ArrayList(addrs), (Session)session);
            }
        }
    }

    private static final String formatMessageHeaders(Iterator<Map.Entry<String, String>> iter) {
        StringBuilder sb = new StringBuilder(1024);
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            sb.append(entry.getKey()).append(STR_DELIM).append(entry.getValue()).append(STR_CRLF);
        }
        return sb.toString();
    }

    public void actionGetNew(ServerSession session, JSONWriter writer, JSONObject requestObj, MailServletInterface mi) throws OXException, JSONException {
        ResponseWriter.write(this.actionGetNew(session, ParamContainer.getInstance(requestObj, EnumComponent.MAIL), mi), writer, Mail.localeFrom(session));
    }

    private final void actionGetNew(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ServerSession session = Mail.getSessionObject((ServletRequest)req);
        try {
            ResponseWriter.write(this.actionGetNew(session, ParamContainer.getInstance(req, EnumComponent.MAIL, resp), null), resp.getWriter(), Mail.localeFrom(session));
        }
        catch (JSONException e) {
            OXException oxe = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error(STR_EMPTY, (Throwable)oxe);
            Response response = new Response(session);
            response.setException(oxe);
            try {
                ResponseWriter.write(response, resp.getWriter(), Mail.localeFrom(session));
            }
            catch (JSONException e1) {
                LOG.error("Error while writing response object.", (Throwable)e1);
                Mail.sendError(resp);
            }
        }
        catch (OXException e) {
            LOG.error(STR_EMPTY, (Throwable)e);
            Response response = new Response(session);
            response.setException(e);
            try {
                ResponseWriter.write(response, resp.getWriter(), Mail.localeFrom(session));
            }
            catch (JSONException e1) {
                LOG.error("Error while writing response object.", (Throwable)e1);
                Mail.sendError(resp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Response actionGetNew(ServerSession session, ParamContainer paramContainer, MailServletInterface mailInterfaceArg) throws JSONException, OXException {
        Response response = new Response(session);
        OXJSONWriter jsonWriter = new OXJSONWriter();
        jsonWriter.array();
        SearchIterator<MailMessage> it = null;
        try {
            String folderId = paramContainer.checkStringParam(PARAMETER_MAILFOLDER);
            int[] columns = paramContainer.checkIntArrayParam("columns");
            String sort = paramContainer.getStringParam("sort");
            String order = paramContainer.getStringParam("order");
            int limit = paramContainer.getIntParam("limit");
            MailServletInterface mailInterface = mailInterfaceArg;
            boolean closeMailInterface = false;
            try {
                String tmp;
                if (mailInterface == null) {
                    mailInterface = MailServletInterface.getInstance(session);
                    closeMailInterface = true;
                }
                int sortCol = sort == null ? MailListField.RECEIVED_DATE.getField() : Integer.parseInt(sort);
                int orderDir = OrderDirection.ASC.getOrder();
                if (order != null) {
                    if (order.equalsIgnoreCase(STR_ASC)) {
                        orderDir = OrderDirection.ASC.getOrder();
                    } else if (order.equalsIgnoreCase(STR_DESC)) {
                        orderDir = OrderDirection.DESC.getOrder();
                    } else {
                        throw MailExceptionCode.INVALID_INT_VALUE.create("order");
                    }
                }
                TimeZone timeZone = Mail.isEmpty(tmp = paramContainer.getStringParam("timezone")) ? null : TimeZoneUtils.getTimeZone(tmp.trim());
                tmp = null;
                MessageWriter.MailFieldWriter[] writers = MessageWriter.getMailFieldWriter(MailListField.getFields(columns));
                it = mailInterface.getNewMessages(folderId, sortCol, orderDir, columns, limit == -9999 ? -1 : limit);
                int size = it.size();
                int userId = session.getUserId();
                int contextId = session.getContextId();
                for (int i = 0; i < size; ++i) {
                    MailMessage mail = (MailMessage)it.next();
                    if (mail == null || mail.isDeleted()) continue;
                    JSONArray ja = new JSONArray();
                    for (MessageWriter.MailFieldWriter writer : writers) {
                        writer.writeField((JSONValue)ja, mail, 0, false, mailInterface.getAccountID(), userId, contextId, timeZone);
                    }
                    jsonWriter.value(ja);
                }
            }
            finally {
                if (closeMailInterface && mailInterface != null) {
                    mailInterface.close(true);
                }
            }
        }
        catch (OXException e) {
            LOG.error(STR_EMPTY, (Throwable)e);
            response.setException(e);
        }
        catch (Exception e) {
            OXException wrapper = Mail.getWrappingOXException(e);
            LOG.error(STR_EMPTY, (Throwable)wrapper);
            response.setException(wrapper);
        }
        finally {
            if (it != null) {
                it.close();
            }
        }
        jsonWriter.endArray();
        response.setData(jsonWriter.getObject());
        response.setTimestamp(null);
        return response;
    }

    public void actionGetSaveVersit(ServerSession session, Writer writer, JSONObject requestObj, MailServletInterface mi) throws JSONException, IOException {
        this.actionGetSaveVersit(session, writer, ParamContainer.getInstance(requestObj, EnumComponent.MAIL), mi);
    }

    private final void actionGetSaveVersit(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ServerSession session = Mail.getSessionObject((ServletRequest)req);
        try {
            this.actionGetSaveVersit(session, (Writer)resp.getWriter(), ParamContainer.getInstance(req, EnumComponent.MAIL, resp), null);
        }
        catch (JSONException e) {
            OXException oxe = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error(STR_EMPTY, (Throwable)oxe);
            Response response = new Response(session);
            response.setException(oxe);
            try {
                ResponseWriter.write(response, resp.getWriter(), Mail.localeFrom(session));
            }
            catch (JSONException e1) {
                LOG.error("Error while writing response object.", (Throwable)e1);
                Mail.sendError(resp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void actionGetSaveVersit(ServerSession session, Writer writer, ParamContainer paramContainer, MailServletInterface mailInterfaceArg) throws JSONException, IOException {
        Response response = new Response(session);
        OXJSONWriter jsonWriter = new OXJSONWriter();
        jsonWriter.array();
        try {
            String folderPath = paramContainer.checkStringParam(PARAMETER_MAILFOLDER);
            String uid = paramContainer.checkStringParam("id");
            String partIdentifier = paramContainer.checkStringParam(PARAMETER_MAILATTCHMENT);
            MailServletInterface mailInterface = mailInterfaceArg;
            boolean closeMailInterface = false;
            try {
                if (mailInterface == null) {
                    mailInterface = MailServletInterface.getInstance(session);
                    closeMailInterface = true;
                }
                MailPart versitPart = mailInterface.getMessageAttachment(folderPath, uid, partIdentifier, false);
                Context ctx = ContextStorage.getStorageContext(session.getContextId());
                ArrayList<CommonObject> retvalList = new ArrayList<CommonObject>();
                if (versitPart.getContentType().isMimeType("text/x-vcard") || versitPart.getContentType().isMimeType("text/vcard")) {
                    VersitUtility.saveVCard(versitPart.getInputStream(), versitPart.getContentType().getBaseType(), versitPart.getContentType().containsCharsetParameter() ? versitPart.getContentType().getCharsetParameter() : MailProperties.getInstance().getDefaultMimeCharset(), retvalList, session, ctx);
                } else if (versitPart.getContentType().isMimeType("text/x-vcalendar") || versitPart.getContentType().isMimeType("text/calendar")) {
                    VersitUtility.saveICal(versitPart.getInputStream(), versitPart.getContentType().getBaseType(), versitPart.getContentType().containsCharsetParameter() ? versitPart.getContentType().getCharsetParameter() : MailProperties.getInstance().getDefaultMimeCharset(), retvalList, session, ctx);
                } else {
                    throw MailExceptionCode.UNSUPPORTED_VERSIT_ATTACHMENT.create(versitPart.getContentType());
                }
                CommonObject[] insertedObjs = retvalList.toArray(new CommonObject[retvalList.size()]);
                JSONObject jo = new JSONObject();
                for (CommonObject current : insertedObjs) {
                    jo.reset();
                    jo.put("id", current.getObjectID());
                    jo.put("folder_id", current.getParentFolderID());
                    jsonWriter.value(jo);
                }
            }
            finally {
                if (closeMailInterface && mailInterface != null) {
                    mailInterface.close(true);
                }
            }
        }
        catch (OXException e) {
            LOG.error(STR_EMPTY, (Throwable)e);
            response.setException(e);
        }
        catch (Exception e) {
            OXException wrapper = Mail.getWrappingOXException(e);
            LOG.error(STR_EMPTY, (Throwable)wrapper);
            response.setException(wrapper);
        }
        jsonWriter.endArray();
        response.setData(jsonWriter.getObject());
        response.setTimestamp(null);
        ResponseWriter.write(response, writer, Mail.localeFrom(session));
    }

    public void actionGetGetMultipleAttachments() throws OXException {
        throw MailExceptionCode.UNSUPPORTED_ACTION.create("zip_attachments", "Multiple servlet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void actionGetMultipleAttachments(HttpServletRequest req, HttpServletResponse resp) {
        ServerSession session = Mail.getSessionObject((ServletRequest)req);
        boolean outSelected = false;
        try {
            String folderPath = Mail.checkStringParam(req, PARAMETER_MAILFOLDER);
            String uid = Mail.checkStringParam(req, "id");
            String[] sequenceIds = Mail.checkStringArrayParam(req, PARAMETER_MAILATTCHMENT);
            MailServletInterface mailInterface = MailServletInterface.getInstance(session);
            ManagedFile mf = null;
            try {
                mf = mailInterface.getMessageAttachments(folderPath, uid, sequenceIds);
                String subject = mailInterface.getMessage(folderPath, uid).getSubject();
                String fileName = subject + ".zip";
                ContentType contentType = new ContentType();
                contentType.setPrimaryType("application");
                contentType.setSubType("octet-stream");
                resp.setContentType(contentType.toString());
                resp.setHeader(STR_CONTENT_DISPOSITION, Mail.getAttachmentDispositionValue(fileName, null, req.getHeader(STR_USER_AGENT)));
                Tools.removeCachingHeader(resp);
                ServletOutputStream out = resp.getOutputStream();
                outSelected = true;
                InputStream zipInputStream = mf.getInputStream();
                try {
                    int len;
                    byte[] buffer = new byte[65535];
                    while ((len = zipInputStream.read(buffer, 0, buffer.length)) > 0) {
                        out.write(buffer, 0, len);
                    }
                    out.flush();
                }
                finally {
                    zipInputStream.close();
                }
            }
            finally {
                if (mailInterface != null) {
                    mailInterface.close(true);
                }
                if (null != mf) {
                    mf.delete();
                    mf = null;
                }
            }
        }
        catch (OXException e) {
            LOG.error(STR_EMPTY, (Throwable)e);
            Mail.callbackError(resp, outSelected, true, session, e);
        }
        catch (Exception e) {
            OXException exc = Mail.getWrappingOXException(e);
            LOG.error(STR_EMPTY, (Throwable)exc);
            Mail.callbackError(resp, outSelected, true, session, exc);
        }
    }

    public void actionGetGetMultipleMessages() throws OXException {
        throw MailExceptionCode.UNSUPPORTED_ACTION.create("zip_messages", "Multiple servlet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void actionGetMultipleMessages(HttpServletRequest req, HttpServletResponse resp) {
        ServerSession session = Mail.getSessionObject((ServletRequest)req);
        boolean outSelected = false;
        try {
            String folderPath = Mail.checkStringParam(req, PARAMETER_MAILFOLDER);
            String[] ids = Mail.checkStringArrayParam(req, "id");
            MailServletInterface mailInterface = MailServletInterface.getInstance(session);
            ManagedFile mf = null;
            try {
                mf = mailInterface.getMessages(folderPath, ids);
                String fileName = "mails.zip";
                ContentType contentType = new ContentType();
                contentType.setPrimaryType("application");
                contentType.setSubType("octet-stream");
                resp.setContentType(contentType.toString());
                resp.setHeader(STR_CONTENT_DISPOSITION, Mail.getAttachmentDispositionValue("mails.zip", null, req.getHeader(STR_USER_AGENT)));
                Tools.removeCachingHeader(resp);
                ServletOutputStream out = resp.getOutputStream();
                outSelected = true;
                InputStream zipInputStream = mf.getInputStream();
                try {
                    int len;
                    byte[] buffer = new byte[65535];
                    while ((len = zipInputStream.read(buffer, 0, buffer.length)) > 0) {
                        out.write(buffer, 0, len);
                    }
                    out.flush();
                }
                finally {
                    zipInputStream.close();
                }
            }
            finally {
                if (mailInterface != null) {
                    mailInterface.close(true);
                }
                if (null != mf) {
                    mf.delete();
                    mf = null;
                }
            }
        }
        catch (OXException e) {
            LOG.error(STR_EMPTY, (Throwable)e);
            Mail.callbackError(resp, outSelected, true, session, e);
        }
        catch (Exception e) {
            OXException exc = Mail.getWrappingOXException(e);
            LOG.error(STR_EMPTY, (Throwable)exc);
            Mail.callbackError(resp, outSelected, true, session, exc);
        }
    }

    public void actionGetAttachmentToken(ServerSession session, JSONWriter writer, JSONObject requestObj, MailServletInterface mi) throws OXException, JSONException {
        ResponseWriter.write(this.actionGetAttachmentToken(session, ParamContainer.getInstance(requestObj, EnumComponent.MAIL), mi), writer, Mail.localeFrom(session));
    }

    private final void actionGetAttachmentToken(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ServerSession session = Mail.getSessionObject((ServletRequest)req);
        try {
            ResponseWriter.write(this.actionGetAttachmentToken(session, ParamContainer.getInstance(req, EnumComponent.MAIL, resp), null), resp.getWriter(), Mail.localeFrom(session));
        }
        catch (JSONException e) {
            OXException oxe = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error(STR_EMPTY, (Throwable)oxe);
            Response response = new Response();
            response.setException(oxe);
            try {
                ResponseWriter.write(response, resp.getWriter(), Mail.localeFrom(session));
            }
            catch (JSONException e1) {
                LOG.error("Error while writing response object.", (Throwable)e1);
                Mail.sendError(resp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Response actionGetAttachmentToken(ServerSession session, ParamContainer paramContainer, MailServletInterface mailInterfaceArg) throws JSONException {
        Response response = new Response(session);
        Object data = JSONObject.NULL;
        ArrayList<OXException> warnings = new ArrayList<OXException>(2);
        try {
            int ttlMillis;
            String folderPath = paramContainer.checkStringParam(PARAMETER_MAILFOLDER);
            String uid = paramContainer.checkStringParam("id");
            String sequenceId = paramContainer.getStringParam(PARAMETER_MAILATTCHMENT);
            String imageContentId = paramContainer.getStringParam(PARAMETER_MAILCID);
            if (sequenceId == null && imageContentId == null) {
                throw MailExceptionCode.MISSING_PARAM.create(PARAMETER_MAILATTCHMENT + " | " + PARAMETER_MAILCID);
            }
            String tmp = paramContainer.getStringParam("ttlMillis");
            try {
                ttlMillis = tmp == null ? -1 : Integer.parseInt(tmp.trim());
            }
            catch (NumberFormatException e) {
                ttlMillis = -1;
            }
            MailServletInterface mailInterface = mailInterfaceArg;
            boolean closeMailInterface = false;
            try {
                MailPart mailPart;
                if (mailInterface == null) {
                    mailInterface = MailServletInterface.getInstance(session);
                    closeMailInterface = true;
                }
                if ((mailPart = mailInterface.getMessageAttachment(folderPath, uid, sequenceId, true)) == null) {
                    throw MailExceptionCode.NO_ATTACHMENT_FOUND.create(sequenceId);
                }
                AttachmentToken token = new AttachmentToken(ttlMillis <= 0 ? 3600000L : (long)ttlMillis);
                token.setAccessInfo(mailInterface.getAccountID(), session);
                token.setAttachmentInfo(folderPath, uid, sequenceId);
                AttachmentTokenRegistry.getInstance().putToken(token.setOneTime(true), session);
                JSONObject attachmentObject = new JSONObject();
                attachmentObject.put("id", (Object)token.getId());
                attachmentObject.put("jsessionid", (Object)token.getJSessionId());
                data = attachmentObject;
                warnings.addAll(mailInterface.getWarnings());
            }
            finally {
                if (closeMailInterface && mailInterface != null) {
                    mailInterface.close(true);
                }
            }
        }
        catch (OXException e) {
            LOG.error(STR_EMPTY, (Throwable)e);
            response.setException(e);
        }
        catch (RuntimeException e) {
            OXException wrapper = Mail.getWrappingOXException(e);
            LOG.error(STR_EMPTY, (Throwable)wrapper);
            response.setException(wrapper);
        }
        response.setData(data);
        response.setTimestamp(null);
        if (!warnings.isEmpty()) {
            response.addWarning((OXException)((Object)warnings.get(0)));
        }
        return response;
    }

    public void actionGetAttachment() throws OXException {
        throw MailExceptionCode.UNSUPPORTED_ACTION.create(PARAMETER_MAILATTCHMENT, "Multiple servlet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void actionGetAttachment(HttpServletRequest req, HttpServletResponse resp) {
        ServerSession session = Mail.getSessionObject((ServletRequest)req);
        boolean outSelected = false;
        boolean saveToDisk = false;
        try {
            String folderPath = Mail.checkStringParam(req, PARAMETER_MAILFOLDER);
            String uid = Mail.checkStringParam(req, "id");
            String sequenceId = req.getParameter(PARAMETER_MAILATTCHMENT);
            String imageContentId = req.getParameter(PARAMETER_MAILCID);
            String saveParam = req.getParameter(PARAMETER_SAVE);
            saveToDisk = saveParam == null || saveParam.length() == 0 ? false : Integer.parseInt(saveParam) > 0;
            String filterParam = req.getParameter(PARAMETER_FILTER);
            boolean filter = Boolean.parseBoolean(filterParam) || STR_1.equals(filterParam);
            MailServletInterface mailInterface = MailServletInterface.getInstance(session);
            try {
                InputStream attachmentInputStream;
                MailPart mailPart;
                if (sequenceId == null && imageContentId == null) {
                    throw MailExceptionCode.MISSING_PARAM.create(PARAMETER_MAILATTCHMENT + " | " + PARAMETER_MAILCID);
                }
                if (imageContentId == null) {
                    mailPart = mailInterface.getMessageAttachment(folderPath, uid, sequenceId, !saveToDisk);
                    if (mailPart == null) {
                        throw MailExceptionCode.NO_ATTACHMENT_FOUND.create(sequenceId);
                    }
                    if (filter && !saveToDisk && mailPart.getContentType().isMimeType("text/htm*")) {
                        ContentType contentType = mailPart.getContentType();
                        String cs = contentType.containsCharsetParameter() ? contentType.getCharsetParameter() : MailProperties.getInstance().getDefaultMimeCharset();
                        String htmlContent = MessageUtility.readMailPart(mailPart, cs);
                        htmlContent = MessageUtility.simpleHtmlDuplicateRemoval(htmlContent);
                        HtmlService htmlService = ServerServiceRegistry.getInstance().getService(HtmlService.class);
                        attachmentInputStream = new UnsynchronizedByteArrayInputStream(Mail.sanitizeHtml(htmlContent, htmlService).getBytes(Charsets.forName((String)cs)));
                    } else {
                        attachmentInputStream = mailPart.getInputStream();
                    }
                } else {
                    mailPart = mailInterface.getMessageImage(folderPath, uid, imageContentId);
                    if (mailPart == null) {
                        throw MailExceptionCode.NO_ATTACHMENT_FOUND.create(sequenceId);
                    }
                    attachmentInputStream = mailPart.getInputStream();
                }
                String fileName = mailPart.getFileName();
                if (saveToDisk) {
                    resp.setContentType("application/octet-stream");
                    resp.setHeader("Content-Disposition", Mail.getAttachmentDispositionValue(fileName, mailPart.getContentType().getBaseType(), req.getHeader(STR_USER_AGENT)));
                } else {
                    DownloadUtility.CheckedDownload checkedDownload = DownloadUtility.checkInlineDownload(attachmentInputStream, fileName, mailPart.getContentType().toString(), req.getHeader(STR_USER_AGENT));
                    resp.setContentType(checkedDownload.getContentType());
                    resp.setHeader("Content-Disposition", checkedDownload.getContentDisposition());
                    attachmentInputStream = checkedDownload.getInputStream();
                }
                Tools.removeCachingHeader(resp);
                ServletOutputStream out = resp.getOutputStream();
                outSelected = true;
                try {
                    int len;
                    int buflen = 65535;
                    byte[] buffer = new byte[65535];
                    while ((len = attachmentInputStream.read(buffer, 0, 65535)) > 0) {
                        out.write(buffer, 0, len);
                    }
                    out.flush();
                }
                finally {
                    attachmentInputStream.close();
                }
            }
            finally {
                if (mailInterface != null) {
                    mailInterface.close(true);
                }
            }
        }
        catch (OXException e) {
            LOG.error(STR_EMPTY, (Throwable)e);
            Mail.callbackError(resp, outSelected, saveToDisk, session, e);
        }
        catch (Exception e) {
            OXException exc = Mail.getWrappingOXException(e);
            LOG.error(STR_EMPTY, (Throwable)exc);
            Mail.callbackError(resp, outSelected, saveToDisk, session, exc);
        }
    }

    private static String sanitizeHtml(String htmlContent, HtmlService htmlService) {
        return htmlService.sanitize(htmlContent, null, false, null, null);
    }

    private static void callbackError(HttpServletResponse resp, boolean outSelected, boolean saveToDisk, ServerSession session, OXException e) {
        try {
            PrintWriter writer;
            resp.setContentType(MIME_TEXT_HTML_CHARSET_UTF_8);
            if (outSelected) {
                Tools.disableCaching(resp);
                writer = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)resp.getOutputStream(), resp.getCharacterEncoding())), true);
            } else {
                writer = resp.getWriter();
            }
            resp.setHeader(STR_CONTENT_DISPOSITION, null);
            Response response = null == session ? new Response() : new Response(session);
            response.setException(e);
            ((Writer)writer).write(Mail.substituteJS(ResponseWriter.getJSON(response).toString(), "error"));
            ((Writer)writer).flush();
        }
        catch (UnsupportedEncodingException uee) {
            uee.initCause(e);
            LOG.error(STR_EMPTY, (Throwable)uee);
        }
        catch (IOException ioe) {
            ioe.initCause(e);
            LOG.error(STR_EMPTY, (Throwable)ioe);
        }
        catch (IllegalStateException ise) {
            ise.initCause(e);
            LOG.error(STR_EMPTY, (Throwable)ise);
        }
        catch (JSONException je) {
            je.initCause((Throwable)e);
            LOG.error(STR_EMPTY, (Throwable)je);
        }
    }

    private static boolean isMSIEOnWindows(String userAgent) {
        BrowserDetector browserDetector = new BrowserDetector(userAgent);
        return browserDetector.isMSIE() && browserDetector.isWindows();
    }

    private static String escapeBackslashAndQuote(String str) {
        return PAT_QUOTE.matcher(PAT_BSLASH.matcher(str).replaceAll("\\\\\\\\")).replaceAll("\\\\\\\"");
    }

    @Deprecated
    public static final String getSaveAsFileName(String fileName, boolean internetExplorer, String baseCT) {
        if (null == fileName) {
            return DEFAULT_FILENAME;
        }
        StringBuilder tmp = new StringBuilder(32);
        Matcher m = PART_FILENAME_PATTERN.matcher(fileName);
        if (m.matches()) {
            tmp.append(fileName.replaceAll(" ", "_"));
        } else {
            try {
                tmp.append(Helper.encodeFilename(fileName, STR_UTF8, internetExplorer));
            }
            catch (UnsupportedEncodingException e) {
                LOG.error("Unsupported encoding in a message detected and monitored: \"{}{}", new Object[]{STR_UTF8, Character.valueOf('\"'), e});
                MailServletInterface.mailInterfaceMonitor.addUnsupportedEncodingExceptions(STR_UTF8);
                return fileName;
            }
        }
        if (null != baseCT && null == Mail.getFileExtension(fileName)) {
            if (baseCT.regionMatches(true, 0, MIME_TEXT_PLAIN, 0, MIME_TEXT_PLAIN.length()) && !fileName.toLowerCase(Locale.US).endsWith(".txt")) {
                tmp.append(".txt");
            } else if (baseCT.regionMatches(true, 0, MIME_TEXT_HTML, 0, MIME_TEXT_HTML.length()) && !fileName.toLowerCase(Locale.US).endsWith(".html")) {
                tmp.append(".html");
            }
        }
        return Mail.escapeBackslashAndQuote(tmp.toString());
    }

    public static String getAttachmentDispositionValue(String fileName, String baseCT, String userAgent) {
        if (null == fileName) {
            return "attachment; filename=\"" + DEFAULT_FILENAME + '\"';
        }
        Matcher m = PART_FILENAME_PATTERN.matcher(fileName);
        if (m.matches()) {
            return "attachment; filename=\"" + Mail.escapeBackslashAndQuote(fileName.replaceAll(" ", "_")) + '\"';
        }
        String fn = fileName;
        if (null != baseCT && null == Mail.getFileExtension(fn)) {
            if (baseCT.regionMatches(true, 0, MIME_TEXT_PLAIN, 0, MIME_TEXT_PLAIN.length()) && !fileName.toLowerCase(Locale.US).endsWith(".txt")) {
                fn = fn + ".txt";
            } else if (baseCT.regionMatches(true, 0, MIME_TEXT_HTML, 0, MIME_TEXT_HTML.length()) && !fileName.toLowerCase(Locale.US).endsWith(".html")) {
                fn = fn + ".html";
            }
        }
        fn = Mail.escapeBackslashAndQuote(fn);
        if (null != userAgent && new BrowserDetector(userAgent).isMSIE()) {
            return "attachment; filename=\"" + Helper.encodeFilenameForIE(fn, Charsets.UTF_8) + '\"';
        }
        String foo = new String(fn.getBytes(Charsets.UTF_8), Charsets.ISO_8859_1);
        return "attachment; filename*=UTF-8''" + URLCoder.encode(fn) + "; filename=\"" + foo + '\"';
    }

    public static String getFileExtension(String fileName) {
        if (null == fileName || fileName.indexOf(46) <= 0) {
            return null;
        }
        Matcher m = P.matcher(fileName);
        return m.matches() ? m.group(1).toLowerCase(Locale.ENGLISH) : null;
    }

    public void actionPutForwardMultiple(ServerSession session, JSONWriter writer, JSONObject jsonObj, MailServletInterface mi) throws JSONException {
        ResponseWriter.write(this.actionPutForwardMultiple(session, jsonObj.getString("data"), ParamContainer.getInstance(jsonObj, EnumComponent.MAIL), mi), writer, Mail.localeFrom(session));
    }

    private final void actionPutForwardMultiple(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ServerSession session = Mail.getSessionObject((ServletRequest)req);
        try {
            ResponseWriter.write(this.actionPutForwardMultiple(session, Mail.getBody(req), ParamContainer.getInstance(req, EnumComponent.MAIL, resp), null), resp.getWriter(), Mail.localeFrom(session));
        }
        catch (JSONException e) {
            OXException oxe = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error(STR_EMPTY, (Throwable)oxe);
            Response response = new Response(session);
            response.setException(oxe);
            try {
                ResponseWriter.write(response, resp.getWriter(), Mail.localeFrom(session));
            }
            catch (JSONException e1) {
                LOG.error("Error while writing response object.", (Throwable)e1);
                Mail.sendError(resp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Response actionPutForwardMultiple(ServerSession session, String body, ParamContainer paramContainer, MailServletInterface mailInterfaceArg) throws JSONException {
        Response response = new Response(session);
        Object data = JSONObject.NULL;
        ArrayList<OXException> warnings = new ArrayList<OXException>(2);
        try {
            JSONArray paths = new JSONArray(body);
            String[] folders2 = new String[paths.length()];
            String[] ids = new String[paths.length()];
            for (int i = 0; i < folders2.length; ++i) {
                JSONObject folderAndID = paths.getJSONObject(i);
                folders2[i] = folderAndID.getString(PARAMETER_MAILFOLDER);
                ids[i] = folderAndID.getString("id");
            }
            String view = paramContainer.getStringParam(PARAMETER_VIEW);
            UserSettingMail usmNoSave = session.getUserSettingMail().clone();
            usmNoSave.setNoSave(true);
            if (null != view) {
                if (VIEW_TEXT.equals(view)) {
                    usmNoSave.setDisplayHtmlInlineContent(false);
                } else if (VIEW_TEXT_NO_HTML_ATTACHMENT.equals(view)) {
                    usmNoSave.setDisplayHtmlInlineContent(false);
                    usmNoSave.setSuppressHTMLAlternativePart(true);
                } else if (VIEW_HTML.equals(view)) {
                    usmNoSave.setDisplayHtmlInlineContent(true);
                    usmNoSave.setAllowHTMLImages(true);
                } else if (VIEW_HTML_BLOCKED_IMAGES.equals(view)) {
                    usmNoSave.setDisplayHtmlInlineContent(true);
                    usmNoSave.setAllowHTMLImages(false);
                } else {
                    LOG.warn("Unknown value in parameter {}: {}. Using user's mail settings as fallback.", (Object)PARAMETER_VIEW, (Object)view);
                }
            }
            MailServletInterface mailInterface = mailInterfaceArg;
            boolean closeMailInterface = false;
            try {
                if (mailInterface == null) {
                    mailInterface = MailServletInterface.getInstance(session);
                    closeMailInterface = true;
                }
                data = MessageWriter.writeMailMessage(mailInterface.getAccountID(), mailInterface.getForwardMessageForDisplay(folders2, ids, usmNoSave), DisplayMode.MODIFYABLE, false, session, usmNoSave, warnings, false, -1);
            }
            finally {
                if (closeMailInterface && mailInterface != null) {
                    mailInterface.close(true);
                }
            }
        }
        catch (OXException e) {
            LOG.error(STR_EMPTY, (Throwable)e);
            response.setException(e);
        }
        catch (Exception e) {
            OXException wrapper = Mail.getWrappingOXException(e);
            LOG.error(STR_EMPTY, (Throwable)wrapper);
            response.setException(wrapper);
        }
        response.setData(data);
        response.setTimestamp(null);
        if (!warnings.isEmpty()) {
            response.addWarning((OXException)((Object)warnings.get(0)));
        }
        return response;
    }

    public void actionPutReply(ServerSession session, boolean replyAll, JSONWriter writer, JSONObject jsonObj, MailServletInterface mi) throws JSONException {
        ResponseWriter.write(this.actionPutReply(session, jsonObj.getString("data"), ParamContainer.getInstance(jsonObj, EnumComponent.MAIL), replyAll, mi), writer, Mail.localeFrom(session));
    }

    private final void actionPutReply(HttpServletRequest req, HttpServletResponse resp, boolean replyAll) throws IOException {
        ServerSession session = Mail.getSessionObject((ServletRequest)req);
        try {
            ResponseWriter.write(this.actionPutReply(session, Mail.getBody(req), ParamContainer.getInstance(req, EnumComponent.MAIL, resp), replyAll, null), resp.getWriter(), Mail.localeFrom(session));
        }
        catch (JSONException e) {
            OXException oxe = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error(STR_EMPTY, (Throwable)oxe);
            Response response = new Response(session);
            response.setException(oxe);
            try {
                ResponseWriter.write(response, resp.getWriter(), Mail.localeFrom(session));
            }
            catch (JSONException e1) {
                LOG.error("Error while writing response object.", (Throwable)e1);
                Mail.sendError(resp);
            }
        }
    }

    private final Response actionPutReply(ServerSession session, String body, ParamContainer paramContainer, boolean replyAll, MailServletInterface mailInterfaceArg) throws JSONException {
        JSONArray paths = new JSONArray(body);
        int length = paths.length();
        if (length != 1) {
            throw new IllegalArgumentException("JSON array's length is not 1");
        }
        HashMap<String, String> map = Collections.newHashMap(8);
        for (String name : paramContainer.getParameterNames()) {
            try {
                map.put(name, paramContainer.getStringParam(name));
            }
            catch (OXException e) {
                LOG.warn(STR_EMPTY, (Throwable)e);
            }
        }
        for (int i = 0; i < length; ++i) {
            JSONObject folderAndID = paths.getJSONObject(i);
            map.put(PARAMETER_MAILFOLDER, folderAndID.getString(PARAMETER_MAILFOLDER));
            map.put("id", folderAndID.get("id").toString());
        }
        return this.actionGetReply(session, replyAll, ParamContainer.getInstance(map, EnumComponent.MAIL), mailInterfaceArg);
    }

    public void actionPutGet(ServerSession session, JSONWriter writer, JSONObject jsonObj, MailServletInterface mi) throws JSONException {
        ResponseWriter.write(this.actionPutGet(session, jsonObj.getString("data"), ParamContainer.getInstance(jsonObj, EnumComponent.MAIL), mi), writer, Mail.localeFrom(session));
    }

    private final void actionPutGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ServerSession session = Mail.getSessionObject((ServletRequest)req);
        try {
            ResponseWriter.write(this.actionPutGet(session, Mail.getBody(req), ParamContainer.getInstance(req, EnumComponent.MAIL, resp), null), resp.getWriter(), Mail.localeFrom(session));
        }
        catch (JSONException e) {
            OXException oxe = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error(STR_EMPTY, (Throwable)oxe);
            Response response = new Response(session);
            response.setException(oxe);
            try {
                ResponseWriter.write(response, resp.getWriter(), Mail.localeFrom(session));
            }
            catch (JSONException e1) {
                LOG.error("Error while writing response object.", (Throwable)e1);
                Mail.sendError(resp);
            }
        }
    }

    private final Response actionPutGet(ServerSession session, String body, ParamContainer paramContainer, MailServletInterface mailInterfaceArg) throws JSONException {
        JSONArray paths = new JSONArray(body);
        int length = paths.length();
        if (length != 1) {
            throw new IllegalArgumentException("JSON array's length is not 1");
        }
        HashMap<String, String> map = Collections.newHashMap(2);
        for (int i = 0; i < length; ++i) {
            JSONObject folderAndID = paths.getJSONObject(i);
            map.put(PARAMETER_MAILFOLDER, folderAndID.getString(PARAMETER_MAILFOLDER));
            map.put("id", folderAndID.get("id").toString());
        }
        try {
            String tmp = paramContainer.getStringParam("src");
            if (STR_1.equals(tmp) || Boolean.parseBoolean(tmp)) {
                map.put("src", tmp);
            }
            if (STR_1.equals(tmp = paramContainer.getStringParam(PARAMETER_EDIT_DRAFT)) || Boolean.parseBoolean(tmp)) {
                map.put(PARAMETER_EDIT_DRAFT, tmp);
            }
            if (STR_1.equals(tmp = paramContainer.getStringParam(PARAMETER_SHOW_HEADER)) || Boolean.parseBoolean(tmp)) {
                map.put(PARAMETER_SHOW_HEADER, tmp);
            }
            if ((tmp = paramContainer.getStringParam(PARAMETER_SAVE)) != null && tmp.length() > 0 && Integer.parseInt(tmp) > 0) {
                map.put(PARAMETER_SAVE, tmp);
            }
            if ((tmp = paramContainer.getStringParam(PARAMETER_VIEW)) != null) {
                map.put(PARAMETER_VIEW, tmp);
            }
            if ((tmp = paramContainer.getStringParam(PARAMETER_UNSEEN)) != null) {
                map.put(PARAMETER_UNSEEN, tmp);
            }
            tmp = null;
        }
        catch (OXException e) {
            Response response = new Response(session);
            response.setException(e);
            return response;
        }
        return this.actionGetMessage(session, ParamContainer.getInstance(map, EnumComponent.MAIL), mailInterfaceArg);
    }

    public void actionPutAutosave(ServerSession session, JSONWriter writer, JSONObject jsonObj, MailServletInterface mi) throws JSONException {
        ResponseWriter.write(this.actionPutAutosave(session, jsonObj.getString("data"), ParamContainer.getInstance(jsonObj, EnumComponent.MAIL), mi), writer, Mail.localeFrom(session));
    }

    private final void actionPutAutosave(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ServerSession session = Mail.getSessionObject((ServletRequest)req);
        try {
            ResponseWriter.write(this.actionPutAutosave(session, Mail.getBody(req), ParamContainer.getInstance(req, EnumComponent.MAIL, resp), null), resp.getWriter(), Mail.localeFrom(session));
        }
        catch (JSONException e) {
            OXException oxe = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error(STR_EMPTY, (Throwable)oxe);
            Response response = new Response(session);
            response.setException(oxe);
            try {
                ResponseWriter.write(response, resp.getWriter(), Mail.localeFrom(session));
            }
            catch (JSONException e1) {
                LOG.error("Error while writing response object.", (Throwable)e1);
                Mail.sendError(resp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Response actionPutAutosave(ServerSession session, String body, ParamContainer paramContainer, MailServletInterface mailInterfaceArg) throws JSONException {
        Response response = new Response(session);
        try {
            MailServletInterface mailInterface = mailInterfaceArg;
            boolean closeMailInterface = false;
            try {
                int accountId;
                if (mailInterface == null) {
                    mailInterface = MailServletInterface.getInstance(session);
                    closeMailInterface = true;
                }
                String msgIdentifier = null;
                JSONObject jsonMailObj = new JSONObject(body);
                ArrayList<OXException> warnings = new ArrayList<OXException>();
                ComposedMailMessage composedMail = MessageParser.parse4Draft(jsonMailObj, null, session, 0, warnings);
                response.addWarnings(warnings);
                if ((composedMail.getFlags() & 4) == 0) {
                    LOG.warn("Missing \\Draft flag on action=autosave in JSON message object", new Throwable());
                    composedMail.setFlag(4, true);
                }
                if ((composedMail.getFlags() & 4) == 4) {
                    accountId = composedMail.containsFrom() ? Mail.resolveFrom2Account(session, composedMail.getFrom()[0], false, true) : 0;
                    if (mailInterface.getDraftsFolder(accountId) == null) {
                        if (0 == accountId) {
                            throw MailExceptionCode.FOLDER_NOT_FOUND.create("Drafts");
                        }
                        LOG.warn("Mail account {} for user {} in context {} has no drafts folder. Saving draft to default account's draft folder.", new Object[]{accountId, session.getUserId(), session.getContextId()});
                        accountId = 0;
                        composedMail.setFolder(mailInterface.getDraftsFolder(accountId));
                    }
                } else {
                    throw MailExceptionCode.UNEXPECTED_ERROR.create("No new message on action=edit");
                }
                msgIdentifier = mailInterface.saveDraft(composedMail, true, accountId);
                if (msgIdentifier == null) {
                    throw MailExceptionCode.SEND_FAILED_UNKNOWN.create();
                }
                response.setData(msgIdentifier);
            }
            finally {
                if (closeMailInterface && mailInterface != null) {
                    mailInterface.close(true);
                }
            }
        }
        catch (OXException e) {
            if (MimeMailExceptionCode.INVALID_EMAIL_ADDRESS.equals(e)) {
                e.setCategory(Category.CATEGORY_USER_INPUT);
                LOG.warn(STR_EMPTY, (Throwable)e);
            } else {
                LOG.error(STR_EMPTY, (Throwable)e);
            }
            response.setException(e);
        }
        catch (Exception e) {
            OXException wrapper = Mail.getWrappingOXException(e);
            LOG.error(STR_EMPTY, (Throwable)wrapper);
            response.setException(wrapper);
        }
        response.setTimestamp(null);
        return response;
    }

    public void actionPutClear(ServerSession session, JSONWriter writer, JSONObject jsonObj, MailServletInterface mi) throws JSONException {
        ResponseWriter.write(this.actionPutClear(session, jsonObj.getString("data"), ParamContainer.getInstance(jsonObj, EnumComponent.MAIL), mi), writer, Mail.localeFrom(session));
    }

    private final void actionPutClear(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ServerSession session = Mail.getSessionObject((ServletRequest)req);
        try {
            ResponseWriter.write(this.actionPutClear(session, Mail.getBody(req), ParamContainer.getInstance(req, EnumComponent.MAIL, resp), null), resp.getWriter(), Mail.localeFrom(session));
        }
        catch (JSONException e) {
            OXException oxe = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error(STR_EMPTY, (Throwable)oxe);
            Response response = new Response(session);
            response.setException(oxe);
            try {
                ResponseWriter.write(response, resp.getWriter(), Mail.localeFrom(session));
            }
            catch (JSONException e1) {
                LOG.error("Error while writing response object.", (Throwable)e1);
                Mail.sendError(resp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Response actionPutClear(ServerSession session, String body, ParamContainer paramContainer, MailServletInterface mailInterfaceArg) throws JSONException {
        OXJSONWriter jsonWriter;
        Response response;
        block9: {
            response = new Response(session);
            jsonWriter = new OXJSONWriter();
            jsonWriter.array();
            try {
                JSONArray ja = new JSONArray(body);
                int length = ja.length();
                if (length <= 0) break block9;
                MailServletInterface mailInterface = mailInterfaceArg;
                boolean closeMailInterface = false;
                try {
                    if (mailInterface == null) {
                        mailInterface = MailServletInterface.getInstance(session);
                        closeMailInterface = true;
                    }
                    for (int i = 0; i < length; ++i) {
                        String folderId = ja.getString(i);
                        if (mailInterface.clearFolder(folderId)) continue;
                        jsonWriter.value(folderId);
                    }
                }
                finally {
                    if (closeMailInterface && mailInterface != null) {
                        mailInterface.close(true);
                    }
                }
            }
            catch (OXException e) {
                LOG.error(STR_EMPTY, (Throwable)e);
                response.setException(e);
            }
            catch (Exception e) {
                OXException wrapper = Mail.getWrappingOXException(e);
                LOG.error(STR_EMPTY, (Throwable)wrapper);
                response.setException(wrapper);
            }
        }
        jsonWriter.endArray();
        response.setData(jsonWriter.getObject());
        response.setTimestamp(null);
        return response;
    }

    public void actionPutMailSearch(ServerSession session, JSONWriter writer, JSONObject jsonObj, MailServletInterface mi) throws JSONException, OXException {
        ResponseWriter.write(this.actionPutMailSearch(session, jsonObj.getString("data"), ParamContainer.getInstance(jsonObj, EnumComponent.MAIL), mi), writer, Mail.localeFrom(session));
    }

    private final void actionPutMailSearch(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ServerSession session = Mail.getSessionObject((ServletRequest)req);
        try {
            ResponseWriter.write(this.actionPutMailSearch(session, Mail.getBody(req), ParamContainer.getInstance(req, EnumComponent.MAIL, resp), null), resp.getWriter(), Mail.localeFrom(session));
        }
        catch (JSONException e) {
            OXException oxe = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error(STR_EMPTY, (Throwable)oxe);
            Response response = new Response(session);
            response.setException(oxe);
            try {
                ResponseWriter.write(response, resp.getWriter(), Mail.localeFrom(session));
            }
            catch (JSONException e1) {
                LOG.error("Error while writing response object.", (Throwable)e1);
                Mail.sendError(resp);
            }
        }
        catch (OXException e) {
            LOG.error(STR_EMPTY, (Throwable)e);
            Response response = new Response(session);
            response.setException(e);
            try {
                ResponseWriter.write(response, resp.getWriter(), Mail.localeFrom(session));
            }
            catch (JSONException e1) {
                LOG.error("Error while writing response object.", (Throwable)e1);
                Mail.sendError(resp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Response actionPutMailSearch(ServerSession session, String body, ParamContainer paramContainer, MailServletInterface mailInterfaceArg) throws JSONException, OXException {
        OXJSONWriter jsonWriter;
        Response response;
        block43: {
            response = new Response(session);
            jsonWriter = new OXJSONWriter();
            jsonWriter.array();
            SearchIterator<MailMessage> it = null;
            try {
                JSONArray searchValue;
                String folderId = paramContainer.checkStringParam(PARAMETER_MAILFOLDER);
                int[] columns = paramContainer.checkIntArrayParam("columns");
                String sort = paramContainer.getStringParam("sort");
                String order = paramContainer.getStringParam("order");
                if (sort != null && order == null) {
                    throw MailExceptionCode.MISSING_PARAM.create("order");
                }
                if (Mail.startsWith('[', body, true)) {
                    searchValue = new JSONArray(body);
                } else if (Mail.startsWith('{', body, true)) {
                    searchValue = new JSONObject(body);
                } else {
                    throw new JSONException(MessageFormat.format("Request body is not a JSON value: {0}", body));
                }
                String s = paramContainer.getStringParam("timezone");
                TimeZone timeZone = Mail.isEmpty(s) ? null : TimeZoneUtils.getTimeZone(s.trim());
                s = null;
                if (searchValue.isArray()) {
                    JSONArray ja = searchValue.toArray();
                    int length = ja.length();
                    if (length <= 0) break block43;
                    int[] searchCols = new int[length];
                    String[] searchPats = new String[length];
                    for (int i = 0; i < length; ++i) {
                        JSONObject tmp = ja.getJSONObject(i);
                        searchCols[i] = tmp.getInt(PARAMETER_COL);
                        searchPats[i] = tmp.getString("pattern");
                    }
                    MailServletInterface mailInterface = mailInterfaceArg;
                    boolean closeMailInterface = false;
                    try {
                        if (mailInterface == null) {
                            mailInterface = MailServletInterface.getInstance(session);
                            closeMailInterface = true;
                        }
                        MessageWriter.MailFieldWriter[] writers = MessageWriter.getMailFieldWriter(MailListField.getFields(columns));
                        int userId = session.getUserId();
                        int contextId = session.getContextId();
                        int orderDir = OrderDirection.ASC.getOrder();
                        if (order != null) {
                            if (order.equalsIgnoreCase(STR_ASC)) {
                                orderDir = OrderDirection.ASC.getOrder();
                            } else if (order.equalsIgnoreCase(STR_DESC)) {
                                orderDir = OrderDirection.DESC.getOrder();
                            } else {
                                throw MailExceptionCode.INVALID_INT_VALUE.create("order");
                            }
                        }
                        if (STR_THREAD.equalsIgnoreCase(sort)) {
                            it = mailInterface.getThreadedMessages(folderId, null, MailSortField.RECEIVED_DATE.getField(), orderDir, searchCols, searchPats, true, columns);
                            int size = it.size();
                            for (int i = 0; i < size; ++i) {
                                MailMessage mail = (MailMessage)it.next();
                                if (mail == null || mail.isDeleted()) continue;
                                JSONArray arr = new JSONArray();
                                for (MessageWriter.MailFieldWriter writer : writers) {
                                    writer.writeField((JSONValue)arr, mail, 0, false, mailInterface.getAccountID(), userId, contextId, timeZone);
                                }
                                jsonWriter.value(arr);
                            }
                        } else {
                            int sortCol = sort == null ? MailListField.RECEIVED_DATE.getField() : Integer.parseInt(sort);
                            it = mailInterface.getMessages(folderId, null, sortCol, orderDir, searchCols, searchPats, true, columns);
                            int size = it.size();
                            for (int i = 0; i < size; ++i) {
                                MailMessage mail = (MailMessage)it.next();
                                if (mail == null || mail.isDeleted()) continue;
                                JSONArray arr = new JSONArray();
                                for (MessageWriter.MailFieldWriter writer : writers) {
                                    writer.writeField((JSONValue)arr, mail, 0, false, mailInterface.getAccountID(), userId, contextId, timeZone);
                                }
                                jsonWriter.value(arr);
                            }
                        }
                        break block43;
                    }
                    finally {
                        if (closeMailInterface && mailInterface != null) {
                            mailInterface.close(true);
                        }
                    }
                }
                JSONArray searchArray = searchValue.toObject().getJSONArray(PARAMETER_FILTER);
                MailServletInterface mailInterface = mailInterfaceArg;
                boolean closeMailInterface = false;
                try {
                    if (mailInterface == null) {
                        mailInterface = MailServletInterface.getInstance(session);
                        closeMailInterface = true;
                    }
                    MessageWriter.MailFieldWriter[] writers = MessageWriter.getMailFieldWriter(MailListField.getFields(columns));
                    int userId = session.getUserId();
                    int contextId = session.getContextId();
                    int orderDir = OrderDirection.ASC.getOrder();
                    if (order != null) {
                        if (order.equalsIgnoreCase(STR_ASC)) {
                            orderDir = OrderDirection.ASC.getOrder();
                        } else if (order.equalsIgnoreCase(STR_DESC)) {
                            orderDir = OrderDirection.DESC.getOrder();
                        } else {
                            throw MailExceptionCode.INVALID_INT_VALUE.create("order");
                        }
                    }
                    int sortCol = sort == null ? MailListField.RECEIVED_DATE.getField() : Integer.parseInt(sort);
                    it = mailInterface.getMessages(folderId, null, sortCol, orderDir, SearchTermParser.parse(searchArray), true, columns);
                    int size = it.size();
                    for (int i = 0; i < size; ++i) {
                        MailMessage mail = (MailMessage)it.next();
                        JSONArray arr = new JSONArray();
                        for (MessageWriter.MailFieldWriter writer : writers) {
                            writer.writeField((JSONValue)arr, mail, 0, false, mailInterface.getAccountID(), userId, contextId, timeZone);
                        }
                        jsonWriter.value(arr);
                    }
                }
                finally {
                    if (closeMailInterface && mailInterface != null) {
                        mailInterface.close(true);
                    }
                }
            }
            catch (OXException e) {
                LOG.error(STR_EMPTY, (Throwable)e);
                response.setException(e);
            }
            catch (Exception e) {
                OXException wrapper = Mail.getWrappingOXException(e);
                LOG.error(STR_EMPTY, (Throwable)wrapper);
                response.setException(wrapper);
            }
            finally {
                if (it != null) {
                    it.close();
                }
            }
        }
        jsonWriter.endArray();
        response.setData(jsonWriter.getObject());
        response.setTimestamp(null);
        return response;
    }

    public void actionPutMailList(ServerSession session, JSONWriter writer, JSONObject jsonObj, MailServletInterface mi) throws JSONException {
        ResponseWriter.write(this.actionPutMailList(session, jsonObj.getString("data"), ParamContainer.getInstance(jsonObj, EnumComponent.MAIL), mi), writer, Mail.localeFrom(session));
    }

    private final void actionPutMailList(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ServerSession session = Mail.getSessionObject((ServletRequest)req);
        try {
            ResponseWriter.write(this.actionPutMailList(session, Mail.getBody(req), ParamContainer.getInstance(req, EnumComponent.MAIL, resp), null), resp.getWriter(), Mail.localeFrom(session));
        }
        catch (JSONException e) {
            OXException oxe = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error(STR_EMPTY, (Throwable)oxe);
            Response response = new Response(session);
            response.setException(oxe);
            try {
                ResponseWriter.write(response, resp.getWriter(), Mail.localeFrom(session));
            }
            catch (JSONException e1) {
                LOG.error("Error while writing response object.", (Throwable)e1);
                Mail.sendError(resp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Response actionPutMailList(ServerSession session, String body, ParamContainer paramContainer, MailServletInterface mailInterfaceArg) throws JSONException {
        Response response = new Response(session);
        OXJSONWriter jsonWriter = new OXJSONWriter();
        jsonWriter.array();
        try {
            int[] columns = paramContainer.checkIntArrayParam("columns");
            String tmp = paramContainer.getStringParam(PARAMETER_HEADERS);
            String[] headers = null == tmp ? null : SPLIT.split(tmp, 0);
            tmp = paramContainer.getStringParam("timezone");
            TimeZone timeZone = Mail.isEmpty(tmp) ? null : TimeZoneUtils.getTimeZone(tmp.trim());
            tmp = null;
            MessageWriter.MailFieldWriter[] writers = MessageWriter.getMailFieldWriter(MailListField.getFields(columns));
            MessageWriter.MailFieldWriter[] headerWriters = null == headers ? null : MessageWriter.getHeaderFieldWriter(headers);
            Map<String, List<String>> idMap = Mail.fillMapByArray(new JSONArray(body));
            if (idMap.isEmpty()) {
                LOG.debug("Empty JSON array detected in request body.", new Throwable());
                Response r = new Response(session);
                r.setData(EMPTY_JSON_ARR);
                return r;
            }
            MailServletInterface mailInterface = mailInterfaceArg;
            boolean closeMailInterface = false;
            try {
                if (mailInterface == null) {
                    mailInterface = MailServletInterface.getInstance(session);
                    closeMailInterface = true;
                }
                int userId = session.getUserId();
                int contextId = session.getContextId();
                for (Map.Entry<String, List<String>> entry : idMap.entrySet()) {
                    MailMessage[] mails = mailInterface.getMessageList(entry.getKey(), Mail.toArray((Collection<String>)entry.getValue()), columns, headers);
                    int accountID = mailInterface.getAccountID();
                    for (MailMessage mail : mails) {
                        int j;
                        if (mail == null) continue;
                        JSONArray ja = new JSONArray();
                        for (j = 0; j < writers.length; ++j) {
                            writers[j].writeField((JSONValue)ja, mail, 0, false, accountID, userId, contextId, timeZone);
                        }
                        if (null != headerWriters) {
                            for (j = 0; j < headerWriters.length; ++j) {
                                headerWriters[j].writeField((JSONValue)ja, mail, 0, false, accountID, userId, contextId, timeZone);
                            }
                        }
                        jsonWriter.value(ja);
                    }
                }
            }
            finally {
                if (closeMailInterface && mailInterface != null) {
                    mailInterface.close(true);
                }
            }
        }
        catch (OXException e) {
            LOG.error(STR_EMPTY, (Throwable)e);
            response.setException(e);
        }
        catch (Exception e) {
            OXException wrapper = Mail.getWrappingOXException(e);
            LOG.error(STR_EMPTY, (Throwable)wrapper);
            response.setException(wrapper);
        }
        jsonWriter.endArray();
        response.setData(jsonWriter.getObject());
        response.setTimestamp(null);
        return response;
    }

    private static String[] toArray(Collection<String> c) {
        return c.toArray(new String[c.size()]);
    }

    private static final Map<String, List<String>> fillMapByArray(JSONArray idArray) throws JSONException, OXException {
        int length = idArray.length();
        if (length <= 0) {
            return java.util.Collections.emptyMap();
        }
        HashMap<String, List<String>> idMap = Collections.newHashMap(4);
        String parameterFolderId = PARAMETER_MAILFOLDER;
        String parameterId = "id";
        JSONObject idObject = idArray.getJSONObject(0);
        String folder = Mail.ensureString(PARAMETER_MAILFOLDER, idObject);
        List<String> list = new ArrayList<String>(length);
        idMap.put(folder, list);
        list.add(Mail.ensureString("id", idObject));
        for (int i = 1; i < length; ++i) {
            JSONObject idObject2 = idArray.getJSONObject(i);
            String fld = Mail.ensureString(PARAMETER_MAILFOLDER, idObject2);
            if (!folder.equals(fld)) {
                folder = fld;
                List tmp = (List)idMap.get(folder);
                if (tmp == null) {
                    list = new ArrayList(length);
                    idMap.put(folder, list);
                } else {
                    list = tmp;
                }
            }
            list.add(Mail.ensureString("id", idObject2));
        }
        return idMap;
    }

    private static String ensureString(String key, JSONObject jo) throws OXException {
        if (!jo.hasAndNotNull(key)) {
            throw MailExceptionCode.MISSING_PARAMETER.create(key);
        }
        return jo.optString(key);
    }

    public void actionPutDeleteMails(ServerSession session, JSONWriter writer, JSONObject jsonObj, MailServletInterface mi) throws JSONException {
        ResponseWriter.write(this.actionPutDeleteMails(session, jsonObj.getString("data"), ParamContainer.getInstance(jsonObj, EnumComponent.MAIL), mi), writer, Mail.localeFrom(session));
    }

    private final void actionPutDeleteMails(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ServerSession session = Mail.getSessionObject((ServletRequest)req);
        try {
            ResponseWriter.write(this.actionPutDeleteMails(session, Mail.getBody(req), ParamContainer.getInstance(req, EnumComponent.MAIL, resp), null), resp.getWriter(), Mail.localeFrom(session));
        }
        catch (JSONException e) {
            OXException oxe = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error(STR_EMPTY, (Throwable)oxe);
            Response response = new Response(session);
            response.setException(oxe);
            try {
                ResponseWriter.write(response, resp.getWriter(), Mail.localeFrom(session));
            }
            catch (JSONException e1) {
                LOG.error("Error while writing response object.", (Throwable)e1);
                Mail.sendError(resp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Response actionPutDeleteMails(ServerSession session, String body, ParamContainer paramContainer, MailServletInterface mailInterfaceArg) throws JSONException {
        Response response = new Response(session);
        OXJSONWriter jsonWriter = new OXJSONWriter();
        jsonWriter.array();
        try {
            boolean hardDelete = STR_1.equals(paramContainer.getStringParam("harddelete"));
            JSONArray jsonIDs = new JSONArray(body);
            MailServletInterface mailInterface = mailInterfaceArg;
            boolean closeMailInterface = false;
            try {
                int length;
                if (mailInterface == null) {
                    mailInterface = MailServletInterface.getInstance(session);
                    closeMailInterface = true;
                }
                if ((length = jsonIDs.length()) > 0) {
                    ArrayList<MailPath> l = new ArrayList<MailPath>(length);
                    for (int i = 0; i < length; ++i) {
                        JSONObject obj = jsonIDs.getJSONObject(i);
                        FullnameArgument fa = MailFolderUtility.prepareMailFolderParam(obj.getString(PARAMETER_MAILFOLDER));
                        l.add(new MailPath(fa.getAccountId(), fa.getFullname(), obj.getString("id")));
                    }
                    java.util.Collections.sort(l, MailPath.COMPARATOR);
                    String lastFldArg = ((MailPath)l.get(0)).getFolderArgument();
                    ArrayList<String> arr = new ArrayList<String>(length);
                    for (int i = 0; i < length; ++i) {
                        MailPath current = (MailPath)l.get(i);
                        String folderArgument = current.getFolderArgument();
                        if (!lastFldArg.equals(folderArgument)) {
                            String[] uids = arr.toArray(new String[arr.size()]);
                            mailInterface.deleteMessages(lastFldArg, uids, hardDelete);
                            arr.clear();
                            lastFldArg = folderArgument;
                        }
                        arr.add(current.getMailID());
                    }
                    if (arr.size() > 0) {
                        String[] uids = arr.toArray(new String[arr.size()]);
                        mailInterface.deleteMessages(lastFldArg, uids, hardDelete);
                    }
                }
            }
            finally {
                if (closeMailInterface && mailInterface != null) {
                    mailInterface.close(true);
                }
            }
        }
        catch (OXException e) {
            LOG.error(STR_EMPTY, (Throwable)e);
            response.setException(e);
        }
        catch (Exception e) {
            OXException wrapper = Mail.getWrappingOXException(e);
            LOG.error(STR_EMPTY, (Throwable)wrapper);
            response.setException(wrapper);
        }
        jsonWriter.endArray();
        response.setData(jsonWriter.getObject());
        response.setTimestamp(null);
        return response;
    }

    public void actionPutUpdateMail(ServerSession session, JSONWriter writer, JSONObject jsonObj, MailServletInterface mailInterface) throws JSONException {
        ResponseWriter.write(this.actionPutUpdateMail(session, jsonObj.getString("data"), ParamContainer.getInstance(jsonObj, EnumComponent.MAIL), mailInterface), writer, Mail.localeFrom(session));
    }

    private final void actionPutUpdateMail(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ServerSession session = Mail.getSessionObject((ServletRequest)req);
        try {
            ResponseWriter.write(this.actionPutUpdateMail(session, Mail.getBody(req), ParamContainer.getInstance(req, EnumComponent.MAIL, resp), null), resp.getWriter(), Mail.localeFrom(session));
        }
        catch (JSONException e) {
            OXException oxe = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error(STR_EMPTY, (Throwable)oxe);
            Response response = new Response(session);
            response.setException(oxe);
            try {
                ResponseWriter.write(response, resp.getWriter(), Mail.localeFrom(session));
            }
            catch (JSONException e1) {
                LOG.error("Error while writing response object.", (Throwable)e1);
                Mail.sendError(resp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Response actionPutUpdateMail(ServerSession session, String body, ParamContainer paramContainer, MailServletInterface mailIntefaceArg) throws JSONException {
        Response response = new Response(session);
        OXJSONWriter jsonWriter = new OXJSONWriter();
        jsonWriter.object();
        try {
            String sourceFolder = paramContainer.checkStringParam(PARAMETER_MAILFOLDER);
            JSONObject bodyObj = new JSONObject(body);
            String destFolder = bodyObj.hasAndNotNull("folder_id") ? bodyObj.getString("folder_id") : null;
            Integer colorLabel = bodyObj.hasAndNotNull("color_label") ? Integer.valueOf(bodyObj.getInt("color_label")) : null;
            Integer flagBits = bodyObj.hasAndNotNull(MailJSONField.FLAGS.getKey()) ? Integer.valueOf(bodyObj.getInt(MailJSONField.FLAGS.getKey())) : null;
            boolean flagVal = false;
            if (flagBits != null) {
                flagVal = bodyObj.has(MailJSONField.VALUE.getKey()) && !bodyObj.isNull(MailJSONField.VALUE.getKey()) ? bodyObj.getBoolean(MailJSONField.VALUE.getKey()) : false;
            }
            Integer setFlags = bodyObj.hasAndNotNull("set_flags") ? Integer.valueOf(bodyObj.getInt("set_flags")) : null;
            Integer clearFlags = bodyObj.hasAndNotNull("clear_flags") ? Integer.valueOf(bodyObj.getInt("clear_flags")) : null;
            MailServletInterface mailInterface = mailIntefaceArg;
            boolean closeMailInterface = false;
            try {
                String tmp;
                if (mailInterface == null) {
                    mailInterface = MailServletInterface.getInstance(session);
                    closeMailInterface = true;
                }
                Object uid = null == (tmp = paramContainer.getStringParam("id")) ? (null == (tmp = paramContainer.getStringParam(PARAMETER_MESSAGE_ID)) ? null : mailInterface.getMailIDByMessageID(sourceFolder, tmp)) : tmp;
                String folderId = sourceFolder;
                String mailId = uid;
                if (colorLabel != null) {
                    String[] stringArray;
                    if (uid == null) {
                        stringArray = null;
                    } else {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = uid;
                    }
                    mailInterface.updateMessageColorLabel(sourceFolder, stringArray, colorLabel);
                }
                if (flagBits != null) {
                    String[] stringArray;
                    if (uid == null) {
                        stringArray = null;
                    } else {
                        String[] stringArray3 = new String[1];
                        stringArray = stringArray3;
                        stringArray3[0] = uid;
                    }
                    mailInterface.updateMessageFlags(sourceFolder, stringArray, flagBits, flagVal);
                }
                if (setFlags != null) {
                    String[] stringArray;
                    if (uid == null) {
                        stringArray = null;
                    } else {
                        String[] stringArray4 = new String[1];
                        stringArray = stringArray4;
                        stringArray4[0] = uid;
                    }
                    mailInterface.updateMessageFlags(sourceFolder, stringArray, setFlags, true);
                }
                if (clearFlags != null) {
                    String[] stringArray;
                    if (uid == null) {
                        stringArray = null;
                    } else {
                        String[] stringArray5 = new String[1];
                        stringArray = stringArray5;
                        stringArray5[0] = uid;
                    }
                    mailInterface.updateMessageFlags(sourceFolder, stringArray, clearFlags, false);
                }
                if (destFolder != null) {
                    mailId = mailInterface.copyMessages(sourceFolder, destFolder, new String[]{uid}, true)[0];
                    folderId = destFolder;
                }
                jsonWriter.key("folder_id").value((Object)folderId);
                jsonWriter.key("id").value((Object)mailId);
            }
            finally {
                if (closeMailInterface && mailInterface != null) {
                    mailInterface.close(true);
                }
            }
        }
        catch (OXException e) {
            LOG.error(STR_EMPTY, (Throwable)e);
            response.setException(e);
        }
        catch (Exception e) {
            OXException wrapper = Mail.getWrappingOXException(e);
            LOG.error(STR_EMPTY, (Throwable)wrapper);
            response.setException(wrapper);
        }
        jsonWriter.endObject();
        response.setData(jsonWriter.getObject());
        response.setTimestamp(null);
        return response;
    }

    private final void actionPutNewMail(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ServerSession session = Mail.getSessionObject((ServletRequest)req);
        try {
            ResponseWriter.write(this.actionPutNewMail(session, req, ParamContainer.getInstance(req, EnumComponent.MAIL, resp)), resp.getWriter(), Mail.localeFrom(session));
        }
        catch (JSONException e) {
            OXException oxe = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error(STR_EMPTY, (Throwable)oxe);
            Response response = new Response(session);
            response.setException(oxe);
            try {
                ResponseWriter.write(response, resp.getWriter(), Mail.localeFrom(session));
            }
            catch (JSONException e1) {
                LOG.error("Error while writing response object.", (Throwable)e1);
                Mail.sendError(resp);
            }
        }
    }

    private final void actionPostImportMail(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Tools.disableCaching(resp);
        resp.setContentType("text/javascript; charset=UTF-8");
        ServerSession session = Mail.getSessionObject((ServletRequest)req);
        Response response = this.actionPostImportMail(session, req, ParamContainer.getInstance(req, EnumComponent.MAIL, resp));
        try {
            ResponseWriter.write(response, resp.getWriter(), Mail.localeFrom(session));
        }
        catch (JSONException e) {
            OXException oxe = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error(STR_EMPTY, (Throwable)oxe);
            Response response1 = new Response(session);
            response1.setException(oxe);
            try {
                ResponseWriter.write(response1, resp.getWriter(), Mail.localeFrom(session));
            }
            catch (JSONException e1) {
                LOG.error("Error while writing response object.", (Throwable)e1);
                Mail.sendError(resp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Response actionPutNewMail(ServerSession session, HttpServletRequest req, ParamContainer paramContainer) {
        JSONObject responseData;
        Response response;
        block32: {
            response = new Response(session);
            responseData = null;
            ManagedMimeMessage managedMimeMessage = null;
            try {
                String[] ids;
                QuotedInternetAddress fromAddress;
                MimeMessage message;
                String folder = paramContainer.getStringParam(PARAMETER_MAILFOLDER);
                int i = paramContainer.getIntParam(PARAMETER_FLAGS);
                int flags = -9999 == i ? 0 : i;
                String tmp = paramContainer.getStringParam("force");
                boolean force = null == tmp ? false : STR_1.equals(tmp = tmp.trim()) || Boolean.parseBoolean(tmp);
                QuotedInternetAddress defaultSendAddr = new QuotedInternetAddress(Mail.getDefaultSendAddress(session), false);
                ServletInputStream in = null;
                try {
                    in = req.getInputStream();
                    message = new MimeMessage(MimeDefaultSession.getDefaultSession(), (InputStream)in);
                }
                finally {
                    if (null != in) {
                        try {
                            in.close();
                        }
                        catch (Exception e) {
                            LOG.error("Closing stream failed.", (Throwable)e);
                        }
                    }
                }
                message.removeHeader("x-original-headers");
                new MimeMessageFiller(session, session.getContext()).setCommonHeaders(message);
                String fromAddr = message.getHeader("From", null);
                if (Mail.isEmpty(fromAddr)) {
                    fromAddress = defaultSendAddr;
                    message.setFrom((Address)fromAddress);
                } else {
                    fromAddress = new QuotedInternetAddress(fromAddr, true);
                }
                PutNewMailData data = new PutNewMailData(){

                    @Override
                    public MimeMessage getMail() {
                        return message;
                    }

                    @Override
                    public InternetAddress getFromAddress() {
                        return fromAddress;
                    }
                };
                if (folder == null) {
                    responseData = this.appendDraft(session, flags, force, data.getFromAddress(), data.getMail());
                    break block32;
                }
                MailServletInterface mailInterface = MailServletInterface.getInstance(session);
                try {
                    ids = mailInterface.appendMessages(folder, new MailMessage[]{MimeMessageConverter.convertMessage(data.getMail())}, force);
                    if (flags > 0) {
                        mailInterface.updateMessageFlags(folder, ids, flags, true);
                    }
                }
                finally {
                    mailInterface.close(true);
                }
                JSONObject responseObj = new JSONObject();
                responseObj.put("folder_id", (Object)folder);
                responseObj.put("id", (Object)ids[0]);
                responseData = responseObj;
            }
            catch (OXException e) {
                LOG.error(STR_EMPTY, (Throwable)e);
                response.setException(e);
            }
            catch (Exception e) {
                OXException wrapper = Mail.getWrappingOXException(e);
                LOG.error(STR_EMPTY, (Throwable)wrapper);
                response.setException(wrapper);
            }
            finally {
                if (null != managedMimeMessage) {
                    try {
                        managedMimeMessage.cleanUp();
                    }
                    catch (Exception e) {}
                }
            }
        }
        response.setData(responseData == null ? JSONObject.NULL : responseData);
        response.setTimestamp(null);
        return response;
    }

    public void actionPutTransportMail(ServerSession session, JSONWriter writer, JSONObject jsonObj, MailServletInterface mailInterface) throws JSONException {
        ResponseWriter.write(this.actionPutTransportMail(session, jsonObj.getString("data"), ParamContainer.getInstance(jsonObj, EnumComponent.MAIL), mailInterface), writer, Mail.localeFrom(session));
    }

    private final void actionPutTransportMail(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ServerSession session = Mail.getSessionObject((ServletRequest)req);
        try {
            ResponseWriter.write(this.actionPutTransportMail(session, Mail.getBody(req), ParamContainer.getInstance(req, EnumComponent.MAIL, resp), null), resp.getWriter(), Mail.localeFrom(session));
        }
        catch (JSONException e) {
            OXException oxe = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error(STR_EMPTY, (Throwable)oxe);
            Response response = new Response(session);
            response.setException(oxe);
            try {
                ResponseWriter.write(response, resp.getWriter(), Mail.localeFrom(session));
            }
            catch (JSONException e1) {
                LOG.error("Error while writing response object.", (Throwable)e1);
                Mail.sendError(resp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Response actionPutTransportMail(ServerSession session, String body, ParamContainer paramContainer, MailServletInterface mailIntefaceArg) {
        Response response = new Response(session);
        JSONObject responseData = null;
        try {
            String recipientsStr = paramContainer.getStringParam("recipients");
            InternetAddress[] recipients = null == recipientsStr ? null : QuotedInternetAddress.parseHeader(recipientsStr, false);
            ComposedMailMessage composedMail = MIMEStructureParser.parseStructure(new JSONObject(body), session);
            if (recipients != null && recipients.length > 0) {
                composedMail.addRecipients(recipients);
            }
            MailServletInterface mailInterface = mailIntefaceArg;
            boolean closeMailInterface = false;
            try {
                int accountId;
                if (mailInterface == null) {
                    mailInterface = MailServletInterface.getInstance(session);
                    closeMailInterface = true;
                }
                try {
                    InternetAddress[] fromAddrs = composedMail.getFrom();
                    accountId = Mail.resolveFrom2Account(session, fromAddrs != null && fromAddrs.length > 0 ? fromAddrs[0] : null, true, true);
                }
                catch (OXException e) {
                    if (MailExceptionCode.NO_TRANSPORT_SUPPORT.equals(e)) {
                        throw e;
                    }
                    LOG.warn("{}. Using default account's transport.", (Object)e.getMessage());
                    accountId = 0;
                }
                String id = mailInterface.sendMessage(composedMail, ComposeType.NEW, accountId);
                int pos = id.lastIndexOf(47);
                if (-1 == pos) {
                    throw MailExceptionCode.INVALID_MAIL_IDENTIFIER.create(id);
                }
                JSONObject responseObj = new JSONObject();
                responseObj.put("folder_id", (Object)id.substring(0, pos));
                responseObj.put("id", (Object)id.substring(pos + 1));
                responseData = responseObj;
                try {
                    ServerUserSetting setting = ServerUserSetting.getInstance();
                    int contextId = session.getContextId();
                    int userId = session.getUserId();
                    if (setting.isContactCollectionEnabled(contextId, userId).booleanValue() && setting.isContactCollectOnMailTransport(contextId, userId).booleanValue()) {
                        Mail.triggerContactCollector(session, composedMail);
                    }
                }
                catch (OXException e) {
                    LOG.warn("Contact collector could not be triggered.", (Throwable)e);
                }
            }
            finally {
                if (closeMailInterface && mailInterface != null) {
                    mailInterface.close(true);
                }
            }
        }
        catch (OXException e) {
            LOG.error(STR_EMPTY, (Throwable)e);
            response.setException(e);
        }
        catch (Exception e) {
            OXException wrapper = Mail.getWrappingOXException(e);
            LOG.error(STR_EMPTY, (Throwable)wrapper);
            response.setException(wrapper);
        }
        response.setData(responseData == null ? JSONObject.NULL : responseData);
        response.setTimestamp(null);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Response actionPostImportMail(ServerSession session, HttpServletRequest req, ParamContainer paramContainer) {
        Response response = new Response(session);
        JSONArray responseData = null;
        try {
            MailImportResult[] mirs;
            String folder = paramContainer.checkStringParam(PARAMETER_MAILFOLDER);
            int i = paramContainer.getIntParam(PARAMETER_FLAGS);
            int flags = -9999 == i ? 0 : i;
            String tmp = paramContainer.getStringParam("force");
            boolean force = null == tmp ? false : STR_1.equals(tmp = tmp.trim()) || Boolean.parseBoolean(tmp);
            QuotedInternetAddress defaultSendAddr = new QuotedInternetAddress(Mail.getDefaultSendAddress(session), false);
            MailServletInterface mailInterface = MailServletInterface.getInstance(session);
            ArrayBlockingQueue<MimeMessage> queue = new ArrayBlockingQueue<MimeMessage>(100);
            Future future = null;
            if (!ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
                throw MailExceptionCode.UNSUPPORTED_MIME_TYPE.create(req.getContentType());
            }
            ThreadPoolService service = ServerServiceRegistry.getInstance().getService(ThreadPoolService.class, true);
            AppenderTask task = new AppenderTask(mailInterface, folder, force, flags, queue);
            try {
                FileItemIterator iter = Mail.newFileUploadBase().getItemIterator(req);
                if (iter.hasNext()) {
                    future = service.submit((Task)task);
                }
                boolean keepgoing = true;
                while (keepgoing && iter.hasNext()) {
                    MimeMessage message;
                    FileItemStream item = iter.next();
                    InputStream is = item.openStream();
                    try {
                        message = new MimeMessage(MimeDefaultSession.getDefaultSession(), is);
                    }
                    finally {
                        try {
                            is.close();
                        }
                        catch (Exception e) {
                            LOG.error("Closing file item stream failed.", (Throwable)e);
                        }
                    }
                    String fromAddr = message.getHeader("From", null);
                    if (Mail.isEmpty(fromAddr)) {
                        message.setFrom((Address)defaultSendAddr);
                    }
                    while (keepgoing && !queue.offer(message, 1L, TimeUnit.SECONDS)) {
                        keepgoing = !future.isDone();
                    }
                }
            }
            finally {
                task.stop();
            }
            if (null == future) {
                mirs = new MailImportResult[]{};
            } else {
                try {
                    future.get(10L, TimeUnit.SECONDS);
                }
                catch (TimeoutException e) {
                    future.cancel(true);
                }
                MailImportResult[] alreadyImportedOnes = mailInterface.getMailImportResults();
                if (queue.isEmpty()) {
                    mirs = alreadyImportedOnes;
                } else {
                    ArrayList messages = new ArrayList(16);
                    queue.drainTo(messages);
                    messages.remove(POISON);
                    ArrayList<MailMessage> mails = new ArrayList<MailMessage>(messages.size());
                    for (MimeMessage message : messages) {
                        message.getHeader("Date", null);
                        MailMessage mm = MimeMessageConverter.convertMessage(message);
                        mails.add(mm);
                    }
                    messages.clear();
                    mailInterface = MailServletInterface.getInstance(session);
                    try {
                        String[] ids = mailInterface.importMessages(folder, mails.toArray(new MailMessage[mails.size()]), force);
                        mails.clear();
                        if (flags > 0) {
                            mailInterface.updateMessageFlags(folder, ids, flags, true);
                        }
                    }
                    finally {
                        mailInterface.close(true);
                    }
                    MailImportResult[] byCaller = mailInterface.getMailImportResults();
                    mirs = new MailImportResult[alreadyImportedOnes.length + byCaller.length];
                    System.arraycopy(alreadyImportedOnes, 0, mirs, 0, alreadyImportedOnes.length);
                    System.arraycopy(byCaller, 0, mirs, alreadyImportedOnes.length, byCaller.length);
                }
            }
            JSONArray respArray = new JSONArray();
            for (MailImportResult m : mirs) {
                JSONObject responseObj;
                if (m.hasError()) {
                    responseObj = new JSONObject();
                    responseObj.put("folder_id", (Object)folder);
                    responseObj.put(MailImportResult.FILENAME, (Object)m.getMail().getFileName());
                    responseObj.put(MailImportResult.ERROR, (Object)m.getException().getMessage());
                    respArray.put((Object)responseObj);
                    continue;
                }
                responseObj = new JSONObject();
                responseObj.put("folder_id", (Object)folder);
                responseObj.put("id", (Object)m.getId());
                respArray.put((Object)responseObj);
            }
            responseData = respArray;
        }
        catch (OXException e) {
            LOG.error(STR_EMPTY, (Throwable)e);
            response.setException(e);
        }
        catch (Exception e) {
            OXException wrapper = Mail.getWrappingOXException(e);
            LOG.error(STR_EMPTY, (Throwable)wrapper);
            response.setException(wrapper);
        }
        response.setData(responseData == null ? JSONObject.NULL : responseData);
        response.setTimestamp(null);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject appendDraft(ServerSession session, int flags, boolean force, InternetAddress from, MimeMessage m) throws OXException, OXException, JSONException {
        int accId;
        try {
            accId = Mail.resolveFrom2Account(session, from, true, !force);
        }
        catch (OXException e) {
            if (MailExceptionCode.NO_TRANSPORT_SUPPORT.equals(e)) {
                throw e;
            }
            LOG.warn("{}. Using default account's transport.", (Object)e.getMessage());
            accId = 0;
        }
        int accountId = accId;
        MailTransport transport = MailTransport.getInstance(session, accountId);
        try {
            JSONObject responseData;
            block28: {
                if (MailProperties.getInstance().isAddClientIPAddress()) {
                    MimeMessageFiller.addClientIPAddress(m, session);
                }
                MailMessage sentMail = transport.sendMailMessage(new ContentAwareComposedMailMessage(m, session, null), ComposeType.NEW);
                responseData = null;
                MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = null;
                try {
                    String[] uidArr;
                    mailAccess = MailAccess.getInstance(session, accountId);
                    mailAccess.connect();
                    if (mailAccess.getMessageStorage() instanceof IMailMessageStorageExt) {
                        String references;
                        ArrayList<String> lst = new ArrayList<String>(2);
                        String inReplyTo = sentMail.getFirstHeader("In-Reply-To");
                        if (Mail.equals(inReplyTo, references = sentMail.getFirstHeader("References"))) {
                            references = null;
                        }
                        if (null != inReplyTo) {
                            lst.add(inReplyTo);
                        }
                        if (null != references) {
                            lst.add(references);
                        }
                        if (!lst.isEmpty()) {
                            MailMessage[] mails;
                            IMailMessageStorageExt messageStorageExt = (IMailMessageStorageExt)mailAccess.getMessageStorage();
                            for (MailMessage mail : mails = messageStorageExt.getMessagesByMessageID(lst.toArray(new String[lst.size()]))) {
                                if (null == mail) continue;
                                this.setFlagReply(new MailPath(accountId, mail.getFolder(), mail.getMailId()), mailAccess);
                            }
                        }
                    }
                    if (session.getUserSettingMail().isNoCopyIntoStandardSentFolder()) break block28;
                    String sentFullname = MailFolderUtility.prepareMailFolderParam(mailAccess.getFolderStorage().getSentFolder()).getFullname();
                    try {
                        if (flags != -9999) {
                            sentMail.setFlags(flags);
                        }
                        uidArr = mailAccess.getMessageStorage().appendMessages(sentFullname, new MailMessage[]{sentMail});
                        try {
                            MailMessageCache.getInstance().removeFolderMessages(accountId, sentFullname, session.getUserId(), session.getContext().getContextId());
                        }
                        catch (OXException e) {
                            LOG.error(STR_EMPTY, (Throwable)e);
                        }
                    }
                    catch (OXException e) {
                        if (e.getMessage().indexOf("quota") != -1) {
                            throw MailExceptionCode.COPY_TO_SENT_FOLDER_FAILED_QUOTA.create(e, new Object[0]);
                        }
                        throw MailExceptionCode.COPY_TO_SENT_FOLDER_FAILED.create(e, new Object[0]);
                    }
                    if (uidArr != null && uidArr[0] != null) {
                        mailAccess.getMessageStorage().updateMessageFlags(sentFullname, uidArr, 32, true);
                    }
                    responseData = new JSONObject();
                    responseData.put("folder_id", (Object)MailFolderUtility.prepareFullname(0, sentFullname));
                    responseData.put("id", (Object)uidArr[0]);
                }
                finally {
                    if (null != mailAccess) {
                        mailAccess.close(true);
                    }
                }
            }
            JSONObject jSONObject = responseData;
            return jSONObject;
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (RuntimeException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        finally {
            transport.close();
        }
    }

    private static boolean equals(String s1, String s2) {
        return !(null == s1 ? null != s2 : !s1.equals(s2));
    }

    private void setFlagReply(MailPath path, MailAccess<? extends IMailFolderStorage, ? extends IMailMessageStorage> mailAccess) throws OXException {
        if (null == path) {
            LOG.warn("Missing msgref on reply. Corresponding mail cannot be marked as answered.", new Throwable());
            return;
        }
        String fullname = path.getFolder();
        String[] uids = new String[]{path.getMailID()};
        mailAccess.getMessageStorage().updateMessageFlags(fullname, uids, 1, true);
        try {
            Session session = mailAccess.getSession();
            int userId = session.getUserId();
            int contextId = session.getContextId();
            if (MailMessageCache.getInstance().containsFolderMessages(mailAccess.getAccountId(), fullname, userId, contextId)) {
                MailMessageCache.getInstance().updateCachedMessages(uids, mailAccess.getAccountId(), fullname, userId, contextId, FIELDS_FLAGS, new Object[]{1});
            }
        }
        catch (OXException e) {
            LOG.error(STR_EMPTY, (Throwable)e);
        }
    }

    public void actionPutCopyMail(ServerSession session, JSONWriter writer, JSONObject jsonObj, MailServletInterface mailInterface) throws JSONException {
        ResponseWriter.write(this.actionPutCopyMail(session, jsonObj.getString("data"), ParamContainer.getInstance(jsonObj, EnumComponent.MAIL), mailInterface), writer, Mail.localeFrom(session));
    }

    private final void actionPutCopyMail(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ServerSession session = Mail.getSessionObject((ServletRequest)req);
        try {
            ResponseWriter.write(this.actionPutCopyMail(session, Mail.getBody(req), ParamContainer.getInstance(req, EnumComponent.MAIL, resp), null), resp.getWriter(), Mail.localeFrom(session));
        }
        catch (JSONException e) {
            OXException oxe = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error(STR_EMPTY, (Throwable)oxe);
            Response response = new Response(session);
            response.setException(oxe);
            try {
                ResponseWriter.write(response, resp.getWriter(), Mail.localeFrom(session));
            }
            catch (JSONException e1) {
                LOG.error("Error while writing response object.", (Throwable)e1);
                Mail.sendError(resp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Response actionPutCopyMail(ServerSession session, String body, ParamContainer paramContainer, MailServletInterface mailInterfaceArg) throws JSONException {
        Response response = new Response(session);
        OXJSONWriter jsonWriter = new OXJSONWriter();
        jsonWriter.object();
        try {
            String uid = paramContainer.checkStringParam("id");
            String sourceFolder = paramContainer.checkStringParam(PARAMETER_MAILFOLDER);
            String destFolder = new JSONObject(body).getString("folder_id");
            MailServletInterface mailInterface = mailInterfaceArg;
            boolean closeMailInterface = false;
            try {
                if (mailInterface == null) {
                    mailInterface = MailServletInterface.getInstance(session);
                    closeMailInterface = true;
                }
                String msgUID = mailInterface.copyMessages(sourceFolder, destFolder, new String[]{uid}, false)[0];
                jsonWriter.key("folder_id").value((Object)destFolder);
                jsonWriter.key("id").value((Object)msgUID);
            }
            finally {
                if (closeMailInterface && mailInterface != null) {
                    mailInterface.close(true);
                }
            }
        }
        catch (OXException e) {
            LOG.error(STR_EMPTY, (Throwable)e);
            response.setException(e);
        }
        catch (Exception e) {
            OXException wrapper = Mail.getWrappingOXException(e);
            LOG.error(STR_EMPTY, (Throwable)wrapper);
            response.setException(wrapper);
        }
        jsonWriter.endObject();
        response.setData(jsonWriter.getObject());
        response.setTimestamp(null);
        return response;
    }

    public final void actionPutMoveMailMultiple(ServerSession session, JSONWriter writer, String[] mailIDs, String sourceFolder, String destFolder, MailServletInterface mailInteface) throws JSONException {
        this.actionPutMailMultiple(session, writer, mailIDs, sourceFolder, destFolder, true, mailInteface);
    }

    public final void actionPutCopyMailMultiple(ServerSession session, JSONWriter writer, String[] mailIDs, String srcFolder, String destFolder, MailServletInterface mailInterface) throws JSONException {
        this.actionPutMailMultiple(session, writer, mailIDs, srcFolder, destFolder, false, mailInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void actionPutMailMultiple(ServerSession session, JSONWriter writer, String[] mailIDs, String srcFolder, String destFolder, boolean move, MailServletInterface mailInterfaceArg) throws JSONException {
        try {
            MailServletInterface mailInterface = mailInterfaceArg;
            boolean closeMailInterface = false;
            try {
                String[] msgUIDs;
                if (mailInterface == null) {
                    mailInterface = MailServletInterface.getInstance(session);
                    closeMailInterface = true;
                }
                if ((msgUIDs = mailInterface.copyMessages(srcFolder, destFolder, mailIDs, move)).length > 0) {
                    Response response = new Response(session);
                    for (String msgUID : msgUIDs) {
                        response.reset();
                        JSONObject jsonObj = new JSONObject();
                        jsonObj.put("folder_id", (Object)destFolder);
                        jsonObj.put("id", (Object)msgUID);
                        response.setData(jsonObj);
                        response.setTimestamp(null);
                        ResponseWriter.write(response, writer, Mail.localeFrom(session));
                    }
                } else {
                    Response response = new Response(session);
                    response.setData(JSONObject.NULL);
                    response.setTimestamp(null);
                    ResponseWriter.write(response, writer, Mail.localeFrom(session));
                }
            }
            finally {
                if (closeMailInterface && mailInterface != null) {
                    mailInterface.close(true);
                }
            }
        }
        catch (OXException e) {
            LOG.error(STR_EMPTY, (Throwable)e);
            Response response = new Response(session);
            for (String mailID : mailIDs) {
                response.reset();
                response.setException(e);
                response.setData(JSONObject.NULL);
                response.setTimestamp(null);
                ResponseWriter.write(response, writer, Mail.localeFrom(session));
            }
        }
        catch (Exception e) {
            OXException wrapper = Mail.getWrappingOXException(e);
            LOG.error(STR_EMPTY, (Throwable)wrapper);
            Response response = new Response(session);
            for (String mailID : mailIDs) {
                response.reset();
                response.setException(wrapper);
                response.setData(JSONObject.NULL);
                response.setTimestamp(null);
                ResponseWriter.write(response, writer, Mail.localeFrom(session));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPutStoreFlagsMultiple(ServerSession session, JSONWriter writer, String[] mailIDs, String folder, int flagsBits, boolean flagValue, MailServletInterface mailInterfaceArg) throws JSONException {
        try {
            MailServletInterface mailInterface = mailInterfaceArg;
            boolean closeMailInterface = false;
            try {
                if (mailInterface == null) {
                    mailInterface = MailServletInterface.getInstance(session);
                    closeMailInterface = true;
                }
                mailInterface.updateMessageFlags(folder, mailIDs, flagsBits, flagValue);
                Response response = new Response(session);
                for (String mailID : mailIDs) {
                    response.reset();
                    JSONObject jsonObj = new JSONObject();
                    jsonObj.put("folder_id", (Object)folder);
                    jsonObj.put("id", (Object)mailID);
                    response.setData(jsonObj);
                    response.setTimestamp(null);
                    ResponseWriter.write(response, writer, Mail.localeFrom(session));
                }
            }
            finally {
                if (closeMailInterface && mailInterface != null) {
                    mailInterface.close(true);
                }
            }
        }
        catch (OXException e) {
            LOG.error(STR_EMPTY, (Throwable)e);
            Response response = new Response(session);
            for (String mailID : mailIDs) {
                response.reset();
                response.setException(e);
                response.setData(JSONObject.NULL);
                response.setTimestamp(null);
                ResponseWriter.write(response, writer, Mail.localeFrom(session));
            }
        }
        catch (Exception e) {
            OXException wrapper = Mail.getWrappingOXException(e);
            LOG.error(STR_EMPTY, (Throwable)wrapper);
            Response response = new Response(session);
            for (String mailID : mailIDs) {
                response.reset();
                response.setException(wrapper);
                response.setData(JSONObject.NULL);
                response.setTimestamp(null);
                ResponseWriter.write(response, writer, Mail.localeFrom(session));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPutColorLabelMultiple(ServerSession session, JSONWriter writer, String[] mailIDs, String folder, int colorLabel, MailServletInterface mailInterfaceArg) throws JSONException {
        try {
            MailServletInterface mailInterface = mailInterfaceArg;
            boolean closeMailInterface = false;
            try {
                if (mailInterface == null) {
                    mailInterface = MailServletInterface.getInstance(session);
                    closeMailInterface = true;
                }
                mailInterface.updateMessageColorLabel(folder, mailIDs, colorLabel);
                Response response = new Response(session);
                for (String mailID : mailIDs) {
                    response.reset();
                    JSONObject jsonObj = new JSONObject();
                    jsonObj.put("folder_id", (Object)folder);
                    jsonObj.put("id", (Object)mailID);
                    response.setData(jsonObj);
                    response.setTimestamp(null);
                    ResponseWriter.write(response, writer, Mail.localeFrom(session));
                }
            }
            finally {
                if (closeMailInterface && mailInterface != null) {
                    mailInterface.close(true);
                }
            }
        }
        catch (OXException e) {
            LOG.error(STR_EMPTY, (Throwable)e);
            Response response = new Response(session);
            for (String mailID : mailIDs) {
                response.reset();
                response.setException(e);
                response.setData(JSONObject.NULL);
                response.setTimestamp(null);
                ResponseWriter.write(response, writer, Mail.localeFrom(session));
            }
        }
        catch (Exception e) {
            OXException wrapper = Mail.getWrappingOXException(e);
            LOG.error(STR_EMPTY, (Throwable)wrapper);
            Response response = new Response(session);
            for (String mailID : mailIDs) {
                response.reset();
                response.setException(wrapper);
                response.setData(JSONObject.NULL);
                response.setTimestamp(null);
                ResponseWriter.write(response, writer, Mail.localeFrom(session));
            }
        }
    }

    public void actionPutAttachment(ServerSession session, JSONWriter writer, JSONObject jsonObj, MailServletInterface mi) throws JSONException {
        ResponseWriter.write(this.actionPutAttachment(session, jsonObj.getString("data"), ParamContainer.getInstance(jsonObj, EnumComponent.MAIL), mi), writer, Mail.localeFrom(session));
    }

    private final void actionPutAttachment(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ServerSession session = Mail.getSessionObject((ServletRequest)req);
        try {
            ResponseWriter.write(this.actionPutAttachment(session, Mail.getBody(req), ParamContainer.getInstance(req, EnumComponent.MAIL, resp), null), resp.getWriter(), Mail.localeFrom(session));
        }
        catch (JSONException e) {
            OXException oxe = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error(STR_EMPTY, (Throwable)oxe);
            Response response = new Response(session);
            response.setException(oxe);
            try {
                ResponseWriter.write(response, resp.getWriter(), Mail.localeFrom(session));
            }
            catch (JSONException e1) {
                LOG.error("Error while writing response object.", (Throwable)e1);
                Mail.sendError(resp);
            }
        }
    }

    private final Response actionPutAttachment(ServerSession session, String body, ParamContainer paramContainer, MailServletInterface mailInterfaceArg) throws JSONException {
        Response response = new Response(session);
        OXJSONWriter jsonWriter = new OXJSONWriter();
        jsonWriter.array();
        try {
            String folderPath = paramContainer.checkStringParam(PARAMETER_MAILFOLDER);
            String uid = paramContainer.checkStringParam("id");
            String sequenceId = paramContainer.checkStringParam(PARAMETER_MAILATTCHMENT);
            String destFolderIdentifier = paramContainer.checkStringParam(PARAMETER_DESTINATION_FOLDER);
            MailServletInterface mailInterface = mailInterfaceArg;
            boolean closeMailInterface = false;
            ServerServiceRegistry serviceRegistry = ServerServiceRegistry.getInstance();
            IDBasedFileAccess fileAccess = serviceRegistry.getService(IDBasedFileAccessFactory.class).createAccess((Session)session);
            boolean performRollback = false;
            try {
                MailPart mailPart;
                if (!session.getUserPermissionBits().hasInfostore()) {
                    throw MailExceptionCode.NO_MAIL_ACCESS.create();
                }
                if (mailInterface == null) {
                    mailInterface = MailServletInterface.getInstance(session);
                    closeMailInterface = true;
                }
                if ((mailPart = mailInterface.getMessageAttachment(folderPath, uid, sequenceId, false)) == null) {
                    throw MailExceptionCode.NO_ATTACHMENT_FOUND.create(sequenceId);
                }
                String destFolderID = destFolderIdentifier;
                FileMetadataParserService parser = serviceRegistry.getService(FileMetadataParserService.class, true);
                JSONObject jsonFileObject = new JSONObject(body);
                File file = parser.parse(jsonFileObject);
                List fields = parser.getFields(jsonFileObject);
                EnumSet set = EnumSet.copyOf(fields);
                if (!set.contains(File.Field.FILENAME)) {
                    file.setFileName(mailPart.getFileName());
                }
                file.setFileMIMEType(mailPart.getContentType().getBaseType());
                file.setFileSize(0L);
                if (!set.contains(File.Field.TITLE)) {
                    file.setTitle(mailPart.getFileName());
                }
                file.setFolderId(destFolderID);
                fileAccess.startTransaction();
                performRollback = true;
                fileAccess.saveDocument(file, mailPart.getInputStream(), System.currentTimeMillis(), fields);
                fileAccess.commit();
            }
            catch (Exception e) {
                if (performRollback) {
                    fileAccess.rollback();
                }
                throw e;
            }
            finally {
                if (closeMailInterface && mailInterface != null) {
                    mailInterface.close(true);
                }
                if (fileAccess != null) {
                    fileAccess.finish();
                }
            }
        }
        catch (OXException e) {
            LOG.error(STR_EMPTY, (Throwable)e);
            response.setException(e);
        }
        catch (Exception e) {
            OXException wrapper = Mail.getWrappingOXException(e);
            LOG.error(STR_EMPTY, (Throwable)wrapper);
            response.setException(wrapper);
        }
        jsonWriter.endArray();
        response.setData(jsonWriter.getObject());
        response.setTimestamp(null);
        return response;
    }

    public void actionPutReceiptAck(ServerSession session, JSONWriter writer, JSONObject jsonObj, MailServletInterface mi) throws JSONException {
        ResponseWriter.write(this.actionPutReceiptAck(session, jsonObj.getString("data"), ParamContainer.getInstance(jsonObj, EnumComponent.MAIL), mi), writer, Mail.localeFrom(session));
    }

    private final void actionPutReceiptAck(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ServerSession session = Mail.getSessionObject((ServletRequest)req);
        try {
            ResponseWriter.write(this.actionPutReceiptAck(session, Mail.getBody(req), ParamContainer.getInstance(req, EnumComponent.MAIL, resp), null), resp.getWriter(), Mail.localeFrom(session));
        }
        catch (JSONException e) {
            OXException oxe = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error(STR_EMPTY, (Throwable)oxe);
            Response response = new Response(session);
            response.setException(oxe);
            try {
                ResponseWriter.write(response, resp.getWriter(), Mail.localeFrom(session));
            }
            catch (JSONException e1) {
                LOG.error("Error while writing response object.", (Throwable)e1);
                Mail.sendError(resp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Response actionPutReceiptAck(ServerSession session, String body, ParamContainer paramContainer, MailServletInterface mailInterfaceArg) {
        Response response = new Response(session);
        try {
            String uid;
            String folderPath;
            JSONObject bodyObj = new JSONObject(body);
            String string = folderPath = bodyObj.has(PARAMETER_MAILFOLDER) ? bodyObj.getString(PARAMETER_MAILFOLDER) : null;
            if (null == folderPath) {
                throw MailExceptionCode.MISSING_PARAM.create(PARAMETER_MAILFOLDER);
            }
            String string2 = uid = bodyObj.has("id") ? bodyObj.getString("id") : null;
            if (null == uid) {
                throw MailExceptionCode.MISSING_PARAM.create("id");
            }
            String fromAddr = bodyObj.has(MailJSONField.FROM.getKey()) && !bodyObj.isNull(MailJSONField.FROM.getKey()) ? bodyObj.getString(MailJSONField.FROM.getKey()) : null;
            MailServletInterface mailInterface = mailInterfaceArg;
            boolean closeMailInterface = false;
            try {
                if (mailInterface == null) {
                    mailInterface = MailServletInterface.getInstance(session);
                    closeMailInterface = true;
                }
                mailInterface.sendReceiptAck(folderPath, uid, fromAddr);
            }
            finally {
                if (closeMailInterface && mailInterface != null) {
                    mailInterface.close(true);
                }
            }
        }
        catch (OXException e) {
            LOG.error(STR_EMPTY, (Throwable)e);
            response.setException(e);
        }
        catch (Exception e) {
            OXException wrapper = Mail.getWrappingOXException(e);
            LOG.error(STR_EMPTY, (Throwable)wrapper);
            response.setException(wrapper);
        }
        response.setData(JSONObject.NULL);
        response.setTimestamp(null);
        return response;
    }

    private static String checkStringParam(HttpServletRequest req, String paramName) throws OXException {
        String paramVal = req.getParameter(paramName);
        if (paramVal == null || paramVal.length() == 0 || STR_NULL.equals(paramVal)) {
            throw MailExceptionCode.MISSING_FIELD.create(paramName);
        }
        return paramVal;
    }

    private static String[] checkStringArrayParam(HttpServletRequest req, String paramName) throws OXException {
        String tmp = req.getParameter(paramName);
        if (tmp == null || tmp.length() == 0 || STR_NULL.equals(tmp)) {
            throw MailExceptionCode.MISSING_FIELD.create(paramName);
        }
        return SPLIT.split(tmp, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ServerSession session = Mail.getSessionObject((ServletRequest)req);
        Tools.disableCaching(resp);
        String groupId = req.getParameter("groupId");
        String actionStr = req.getParameter("action");
        if ("import".equals(actionStr)) {
            this.actionPostImportMail(req, resp);
            return;
        }
        try {
            MailServletInterface mailInterface = MailServletInterface.getInstance(session);
            try {
                resp.setContentType(MIME_TEXT_HTML_CHARSET_UTF_8);
                ArrayList<UploadListener> listeners = new ArrayList<UploadListener>(1);
                listeners.add(this);
                UploadEvent uploadEvent = this.processUpload(req);
                uploadEvent.setParameter(UPLOAD_PARAM_MAILINTERFACE, mailInterface);
                uploadEvent.setParameter(UPLOAD_PARAM_WRITER, resp.getWriter());
                uploadEvent.setParameter(UPLOAD_PARAM_SESSION, session);
                uploadEvent.setParameter(UPLOAD_PARAM_HOSTNAME, req.getServerName());
                uploadEvent.setParameter(UPLOAD_PARAM_PROTOCOL, Tools.getProtocol(req));
                uploadEvent.setParameter(UPLOAD_PARAM_GID, groupId);
                uploadEvent.setParameter("action", actionStr);
                this.fireUploadEvent(uploadEvent, listeners);
            }
            finally {
                if (mailInterface != null) {
                    try {
                        mailInterface.close(true);
                    }
                    catch (Exception e) {
                        LOG.error(STR_EMPTY, (Throwable)e);
                    }
                }
            }
        }
        catch (UploadException e) {
            LOG.error(STR_EMPTY, (Throwable)((Object)e));
            JSONObject responseObj = null;
            try {
                Response response = new Response(session);
                response.setException(e);
                responseObj = ResponseWriter.getJSON(response);
            }
            catch (JSONException e1) {
                LOG.error(STR_EMPTY, (Throwable)e1);
            }
            throw new UploadServletException(resp, Mail.substituteJS(responseObj == null ? STR_NULL : responseObj.toString(), e.getAction() == null ? STR_NULL : e.getAction()), e.getMessage(), (Throwable)((Object)e));
        }
        catch (OXException e) {
            LOG.error(STR_EMPTY, (Throwable)e);
            JSONObject responseObj = null;
            try {
                Response response = new Response(session);
                response.setException(e);
                responseObj = ResponseWriter.getJSON(response);
            }
            catch (JSONException e1) {
                LOG.error(STR_EMPTY, (Throwable)e1);
            }
            throw new UploadServletException(resp, Mail.substituteJS(responseObj == null ? STR_NULL : responseObj.toString(), actionStr == null ? STR_NULL : actionStr), e.getMessage(), e);
        }
        catch (Exception e) {
            OXException wrapper = Mail.getWrappingOXException(e);
            LOG.error(STR_EMPTY, (Throwable)wrapper);
            JSONObject responseObj = null;
            try {
                Response response = new Response(session);
                response.setException(wrapper);
                responseObj = ResponseWriter.getJSON(response);
            }
            catch (JSONException e1) {
                LOG.error(STR_EMPTY, (Throwable)e1);
            }
            throw new UploadServletException(resp, Mail.substituteJS(responseObj == null ? STR_NULL : responseObj.toString(), actionStr == null ? STR_NULL : actionStr), wrapper.getMessage(), wrapper);
        }
    }

    protected boolean sendMessage(HttpServletRequest req) {
        return req.getParameter("action") != null && req.getParameter("action").equalsIgnoreCase("send");
    }

    protected boolean appendMessage(HttpServletRequest req) {
        return req.getParameter("action") != null && req.getParameter("action").equalsIgnoreCase("append");
    }

    @Override
    public boolean action(UploadEvent uploadEvent) throws OXException {
        if (uploadEvent.getAffiliationId() != 1) {
            return false;
        }
        ArrayList<OXException> warnings = new ArrayList<OXException>();
        try {
            String protocol = (String)uploadEvent.getParameter(UPLOAD_PARAM_PROTOCOL);
            String serverName = (String)uploadEvent.getParameter(UPLOAD_PARAM_HOSTNAME);
            PrintWriter writer = (PrintWriter)uploadEvent.getParameter(UPLOAD_PARAM_WRITER);
            String actionStr = (String)uploadEvent.getParameter("action");
            String groupId = (String)uploadEvent.getParameter(UPLOAD_PARAM_GID);
            ServerSession session = (ServerSession)uploadEvent.getParameter(UPLOAD_PARAM_SESSION);
            try {
                MailServletInterface mailServletInterface = (MailServletInterface)uploadEvent.getParameter(UPLOAD_PARAM_MAILINTERFACE);
                String action = uploadEvent.getAction();
                if ("new".equals(action)) {
                    String jsResponse;
                    Response response;
                    int accountId;
                    InternetAddress from;
                    String msgIdentifier = null;
                    String json0 = uploadEvent.getFormField("json_0");
                    if (json0 == null || json0.trim().length() == 0) {
                        throw MailExceptionCode.MISSING_PARAM.create("json_0");
                    }
                    JSONObject jsonMailObj = new JSONObject(json0);
                    try {
                        from = MessageParser.getFromField(jsonMailObj)[0];
                    }
                    catch (AddressException e) {
                        throw MimeMailException.handleMessagingException((MessagingException)((Object)e));
                    }
                    try {
                        accountId = Mail.resolveFrom2Account(session, from, true, true);
                    }
                    catch (OXException e) {
                        if (MailExceptionCode.NO_TRANSPORT_SUPPORT.equals(e)) {
                            throw e;
                        }
                        LOG.warn("{}. Using default account's transport.", (Object)e.getMessage());
                        accountId = 0;
                    }
                    if (jsonMailObj.hasAndNotNull(MailJSONField.FLAGS.getKey()) && (jsonMailObj.getInt(MailJSONField.FLAGS.getKey()) & 4) > 0) {
                        ComposedMailMessage composedMail = MessageParser.parse4Draft(jsonMailObj, uploadEvent, session, accountId, warnings);
                        msgIdentifier = mailServletInterface.saveDraft(composedMail, false, accountId);
                    } else {
                        ComposedMailMessage[] composedMails = MessageParser.parse4Transport(jsonMailObj, uploadEvent, session, accountId, protocol, serverName, warnings);
                        ComposeType sendType = jsonMailObj.hasAndNotNull(PARAMETER_SEND_TYPE) ? ComposeType.getType(jsonMailObj.getInt(PARAMETER_SEND_TYPE)) : ComposeType.NEW;
                        msgIdentifier = mailServletInterface.sendMessage(composedMails[0], sendType, accountId);
                        for (int i = 1; i < composedMails.length; ++i) {
                            mailServletInterface.sendMessage(composedMails[i], sendType, accountId);
                        }
                        try {
                            ServerUserSetting setting = ServerUserSetting.getInstance();
                            int contextId = session.getContextId();
                            int userId = session.getUserId();
                            if (setting.isContactCollectionEnabled(contextId, userId).booleanValue() && setting.isContactCollectOnMailTransport(contextId, userId).booleanValue()) {
                                Mail.triggerContactCollector(session, composedMails[0]);
                            }
                        }
                        catch (OXException e) {
                            LOG.warn("Contact collector could not be triggered.", (Throwable)e);
                        }
                    }
                    if (msgIdentifier == null) {
                        warnings.addAll(mailServletInterface.getWarnings());
                        if (warnings.isEmpty()) {
                            throw MailExceptionCode.SEND_FAILED_UNKNOWN.create();
                        }
                        response = new Response(session);
                        response.setData(JSONObject.NULL);
                        response.addWarnings(warnings);
                        jsResponse = Mail.substituteJS(ResponseWriter.getJSON(response).toString(), actionStr);
                        writer.write(jsResponse);
                        writer.flush();
                        return true;
                    }
                    response = new Response(session);
                    response.setData(msgIdentifier);
                    jsResponse = Mail.substituteJS(ResponseWriter.getJSON(response).toString(), actionStr);
                    writer.write(jsResponse);
                    writer.flush();
                    return true;
                }
                if (PARAMETER_EDIT_DRAFT.equals(action)) {
                    InternetAddress from;
                    String msgIdentifier = null;
                    JSONObject jsonMailObj = new JSONObject(uploadEvent.getFormField("json_0"));
                    try {
                        from = MessageParser.getFromField(jsonMailObj)[0];
                    }
                    catch (AddressException e) {
                        throw MimeMailException.handleMessagingException((MessagingException)((Object)e));
                    }
                    int accountId = Mail.resolveFrom2Account(session, from, false, true);
                    MailServletInterface msi = mailServletInterface;
                    if (msi.getDraftsFolder(accountId) == null) {
                        if (0 == accountId) {
                            throw MailExceptionCode.FOLDER_NOT_FOUND.create("Drafts");
                        }
                        LOG.warn("Mail account {} for user {} in context {} has no drafts folder. Saving draft to default account's draft folder.", new Object[]{accountId, session.getUserId(), session.getContextId()});
                        accountId = 0;
                    }
                    if (!jsonMailObj.hasAndNotNull(MailJSONField.FLAGS.getKey()) || (jsonMailObj.getInt(MailJSONField.FLAGS.getKey()) & 4) <= 0) {
                        throw MailExceptionCode.UNEXPECTED_ERROR.create("No new message on action=edit");
                    }
                    ComposedMailMessage composedMail = MessageParser.parse4Draft(jsonMailObj, uploadEvent, session, 0, warnings);
                    msgIdentifier = msi.saveDraft(composedMail, false, accountId);
                    if (msgIdentifier == null) {
                        throw MailExceptionCode.SEND_FAILED_UNKNOWN.create();
                    }
                    Response response = new Response(session);
                    response.setData(msgIdentifier);
                    String jsResponse = Mail.substituteJS(ResponseWriter.getJSON(response).toString(), actionStr);
                    writer.write(jsResponse);
                    writer.flush();
                    return true;
                }
                if ("formMail".equals(action)) {
                    int accountId;
                    InternetAddress from;
                    if (null == groupId) {
                        throw MailExceptionCode.MISSING_PARAM.create(UPLOAD_PARAM_GID);
                    }
                    String json0 = uploadEvent.getFormField("json_0");
                    if (json0 == null || json0.trim().length() == 0) {
                        throw MailExceptionCode.MISSING_PARAM.create("json_0");
                    }
                    JSONObject jsonMailObj = new JSONObject(json0);
                    try {
                        from = MessageParser.getFromField(jsonMailObj)[0];
                    }
                    catch (AddressException e) {
                        throw MimeMailException.handleMessagingException((MessagingException)((Object)e));
                    }
                    try {
                        accountId = Mail.resolveFrom2Account(session, from, true, true);
                    }
                    catch (OXException e) {
                        if (MailExceptionCode.NO_TRANSPORT_SUPPORT.equals(e)) {
                            throw e;
                        }
                        LOG.warn("{}. Using default account's transport.", (Object)e.getMessage());
                        accountId = 0;
                    }
                    ComposedMailMessage[] composedMails = MessageParser.parse4Transport(jsonMailObj, uploadEvent, session, accountId, protocol, serverName, warnings);
                    mailServletInterface.sendFormMail(composedMails[0], Integer.parseInt(groupId), accountId);
                    for (int i = 1; i < composedMails.length; ++i) {
                        mailServletInterface.sendFormMail(composedMails[i], Integer.parseInt(groupId), accountId);
                    }
                    Response response = new Response(session);
                    response.setData(Boolean.TRUE);
                    response.addWarnings(warnings);
                    String jsResponse = Mail.substituteJS(ResponseWriter.getJSON(response).toString(), actionStr);
                    writer.write(jsResponse);
                    writer.flush();
                    return true;
                }
                if ("append".equals(action)) {
                    throw new UnsupportedOperationException("APPEND NOT SUPPORTED, YET!");
                }
            }
            catch (OXException e) {
                LOG.error(STR_EMPTY, (Throwable)e);
                Response response = new Response(session);
                response.setException(e);
                String jsResponse = Mail.substituteJS(ResponseWriter.getJSON(response).toString(), actionStr);
                writer.write(jsResponse);
                writer.flush();
                return true;
            }
            return false;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public UploadRegistry getRegistry() {
        return this;
    }

    @Override
    protected boolean hasModulePermission(ServerSession session) {
        return session.getUserPermissionBits().hasWebMail();
    }

    private static String getDefaultSendAddress(ServerSession session) throws OXException {
        MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
        return storageService.getDefaultMailAccount(session.getUserId(), session.getContextId()).getPrimaryAddress();
    }

    private static int resolveFrom2Account(ServerSession session, InternetAddress from, boolean checkTransportSupport, boolean checkFrom) throws OXException, OXException {
        int accountId;
        MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
        int user = session.getUserId();
        int cid = session.getContextId();
        if (null == from) {
            accountId = 0;
        } else {
            accountId = storageService.getByPrimaryAddress(from.getAddress(), user, cid);
            if (accountId == -1) {
                accountId = storageService.getByPrimaryAddress(IDNA.toIDN((String)from.getAddress()), user, cid);
            }
        }
        if (accountId != -1) {
            MailAccount account;
            if (!session.getUserPermissionBits().isMultipleMailAccounts() && accountId != 0) {
                throw MailAccountExceptionCodes.NOT_ENABLED.create(user, cid);
            }
            if (checkTransportSupport && null == (account = storageService.getMailAccount(accountId, user, cid)).getTransportServer()) {
                throw MailExceptionCode.NO_TRANSPORT_SUPPORT.create(account.getName(), accountId);
            }
        }
        if (accountId == -1) {
            if (checkFrom && null != from) {
                try {
                    String[] aliases;
                    HashSet<InternetAddress> validAddrs = new HashSet<InternetAddress>(4);
                    User user2 = session.getUser();
                    for (String alias : aliases = user2.getAliases()) {
                        validAddrs.add(new QuotedInternetAddress(alias));
                    }
                    if (MailProperties.getInstance().isSupportMsisdnAddresses()) {
                        MsisdnUtility.addMsisdnAddress(validAddrs, session);
                        String address = from.getAddress();
                        int pos = address.indexOf(47);
                        if (pos > 0) {
                            from.setAddress(address.substring(0, pos));
                        }
                    }
                    if (!validAddrs.contains(from)) {
                        throw MailExceptionCode.INVALID_SENDER.create(from.toString());
                    }
                }
                catch (AddressException e) {
                    throw MimeMailException.handleMessagingException((MessagingException)((Object)e));
                }
            }
            accountId = 0;
        }
        return accountId;
    }

    static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Strings.isWhitespace((char)string.charAt(i));
        }
        return isWhitespace;
    }

    private static boolean startsWith(char startingChar, String toCheck, boolean ignoreHeadingWhitespaces) {
        int i;
        if (null == toCheck) {
            return false;
        }
        int len = toCheck.length();
        if (len <= 0) {
            return false;
        }
        if (!ignoreHeadingWhitespaces) {
            return startingChar == toCheck.charAt(0);
        }
        for (i = 0; i < len && Strings.isWhitespace((char)toCheck.charAt(i)); ++i) {
        }
        if (i >= len) {
            return false;
        }
        return startingChar == toCheck.charAt(i);
    }

    private static JSONArray toJSONArray(String toCheck) {
        if (!Mail.startsWith('[', toCheck, true)) {
            return null;
        }
        try {
            return new JSONArray(toCheck);
        }
        catch (JSONException e) {
            return null;
        }
    }

    private static String getSimpleName(String fullname) {
        if (null == fullname) {
            return null;
        }
        int len = fullname.length();
        int pos = fullname.lastIndexOf(46);
        if (pos >= 0 && pos < len - 1) {
            return fullname.substring(pos + 1);
        }
        pos = fullname.lastIndexOf(47);
        if (pos >= 0 && pos < len - 1) {
            return fullname.substring(pos + 1);
        }
        return fullname;
    }

    private static final class HTTPRequestStringProvider
    implements StringProvider {
        private final HttpServletRequest req;

        public HTTPRequestStringProvider(HttpServletRequest req) {
            this.req = req;
        }

        @Override
        public String getString() throws IOException {
            return AJAXServlet.getBody(this.req);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }

    private static final class SimpleStringProvider
    implements StringProvider {
        private final String string;

        public SimpleStringProvider(String string) {
            this.string = string;
        }

        @Override
        public String getString() throws IOException {
            return this.string;
        }

        @Override
        public boolean isEmpty() {
            return null == this.string || 0 == this.string.length();
        }
    }

    private static interface StringProvider {
        public String getString() throws IOException;

        public boolean isEmpty();
    }

    private static final class AppenderTask
    extends AbstractTask<Object> {
        private final AtomicBoolean keepgoing = new AtomicBoolean(true);
        private final MailServletInterface mailInterface;
        private final String folder;
        private final boolean force;
        private final int flags;
        private final BlockingQueue<MimeMessage> queue;
        private OXException exception;

        protected AppenderTask(MailServletInterface mailInterface, String folder, boolean force, int flags, BlockingQueue<MimeMessage> queue) {
            this.mailInterface = mailInterface;
            this.folder = folder;
            this.force = force;
            this.flags = flags;
            this.queue = queue;
        }

        protected void stop() throws OXException {
            this.keepgoing.set(false);
            try {
                this.queue.put(POISON);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw MailExceptionCode.INTERRUPT_ERROR.create(e, new Object[0]);
            }
        }

        public Object call() throws Exception {
            ArrayList<String> idList = new ArrayList<String>();
            try {
                ArrayList<MimeMessage> messages = new ArrayList<MimeMessage>(16);
                ArrayList<MailMessage> mails = new ArrayList<MailMessage>(16);
                while (this.keepgoing.get() || !this.queue.isEmpty()) {
                    if (this.queue.isEmpty()) {
                        MimeMessage msg = this.queue.take();
                        if (POISON == msg) {
                            Object var5_9 = null;
                            return var5_9;
                        }
                        messages.add(msg);
                    }
                    this.queue.drainTo(messages);
                    boolean quit = messages.remove(POISON);
                    for (MimeMessage message : messages) {
                        message.getHeader("Date", null);
                        MailMessage mm = MimeMessageConverter.convertMessage(message);
                        mails.add(mm);
                    }
                    messages.clear();
                    String[] ids = this.mailInterface.importMessages(this.folder, mails.toArray(new MailMessage[mails.size()]), this.force);
                    mails.clear();
                    idList.addAll(Arrays.asList(ids));
                    if (this.flags > 0) {
                        this.mailInterface.updateMessageFlags(this.folder, ids, this.flags, true);
                    }
                    if (!quit) continue;
                    Object var6_10 = null;
                    return var6_10;
                }
            }
            catch (OXException e) {
                this.exception = e;
                throw e;
            }
            catch (MessagingException e) {
                this.exception = MimeMailException.handleMessagingException(e);
                throw this.exception;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.exception = Mail.getWrappingOXException(e);
                throw this.exception;
            }
            finally {
                this.mailInterface.close(true);
            }
            return null;
        }

        public void setThreadName(ThreadRenamer threadRenamer) {
            threadRenamer.rename("Mail Import Thread");
        }
    }

    private static interface PutNewMailData {
        public InternetAddress getFromAddress();

        public MimeMessage getMail();
    }
}

