/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import org.json.JSONException;
import org.json.JSONTokener;
import org.json.helpers.StringAllocator;

public class HTTPTokener
extends JSONTokener {
    public HTTPTokener(String s) {
        super(s);
    }

    public String nextToken() throws JSONException {
        char c;
        StringAllocator sb = new StringAllocator();
        while (HTTPTokener.isWhitespace(c = this.next())) {
        }
        if (c == '\"' || c == '\'') {
            char q = c;
            while (true) {
                if ((c = this.next()) < ' ') {
                    throw this.syntaxError("Unterminated string.");
                }
                if (c == q) {
                    return sb.toString();
                }
                sb.append(c);
            }
        }
        while (c != '\u0000' && !HTTPTokener.isWhitespace(c)) {
            sb.append(c);
            c = this.next();
        }
        return sb.toString();
    }

    private static boolean isWhitespace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\u000b': 
            case '\f': 
            case '\r': 
            case '\u000e': 
            case '\u001c': 
            case '\u001d': 
            case '\u001e': 
            case '\u001f': 
            case ' ': {
                return true;
            }
        }
        return false;
    }
}

