/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.webdav.action.ActionTestCase;
import com.openexchange.webdav.action.MockWebdavRequest;
import com.openexchange.webdav.action.MockWebdavResponse;
import com.openexchange.webdav.action.WebdavAction;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.WebdavResponse;
import com.openexchange.webdav.protocol.WebdavFactory;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavResource;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public abstract class StructureTest
extends ActionTestCase {
    protected WebdavPath INDEX_HTML_URL = null;
    protected WebdavPath COPIED_INDEX_HTML_URL = null;
    private WebdavPath SITEMAP_HTML_URL = null;
    private WebdavPath DEVELOPMENT_URL = null;
    private WebdavPath PM_URL = null;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.INDEX_HTML_URL = this.testCollection.dup().append(new String[]{"index.html"});
        this.COPIED_INDEX_HTML_URL = this.testCollection.dup().append(new String[]{"copied_index.html"});
        this.SITEMAP_HTML_URL = this.testCollection.dup().append(new String[]{"sitemap.html"});
        this.DEVELOPMENT_URL = this.testCollection.dup().append(new String[]{"development"});
        this.PM_URL = this.testCollection.dup().append(new String[]{"pm"});
    }

    public void testResource() throws Exception {
        String content = this.getContent(this.INDEX_HTML_URL);
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(this.INDEX_HTML_URL);
        req.setHeader("Destination", this.COPIED_INDEX_HTML_URL.toString());
        WebdavAction action = this.getAction(this.factory);
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        StructureTest.assertEquals((int)201, (int)res.getStatus());
        WebdavResource resource = this.factory.resolveResource(this.INDEX_HTML_URL);
        StructureTest.assertTrue((boolean)resource.exists());
        StructureTest.assertEquals((String)content, (String)this.getContent(this.INDEX_HTML_URL));
        resource = this.factory.resolveResource(this.COPIED_INDEX_HTML_URL);
        StructureTest.assertTrue((boolean)resource.exists());
        StructureTest.assertEquals((String)content, (String)this.getContent(this.COPIED_INDEX_HTML_URL));
    }

    public void testOverwrite() throws Exception {
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(this.INDEX_HTML_URL);
        req.setHeader("Destination", this.SITEMAP_HTML_URL.toString());
        req.setHeader("Overwrite", "F");
        WebdavAction action = this.getAction(this.factory);
        try {
            action.perform((WebdavRequest)req, (WebdavResponse)res);
            StructureTest.fail((String)"Expected 412 Precondition Failed");
        }
        catch (WebdavProtocolException x) {
            StructureTest.assertEquals((int)412, (int)x.getStatus());
        }
    }

    public void testSuccessfulOverwrite() throws Exception {
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(this.INDEX_HTML_URL);
        req.setHeader("Destination", this.SITEMAP_HTML_URL.toString());
        req.setHeader("Overwrite", "T");
        WebdavAction action = this.getAction(this.factory);
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        StructureTest.assertEquals((int)204, (int)res.getStatus());
    }

    public void testOverwriteCollection() throws Exception {
        this.factory.resolveCollection(this.DEVELOPMENT_URL).resolveResource(new WebdavPath((CharSequence)"test.html")).create();
        this.factory.resolveCollection(this.PM_URL).resolveResource(new WebdavPath((CharSequence)"test.html")).create();
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(this.DEVELOPMENT_URL);
        req.setHeader("Destination", this.PM_URL.toString());
        req.setHeader("Overwrite", "F");
        WebdavAction action = this.getAction(this.factory);
        try {
            action.perform((WebdavRequest)req, (WebdavResponse)res);
            StructureTest.fail((String)"Expected 412 Precondition Failed");
        }
        catch (WebdavProtocolException x) {
            StructureTest.assertEquals((int)412, (int)x.getStatus());
        }
    }

    public void testMergeCollection() throws Exception {
        WebdavResource r = this.factory.resolveCollection(this.DEVELOPMENT_URL).resolveResource(new WebdavPath((CharSequence)"test.html"));
        r.putBodyAndGuessLength((InputStream)new ByteArrayInputStream(new byte[2]));
        r.create();
        r = this.factory.resolveCollection(this.PM_URL).resolveResource(new WebdavPath((CharSequence)"test2.html"));
        r.putBodyAndGuessLength((InputStream)new ByteArrayInputStream(new byte[2]));
        r.create();
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(this.DEVELOPMENT_URL);
        req.setHeader("Destination", this.PM_URL.toString());
        WebdavAction action = this.getAction(this.factory);
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        StructureTest.assertTrue((boolean)this.factory.resolveResource(this.PM_URL + "/test.html").exists());
    }

    public void testSame() throws Exception {
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(this.DEVELOPMENT_URL);
        req.setHeader("Destination", this.DEVELOPMENT_URL.toString());
        WebdavAction action = this.getAction(this.factory);
        try {
            action.perform((WebdavRequest)req, (WebdavResponse)res);
            StructureTest.fail((String)"Expected 403 FORBIDDEN");
        }
        catch (WebdavProtocolException x) {
            StructureTest.assertEquals((int)403, (int)x.getStatus());
        }
    }

    public void testConflict() throws Exception {
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(this.DEVELOPMENT_URL);
        req.setHeader("Destination", "/doesntExist/nonono");
        WebdavAction action = this.getAction(this.factory);
        try {
            action.perform((WebdavRequest)req, (WebdavResponse)res);
            StructureTest.fail((String)"Expected 409 CONFLICT, 412 PRECONDITION FAILED or 207 MULTISTATUS");
        }
        catch (WebdavProtocolException x) {
            StructureTest.assertTrue((String)("" + x.getStatus()), (409 == x.getStatus() || 207 == x.getStatus() || 412 == x.getStatus() ? 1 : 0) != 0);
        }
    }

    public abstract WebdavAction getAction(WebdavFactory var1);
}

