/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit.filetokenizer;

import com.openexchange.tools.versit.ICalendar;
import com.openexchange.tools.versit.VCard;
import com.openexchange.tools.versit.VersitDefinition;
import com.openexchange.tools.versit.filetokenizer.VCardFileToken;
import com.openexchange.tools.versit.filetokenizer.VCardTokenizer;
import com.openexchange.tools.versit.old.VCalendar10;
import com.openexchange.tools.versit.old.VCard21;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import junit.framework.TestCase;

public class VCardTokenizerTest
extends TestCase {
    public static final String VCARD21 = "BEGIN:VCARD\nVERSION:2.1\nN:Prinz;Tobias;;;\nFN:Tobias Prinz\nEMAIL;INTERNET:top@synapps.de\nEMAIL;INTERNET;WORK:top@synapps.de\nTEL:+375293917117\nTEL;CELL:016091408095\nTEL;MAIN:023587192\nADR;HOME:;;Am Piwitt 18;Meinerzhagen;;58540;Deutschland\nCATEGORIES:Nicht abgelegt\nEND:VCARD\n";
    public static final String VCARD30 = "BEGIN:VCARD\nVERSION:3.0\nN:;Svetlana;;;\nFN:Svetlana\nTEL;type=CELL;type=pref:6670373\nCATEGORIES:Nicht abgelegt\nX-ABUID:CBC739E8-694E-4589-8651-8C30E1A6E724\\:ABPerson\nEND:VCARD\n";
    public static final String VCALENDAR10 = "BEGIN:VCALENDAR\nVERSION:1.0\nBEGIN:VEVENT\nSUMMARY:Sample vCalendar event\nDTSTART:20031228T080000\nDTEND:20031228T083000\nEND:VEVENT\nEND:VCALENDAR\n";
    public static final String ICALENDAR = "BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//hacksw/handcal//NONSGML v1.0//EN\nBEGIN:VEVENT\nDTSTART:19970714T170000Z\nDTEND:19970715T035959Z\nSUMMARY:Bastille Day Party\nEND:VEVENT\nEND:VCALENDAR";
    public static final String MULTI_MONDO_TEST = "BEGIN:VCARD\nVERSION:2.1\nN:Prinz;Tobias;;;\nFN:Tobias Prinz\nEMAIL;INTERNET:top@synapps.de\nEMAIL;INTERNET;WORK:top@synapps.de\nTEL:+375293917117\nTEL;CELL:016091408095\nTEL;MAIN:023587192\nADR;HOME:;;Am Piwitt 18;Meinerzhagen;;58540;Deutschland\nCATEGORIES:Nicht abgelegt\nEND:VCARD\nBEGIN:VCALENDAR\nVERSION:1.0\nBEGIN:VEVENT\nSUMMARY:Sample vCalendar event\nDTSTART:20031228T080000\nDTEND:20031228T083000\nEND:VEVENT\nEND:VCALENDAR\nBEGIN:VCARD\nVERSION:3.0\nN:;Svetlana;;;\nFN:Svetlana\nTEL;type=CELL;type=pref:6670373\nCATEGORIES:Nicht abgelegt\nX-ABUID:CBC739E8-694E-4589-8651-8C30E1A6E724\\:ABPerson\nEND:VCARD\nBEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//hacksw/handcal//NONSGML v1.0//EN\nBEGIN:VEVENT\nDTSTART:19970714T170000Z\nDTEND:19970715T035959Z\nSUMMARY:Bastille Day Party\nEND:VEVENT\nEND:VCALENDAR";
    public static final String MULTI_MONDO_TEST2 = "BEGIN:VCARD\nVERSION:2.1\nN:Prinz;Tobias;;;\nFN:Tobias Prinz\nEMAIL;INTERNET:top@synapps.de\nEMAIL;INTERNET;WORK:top@synapps.de\nTEL:+375293917117\nTEL;CELL:016091408095\nTEL;MAIN:023587192\nADR;HOME:;;Am Piwitt 18;Meinerzhagen;;58540;Deutschland\nCATEGORIES:Nicht abgelegt\nEND:VCARD\nBEGIN:VCALENDAR\nVERSION:1.0\nBEGIN:VEVENT\nSUMMARY:Sample vCalendar event\nDTSTART:20031228T080000\nDTEND:20031228T083000\nEND:VEVENT\nEND:VCALENDAR\nBEGIN:VCARD\nVERSION:3.0\nN:;Svetlana;;;\nFN:Svetlana\nTEL;type=CELL;type=pref:6670373\nCATEGORIES:Nicht abgelegt\nX-ABUID:CBC739E8-694E-4589-8651-8C30E1A6E724\\:ABPerson\nEND:VCARD\nBEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//hacksw/handcal//NONSGML v1.0//EN\nBEGIN:VEVENT\nDTSTART:19970714T170000Z\nDTEND:19970715T035959Z\nSUMMARY:Bastille Day Party\nEND:VEVENT\nEND:VCALENDAR\n";
    public static final String BUG_7248 = "BEGIN:VCARD\nVERSION:2.1\nN:Colombara;Robert\nFN:Robert Colombara\nADR;WORK:;;;;;;DE\nADR;HOME:;;;;;- / -\nEND:VCARD";
    public static final String BUG_7250 = "BEGIN:VCARD\nVERSION:2.1\nN:C\u00f6l\u00f6mb\u00e4r\u00e4;R\u00f6b\u00f6rt\nEND:VCARD";
    public static final String UTF8 = "UTF-8";
    public static final String WIN = "Cp1252";

    public void testVCardRecognition() throws IOException {
        this.prepareTest(VCARD21, 1, 1, new VersitDefinition[]{VCard21.definition}, new String[]{VCARD21}, UTF8);
        this.prepareTest(VCARD30, 1, 1, new VersitDefinition[]{VCard.definition}, new String[]{VCARD30}, UTF8);
        this.prepareTest("BEGIN:VCARD\nVERSION:2.1\nN:Prinz;Tobias;;;\nFN:Tobias Prinz\nEMAIL;INTERNET:top@synapps.de\nEMAIL;INTERNET;WORK:top@synapps.de\nTEL:+375293917117\nTEL;CELL:016091408095\nTEL;MAIN:023587192\nADR;HOME:;;Am Piwitt 18;Meinerzhagen;;58540;Deutschland\nCATEGORIES:Nicht abgelegt\nEND:VCARD\nBEGIN:VCARD\nVERSION:3.0\nN:;Svetlana;;;\nFN:Svetlana\nTEL;type=CELL;type=pref:6670373\nCATEGORIES:Nicht abgelegt\nX-ABUID:CBC739E8-694E-4589-8651-8C30E1A6E724\\:ABPerson\nEND:VCARD\n", 2, 2, new VersitDefinition[]{VCard21.definition, VCard.definition}, new String[]{VCARD21, VCARD30}, UTF8);
    }

    public void testVCalendarRecognition() throws IOException {
        this.prepareTest(VCALENDAR10, 1, 1, new VersitDefinition[]{VCalendar10.definition}, new String[]{VCALENDAR10}, UTF8);
        this.prepareTest(ICALENDAR, 1, 1, new VersitDefinition[]{ICalendar.definition}, new String[]{ICALENDAR}, UTF8);
    }

    public void testAll() throws IOException {
        this.prepareTest(MULTI_MONDO_TEST, 4, 4, new VersitDefinition[]{VCard21.definition, VCalendar10.definition, VCard.definition, ICalendar.definition}, new String[]{VCARD21, VCALENDAR10, VCARD30, ICALENDAR}, UTF8);
        this.prepareTest(MULTI_MONDO_TEST2, 4, 4, new VersitDefinition[]{VCard21.definition, VCalendar10.definition, VCard.definition, ICalendar.definition}, new String[]{VCARD21, VCALENDAR10, VCARD30, ICALENDAR}, UTF8);
    }

    public void test7248() throws IOException {
        this.prepareTest(BUG_7248, 1, 1, new VersitDefinition[]{VCard21.definition}, new String[]{BUG_7248}, UTF8);
    }

    public void test7250() throws IOException {
        this.prepareTest(BUG_7250, 1, 1, new VersitDefinition[]{VCard21.definition}, new String[]{BUG_7250}, WIN);
    }

    private void prepareTest(String content, int entriesFound, int entriesRecognized, VersitDefinition[] compDefs, String[] expectedContent, String encoding) throws IOException {
        VCardTokenizer chunky = new VCardTokenizer((InputStream)new ByteArrayInputStream(content.getBytes(encoding)));
        List l = chunky.split();
        VCardTokenizerTest.assertTrue((String)"Correct number of entries", (chunky.getNumberOfEntriesFound() == entriesFound ? 1 : 0) != 0);
        VCardTokenizerTest.assertTrue((String)"Correct number of recognized entries", (chunky.getNumberOfEntriesRecognized() == entriesRecognized ? 1 : 0) != 0);
        for (int i = 0; i < l.size(); ++i) {
            VCardTokenizerTest.assertEquals((String)("Correct type recognized at entry #" + i + "?"), (Object)compDefs[i], (Object)((VCardFileToken)l.get(i)).getVersitDefinition());
            VCardTokenizerTest.assertEquals((String)("Contains expected content for entry #" + i + "?"), (String)expectedContent[i].trim(), (String)new String(((VCardFileToken)l.get(i)).getContent(), encoding).trim());
        }
    }
}

