/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.fixtures.ajax;

import com.openexchange.ajax.config.ConfigTools;
import com.openexchange.ajax.config.actions.GetRequest;
import com.openexchange.ajax.config.actions.SetRequest;
import com.openexchange.ajax.config.actions.Tree;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.exception.OXException;
import com.openexchange.test.fixtures.TestUserConfig;
import java.io.IOException;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class AJAXUserConfig
implements TestUserConfig {
    private final AJAXClient client;

    public AJAXUserConfig(AJAXClient client) {
        this.client = client;
    }

    @Override
    public Object get(Tree tree) {
        try {
            return ConfigTools.get(this.client, new GetRequest(tree)).getData();
        }
        catch (OXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public boolean getBool(Tree tree) {
        return (Boolean)this.get(tree);
    }

    @Override
    public int getInt(Tree tree) {
        return (Integer)this.get(tree);
    }

    @Override
    public long getLong(Tree tree) {
        return (Long)this.get(tree);
    }

    @Override
    public String getString(Tree tree) {
        return this.get(tree).toString();
    }

    @Override
    public void set(Tree tree, Object value) {
        try {
            ConfigTools.set(this.client, new SetRequest(tree, value));
        }
        catch (OXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }
}

