/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.importexport;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.importexport.csv.CSVParser;
import java.util.List;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;

public class CSVParserTest {
    private static final String UNESCAPED_TEST = "title 1, title 2, title3\ncontent 1, content2, content3";
    private static final String ESCAPED_TEST = "\"title 1\", \"title 2\", \"title3\"\r\n\"content \"\"1\"\"\", \"content,2\", \"content\n3\"";
    private static final String UNEVEN_TEST = "title1, title 2\ncontent 11\ncontent21, content22,content23";
    private List<List<String>> result;
    private CSVParser parser;

    public static Test suite() {
        return new JUnit4TestAdapter(CSVParserTest.class);
    }

    @org.junit.Test
    public void getLines() {
        this.parser = new CSVParser(UNESCAPED_TEST);
        Assert.assertEquals((Object)"title 1, title 2, title3", (Object)this.parser.getLine(0));
        Assert.assertEquals((Object)"content 1, content2, content3", (Object)this.parser.getLine(1));
        this.parser = new CSVParser(UNEVEN_TEST);
        Assert.assertEquals((Object)"title1, title 2", (Object)this.parser.getLine(0));
        Assert.assertEquals((Object)"content 11", (Object)this.parser.getLine(1));
        Assert.assertEquals((Object)"content21, content22,content23", (Object)this.parser.getLine(2));
    }

    @org.junit.Test
    public void parseUnescaped() throws OXException {
        this.doAsserts("title 1, title 2, title3\ncontent 1, content2, content3\n", "Un-escaped with final linebreak", 2, 3, false);
        this.doAsserts(UNESCAPED_TEST, "Un-escaped without final linebreak", 2, 3, false);
    }

    @org.junit.Test
    public void parseEscaped() throws OXException {
        this.doAsserts("\"title 1\", \"title 2\", \"title3\"\r\n\"content \"\"1\"\"\", \"content,2\", \"content\n3\"\n", "Escaped with final linebreak", 2, 3, false);
        this.doAsserts(ESCAPED_TEST, "Escaped without final linebreak", 2, 3, false);
    }

    @org.junit.Test
    public void parseMixed() throws OXException {
        this.doAsserts("title 1, title 2, title3\ncontent 1, content2, content3\n\"title 1\", \"title 2\", \"title3\"\r\n\"content \"\"1\"\"\", \"content,2\", \"content\n3\"", "Un-escaped with final linebreak", 4, 3, false);
        this.doAsserts("title 1, title 2, title3\ncontent 1, content2, content3\n\"title 1\", \"title 2\", \"title3\"\r\n\"content \"\"1\"\"\", \"content,2\", \"content\n3\"\n", "Un-escaped without final linebreak", 4, 3, false);
    }

    @org.junit.Test
    public void parseBuggedIntolerant() {
        this.parser = new CSVParser(UNEVEN_TEST);
        this.parser.setTolerant(false);
        try {
            this.parser.parse();
        }
        catch (OXException e) {
            Assert.assertTrue((String)"Exception caught", (boolean)true);
            Assert.assertEquals((String)"Correct exception thrown", (Object)"CSV-1000", (Object)e.getErrorCode());
            return;
        }
        Assert.fail((String)"Unparsable CSV given, but no exception thrown!");
    }

    @org.junit.Test
    public void parseBuggedIntolerant2() {
        String bla = "1\n2,3";
        this.parser = new CSVParser("1\n2,3");
        this.parser.setTolerant(false);
        try {
            this.parser.parse();
        }
        catch (OXException e) {
            Assert.assertTrue((String)"Exception caught", (boolean)true);
            Assert.assertEquals((String)"Correct exception thrown", (Object)"CSV-1000", (Object)e.getErrorCode());
            return;
        }
        Assert.fail((String)"Unparsable CSV given, but no exception thrown!");
    }

    @org.junit.Test
    public void parseBuggedTolerant() throws OXException {
        List<List<String>> result = this.doAsserts(UNEVEN_TEST, "Bugged lines with tolerant parser", 3, 2, true);
        Assert.assertEquals((String)"checking last element", (Object)"content22", (Object)result.get(2).get(1));
    }

    @org.junit.Test
    public void umlauts() throws OXException {
        String umlaut = "\u00dcmlaut title\nSonder\u00dfeichen cell";
        List<List<String>> result = this.doAsserts("\u00dcmlaut title\nSonder\u00dfeichen cell", "Checking umlauts", 2, 1, false);
        Assert.assertEquals((String)"\u00dc in title", (Object)"\u00dcmlaut title", (Object)result.get(0).get(0));
        Assert.assertEquals((String)"\u00df in cell", (Object)"Sonder\u00dfeichen cell", (Object)result.get(1).get(0));
    }

    protected List<List<String>> doAsserts(String line, String comment, int lines, int cells, boolean isTolerant) throws OXException {
        this.parser = new CSVParser(line);
        this.parser.setTolerant(isTolerant);
        this.result = this.parser.parse();
        Assert.assertEquals((String)(comment + ":: Number of lines"), (long)lines, (long)this.result.size());
        for (List<String> currList : this.result) {
            Assert.assertEquals((String)(comment + ":: Number of cells"), (long)cells, (long)currList.size());
        }
        return this.result;
    }
}

