/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.container;

import com.openexchange.groupware.container.CommonObject;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderChildObject;
import com.openexchange.groupware.container.FolderChildObjectTest;

public class CommonObjectTest
extends FolderChildObjectTest {
    @Override
    public void testFindDifferingFields() {
        CommonObject dataObject = this.getCommonObject();
        CommonObject otherDataObject = this.getCommonObject();
        otherDataObject.setCategories("blupp");
        this.assertDifferences((DataObject)dataObject, (DataObject)otherDataObject, 100);
        otherDataObject.setLabel(-2);
        this.assertDifferences((DataObject)dataObject, (DataObject)otherDataObject, 100, 102);
        otherDataObject.setNumberOfAttachments(-2);
        this.assertDifferences((DataObject)dataObject, (DataObject)otherDataObject, 100, 102, 104);
        otherDataObject.setNumberOfLinks(-2);
        this.assertDifferences((DataObject)dataObject, (DataObject)otherDataObject, 100, 102, 104, 103);
        otherDataObject.setPrivateFlag(false);
        this.assertDifferences((DataObject)dataObject, (DataObject)otherDataObject, 100, 102, 104, 103, 101);
    }

    @Override
    public void testAttrAccessors() {
        CommonObject object = new CommonObject(){};
        CommonObjectTest.assertFalse((boolean)object.contains(102));
        CommonObjectTest.assertFalse((boolean)object.containsLabel());
        object.setLabel(-12);
        CommonObjectTest.assertTrue((boolean)object.contains(102));
        CommonObjectTest.assertTrue((boolean)object.containsLabel());
        CommonObjectTest.assertEquals((Object)-12, (Object)object.get(102));
        object.set(102, (Object)12);
        CommonObjectTest.assertEquals((int)12, (int)object.getLabel());
        object.remove(102);
        CommonObjectTest.assertFalse((boolean)object.contains(102));
        CommonObjectTest.assertFalse((boolean)object.containsLabel());
        CommonObjectTest.assertFalse((boolean)object.contains(100));
        CommonObjectTest.assertFalse((boolean)object.containsCategories());
        object.setCategories("Bla");
        CommonObjectTest.assertTrue((boolean)object.contains(100));
        CommonObjectTest.assertTrue((boolean)object.containsCategories());
        CommonObjectTest.assertEquals((Object)"Bla", (Object)object.get(100));
        object.set(100, (Object)"Blupp");
        CommonObjectTest.assertEquals((String)"Blupp", (String)object.getCategories());
        object.remove(100);
        CommonObjectTest.assertFalse((boolean)object.contains(100));
        CommonObjectTest.assertFalse((boolean)object.containsCategories());
        CommonObjectTest.assertFalse((boolean)object.contains(103));
        CommonObjectTest.assertFalse((boolean)object.containsNumberOfLinks());
        object.setNumberOfLinks(-12);
        CommonObjectTest.assertTrue((boolean)object.contains(103));
        CommonObjectTest.assertTrue((boolean)object.containsNumberOfLinks());
        CommonObjectTest.assertEquals((Object)-12, (Object)object.get(103));
        object.set(103, (Object)12);
        CommonObjectTest.assertEquals((int)12, (int)object.getNumberOfLinks());
        object.remove(103);
        CommonObjectTest.assertFalse((boolean)object.contains(103));
        CommonObjectTest.assertFalse((boolean)object.containsNumberOfLinks());
        CommonObjectTest.assertFalse((boolean)object.contains(104));
        CommonObjectTest.assertFalse((boolean)object.containsNumberOfAttachments());
        object.setNumberOfAttachments(-12);
        CommonObjectTest.assertTrue((boolean)object.contains(104));
        CommonObjectTest.assertTrue((boolean)object.containsNumberOfAttachments());
        CommonObjectTest.assertEquals((Object)-12, (Object)object.get(104));
        object.set(104, (Object)12);
        CommonObjectTest.assertEquals((int)12, (int)object.getNumberOfAttachments());
        object.remove(104);
        CommonObjectTest.assertFalse((boolean)object.contains(104));
        CommonObjectTest.assertFalse((boolean)object.containsNumberOfAttachments());
        CommonObjectTest.assertFalse((boolean)object.contains(101));
        CommonObjectTest.assertFalse((boolean)object.containsPrivateFlag());
        object.setPrivateFlag(false);
        CommonObjectTest.assertTrue((boolean)object.contains(101));
        CommonObjectTest.assertTrue((boolean)object.containsPrivateFlag());
        CommonObjectTest.assertEquals((Object)false, (Object)object.get(101));
        object.set(101, (Object)true);
        CommonObjectTest.assertEquals((boolean)true, (boolean)object.getPrivateFlag());
        object.remove(101);
        CommonObjectTest.assertFalse((boolean)object.contains(101));
        CommonObjectTest.assertFalse((boolean)object.containsPrivateFlag());
    }

    private CommonObject getCommonObject() {
        CommonObject co = new CommonObject(){};
        this.fillCommonObject(co);
        return co;
    }

    public void fillCommonObject(CommonObject co) {
        super.fillFolderChildObject((FolderChildObject)co);
        co.setCategories("c1, c2, c3");
        co.setLabel(1);
        co.setNumberOfAttachments(2);
        co.setNumberOfLinks(3);
        co.setPersonalFolderID(12);
        co.setPrivateFlag(true);
    }
}

