/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar;

import com.openexchange.groupware.calendar.AbstractCalendarTest;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.calendarsqltests.CalendarSqlTest;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.server.impl.OCLPermission;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CalendarMoveTest
extends AbstractCalendarTest {
    private static final Log LOG = LogFactory.getLog(CalendarSqlTest.class);
    private final int[] columns = new int[]{1, 220, 221};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMoveFromPrivateToPrivate() throws Throwable {
        try {
            FolderObject folder1 = this.folders.createPrivateFolderForSessionUser(this.session, this.ctx, "folder1", this.appointments.getPrivateFolder());
            this.cleanFolders.add(folder1);
            FolderObject folder2 = this.folders.createPrivateFolderForSessionUser(this.session, this.ctx, "folder2", this.appointments.getPrivateFolder());
            this.cleanFolders.add(folder2);
            Date start = new Date(1231596000000L);
            Date end = new Date(1231599600000L);
            CalendarDataObject appointment = this.appointments.buildBasicAppointment(start, end);
            appointment.setTitle("testMoveFromPrivateToPrivate");
            appointment.setIgnoreConflicts(true);
            appointment.setParentFolderID(folder1.getObjectID());
            this.appointments.save(appointment);
            int objectId = appointment.getObjectID();
            this.clean.add(appointment);
            CalendarDataObject appointmentMove = this.appointments.createIdentifyingCopy(appointment);
            appointmentMove.setParentFolderID(folder2.getObjectID());
            this.appointments.move(appointmentMove, folder1.getObjectID());
            List<Appointment> appointmentsInFolder1 = this.appointments.getAppointmentsInFolder(folder1.getObjectID(), this.columns);
            List<Appointment> appointmentsInFolder2 = this.appointments.getAppointmentsInFolder(folder2.getObjectID(), this.columns);
            boolean found = false;
            for (Appointment object : appointmentsInFolder1) {
                if (object.getObjectID() != objectId) continue;
                found = true;
                break;
            }
            CalendarMoveTest.assertFalse((String)"Appointment not expected in first folder.", (boolean)found);
            Appointment foundAppointment = null;
            found = false;
            for (Appointment object : appointmentsInFolder2) {
                if (object.getObjectID() != objectId) continue;
                found = true;
                foundAppointment = object;
                break;
            }
            CalendarMoveTest.assertTrue((String)"Appointment expected in second folder.", (boolean)found);
            this.compareParticipants((Appointment)appointment, foundAppointment);
            this.compareUsers((Appointment)appointment, foundAppointment);
        }
        catch (Exception e) {
            CalendarMoveTest.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMoveFromPrivateToShared() throws Throwable {
        try {
            FolderObject folder1 = this.folders.createPrivateFolderForSessionUser(this.session, this.ctx, "folder1", this.appointments.getPrivateFolder());
            this.cleanFolders.add(folder1);
            OCLPermission oclp = new OCLPermission();
            oclp.setAllPermission(4, 4, 4, 4);
            this.folders.sharePrivateFolder(this.session, this.ctx, this.secondUserId, folder1, oclp);
            this.appointments.switchUser(this.secondUser);
            Date start = new Date(1231596000000L);
            Date end = new Date(1231599600000L);
            CalendarDataObject appointment = this.appointments.buildBasicAppointment(start, end);
            appointment.setTitle("testMoveFromSharedToSharedSameUser");
            appointment.setIgnoreConflicts(true);
            appointment.setParentFolderID(this.appointments.getPrivateFolder());
            this.appointments.save(appointment);
            int objectId = appointment.getObjectID();
            this.clean.add(appointment);
            CalendarDataObject appointmentMove = this.appointments.createIdentifyingCopy(appointment);
            appointmentMove.setParentFolderID(folder1.getObjectID());
            this.appointments.move(appointmentMove, this.appointments.getPrivateFolder());
            List<Appointment> appointmentsInPrivateFolder = this.appointments.getAppointmentsInFolder(this.appointments.getPrivateFolder(), this.columns);
            List<Appointment> appointmentsInFolder1 = this.appointments.getAppointmentsInFolder(folder1.getObjectID(), this.columns);
            boolean found = false;
            for (Appointment object : appointmentsInPrivateFolder) {
                if (object.getObjectID() != objectId) continue;
                found = true;
                break;
            }
            CalendarMoveTest.assertFalse((String)"Appointment not expected in first folder.", (boolean)found);
            Appointment foundAppointment = null;
            found = false;
            for (Appointment object : appointmentsInFolder1) {
                if (object.getObjectID() != objectId) continue;
                found = true;
                foundAppointment = object;
                break;
            }
            CalendarMoveTest.assertTrue((String)"Appointment expected in second folder.", (boolean)found);
            Participant[] expectedParticipants = new Participant[]{new UserParticipant(this.userId)};
            this.compareParticipants(expectedParticipants, foundAppointment.getParticipants());
            this.compareParticipants(expectedParticipants, (Participant[])foundAppointment.getUsers());
        }
        catch (Exception e) {
            CalendarMoveTest.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMoveFromPrivateToPublic() throws Throwable {
        try {
            FolderObject folder1 = this.folders.createPublicFolderFor(this.session, this.ctx, "folder1", 2, this.userId, this.secondUserId);
            this.cleanFolders.add(folder1);
            this.appointments.switchUser(this.secondUser);
            Date start = new Date(1231596000000L);
            Date end = new Date(1231599600000L);
            CalendarDataObject appointment = this.appointments.buildBasicAppointment(start, end);
            appointment.setTitle("testMoveFromPrivateToPublic");
            appointment.setIgnoreConflicts(true);
            appointment.setParentFolderID(this.appointments.getPrivateFolder());
            this.appointments.save(appointment);
            int objectId = appointment.getObjectID();
            this.clean.add(appointment);
            CalendarDataObject appointmentMove = this.appointments.createIdentifyingCopy(appointment);
            appointmentMove.setParentFolderID(folder1.getObjectID());
            this.appointments.move(appointmentMove, this.appointments.getPrivateFolder());
            List<Appointment> appointmentsPrivateFolder = this.appointments.getAppointmentsInFolder(this.appointments.getPrivateFolder(), this.columns);
            List<Appointment> appointmentsInFolder1 = this.appointments.getAppointmentsInFolder(folder1.getObjectID(), this.columns);
            boolean found = false;
            for (Appointment object : appointmentsPrivateFolder) {
                if (object.getObjectID() != objectId) continue;
                found = true;
                break;
            }
            CalendarMoveTest.assertFalse((String)"Appointment not expected in first folder.", (boolean)found);
            Appointment foundAppointment = null;
            found = false;
            for (Appointment object : appointmentsInFolder1) {
                if (object.getObjectID() != objectId) continue;
                found = true;
                foundAppointment = object;
                break;
            }
            CalendarMoveTest.assertTrue((String)"Appointment expected in second folder.", (boolean)found);
            this.compareParticipants((Appointment)appointment, foundAppointment);
            this.compareUsers((Appointment)appointment, foundAppointment);
        }
        catch (Exception e) {
            CalendarMoveTest.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMoveFromSharedToPrivate() throws Throwable {
        try {
            FolderObject folder1 = this.folders.createPrivateFolderForSessionUser(this.session, this.ctx, "folder1", this.appointments.getPrivateFolder());
            this.cleanFolders.add(folder1);
            OCLPermission oclp = new OCLPermission();
            oclp.setAllPermission(4, 4, 4, 4);
            this.folders.sharePrivateFolder(this.session, this.ctx, this.secondUserId, folder1, oclp);
            this.appointments.switchUser(this.secondUser);
            Date start = new Date(1231596000000L);
            Date end = new Date(1231599600000L);
            CalendarDataObject appointment = this.appointments.buildBasicAppointment(start, end);
            appointment.setTitle("testMoveFromSharedToSharedSameUser");
            appointment.setIgnoreConflicts(true);
            appointment.setParentFolderID(folder1.getObjectID());
            this.appointments.save(appointment);
            int objectId = appointment.getObjectID();
            this.clean.add(appointment);
            CalendarDataObject appointmentMove = this.appointments.createIdentifyingCopy(appointment);
            appointmentMove.setParentFolderID(this.appointments.getPrivateFolder());
            this.appointments.move(appointmentMove, folder1.getObjectID());
            List<Appointment> appointmentsInFolder1 = this.appointments.getAppointmentsInFolder(folder1.getObjectID(), this.columns);
            List<Appointment> appointmentsInPrivateFolder = this.appointments.getAppointmentsInFolder(this.appointments.getPrivateFolder(), this.columns);
            boolean found = false;
            for (Appointment object : appointmentsInFolder1) {
                if (object.getObjectID() != objectId) continue;
                found = true;
                break;
            }
            CalendarMoveTest.assertFalse((String)"Appointment not expected in first folder.", (boolean)found);
            Appointment foundAppointment = null;
            found = false;
            for (Appointment object : appointmentsInPrivateFolder) {
                if (object.getObjectID() != objectId) continue;
                found = true;
                foundAppointment = object;
                break;
            }
            CalendarMoveTest.assertTrue((String)"Appointment expected in second folder.", (boolean)found);
            Participant[] expectedParticipants = new Participant[]{new UserParticipant(this.secondUserId)};
            this.compareParticipants(expectedParticipants, foundAppointment.getParticipants());
            this.compareParticipants(expectedParticipants, (Participant[])foundAppointment.getUsers());
        }
        catch (Exception e) {
            CalendarMoveTest.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMoveFromSharedToSharedSameUser() throws Throwable {
        try {
            FolderObject folder1 = this.folders.createPrivateFolderForSessionUser(this.session, this.ctx, "folder1", this.appointments.getPrivateFolder());
            this.cleanFolders.add(folder1);
            FolderObject folder2 = this.folders.createPrivateFolderForSessionUser(this.session, this.ctx, "folder2", this.appointments.getPrivateFolder());
            this.cleanFolders.add(folder2);
            OCLPermission oclp = new OCLPermission();
            oclp.setAllPermission(4, 4, 4, 4);
            this.folders.sharePrivateFolder(this.session, this.ctx, this.secondUserId, folder1, oclp);
            this.folders.sharePrivateFolder(this.session, this.ctx, this.secondUserId, folder2, oclp);
            this.appointments.switchUser(this.secondUser);
            Date start = new Date(1231596000000L);
            Date end = new Date(1231599600000L);
            CalendarDataObject appointment = this.appointments.buildBasicAppointment(start, end);
            appointment.setTitle("testMoveFromSharedToSharedSameUser");
            appointment.setIgnoreConflicts(true);
            appointment.setParentFolderID(folder1.getObjectID());
            this.appointments.save(appointment);
            int objectId = appointment.getObjectID();
            this.clean.add(appointment);
            CalendarDataObject appointmentMove = this.appointments.createIdentifyingCopy(appointment);
            appointmentMove.setParentFolderID(folder2.getObjectID());
            this.appointments.move(appointmentMove, folder1.getObjectID());
            List<Appointment> appointmentsInFolder1 = this.appointments.getAppointmentsInFolder(folder1.getObjectID(), this.columns);
            List<Appointment> appointmentsInFolder2 = this.appointments.getAppointmentsInFolder(folder2.getObjectID(), this.columns);
            boolean found = false;
            for (Appointment object : appointmentsInFolder1) {
                if (object.getObjectID() != objectId) continue;
                found = true;
                break;
            }
            CalendarMoveTest.assertFalse((String)"Appointment not expected in first folder.", (boolean)found);
            Appointment foundAppointment = null;
            found = false;
            for (Appointment object : appointmentsInFolder2) {
                if (object.getObjectID() != objectId) continue;
                found = true;
                foundAppointment = object;
                break;
            }
            CalendarMoveTest.assertTrue((String)"Appointment expected in second folder.", (boolean)found);
            this.compareParticipants((Appointment)appointment, foundAppointment);
            this.compareUsers((Appointment)appointment, foundAppointment);
        }
        catch (Exception e) {
            CalendarMoveTest.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMoveFromSharedToPublic() throws Throwable {
        try {
            FolderObject folder1 = this.folders.createPrivateFolderForSessionUser(this.session, this.ctx, "folder1", this.appointments.getPrivateFolder());
            this.cleanFolders.add(folder1);
            FolderObject folder2 = this.folders.createPublicFolderFor(this.session, this.ctx, "folder2", 2, this.userId, this.secondUserId);
            this.cleanFolders.add(folder2);
            OCLPermission oclp = new OCLPermission();
            oclp.setAllPermission(4, 4, 4, 4);
            this.folders.sharePrivateFolder(this.session, this.ctx, this.secondUserId, folder1, oclp);
            this.appointments.switchUser(this.secondUser);
            Date start = new Date(1231596000000L);
            Date end = new Date(1231599600000L);
            CalendarDataObject appointment = this.appointments.buildBasicAppointment(start, end);
            appointment.setTitle("testMoveFromSharedToPublic");
            appointment.setIgnoreConflicts(true);
            appointment.setParentFolderID(folder1.getObjectID());
            this.appointments.save(appointment);
            int objectId = appointment.getObjectID();
            this.clean.add(appointment);
            CalendarDataObject appointmentMove = this.appointments.createIdentifyingCopy(appointment);
            appointmentMove.setParentFolderID(folder2.getObjectID());
            this.appointments.move(appointmentMove, folder1.getObjectID());
            List<Appointment> appointmentsInFolder1 = this.appointments.getAppointmentsInFolder(folder1.getObjectID(), this.columns);
            List<Appointment> appointmentsInFolder2 = this.appointments.getAppointmentsInFolder(folder2.getObjectID(), this.columns);
            boolean found = false;
            for (Appointment object : appointmentsInFolder1) {
                if (object.getObjectID() != objectId) continue;
                found = true;
                break;
            }
            CalendarMoveTest.assertFalse((String)"Appointment not expected in first folder.", (boolean)found);
            Appointment foundAppointment = null;
            found = false;
            for (Appointment object : appointmentsInFolder2) {
                if (object.getObjectID() != objectId) continue;
                found = true;
                foundAppointment = object;
                break;
            }
            CalendarMoveTest.assertTrue((String)"Appointment expected in second folder.", (boolean)found);
            this.compareParticipants((Appointment)appointment, foundAppointment);
            this.compareUsers((Appointment)appointment, foundAppointment);
        }
        catch (Exception e) {
            CalendarMoveTest.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMoveFromPublicToPrivate1() throws Throwable {
        try {
            FolderObject folder1 = this.folders.createPublicFolderFor(this.session, this.ctx, "folder1", 2, this.userId, this.secondUserId);
            this.cleanFolders.add(folder1);
            this.appointments.switchUser(this.secondUser);
            Date start = new Date(1231596000000L);
            Date end = new Date(1231599600000L);
            CalendarDataObject appointment = this.appointments.buildBasicAppointment(start, end);
            appointment.setTitle("testMoveFromPublicToPrivate");
            appointment.setIgnoreConflicts(true);
            appointment.setParentFolderID(folder1.getObjectID());
            this.appointments.save(appointment);
            int objectId = appointment.getObjectID();
            this.clean.add(appointment);
            CalendarDataObject appointmentMove = this.appointments.createIdentifyingCopy(appointment);
            appointmentMove.setParentFolderID(this.appointments.getPrivateFolder());
            this.appointments.move(appointmentMove, folder1.getObjectID());
            List<Appointment> appointmentsInFolder1 = this.appointments.getAppointmentsInFolder(folder1.getObjectID(), this.columns);
            List<Appointment> appointmentsInFolder2 = this.appointments.getAppointmentsInFolder(this.appointments.getPrivateFolder(), this.columns);
            boolean found = false;
            for (Appointment object : appointmentsInFolder1) {
                if (object.getObjectID() != objectId) continue;
                found = true;
                break;
            }
            CalendarMoveTest.assertFalse((String)"Appointment not expected in first folder.", (boolean)found);
            Appointment foundAppointment = null;
            found = false;
            for (Appointment object : appointmentsInFolder2) {
                if (object.getObjectID() != objectId) continue;
                found = true;
                foundAppointment = object;
                break;
            }
            CalendarMoveTest.assertTrue((String)"Appointment expected in second folder.", (boolean)found);
            Participant[] expectedParticipants = new Participant[]{new UserParticipant(this.secondUserId)};
            this.compareParticipants(expectedParticipants, foundAppointment.getParticipants());
            this.compareParticipants(expectedParticipants, (Participant[])foundAppointment.getUsers());
        }
        catch (Exception e) {
            CalendarMoveTest.fail((String)e.getMessage());
        }
    }

    public void testMoveFromPublicToPrivate2() throws Throwable {
        FolderObject folder1 = this.folders.createPublicFolderFor(this.session, this.ctx, "folder1", 2, this.userId, this.secondUserId);
        this.cleanFolders.add(folder1);
        Date start = new Date(1231596000000L);
        Date end = new Date(1231599600000L);
        CalendarDataObject appointment = this.appointments.buildBasicAppointment(start, end);
        appointment.setTitle("testMoveFromPublicToPrivate");
        appointment.setIgnoreConflicts(true);
        appointment.setParentFolderID(folder1.getObjectID());
        this.appointments.save(appointment);
        int objectId = appointment.getObjectID();
        this.clean.add(appointment);
        this.appointments.switchUser(this.secondUser);
        CalendarDataObject appointmentMove = this.appointments.createIdentifyingCopy(appointment);
        appointmentMove.setParentFolderID(this.appointments.getPrivateFolder());
        this.appointments.move(appointmentMove, folder1.getObjectID());
        List<Appointment> appointmentsInFolder1 = this.appointments.getAppointmentsInFolder(folder1.getObjectID(), this.columns);
        List<Appointment> appointmentsInFolder2 = this.appointments.getAppointmentsInFolder(this.appointments.getPrivateFolder(), this.columns);
        boolean found = false;
        for (Appointment object : appointmentsInFolder1) {
            if (object.getObjectID() != objectId) continue;
            found = true;
            break;
        }
        CalendarMoveTest.assertFalse((String)"Appointment not expected in first folder.", (boolean)found);
        Appointment foundAppointment = null;
        found = false;
        for (Appointment object : appointmentsInFolder2) {
            if (object.getObjectID() != objectId) continue;
            found = true;
            foundAppointment = object;
            break;
        }
        CalendarMoveTest.assertTrue((String)"Appointment expected in second folder.", (boolean)found);
        Participant[] expectedParticipants = new Participant[]{new UserParticipant(this.userId), new UserParticipant(this.secondUserId)};
        this.compareParticipants(expectedParticipants, foundAppointment.getParticipants());
        this.compareParticipants(expectedParticipants, (Participant[])foundAppointment.getUsers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMoveFromPublicToShared() throws Throwable {
        try {
            FolderObject folder1 = this.folders.createPublicFolderFor(this.session, this.ctx, "folder1", 2, this.userId, this.secondUserId);
            this.cleanFolders.add(folder1);
            FolderObject folder2 = this.folders.createPrivateFolderForSessionUser(this.session, this.ctx, "folder2", this.appointments.getPrivateFolder());
            this.cleanFolders.add(folder2);
            OCLPermission oclp = new OCLPermission();
            oclp.setAllPermission(4, 4, 4, 4);
            this.folders.sharePrivateFolder(this.session, this.ctx, this.secondUserId, folder2, oclp);
            this.appointments.switchUser(this.secondUser);
            Date start = new Date(1231596000000L);
            Date end = new Date(1231599600000L);
            CalendarDataObject appointment = this.appointments.buildBasicAppointment(start, end);
            appointment.setTitle("testMoveFromPublicToShared");
            appointment.setIgnoreConflicts(true);
            appointment.setParentFolderID(folder1.getObjectID());
            this.appointments.save(appointment);
            int objectId = appointment.getObjectID();
            this.clean.add(appointment);
            CalendarDataObject appointmentMove = this.appointments.createIdentifyingCopy(appointment);
            appointmentMove.setParentFolderID(folder2.getObjectID());
            this.appointments.move(appointmentMove, folder1.getObjectID());
            List<Appointment> appointmentsInFolder1 = this.appointments.getAppointmentsInFolder(folder1.getObjectID(), this.columns);
            List<Appointment> appointmentsInFolder2 = this.appointments.getAppointmentsInFolder(folder2.getObjectID(), this.columns);
            boolean found = false;
            for (Appointment object : appointmentsInFolder1) {
                if (object.getObjectID() != objectId) continue;
                found = true;
                break;
            }
            CalendarMoveTest.assertFalse((String)"Appointment not expected in first folder.", (boolean)found);
            Appointment foundAppointment = null;
            found = false;
            for (Appointment object : appointmentsInFolder2) {
                if (object.getObjectID() != objectId) continue;
                found = true;
                foundAppointment = object;
                break;
            }
            CalendarMoveTest.assertTrue((String)"Appointment expected in second folder.", (boolean)found);
            Participant[] expectedParticipants = new Participant[]{new UserParticipant(this.userId)};
            this.compareParticipants(expectedParticipants, foundAppointment.getParticipants());
            this.compareParticipants(expectedParticipants, (Participant[])foundAppointment.getUsers());
        }
        catch (Exception e) {
            CalendarMoveTest.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMoveFromPublicToPublic() throws Throwable {
        try {
            FolderObject folder1 = this.folders.createPublicFolderFor(this.session, this.ctx, "folder1", 2, this.userId, this.secondUserId);
            this.cleanFolders.add(folder1);
            FolderObject folder2 = this.folders.createPublicFolderFor(this.session, this.ctx, "folder2", 2, this.userId, this.secondUserId);
            this.cleanFolders.add(folder2);
            this.appointments.switchUser(this.secondUser);
            Date start = new Date(1231596000000L);
            Date end = new Date(1231599600000L);
            CalendarDataObject appointment = this.appointments.buildBasicAppointment(start, end);
            appointment.setTitle("testMoveFromPublicToPublic");
            appointment.setIgnoreConflicts(true);
            appointment.setParentFolderID(folder1.getObjectID());
            this.appointments.save(appointment);
            int objectId = appointment.getObjectID();
            this.clean.add(appointment);
            CalendarDataObject appointmentMove = this.appointments.createIdentifyingCopy(appointment);
            appointmentMove.setParentFolderID(folder2.getObjectID());
            this.appointments.move(appointmentMove, folder1.getObjectID());
            List<Appointment> appointmentsInFolder1 = this.appointments.getAppointmentsInFolder(folder1.getObjectID(), this.columns);
            List<Appointment> appointmentsInFolder2 = this.appointments.getAppointmentsInFolder(folder2.getObjectID(), this.columns);
            boolean found = false;
            for (Appointment object : appointmentsInFolder1) {
                if (object.getObjectID() != objectId) continue;
                found = true;
                break;
            }
            CalendarMoveTest.assertFalse((String)"Appointment not expected in first folder.", (boolean)found);
            Appointment foundAppointment = null;
            found = false;
            for (Appointment object : appointmentsInFolder2) {
                if (object.getObjectID() != objectId) continue;
                found = true;
                foundAppointment = object;
                break;
            }
            CalendarMoveTest.assertTrue((String)"Appointment expected in second folder.", (boolean)found);
            this.compareParticipants((Appointment)appointment, foundAppointment);
            this.compareUsers((Appointment)appointment, foundAppointment);
        }
        catch (Exception e) {
            CalendarMoveTest.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMoveFromSharedToSharedDifferentUser() throws Throwable {
        try {
            FolderObject folder1 = this.folders.createPrivateFolderForSessionUser(this.session, this.ctx, "folder1" + System.currentTimeMillis(), this.appointments.getPrivateFolder());
            this.cleanFolders.add(folder1);
            OCLPermission oclp = new OCLPermission();
            oclp.setAllPermission(4, 4, 4, 4);
            this.folders.sharePrivateFolder(this.session, this.ctx, this.thirdUserId, folder1, oclp);
            this.appointments.switchUser(this.secondUser);
            FolderObject folder2 = this.folders.createPrivateFolderForSessionUser(this.session2, this.ctx, "folder2" + System.currentTimeMillis(), this.appointments.getPrivateFolder());
            this.cleanFolders.add(folder2);
            this.folders.sharePrivateFolder(this.session2, this.ctx, this.thirdUserId, folder2, oclp);
            this.appointments.switchUser(this.thirdUser);
            Date start = new Date(1231596000000L);
            Date end = new Date(1231599600000L);
            CalendarDataObject appointment = this.appointments.buildBasicAppointment(start, end);
            appointment.setTitle("testMoveFromSharedToSharedDifferentUser");
            appointment.setIgnoreConflicts(true);
            appointment.setParentFolderID(folder1.getObjectID());
            this.appointments.save(appointment);
            int objectId = appointment.getObjectID();
            this.clean.add(appointment);
            CalendarDataObject appointmentMove = this.appointments.createIdentifyingCopy(appointment);
            appointmentMove.setParentFolderID(folder2.getObjectID());
            this.appointments.move(appointmentMove, folder1.getObjectID());
            List<Appointment> appointmentsInFolder1 = this.appointments.getAppointmentsInFolder(folder1.getObjectID(), this.columns);
            List<Appointment> appointmentsInFolder2 = this.appointments.getAppointmentsInFolder(folder2.getObjectID(), this.columns);
            boolean found = false;
            for (Appointment object : appointmentsInFolder1) {
                if (object.getObjectID() != objectId) continue;
                found = true;
                break;
            }
            CalendarMoveTest.assertFalse((String)"Appointment not expected in first folder.", (boolean)found);
            Appointment foundAppointment = null;
            found = false;
            for (Appointment object : appointmentsInFolder2) {
                if (object.getObjectID() != objectId) continue;
                found = true;
                foundAppointment = object;
                break;
            }
            CalendarMoveTest.assertTrue((String)"Appointment expected in second folder.", (boolean)found);
            Participant[] expectedParticipants = new Participant[]{new UserParticipant(this.secondUserId)};
            this.compareParticipants(expectedParticipants, foundAppointment.getParticipants());
            this.compareParticipants(expectedParticipants, (Participant[])foundAppointment.getUsers());
        }
        catch (Exception e) {
            CalendarMoveTest.fail((String)e.getMessage());
        }
    }

    private void compareParticipants(Appointment expected, Appointment actual) {
        CalendarMoveTest.assertEquals((String)"Number of participants do not match", (boolean)expected.containsParticipants(), (boolean)actual.containsParticipants());
        if (expected.containsParticipants()) {
            CalendarMoveTest.assertEquals((String)"Number of participants do not match.", (int)expected.getParticipants().length, (int)actual.getParticipants().length);
        }
        this.compareParticipants(expected.getParticipants(), actual.getParticipants());
    }

    private void compareUsers(Appointment expected, Appointment actual) {
        CalendarMoveTest.assertEquals((String)"Number of users do not match.", (boolean)expected.containsUserParticipants(), (boolean)actual.containsUserParticipants());
        if (expected.containsUserParticipants()) {
            CalendarMoveTest.assertEquals((String)"Number of users do not match.", (int)expected.getUsers().length, (int)actual.getUsers().length);
        }
        this.compareParticipants((Participant[])expected.getUsers(), (Participant[])actual.getUsers());
    }

    private void compareParticipants(Participant[] expected, Participant[] actual) {
        for (Participant participantExpected : expected) {
            boolean found = false;
            for (Participant participantActual : actual) {
                if (participantActual.getIdentifier() != participantExpected.getIdentifier()) continue;
                found = true;
                break;
            }
            CalendarMoveTest.assertTrue((String)("Did not found Participant (id: " + participantExpected.getIdentifier() + ", display name: " + participantExpected.getDisplayName() + ")"), (boolean)found);
        }
    }
}

