/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.database;

import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.test.TestInit;
import com.openexchange.tools.sql.DBUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ReplicationMonitorPerformanceTest {
    private static final Log LOG = LogFactory.getLog(ReplicationMonitorPerformanceTest.class);
    private static final int RUNS = 5;
    private static final int THREADS = 2;
    private static final int ITERATIONS = 100;
    private static AtomicInteger NEXT_ID = new AtomicInteger();
    private DBPoolProvider db;
    private Context context;

    @BeforeClass
    public static void setUpClass() throws Exception {
        TestInit.loadTestProperties();
        Init.startServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setUp() throws Exception {
        ContextStorage contextStorage = ContextStorage.getInstance();
        int contextId = contextStorage.getContextId("defaultcontext");
        this.context = contextStorage.getContext(contextId);
        this.db = new DBPoolProvider();
        Connection writeCon = this.db.getWriteConnection(this.context);
        Statement stmt = null;
        try {
            stmt = writeCon.createStatement();
            stmt.executeUpdate("DROP TABLE IF EXISTS replicationMonitorPerformanceTest;");
            DBUtils.closeSQLStuff((Statement)stmt);
            stmt = writeCon.createStatement();
            stmt.executeUpdate("CREATE TABLE `replicationMonitorPerformanceTest` (`id` int(10) unsigned NOT NULL, `key` varchar(128) COLLATE utf8_unicode_ci NOT NULL, `value` varchar(128) COLLATE utf8_unicode_ci NOT NULL, PRIMARY KEY (`id`)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci");
        }
        catch (SQLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            DBUtils.closeSQLStuff((Statement)stmt);
            this.db.releaseWriteConnection(this.context, writeCon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void tearDown() throws Exception {
        Connection writeCon = this.db.getWriteConnection(this.context);
        Statement stmt = null;
        try {
            stmt = writeCon.createStatement();
            stmt.executeUpdate("DROP TABLE replicationMonitorPerformanceTest;");
        }
        finally {
            DBUtils.closeSQLStuff((Statement)stmt);
            this.db.releaseWriteConnection(this.context, writeCon);
        }
    }

    @Test
    public void testInLoop() throws Exception {
        Connection writeCon = this.db.getWriteConnection(this.context);
        PreparedStatement stmt = writeCon.prepareStatement("UPDATE replicationMonitor SET `transaction` = ? WHERE `cid` = ?");
        stmt.setLong(1, 0L);
        stmt.setInt(2, this.context.getContextId());
        stmt.executeUpdate();
        DBUtils.closeSQLStuff((Statement)stmt);
        this.db.releaseWriteConnection(this.context, writeCon);
        Method[] methods = this.getClass().getDeclaredMethods();
        HashMap<Method, ArrayList<Long>> timeMap = new HashMap<Method, ArrayList<Long>>();
        for (int i = 0; i < 5; ++i) {
            long timestamp = System.currentTimeMillis();
            for (Method m : methods) {
                if (!m.getName().startsWith("run")) continue;
                try {
                    List<Long> times = this.executeTest(m, 100, timestamp);
                    ArrayList<Long> allTimes = (ArrayList<Long>)timeMap.get(m);
                    if (allTimes == null) {
                        allTimes = new ArrayList<Long>(times);
                        timeMap.put(m, allTimes);
                        continue;
                    }
                    allTimes.addAll(times);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        Connection readCon = this.db.getReadConnection(this.context);
        this.writeGlobalStatus(readCon, "slave_status");
        this.db.releaseReadConnection(this.context, readCon);
        writeCon = this.db.getWriteConnection(this.context);
        this.writeGlobalStatus(writeCon, "master_status");
        this.db.releaseWriteConnection(this.context, writeCon);
        for (Map.Entry entry : timeMap.entrySet()) {
            PrintWriter w = new PrintWriter(System.getProperty("user.dir") + File.separatorChar + "rm_benchmarks" + File.separatorChar + ((Method)entry.getKey()).getName() + ".csv");
            w.println("time");
            for (Long time : (List)entry.getValue()) {
                w.println(time);
            }
            w.flush();
            w.close();
        }
    }

    private void writeGlobalStatus(Connection con, String filename) throws SQLException, FileNotFoundException {
        Statement stmt = con.createStatement();
        ResultSet rs = stmt.executeQuery("SHOW GLOBAL STATUS;");
        PrintWriter w = new PrintWriter(System.getProperty("user.dir") + File.separatorChar + "rm_benchmarks" + File.separatorChar + filename + ".csv");
        w.println("VARIABLE,VALUE");
        while (rs.next()) {
            w.println(rs.getObject(1).toString() + "," + rs.getObject(2).toString());
        }
        DBUtils.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        PreparedStatement pstmt = con.prepareStatement("SELECT `transaction` FROM replicationMonitor WHERE `cid` = ?");
        pstmt.setInt(1, this.context.getContextId());
        rs = pstmt.executeQuery();
        if (rs.next()) {
            w.println("ReplicationMonitor," + rs.getLong(1));
        }
        DBUtils.closeSQLStuff((ResultSet)rs, (Statement)pstmt);
        w.flush();
        w.close();
    }

    private List<Long> executeTest(Method m, int iterations, long timestamp) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, FileNotFoundException {
        long avg = 0L;
        long min = Long.MAX_VALUE;
        long max = 0L;
        long start = System.currentTimeMillis();
        TestCaseRunner[] runners = new TestCaseRunner[2];
        ArrayList<Long> times = new ArrayList<Long>();
        this.printHeader(m.getName());
        for (int i = 0; i < 2; ++i) {
            runners[i] = new TestCaseRunner(this, m, iterations);
            new Thread(runners[i]).start();
        }
        for (TestCaseRunner runner : runners) {
            try {
                runner.getThread().join();
                if (runner.getMax() > max) {
                    max = runner.getMax();
                }
                if (runner.getMin() < min) {
                    min = runner.getMin();
                }
                avg += runner.getAvg();
                List<Long> threadTimes = runner.getTimes();
                times.addAll(threadTimes);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.printFooter(avg /= (long)runners.length, min, max, System.currentTimeMillis() - start);
        return times;
    }

    private void printHeader(String title) {
        System.out.println("=========================");
        System.out.println(title);
        System.out.println("=========================");
    }

    private void printFooter(long avg, long min, long max, long dur) {
        System.out.println(" Min:      " + min + "ms");
        System.out.println(" Max:      " + max + "ms");
        System.out.println(" Average:  " + avg + "ms");
        System.out.println(" Duration: " + dur + "ms");
        System.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long runSingleInTransaction() throws Exception {
        long startTime;
        block5: {
            startTime = System.currentTimeMillis();
            Connection con = this.db.getWriteConnection(this.context);
            PreparedStatement wstmt = null;
            PreparedStatement rstmt = null;
            ResultSet rs = null;
            try {
                DBUtils.startTransaction((Connection)con);
                int id = NEXT_ID.getAndIncrement();
                String key = UUID.randomUUID().toString();
                String value = UUID.randomUUID().toString();
                wstmt = con.prepareStatement("INSERT INTO replicationMonitorPerformanceTest (`id`, `key`, `value`) VALUES (?, ?, ?)");
                wstmt.setInt(1, id);
                wstmt.setString(2, key);
                wstmt.setString(3, value);
                wstmt.executeUpdate();
                rstmt = con.prepareStatement("SELECT `key`, `value` FROM replicationMonitorPerformanceTest WHERE `id` = ?");
                rstmt.setInt(1, id);
                rs = rstmt.executeQuery();
                Assert.assertTrue((String)"ResultSet is empty", (boolean)rs.next());
                Assert.assertEquals((String)"Wrong key", (Object)key, (Object)rs.getString(1));
                Assert.assertEquals((String)"Wrong value", (Object)value, (Object)rs.getString(2));
                con.commit();
                DBUtils.closeSQLStuff((Statement)wstmt);
            }
            catch (SQLException e) {
                e.printStackTrace();
                con.rollback();
                break block5;
            }
            finally {
                DBUtils.closeSQLStuff(wstmt);
                DBUtils.closeSQLStuff(rs, rstmt);
                DBUtils.autocommit((Connection)con);
                this.db.releaseWriteConnection(this.context, con);
            }
            DBUtils.closeSQLStuff((ResultSet)rs, (Statement)rstmt);
            DBUtils.autocommit((Connection)con);
            this.db.releaseWriteConnection(this.context, con);
        }
        return System.currentTimeMillis() - startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long runBatchInTransaction() throws Exception {
        int times = 25;
        long startTime = System.currentTimeMillis();
        Connection con = this.db.getWriteConnection(this.context);
        PreparedStatement wstmt = null;
        PreparedStatement rstmt = null;
        ResultSet rs = null;
        try {
            int i;
            DBUtils.startTransaction((Connection)con);
            wstmt = con.prepareStatement("INSERT INTO replicationMonitorPerformanceTest (`id`, `key`, `value`) VALUES (?, ?, ?)");
            HashSet<Integer> ids = new HashSet<Integer>(times);
            for (int i2 = 0; i2 < times; ++i2) {
                int id = NEXT_ID.getAndIncrement();
                String key = UUID.randomUUID().toString();
                String value = UUID.randomUUID().toString();
                wstmt.setInt(1, id);
                wstmt.setString(2, key);
                wstmt.setString(3, value);
                wstmt.addBatch();
                ids.add(id);
            }
            wstmt.executeBatch();
            StringBuilder sb = new StringBuilder("SELECT `id`, `key`, `value` FROM replicationMonitorPerformanceTest WHERE `id` IN (?");
            for (i = 0; i < times - 1; ++i) {
                sb.append(", ?");
            }
            sb.append(")");
            rstmt = con.prepareStatement(sb.toString());
            i = 1;
            Iterator i$ = ids.iterator();
            while (i$.hasNext()) {
                int id = (Integer)i$.next();
                rstmt.setInt(i, id);
                ++i;
            }
            rs = rstmt.executeQuery();
            while (rs.next()) {
                int id = rs.getInt(1);
                ids.remove(id);
            }
            Assert.assertEquals((String)"Did not find all entries", (long)0L, (long)ids.size());
            con.commit();
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                con.rollback();
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(wstmt);
                DBUtils.closeSQLStuff(rs, rstmt);
                DBUtils.autocommit((Connection)con);
                this.db.releaseWriteConnection(this.context, con);
                throw throwable;
            }
            DBUtils.closeSQLStuff((Statement)wstmt);
            DBUtils.closeSQLStuff(rs, rstmt);
            DBUtils.autocommit((Connection)con);
            this.db.releaseWriteConnection(this.context, con);
        }
        DBUtils.closeSQLStuff((Statement)wstmt);
        DBUtils.closeSQLStuff((ResultSet)rs, (Statement)rstmt);
        DBUtils.autocommit((Connection)con);
        this.db.releaseWriteConnection(this.context, con);
        return System.currentTimeMillis() - startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long runSingleNoTransaction() throws Exception {
        long startTime;
        block5: {
            startTime = System.currentTimeMillis();
            Connection con = this.db.getWriteConnection(this.context);
            PreparedStatement wstmt = null;
            PreparedStatement rstmt = null;
            ResultSet rs = null;
            try {
                int id = NEXT_ID.getAndIncrement();
                String key = UUID.randomUUID().toString();
                String value = UUID.randomUUID().toString();
                wstmt = con.prepareStatement("INSERT INTO replicationMonitorPerformanceTest (`id`, `key`, `value`) VALUES (?, ?, ?)");
                wstmt.setInt(1, id);
                wstmt.setString(2, key);
                wstmt.setString(3, value);
                wstmt.executeUpdate();
                rstmt = con.prepareStatement("SELECT `key`, `value` FROM replicationMonitorPerformanceTest WHERE `id` = ?");
                rstmt.setInt(1, id);
                rs = rstmt.executeQuery();
                Assert.assertTrue((String)"ResultSet is empty", (boolean)rs.next());
                Assert.assertEquals((String)"Wrong key", (Object)key, (Object)rs.getString(1));
                Assert.assertEquals((String)"Wrong value", (Object)value, (Object)rs.getString(2));
                DBUtils.closeSQLStuff((Statement)wstmt);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                DBUtils.closeSQLStuff(wstmt);
                DBUtils.closeSQLStuff(rs, rstmt);
                this.db.releaseWriteConnection(this.context, con);
            }
            DBUtils.closeSQLStuff((ResultSet)rs, (Statement)rstmt);
            this.db.releaseWriteConnection(this.context, con);
        }
        return System.currentTimeMillis() - startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long runReadUsedAsWrite() throws Exception {
        long startTime = System.currentTimeMillis();
        Connection con = this.db.getWriteConnection(this.context);
        PreparedStatement rstmt = null;
        ResultSet rs = null;
        try {
            rstmt = con.prepareStatement("SELECT `id`, `key`, `value` FROM replicationMonitorPerformanceTest");
            rs = rstmt.executeQuery();
            Assert.assertTrue((String)"ResultSet is empty", (boolean)rs.next());
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, (Statement)rstmt);
                this.db.releaseWriteConnection(this.context, con);
                throw throwable;
            }
            DBUtils.closeSQLStuff((ResultSet)rs, (Statement)rstmt);
            this.db.releaseWriteConnection(this.context, con);
        }
        DBUtils.closeSQLStuff((ResultSet)rs, (Statement)rstmt);
        this.db.releaseWriteConnection(this.context, con);
        return System.currentTimeMillis() - startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long runReadUsedAsRead() throws Exception {
        long startTime = System.currentTimeMillis();
        Connection con = this.db.getWriteConnection(this.context);
        PreparedStatement rstmt = null;
        ResultSet rs = null;
        try {
            rstmt = con.prepareStatement("SELECT `id`, `key`, `value` FROM replicationMonitorPerformanceTest");
            rs = rstmt.executeQuery();
            Assert.assertTrue((String)"ResultSet is empty", (boolean)rs.next());
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, (Statement)rstmt);
                this.db.releaseWriteConnectionAfterReading(this.context, con);
                throw throwable;
            }
            DBUtils.closeSQLStuff((ResultSet)rs, (Statement)rstmt);
            this.db.releaseWriteConnectionAfterReading(this.context, con);
        }
        DBUtils.closeSQLStuff((ResultSet)rs, (Statement)rstmt);
        this.db.releaseWriteConnectionAfterReading(this.context, con);
        return System.currentTimeMillis() - startTime;
    }

    private static final class TestCaseRunner
    implements Runnable {
        private final CountDownLatch latch = new CountDownLatch(1);
        private final List<Long> times;
        private final Method method;
        private final Object object;
        private final int iterations;
        private Thread thread;
        private long max;
        private long min;
        private long avg;

        public TestCaseRunner(Object object, Method method, int iterations) {
            this.object = object;
            this.method = method;
            this.iterations = iterations;
            this.times = new ArrayList<Long>();
            this.max = 0L;
            this.min = Long.MAX_VALUE;
            this.avg = 0L;
        }

        @Override
        public void run() {
            this.thread = Thread.currentThread();
            this.latch.countDown();
            try {
                for (int i = 0; i < this.iterations; ++i) {
                    long dur = (Long)this.method.invoke(this.object, new Object[0]);
                    this.times.add(dur);
                    if (dur > this.max) {
                        this.max = dur;
                    }
                    if (dur < this.min) {
                        this.min = dur;
                    }
                    this.avg += dur;
                }
                this.avg /= 100L;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public long getAvg() {
            return this.avg;
        }

        public long getMin() {
            return this.min;
        }

        public long getMax() {
            return this.max;
        }

        public List<Long> getTimes() {
            return this.times;
        }

        public Thread getThread() throws InterruptedException {
            this.latch.await();
            return this.thread;
        }
    }
}

