/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.contact.storage;

import com.openexchange.contact.storage.ContactStorage;
import com.openexchange.contact.storage.registry.ContactStorageRegistry;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObject;
import com.openexchange.sessiond.impl.SessionObjectWrapper;
import com.openexchange.test.AjaxInit;
import com.openexchange.tools.iterator.SearchIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContactStorageTest
extends TestCase {
    private static final Log LOG = LogFactory.getLog(ContactStorageTest.class);
    public static final int CONTEXT_ID = 424242669;
    private static boolean initialized = false;
    private SessionObject session;
    private Context ctx;
    private int userId;
    private final Collection<Contact> rememberedContacts = new ArrayList<Contact>();

    private static int resolveUser(String user, Context ctx) throws Exception {
        try {
            int pos = -1;
            pos = user.indexOf(64);
            user = pos > -1 ? user.substring(0, pos) : user;
            UserStorage uStorage = UserStorage.getInstance();
            return uStorage.getUserId(user, ctx);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return -1;
        }
    }

    protected void rememberForCleanUp(Contact contact) {
        Contact rememberedContact = new Contact();
        rememberedContact.setObjectID(contact.getObjectID());
        rememberedContact.setParentFolderID(contact.getParentFolderID());
        this.rememberedContacts.add(rememberedContact);
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (!initialized) {
            Init.startServer();
        }
        this.ctx = new ContextImpl(424242669);
        this.userId = ContactStorageTest.resolveUser(AjaxInit.getAJAXProperty("login"), this.ctx);
        this.session = SessionObjectWrapper.createSessionObject((int)this.userId, (int)424242669, (String)"thorben_session_id");
    }

    protected void tearDown() throws Exception {
        if (null != this.rememberedContacts && 0 < this.rememberedContacts.size()) {
            for (Contact contact : this.rememberedContacts) {
                try {
                    this.getStorage().delete(this.getSession(), Integer.toString(contact.getParentFolderID()), Integer.toString(contact.getObjectID()), new Date());
                }
                catch (Exception e) {
                    LOG.error((Object)"error cleaning up contact", (Throwable)e);
                }
            }
        }
        if (initialized) {
            initialized = false;
            Init.stopServer();
        }
        super.tearDown();
    }

    protected ContactStorage getStorage() throws OXException {
        ContactStorageRegistry registry = (ContactStorageRegistry)ServerServiceRegistry.getInstance().getService(ContactStorageRegistry.class);
        return registry.getStorage(this.getSession(), null);
    }

    protected Contact findContact(String uid, String folderID) throws OXException {
        return ContactStorageTest.findContact(uid, (SearchIterator<Contact>)this.getStorage().all(this.getSession(), folderID, ContactField.values()));
    }

    protected Contact findContact(String uid, String folderID, Date since) throws OXException {
        return ContactStorageTest.findContact(uid, (SearchIterator<Contact>)this.getStorage().modified(this.getSession(), folderID, since, ContactField.values()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Contact findContact(String uid, SearchIterator<Contact> iter) throws OXException {
        try {
            while (iter.hasNext()) {
                Contact c = (Contact)iter.next();
                if (!uid.equals(c.getUid())) continue;
                Contact contact = c;
                return contact;
            }
        }
        finally {
            if (null != iter) {
                iter.close();
            }
        }
        return null;
    }

    protected Session getSession() {
        return this.session;
    }

    protected int getContextID() {
        return this.session.getContextId();
    }

    protected int getUserID() {
        return this.session.getUserId();
    }
}

