/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.configuration;

import com.openexchange.configuration.ConfigurationExceptionCodes;
import com.openexchange.configuration.TestConfig;
import com.openexchange.exception.OXException;
import com.openexchange.tools.conf.AbstractConfig;

public class AJAXConfig
extends AbstractConfig {
    private static final TestConfig.Property KEY = TestConfig.Property.AJAX_PROPS;
    private static volatile AJAXConfig singleton;

    protected String getPropertyFileName() throws OXException {
        String fileName = TestConfig.getProperty(KEY);
        if (null == fileName) {
            throw ConfigurationExceptionCodes.PROPERTY_MISSING.create(new Object[]{KEY.getPropertyName()});
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init() throws OXException {
        TestConfig.init();
        if (null != singleton) return;
        Class<AJAXConfig> clazz = AJAXConfig.class;
        synchronized (AJAXConfig.class) {
            if (null != singleton) return;
            singleton = new AJAXConfig();
            singleton.loadPropertiesInternal();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static String getProperty(Property key) {
        return singleton.getPropertyInternal(key.getPropertyName());
    }

    public static String getProperty(Property key, String fallBack) {
        String property;
        try {
            property = AJAXConfig.getProperty(key);
        }
        catch (Exception e) {
            return fallBack;
        }
        return property;
    }

    public static enum Property {
        PROTOCOL("protocol"),
        HOSTNAME("hostname"),
        RMI_HOST("rmihost"),
        SLEEP("sleep"),
        LOGIN("login"),
        PASSWORD("password"),
        SECONDUSER("seconduser"),
        THIRDLOGIN("thirdlogin"),
        FOURTHLOGIN("fourthlogin"),
        OXADMIN("oxadmin"),
        IS_SP3("isSP3"),
        CONTEXTNAME("contextName"),
        USER_PARTICIPANT1("user_participant1"),
        USER_PARTICIPANT2("user_participant2"),
        USER_PARTICIPANT3("user_participant3"),
        RESOURCE_PARTICIPANT1("resource_participant1"),
        RESOURCE_PARTICIPANT2("resource_participant2"),
        RESOURCE_PARTICIPANT3("resource_participant3"),
        GROUP_PARTICIPANT("group_participant"),
        ECHO_HEADER("echo_header");

        private final String propertyName;

        private Property(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

